/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.automation.unit.CivilianUnitAutomation;
import com.unciv.logic.automation.unit.ReligiousUnitAutomation;
import com.unciv.logic.automation.unit.SpecificUnitAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.automation.unit.WorkerAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/automation/unit/CivilianUnitAutomation;", "", "()V", "automateCivilianUnit", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "dangerousTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "isLateGame", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "runAway", "shouldClearTileForAddInCapitalUnits", "tile", "tryRunAwayIfNeccessary", "core"})
@SourceDebugExtension(value={"SMAP\nCivilianUnitAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CivilianUnitAutomation.kt\ncom/unciv/logic/automation/unit/CivilianUnitAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1247#2,2:222\n1247#2,2:280\n526#3:224\n511#3,6:225\n1#4:231\n766#5:232\n857#5,2:233\n1549#5:235\n1620#5,3:236\n766#5:239\n857#5,2:240\n2333#5,14:242\n766#5:256\n857#5,2:257\n288#5,2:259\n288#5,2:261\n766#5:263\n857#5,2:264\n1963#5,14:266\n*S KotlinDebug\n*F\n+ 1 CivilianUnitAutomation.kt\ncom/unciv/logic/automation/unit/CivilianUnitAutomation\n*L\n20#1:222,2\n29#1:280,2\n41#1:224\n41#1:225,6\n137#1:232\n137#1:233,2\n140#1:235\n140#1:236,3\n144#1:239\n144#1:240,2\n144#1:242,14\n186#1:256\n186#1:257,2\n200#1:259,2\n206#1:261,2\n214#1:263\n214#1:264,2\n215#1:266,14\n*E\n"})
public final class CivilianUnitAutomation {
    @NotNull
    public static final CivilianUnitAutomation INSTANCE = new CivilianUnitAutomation();

    private CivilianUnitAutomation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldClearTileForAddInCapitalUnits(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!tile.isCityCenter()) return false;
        City city2 = tile.getCity();
        Intrinsics.checkNotNull(city2);
        if (!city2.isCapital()) return false;
        if (MapUnit.hasUnique$default(unit, UniqueType.AddInCapital, null, false, 6, null)) return false;
        Sequence<MapUnit> $this$any$iv = unit.getCiv().getUnits().getCivUnits();
        boolean $i$f$any = false;
        Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
        do {
            MapUnit element$iv;
            if (!iterator2.hasNext()) return false;
            MapUnit it = element$iv = iterator2.next();
            boolean bl = false;
        } while (!MapUnit.hasUnique$default(unit, UniqueType.AddInCapital, null, false, 6, null));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void automateCivilianUnit(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles) {
        boolean wonderCanBeSpedUpEventually;
        boolean tradeMissionCanBeConductedEventually;
        Object object;
        boolean hasSettlerUnique;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
        boolean bl = hasSettlerUnique = CivilianUnitAutomation.automateCivilianUnit$hasSettlerAction(unit, UniqueType.FoundCity) || CivilianUnitAutomation.automateCivilianUnit$hasSettlerAction(unit, UniqueType.FoundPuppetCity);
        if (hasSettlerUnique) {
            SpecificUnitAutomation.INSTANCE.automateSettlerActions(unit, dangerousTiles);
            return;
        }
        if (this.tryRunAwayIfNeccessary(unit)) {
            return;
        }
        if (this.shouldClearTileForAddInCapitalUnits(unit, unit.getCurrentTile())) {
            Iterator $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Map map2 = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            boolean $i$f$filter2 = false;
            void var7_13 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                if (!UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)it.getKey(), false, false, false, 14, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map tilesCanMoveTo = destination$iv$iv;
            if (!tilesCanMoveTo.isEmpty()) {
                Object v1;
                $this$filter$iv = tilesCanMoveTo;
                object = unit.getMovement();
                Iterable $i$f$filter2 = $this$filter$iv.entrySet();
                $this$filterTo$iv$iv = $i$f$filter2.iterator();
                if (!$this$filterTo$iv$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object t = $this$filterTo$iv$iv.next();
                    if (!$this$filterTo$iv$iv.hasNext()) {
                        v1 = t;
                    } else {
                        Map.Entry it22 = (Map.Entry)t;
                        boolean bl32 = false;
                        float it22 = ((UnitMovement.ParentTileAndTotalMovement)it22.getValue()).getTotalMovement();
                        do {
                            Object bl32 = $this$filterTo$iv$iv.next();
                            Map.Entry it32 = (Map.Entry)bl32;
                            boolean $i$a$-minByOrNull-CivilianUnitAutomation$automateCivilianUnit$2 = false;
                            float it32 = ((UnitMovement.ParentTileAndTotalMovement)it32.getValue()).getTotalMovement();
                            if (Float.compare(it22, it32) <= 0) continue;
                            t = bl32;
                            it22 = it32;
                        } while ($this$filterTo$iv$iv.hasNext());
                        v1 = t;
                    }
                }
                Map.Entry entry = v1;
                Intrinsics.checkNotNull(entry);
                UnitMovement.moveToTile$default((UnitMovement)object, (Tile)entry.getKey(), false, 2, null);
            }
        }
        if (unit.isAutomatingRoadConnection()) {
            unit.getCiv().getWorkerAutomation().getRoadToAutomation().automateConnectRoad(unit, (Set<Tile>)dangerousTiles);
            return;
        }
        if (unit.getCache().getHasUniqueToBuildImprovements()) {
            WorkerAutomation.automateWorkerAction$default(unit.getCiv().getWorkerAutomation(), unit, dangerousTiles, null, 4, null);
            return;
        }
        if (unit.getCache().getHasUniqueToCreateWaterImprovements()) {
            if (!unit.getCiv().getWorkerAutomation().automateWorkBoats(unit)) {
                UnitAutomation.INSTANCE.tryExplore$core(unit);
            }
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.MayFoundReligion, null, false, 6, null) && unit.getCiv().getReligionManager().getReligionState().compareTo((Enum)ReligionState.Religion) < 0 && unit.getCiv().getReligionManager().mayFoundReligionAtAll()) {
            ReligiousUnitAutomation.INSTANCE.foundReligion(unit);
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.MayFoundReligion, null, false, 6, null) && unit.getCiv().isCityState()) {
            unit.disband();
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.MayEnhanceReligion, null, false, 6, null) && unit.getCiv().getReligionManager().getReligionState().compareTo((Enum)ReligionState.EnhancedReligion) < 0 && unit.getCiv().getReligionManager().mayEnhanceReligionAtAll()) {
            ReligiousUnitAutomation.INSTANCE.enhanceReligion(unit);
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.AddInCapital, null, false, 6, null)) {
            SpecificUnitAutomation.INSTANCE.automateAddInCapital(unit);
            return;
        }
        if (unit.getCache().getHasStrengthBonusInRadiusUnique() && SpecificUnitAutomation.INSTANCE.automateGreatGeneral(unit)) {
            return;
        }
        if (unit.getCache().getHasCitadelPlacementUnique() && SpecificUnitAutomation.INSTANCE.automateCitadelPlacer(unit)) {
            return;
        }
        if (unit.getCache().getHasCitadelPlacementUnique() || unit.getCache().getHasStrengthBonusInRadiusUnique()) {
            SpecificUnitAutomation.INSTANCE.automateGreatGeneralFallback(unit);
            return;
        }
        if (unit.getCiv().getReligionManager().maySpreadReligionAtAll(unit)) {
            ReligiousUnitAutomation.INSTANCE.automateMissionary(unit);
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.PreventSpreadingReligion, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.CanRemoveHeresy, null, false, 6, null)) {
            ReligiousUnitAutomation.INSTANCE.automateInquisitor(unit);
            return;
        }
        boolean isLateGame = this.isLateGame(unit.getCiv());
        if (isLateGame) {
            boolean hurriedResearch = UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryResearch);
            if (hurriedResearch) {
                return;
            }
            boolean hurriedPolicy = UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.HurryPolicy);
            if (hurriedPolicy) {
                return;
            }
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.CanTradeWithCityStateForGoldAndInfluence, null, false, 6, null) && !unit.getCiv().isAtWar() && isLateGame && (tradeMissionCanBeConductedEventually = SpecificUnitAutomation.INSTANCE.conductTradeMission(unit))) {
            return;
        }
        if ((MapUnit.hasUnique$default(unit, UniqueType.CanSpeedupConstruction, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.CanSpeedupWonderConstruction, null, false, 6, null)) && (wonderCanBeSpedUpEventually = SpecificUnitAutomation.INSTANCE.speedupWonderConstruction(unit))) {
            return;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.GainFreeBuildings, null, false, 6, null)) {
            City cityToGainBuilding;
            Object v4;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Unique unique = (Unique)SequencesKt.first(MapUnit.getMatchingUniques$default(unit, UniqueType.GainFreeBuildings, null, false, 6, null));
            String buildingName = unique.getParams().get(0);
            Iterable $this$filter$iv = unit.getCiv().getCities();
            boolean $i$f$filter = false;
            Iterable it32 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl4 = false;
                boolean bl5 = !((City)it).getCityConstructions().containsBuildingOrEquivalent(buildingName) && (UnitMovement.canMoveTo$default(unit.getMovement(), ((City)it).getCenterTile(), false, false, false, 14, null) || Intrinsics.areEqual(unit.getCurrentTile(), ((City)it).getCenterTile()));
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (City)item$iv$iv;
                object = destination$iv$iv;
                boolean bl6 = false;
                List path = UnitMovement.getShortestPath$default(unit.getMovement(), ((City)it).getCenterTile(), false, 2, null);
                object.add(TuplesKt.to(it, path.size()));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl7 = false;
                if (!(((Number)((Pair)it).getSecond()).intValue() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    Pair it2 = (Pair)minElem$iv;
                    boolean bl8 = false;
                    int minValue$iv = ((Number)it2.getSecond()).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Pair it3 = (Pair)e$iv;
                        $i$a$-minByOrNull-CivilianUnitAutomation$automateCivilianUnit$cityToGainBuilding$4 = false;
                        int v$iv = ((Number)it3.getSecond()).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = minElem$iv;
                }
            }
            Pair pair = v4;
            City city2 = cityToGainBuilding = pair != null ? (City)pair.getFirst() : null;
            if (cityToGainBuilding != null) {
                if (Intrinsics.areEqual(unit.getCurrentTile(), cityToGainBuilding.getCenterTile())) {
                    UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, unit.getCiv(), null, unit, unit.getCurrentTile(), null, null, 100, null);
                    UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, unit, unique, false, 4, null);
                    return;
                }
                unit.getMovement().headTowards(cityToGainBuilding.getCenterTile());
            }
            return;
        }
        if (SpecificUnitAutomation.INSTANCE.automateImprovementPlacer(unit)) {
            return;
        }
        UnitAction goldenAgeAction2 = SequencesKt.firstOrNull(SequencesKt.filter(UnitActions.INSTANCE.getUnitActions(unit, UnitActionType.TriggerUnique), automateCivilianUnit.goldenAgeAction.1.INSTANCE));
        if (goldenAgeAction2 != null) {
            Function0<Unit> function0 = goldenAgeAction2.getAction();
            if (function0 != null) {
                function0.invoke();
            }
            return;
        }
    }

    private final boolean isLateGame(Civilization civ) {
        float researchCompletePercent = (float)civ.getTech().getResearchedTechnologies().size() * 1.0f / (float)civ.getGameInfo().getRuleset().getTechnologies().size();
        return researchCompletePercent >= 0.6f;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryRunAwayIfNeccessary(@NotNull MapUnit unit) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Set<Tile> set2 = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null).keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            ThreatManager threatManager = unit.getCiv().getThreatManager();
            Intrinsics.checkNotNull(it);
            if (!threatManager.doesTileHaveMilitaryEnemy(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enemyUnitsInWalkingDistance = (List)destination$iv$iv;
        if (!((Collection)enemyUnitsInWalkingDistance).isEmpty() && !unit.getBaseUnit().isMilitary() && unit.getTile().getMilitaryUnit() == null && !unit.getTile().isCityCenter()) {
            this.runAway(unit);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void runAway(MapUnit unit) {
        block16: {
            block15: {
                reachableTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
                v0 = reachableTiles.keySet();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-keys>(...)");
                var4_3 = v0;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Tile)element$iv;
                    $i$a$-firstOrNull-CivilianUnitAutomation$runAway$enterableCity$1 = false;
                    if (!it.isCityCenter()) ** GOTO lbl-1000
                    v1 = unit.getMovement();
                    Intrinsics.checkNotNull(it);
                    if (UnitMovement.canMoveTo$default(v1, it, false, false, false, 14, null)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = element$iv;
                    break block15;
                }
                v3 = null;
            }
            enterableCity = v3;
            if (enterableCity != null) {
                UnitMovement.moveToTile$default(unit.getMovement(), enterableCity, false, 2, null);
                return;
            }
            v4 = reachableTiles.keySet();
            Intrinsics.checkNotNullExpressionValue(v4, "<get-keys>(...)");
            $i$f$firstOrNull = v4;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (Tile)element$iv /* !! */ ;
                $i$a$-firstOrNull-CivilianUnitAutomation$runAway$defensiveUnit$1 = false;
                if (it.getMilitaryUnit() == null) ** GOTO lbl-1000
                v5 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v5);
                if (Intrinsics.areEqual(v5.getCiv(), unit.getCiv()) && it.getCivilianUnit() == null) {
                    v6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                if (!v6) continue;
                v7 = element$iv /* !! */ ;
                break block16;
            }
            v7 = null;
        }
        defensiveUnit = v7;
        if (defensiveUnit != null) {
            UnitMovement.moveToTile$default(unit.getMovement(), defensiveUnit, false, 2, null);
            return;
        }
        v8 = reachableTiles.keySet();
        Intrinsics.checkNotNullExpressionValue(v8, "<get-keys>(...)");
        element$iv /* !! */  = v8;
        $i$f$filter = false;
        $i$a$-firstOrNull-CivilianUnitAutomation$runAway$defensiveUnit$1 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-CivilianUnitAutomation$runAway$tileFurthestFromEnemy$1 = false;
            v9 = unit.getMovement();
            Intrinsics.checkNotNull(it);
            if (!(UnitMovement.canMoveTo$default(v9, it, false, false, false, 14, null) != false && unit.getDamageFromTerrain(it) < unit.getHealth())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v10 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v10 = maxElem$iv;
            } else {
                it = (Tile)maxElem$iv;
                $i$a$-maxByOrNull-CivilianUnitAutomation$runAway$tileFurthestFromEnemy$2 = false;
                maxValue$iv = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 4, false);
                do {
                    e$iv = iterator$iv.next();
                    it = (Tile)e$iv;
                    $i$a$-maxByOrNull-CivilianUnitAutomation$runAway$tileFurthestFromEnemy$2 = false;
                    v$iv = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 4, false);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v10 = maxElem$iv;
            }
        }
        v11 = v10;
        if (v11 == null) {
            return;
        }
        tileFurthestFromEnemy = v11;
        UnitMovement.moveToTile$default(unit.getMovement(), tileFurthestFromEnemy, false, 2, null);
    }

    private static final boolean automateCivilianUnit$hasSettlerAction(MapUnit $unit, UniqueType uniqueType) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.filter(MapUnit.getMatchingUniques$default($unit, uniqueType, StateForConditionals.Companion.getIgnoreConditionals(), false, 4, null), automateCivilianUnit.hasSettlerAction.1.INSTANCE);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!UnitActionModifiers.INSTANCE.canUse($unit, it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

