/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.GreatGeneralImplementation;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/battle/GreatGeneralImplementation;", "", "()V", "getBestAffectedTroopsTile", "Lcom/unciv/logic/map/tile/Tile;", "general", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getGreatGeneralBonus", "Lkotlin/Pair;", "", "", "ourUnitCombatant", "Lcom/unciv/logic/battle/MapUnitCombatant;", "enemy", "Lcom/unciv/logic/battle/ICombatant;", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "GeneralBonusData", "core"})
@SourceDebugExtension(value={"SMAP\nGreatGeneralImplementation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GreatGeneralImplementation.kt\ncom/unciv/logic/battle/GreatGeneralImplementation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1433#2,14:113\n1433#2,5:128\n1439#2,8:142\n1#3:127\n372#4,7:133\n288#5,2:140\n*S KotlinDebug\n*F\n+ 1 GreatGeneralImplementation.kt\ncom/unciv/logic/battle/GreatGeneralImplementation\n*L\n53#1:113,14\n96#1:128,5\n96#1:142,8\n100#1:133,7\n103#1:140,2\n*E\n"})
public final class GreatGeneralImplementation {
    @NotNull
    public static final GreatGeneralImplementation INSTANCE = new GreatGeneralImplementation();

    private GreatGeneralImplementation() {
    }

    @NotNull
    public final Pair<String, Integer> getGreatGeneralBonus(@NotNull MapUnitCombatant ourUnitCombatant, @NotNull ICombatant enemy, @NotNull CombatAction combatAction) {
        Object v0;
        Sequence greatGeneral2;
        Intrinsics.checkNotNullParameter(ourUnitCombatant, "ourUnitCombatant");
        Intrinsics.checkNotNullParameter(enemy, "enemy");
        Intrinsics.checkNotNullParameter((Object)combatAction, "combatAction");
        MapUnit unit = ourUnitCombatant.getUnit();
        Civilization civInfo = ourUnitCombatant.getUnit().getCiv();
        Sequence<MapUnit> allGenerals2 = SequencesKt.filter(civInfo.getUnits().getCivUnits(), getGreatGeneralBonus.allGenerals.1.INSTANCE);
        if (SequencesKt.none(allGenerals2)) {
            return new Pair<String, Integer>("", 0);
        }
        Sequence $this$maxByOrNull$iv = greatGeneral2 = SequencesKt.filter(SequencesKt.flatMap(allGenerals2, (Function1)new Function1<MapUnit, Sequence<? extends GeneralBonusData>>(unit, ourUnitCombatant, enemy, combatAction){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ MapUnitCombatant $ourUnitCombatant;
            final /* synthetic */ ICombatant $enemy;
            final /* synthetic */ CombatAction $combatAction;
            {
                this.$unit = $unit;
                this.$ourUnitCombatant = $ourUnitCombatant;
                this.$enemy = $enemy;
                this.$combatAction = $combatAction;
                super(1);
            }

            @NotNull
            public final Sequence<GeneralBonusData> invoke(@NotNull MapUnit general) {
                Intrinsics.checkNotNullParameter(general, "general");
                return SequencesKt.map(MapUnit.getMatchingUniques$default(general, UniqueType.StrengthBonusInRadius, new StateForConditionals(this.$unit.getCiv(), null, null, null, this.$ourUnitCombatant, this.$enemy, null, this.$combatAction, null, null, false, 1870, null), false, 4, null), (Function1)new Function1<Unique, GeneralBonusData>(general){
                    final /* synthetic */ MapUnit $general;
                    {
                        this.$general = $general;
                        super(1);
                    }

                    @NotNull
                    public final GeneralBonusData invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return new GeneralBonusData(this.$general, it);
                    }
                });
            }
        }), (Function1)new Function1<GeneralBonusData, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GeneralBonusData it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getGeneral().getCurrentTile().aerialDistanceTo(this.$unit.getTile()) <= it.getRadius() && (Intrinsics.areEqual(it.getFilter(), "Military") || MapUnit.matchesFilter$default(this.$unit, it.getFilter(), false, 2, null));
            }
        });
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                GeneralBonusData it = (GeneralBonusData)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getBonus();
                do {
                    Object e$iv = iterator$iv.next();
                    GeneralBonusData it2 = (GeneralBonusData)e$iv;
                    $i$a$-maxByOrNull-GreatGeneralImplementation$getGreatGeneralBonus$greatGeneralModifier$1 = false;
                    int v$iv = it2.getBonus();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        GeneralBonusData generalBonusData2 = v0;
        if (generalBonusData2 == null) {
            return new Pair<String, Integer>("", 0);
        }
        GeneralBonusData greatGeneralModifier = generalBonusData2;
        if (MapUnit.hasUnique$default(unit, UniqueType.GreatGeneralProvidesDoubleCombatBonus, null, true, 2, null) && greatGeneralModifier.getGeneral().isGreatPersonOfType("War")) {
            return new Pair<String, Integer>(greatGeneralModifier.getGeneral().getName(), greatGeneralModifier.getBonus() * 2);
        }
        return new Pair<String, Integer>(greatGeneralModifier.getGeneral().getName(), greatGeneralModifier.getBonus());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Tile getBestAffectedTroopsTile(@NotNull MapUnit general) {
        Object v2;
        void $this$maxByOrNull$iv;
        Object object;
        Intrinsics.checkNotNullParameter(general, "general");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                GeneralBonusData it = (GeneralBonusData)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getBonus());
                it = (GeneralBonusData)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getBonus());
            }
        };
        List generalBonusData2 = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.map(MapUnit.getMatchingUniques$default(general, UniqueType.StrengthBonusInRadius, null, false, 6, null), (Function1)new Function1<Unique, GeneralBonusData>(general){
            final /* synthetic */ MapUnit $general;
            {
                this.$general = $general;
                super(1);
            }

            @NotNull
            public final GeneralBonusData invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return new GeneralBonusData(this.$general, it);
            }
        }), new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    GeneralBonusData it = (GeneralBonusData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRadius());
                    it = (GeneralBonusData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getRadius());
                }
                return n;
            }
        }));
        int unitMaxMovement = MapUnit.getMaxMovement$default(general, false, 1, null);
        Sequence militaryUnitTilesInDistance2 = SequencesKt.filter(SequencesKt.map(MapsKt.asSequence(UnitMovement.getDistanceToTiles$default(general.getMovement(), false, null, null, false, 15, null)), getBestAffectedTroopsTile.militaryUnitTilesInDistance.1.INSTANCE), (Function1)new Function1<Tile, Boolean>(general, unitMaxMovement){
            final /* synthetic */ MapUnit $general;
            final /* synthetic */ int $unitMaxMovement;
            {
                this.$general = $general;
                this.$unitMaxMovement = $unitMaxMovement;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile tile) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                MapUnit militaryUnit = tile.getMilitaryUnit();
                return militaryUnit != null && Intrinsics.areEqual(militaryUnit.getCiv(), this.$general.getCiv()) && (tile.getCivilianUnit() == null || Intrinsics.areEqual(tile.getCivilianUnit(), this.$general)) && MapUnit.getMaxMovement$default(militaryUnit, false, 1, null) <= this.$unitMaxMovement && !tile.isCityCenter();
            }
        });
        Iterator iterator2 = ((Iterable)generalBonusData2).iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = (GeneralBonusData)iterator2.next();
            boolean bl = false;
            it = ((GeneralBonusData)it).getRadius();
            while (iterator2.hasNext()) {
                Object it2 = (GeneralBonusData)iterator2.next();
                $i$a$-maxOfOrNull-GreatGeneralImplementation$getBestAffectedTroopsTile$unitBonusRadius$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((GeneralBonusData)it2).getRadius())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return null;
        }
        int unitBonusRadius = n;
        HashMap militaryUnitToHasAttackableEnemies = new HashMap();
        Sequence sequence = militaryUnitTilesInDistance2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                int n2;
                boolean bl;
                GeneralBonusData it;
                Object answer$iv;
                Object $this$getOrPut$iv;
                MapUnit militaryUnit;
                Tile affectedTile;
                boolean bl2;
                int n3;
                Tile tile;
                Tile unitTile = (Tile)maxElem$iv;
                boolean bl3 = false;
                Sequence<Tile> sequence2 = unitTile.getTilesInDistance(unitBonusRadius);
                int n4 = 0;
                Iterator<Tile> iterator3 = sequence2.iterator();
                while (iterator3.hasNext()) {
                    int n5;
                    Tile tile2 = tile = iterator3.next();
                    n3 = n4;
                    bl2 = false;
                    militaryUnit = affectedTile.getMilitaryUnit();
                    if (militaryUnit == null || !Intrinsics.areEqual(militaryUnit.getCiv(), general.getCiv()) || militaryUnit.isEmbarked()) {
                        n5 = 0;
                    } else {
                        Object object2;
                        $this$getOrPut$iv = militaryUnitToHasAttackableEnemies;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(militaryUnit);
                        if (value$iv == null) {
                            boolean bl4 = false;
                            answer$iv = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, militaryUnit, UnitMovement.getDistanceToTiles$default(militaryUnit.getMovement(), false, null, null, false, 15, null), null, false, 12, null).isEmpty();
                            $this$getOrPut$iv.put(militaryUnit, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        if (((Boolean)object2).booleanValue()) {
                            n5 = 0;
                        } else {
                            Object v6;
                            block25: {
                                Iterable $this$firstOrNull$iv = generalBonusData2;
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv) {
                                    it = (GeneralBonusData)element$iv;
                                    bl = false;
                                    boolean bl5 = affectedTile.aerialDistanceTo(unitTile) <= it.getRadius() && (Intrinsics.areEqual(it.getFilter(), "Military") || MapUnit.matchesFilter$default(militaryUnit, it.getFilter(), false, 2, null));
                                    if (!bl5) continue;
                                    v6 = element$iv;
                                    break block25;
                                }
                                v6 = null;
                            }
                            $this$getOrPut$iv = v6;
                            n5 = $this$getOrPut$iv != null ? ((GeneralBonusData)$this$getOrPut$iv).getBonus() : 0;
                        }
                    }
                    n2 = n5;
                    n4 = n3 + n2;
                }
                int maxValue$iv = n4;
                do {
                    Object e$iv = iterator$iv.next();
                    unitTile = (Tile)e$iv;
                    bl3 = false;
                    sequence2 = unitTile.getTilesInDistance(unitBonusRadius);
                    n4 = 0;
                    iterator3 = sequence2.iterator();
                    while (iterator3.hasNext()) {
                        int n6;
                        affectedTile = tile = iterator3.next();
                        n3 = n4;
                        bl2 = false;
                        militaryUnit = affectedTile.getMilitaryUnit();
                        if (militaryUnit == null || !Intrinsics.areEqual(militaryUnit.getCiv(), general.getCiv()) || militaryUnit.isEmbarked()) {
                            n6 = 0;
                        } else {
                            Object object3;
                            $this$getOrPut$iv = militaryUnitToHasAttackableEnemies;
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(militaryUnit);
                            if (value$iv == null) {
                                boolean bl6 = false;
                                answer$iv = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, militaryUnit, UnitMovement.getDistanceToTiles$default(militaryUnit.getMovement(), false, null, null, false, 15, null), null, false, 12, null).isEmpty();
                                $this$getOrPut$iv.put(militaryUnit, answer$iv);
                                object3 = answer$iv;
                            } else {
                                object3 = value$iv;
                            }
                            if (((Boolean)object3).booleanValue()) {
                                n6 = 0;
                            } else {
                                Object v10;
                                block26: {
                                    Iterable $this$firstOrNull$iv = generalBonusData2;
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv : $this$firstOrNull$iv) {
                                        it = (GeneralBonusData)element$iv;
                                        bl = false;
                                        boolean bl7 = affectedTile.aerialDistanceTo(unitTile) <= it.getRadius() && (Intrinsics.areEqual(it.getFilter(), "Military") || MapUnit.matchesFilter$default(militaryUnit, it.getFilter(), false, 2, null));
                                        if (!bl7) continue;
                                        v10 = element$iv;
                                        break block26;
                                    }
                                    v10 = null;
                                }
                                GeneralBonusData generalBonusData3 = v10;
                                n6 = generalBonusData3 != null ? generalBonusData3.getBonus() : 0;
                            }
                        }
                        n2 = n6;
                        n4 = n3 + n2;
                    }
                    int v$iv = n4;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        return v2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/battle/GreatGeneralImplementation$GeneralBonusData;", "", "general", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/models/ruleset/unique/Unique;)V", "radius", "", "filter", "", "bonus", "(Lcom/unciv/logic/map/mapunit/MapUnit;ILjava/lang/String;I)V", "getBonus", "()I", "getFilter", "()Ljava/lang/String;", "getGeneral", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getRadius", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class GeneralBonusData {
        @NotNull
        private final MapUnit general;
        private final int radius;
        @NotNull
        private final String filter;
        private final int bonus;

        public GeneralBonusData(@NotNull MapUnit general, int radius, @NotNull String filter2, int bonus) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(filter2, "filter");
            this.general = general;
            this.radius = radius;
            this.filter = filter2;
            this.bonus = bonus;
        }

        @NotNull
        public final MapUnit getGeneral() {
            return this.general;
        }

        public final int getRadius() {
            return this.radius;
        }

        @NotNull
        public final String getFilter() {
            return this.filter;
        }

        public final int getBonus() {
            return this.bonus;
        }

        public GeneralBonusData(@NotNull MapUnit general, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(unique, "unique");
            Integer n = StringsKt.toIntOrNull(unique.getParams().get(2));
            Integer n2 = StringsKt.toIntOrNull(unique.getParams().get(0));
            this(general, n != null ? n : 0, unique.getParams().get(1), n2 != null ? n2 : 0);
        }

        @NotNull
        public final MapUnit component1() {
            return this.general;
        }

        public final int component2() {
            return this.radius;
        }

        @NotNull
        public final String component3() {
            return this.filter;
        }

        public final int component4() {
            return this.bonus;
        }

        @NotNull
        public final GeneralBonusData copy(@NotNull MapUnit general, int radius, @NotNull String filter2, int bonus) {
            Intrinsics.checkNotNullParameter(general, "general");
            Intrinsics.checkNotNullParameter(filter2, "filter");
            return new GeneralBonusData(general, radius, filter2, bonus);
        }

        public static /* synthetic */ GeneralBonusData copy$default(GeneralBonusData generalBonusData2, MapUnit mapUnit, int n, String string, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                mapUnit = generalBonusData2.general;
            }
            if ((n3 & 2) != 0) {
                n = generalBonusData2.radius;
            }
            if ((n3 & 4) != 0) {
                string = generalBonusData2.filter;
            }
            if ((n3 & 8) != 0) {
                n2 = generalBonusData2.bonus;
            }
            return generalBonusData2.copy(mapUnit, n, string, n2);
        }

        @NotNull
        public String toString() {
            return "GeneralBonusData(general=" + this.general + ", radius=" + this.radius + ", filter=" + this.filter + ", bonus=" + this.bonus + ')';
        }

        public int hashCode() {
            int result2 = this.general.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.radius);
            result2 = result2 * 31 + this.filter.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.bonus);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneralBonusData)) {
                return false;
            }
            GeneralBonusData generalBonusData2 = (GeneralBonusData)other;
            if (!Intrinsics.areEqual(this.general, generalBonusData2.general)) {
                return false;
            }
            if (this.radius != generalBonusData2.radius) {
                return false;
            }
            if (!Intrinsics.areEqual(this.filter, generalBonusData2.filter)) {
                return false;
            }
            return this.bonus == generalBonusData2.bonus;
        }
    }
}

