/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityResources;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rH\u0002J<\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rH\u0002J<\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J<\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rH\u0002J2\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rJ4\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/city/CityResources;", "", "()V", "addCityResourcesGeneratedFromUniqueBuildings", "", "city", "Lcom/unciv/logic/city/City;", "cityResources", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "resourceModifer", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "addResourceFromUniqueImprovedTiles", "addResourcesFromTiles", "getAvailableResourceAmount", "", "resourceName", "getCityResourcesAvailableToCity", "getCityResourcesFromCiv", "resourceModifers", "getResourcesGeneratedByCity", "resourceModifiers", "getResourcesGeneratedByCityNotIncludingBuildings", "getTileResourceAmount", "tile", "Lcom/unciv/logic/map/tile/Tile;", "removeCityResourcesRequiredByBuildings", "core"})
@SourceDebugExtension(value={"SMAP\nCityResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityResources.kt\ncom/unciv/logic/city/CityResources\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class CityResources {
    @NotNull
    public static final CityResources INSTANCE = new CityResources();

    private CityResources() {
    }

    @NotNull
    public final ResourceSupplyList getResourcesGeneratedByCity(@NotNull City city2, @NotNull HashMap<String, Float> resourceModifiers) {
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(resourceModifiers, "resourceModifiers");
        ResourceSupplyList cityResources = this.getResourcesGeneratedByCityNotIncludingBuildings(city2, resourceModifiers);
        this.addCityResourcesGeneratedFromUniqueBuildings(city2, cityResources, resourceModifiers);
        return cityResources;
    }

    @NotNull
    public final ResourceSupplyList getCityResourcesAvailableToCity(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        HashMap<String, Float> resourceModifers = new HashMap<String, Float>();
        for (TileResource resource2 : city2.getCiv().getGameInfo().getRuleset().getTileResources().values()) {
            Map map2 = resourceModifers;
            String string = resource2.getName();
            Civilization civilization = city2.getCiv();
            Intrinsics.checkNotNull(resource2);
            map2.put(string, Float.valueOf(civilization.getResourceModifier(resource2)));
        }
        ResourceSupplyList cityResources = this.getResourcesGeneratedByCityNotIncludingBuildings(city2, resourceModifers);
        this.getCityResourcesFromCiv(city2, cityResources, resourceModifers);
        CollectionsKt.removeAll(cityResources, (Function1)getCityResourcesAvailableToCity.1.INSTANCE);
        return cityResources;
    }

    private final ResourceSupplyList getResourcesGeneratedByCityNotIncludingBuildings(City city2, HashMap<String, Float> resourceModifers) {
        ResourceSupplyList cityResources = new ResourceSupplyList(false, 1, null);
        this.addResourcesFromTiles(city2, resourceModifers, cityResources);
        this.addResourceFromUniqueImprovedTiles(city2, cityResources, resourceModifers);
        this.removeCityResourcesRequiredByBuildings(city2, cityResources);
        if (city2.getCiv().isCityState() && city2.isCapital() && city2.getCiv().getCityStateResource() != null) {
            Object v = ((Map)city2.getRuleset().getTileResources()).get(city2.getCiv().getCityStateResource());
            Intrinsics.checkNotNull(v);
            ResourceSupplyList.add$default(cityResources, (TileResource)v, "Mercantile City-State", 0, 4, null);
        }
        return cityResources;
    }

    private final void addCityResourcesGeneratedFromUniqueBuildings(City city2, ResourceSupplyList cityResources, HashMap<String, Float> resourceModifer) {
        Iterator<Unique> iterator2 = city2.getMatchingUniques(UniqueType.ProvidesResources, city2.getState(), false).iterator();
        while (iterator2.hasNext()) {
            TileResource resource2;
            Unique unique = iterator2.next();
            if (city2.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
            String string = unique.getSourceNameForUser();
            float f = Float.parseFloat(unique.getParams().get(0));
            Float f2 = resourceModifer.get(resource2.getName());
            Intrinsics.checkNotNull(f2);
            cityResources.add(resource2, string, (int)(f * ((Number)f2).floatValue()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getAvailableResourceAmount(@NotNull City city2, @NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        TileResource tileResource = city2.getRuleset().getTileResources().get(resourceName);
        if (tileResource == null) {
            return 0;
        }
        TileResource resource2 = tileResource;
        if (!resource2.isCityWide()) {
            return city2.getCiv().getResourceAmount(resourceName);
        }
        if (resource2.isStockpiled()) {
            return ((Number)city2.getResourceStockpiles().get((Object)resourceName)).intValue();
        }
        Sequence sequence = SequencesKt.filter(CollectionsKt.asSequence(this.getCityResourcesAvailableToCity(city2)), (Function1)new Function1<ResourceSupplyList.ResourceSupply, Boolean>(resource2){
            final /* synthetic */ TileResource $resource;
            {
                this.$resource = $resource;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResourceSupplyList.ResourceSupply it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getResource(), this.$resource);
            }
        });
        int n = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAmount();
            n = n2 + n3;
        }
        return n;
    }

    private final void addResourcesFromTiles(City city2, HashMap<String, Float> resourceModifer, ResourceSupplyList cityResources) {
        Iterator<Tile> iterator2 = SequencesKt.filter(city2.getTiles(), addResourcesFromTiles.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Tile tileInfo = iterator2.next();
            TileResource resource2 = tileInfo.getTileResource();
            float f = this.getTileResourceAmount(city2, tileInfo);
            Float f2 = resourceModifer.get(resource2.getName());
            Intrinsics.checkNotNull(f2);
            float amount = f * ((Number)f2).floatValue();
            if (!(amount > 0.0f)) continue;
            cityResources.add(resource2, "Tiles", (int)amount);
        }
    }

    private final void addResourceFromUniqueImprovedTiles(City city2, ResourceSupplyList cityResources, HashMap<String, Float> resourceModifer) {
        Iterator<Tile> iterator2 = SequencesKt.filter(city2.getTiles(), addResourceFromUniqueImprovedTiles.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            TileResource resource2;
            Unique unique;
            TileImprovement tileImprovement;
            Tile tileInfo = iterator2.next();
            StateForConditionals stateForConditionals = new StateForConditionals(city2.getCiv(), city2, null, tileInfo, null, null, null, null, null, null, false, 2036, null);
            TileImprovement tileImprovement2 = tileImprovement = tileInfo.getUnpillagedTileImprovement();
            Intrinsics.checkNotNull(tileImprovement2);
            Iterator<Unique> iterator3 = tileImprovement2.getMatchingUniques(UniqueType.ProvidesResources, stateForConditionals).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                if (city2.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
                float f = Float.parseFloat(unique.getParams().get(0));
                Float f2 = resourceModifer.get(resource2.getName());
                Intrinsics.checkNotNull(f2);
                cityResources.add(resource2, "Improvements", (int)(f * ((Number)f2).floatValue()));
            }
            iterator3 = tileImprovement.getMatchingUniques(UniqueType.ConsumesResources, stateForConditionals).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                if (city2.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
                cityResources.add(resource2, "Improvements", -1 * Integer.parseInt(unique.getParams().get(0)));
            }
        }
    }

    private final void removeCityResourcesRequiredByBuildings(City city2, ResourceSupplyList cityResources) {
        Set<String> freeBuildings = city2.getCiv().getCivConstructions().getFreeBuildingNames(city2);
        Iterator<Building> iterator2 = city2.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            if (freeBuildings.contains(building.getName())) continue;
            cityResources.subtractResourceRequirements((HashMap<String, Integer>)building.getResourceRequirementsPerTurn(city2.getState()), city2.getRuleset(), "Buildings");
        }
    }

    private final void getCityResourcesFromCiv(City city2, ResourceSupplyList cityResources, HashMap<String, Float> resourceModifers) {
        Iterator iterator2 = City.getMatchingUniques$default(city2, UniqueType.ProvidesResources, city2.getState(), false, 4, null).iterator();
        while (iterator2.hasNext()) {
            TileResource resource2;
            Unique unique = (Unique)iterator2.next();
            if (city2.getRuleset().getTileResources().get(unique.getParams().get(1)) == null) continue;
            String string = unique.getSourceNameForUser();
            float f = Float.parseFloat(unique.getParams().get(0));
            Float f2 = resourceModifers.get(resource2.getName());
            Intrinsics.checkNotNull(f2);
            cityResources.add(resource2, string, (int)(f * ((Number)f2).floatValue()));
        }
    }

    private final int getTileResourceAmount(City city2, Tile tile) {
        int amountToAdd;
        if (tile.getResource() == null) {
            return 0;
        }
        if (!tile.providesResources(city2.getCiv())) {
            return 0;
        }
        TileResource resource2 = tile.getTileResource();
        int n = amountToAdd = resource2.getResourceType() == ResourceType.Strategic ? tile.getResourceAmount() : 1;
        if (resource2.getResourceType() == ResourceType.Luxury && City.containsBuildingUnique$default(city2, UniqueType.ProvidesExtraLuxuryFromCityResources, null, 2, null)) {
            ++amountToAdd;
        }
        return amountToAdd;
    }
}

