/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.VictoryManager;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J6\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2&\u0010\u001b\u001a\"\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001cj\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0$J\b\u0010%\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0002J\u0006\u0010(\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020\u0011J\b\u0010*\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/unciv/logic/civilization/managers/VictoryManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "currentsSpaceshipParts", "Lcom/unciv/models/Counter;", "", "getCurrentsSpaceshipParts", "()Lcom/unciv/models/Counter;", "setCurrentsSpaceshipParts", "(Lcom/unciv/models/Counter;)V", "hasEverWonDiplomaticVote", "", "getHasEverWonDiplomaticVote", "()Z", "setHasEverWonDiplomaticVote", "(Z)V", "amountMilestonesCompleted", "", "victory", "Lcom/unciv/models/ruleset/Victory;", "calculateDiplomaticVotingResults", "votesCast", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "clone", "getDiplomaticVictoryVoteBreakdown", "Lcom/unciv/logic/civilization/managers/VictoryManager$DiplomaticVictoryVoteBreakdown;", "getNextMilestone", "Lcom/unciv/models/ruleset/Milestone;", "getUNBuildingAndOwnerNames", "Lkotlin/Pair;", "getVictoryTypeAchieved", "getVotingCivs", "Lkotlin/sequences/Sequence;", "hasEnoughVotesForDiplomaticVictory", "hasWon", "votesNeededForDiplomaticVictory", "DiplomaticVictoryVoteBreakdown", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryManager.kt\ncom/unciv/logic/civilization/managers/VictoryManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1#2:143\n553#3,3:144\n125#3:169\n152#3,3:170\n1003#4:147\n1037#4,3:148\n1040#4,3:158\n614#4:161\n372#5,7:151\n526#5:162\n511#5,6:163\n288#6,2:173\n*S KotlinDebug\n*F\n+ 1 VictoryManager.kt\ncom/unciv/logic/civilization/managers/VictoryManager\n*L\n81#1:144,3\n113#1:169\n113#1:170,3\n88#1:147\n88#1:148,3\n88#1:158,3\n89#1:161\n88#1:151,7\n112#1:162\n112#1:163,6\n114#1:173,2\n*E\n"})
public final class VictoryManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    @NotNull
    private Counter<String> currentsSpaceshipParts = new Counter(null, 1, null);
    private boolean hasEverWonDiplomaticVote;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final Counter<String> getCurrentsSpaceshipParts() {
        return this.currentsSpaceshipParts;
    }

    public final void setCurrentsSpaceshipParts(@NotNull Counter<String> counter) {
        Intrinsics.checkNotNullParameter(counter, "<set-?>");
        this.currentsSpaceshipParts = counter;
    }

    public final boolean getHasEverWonDiplomaticVote() {
        return this.hasEverWonDiplomaticVote;
    }

    public final void setHasEverWonDiplomaticVote(boolean bl) {
        this.hasEverWonDiplomaticVote = bl;
    }

    @NotNull
    public final VictoryManager clone() {
        VictoryManager toReturn = new VictoryManager();
        toReturn.currentsSpaceshipParts.putAll((Map)this.currentsSpaceshipParts);
        toReturn.hasEverWonDiplomaticVote = this.hasEverWonDiplomaticVote;
        return toReturn;
    }

    private final Counter<String> calculateDiplomaticVotingResults(HashMap<String, String> votesCast) {
        Counter<String> results = new Counter<String>(null, 1, null);
        String civOwningUN = this.getUNBuildingAndOwnerNames().component2();
        for (Map.Entry entry : ((Map)votesCast).entrySet()) {
            String voter = (String)entry.getKey();
            String votedFor = (String)entry.getValue();
            if (votedFor == null) continue;
            results.add(votedFor, Intrinsics.areEqual(voter, civOwningUN) ? 2 : 1);
        }
        return results;
    }

    private final Sequence<Civilization> getVotingCivs() {
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.getCivInfo().getGameInfo().getCivilizations()), getVotingCivs.1.INSTANCE);
    }

    @NotNull
    public final Pair<String, String> getUNBuildingAndOwnerNames() {
        Pair<Object, Object> pair = (Pair<Object, Object>)SequencesKt.firstOrNull(SequencesKt.flatMap(this.getVotingCivs(), getUNBuildingAndOwnerNames.1.INSTANCE));
        if (pair == null) {
            pair = TuplesKt.to(null, null);
        }
        return pair;
    }

    private final int votesNeededForDiplomaticVictory() {
        String civOwningUN = this.getUNBuildingAndOwnerNames().component2();
        int voteCount = SequencesKt.count(this.getVotingCivs()) + (civOwningUN != null ? 1 : 0);
        if (voteCount > 28) {
            return voteCount * 35 / 100;
        }
        return voteCount * (67 - (int)(1.1 * (double)voteCount)) / 100 + 1;
    }

    public final boolean hasEnoughVotesForDiplomaticVictory() {
        boolean bl;
        block11: {
            Object v0;
            Counter<String> results = this.calculateDiplomaticVotingResults(this.getCivInfo().getGameInfo().getDiplomaticVictoryVotesCast());
            Object object = ((Map)results).entrySet();
            Iterator iterator2 = object.iterator();
            if (!iterator2.hasNext()) {
                v0 = null;
            } else {
                Object t = iterator2.next();
                if (!iterator2.hasNext()) {
                    v0 = t;
                } else {
                    Map.Entry it22 = (Map.Entry)t;
                    boolean bl2 = false;
                    int it22 = ((Number)it22.getValue()).intValue();
                    do {
                        Object t2 = iterator2.next();
                        Map.Entry it = (Map.Entry)t2;
                        $i$a$-maxByOrNull-VictoryManager$hasEnoughVotesForDiplomaticVictory$bestCiv$1 = false;
                        int n = ((Number)it.getValue()).intValue();
                        if (it22 >= n) continue;
                        t = t2;
                        it22 = n;
                    } while (iterator2.hasNext());
                    v0 = t;
                }
            }
            Map.Entry entry = v0;
            if (entry == null) {
                return false;
            }
            Map.Entry bestCiv = entry;
            if (!Intrinsics.areEqual(bestCiv.getKey(), this.getCivInfo().getCivName())) {
                return false;
            }
            if (((Number)bestCiv.getValue()).intValue() < this.votesNeededForDiplomaticVictory()) {
                return false;
            }
            Map $this$none$iv = results;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                object = $this$none$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it, bestCiv) && ((Number)it.getValue()).intValue() == ((Number)bestCiv.getValue()).intValue())) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DiplomaticVictoryVoteBreakdown getDiplomaticVictoryVoteBreakdown() {
        void $this$sortedByDescending$iv;
        void $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv;
        Counter<String> results = this.calculateDiplomaticVotingResults(this.getCivInfo().getGameInfo().getDiplomaticVictoryVotesCast());
        Sequence sequence = MapsKt.asSequence((Map)results);
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-VictoryManager$getDiplomaticVictoryVoteBreakdown$32 = false;
            Integer key$iv$iv = ((Number)it2.getValue()).intValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Map.Entry $i$a$-groupBy-VictoryManager$getDiplomaticVictoryVoteBreakdown$32 = (Map.Entry)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            list2.add((String)it.getKey());
        }
        $this$groupBy$iv = MapsKt.asSequence(destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        Map.Entry entry = (Map.Entry)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getKey()));
            }
        }));
        if (entry == null) {
            return new DiplomaticVictoryVoteBreakdown(results, "No valid votes were cast.");
        }
        Map.Entry entry2 = entry;
        int voteCount = ((Number)entry2.getKey()).intValue();
        List winnerList = (List)entry2.getValue();
        ArrayList lines2 = new ArrayList();
        int minVotes = this.votesNeededForDiplomaticVictory();
        if (voteCount < minVotes) {
            ((Collection)lines2).add("Minimum votes for electing a world leader: [" + minVotes + ']');
        }
        if (winnerList.size() > 1) {
            ((Collection)lines2).add("Tied in first position: [" + CollectionsKt.joinToString$default(winnerList, null, null, null, 0, null, getDiplomaticVictoryVoteBreakdown.4.INSTANCE, 31, null) + ']');
        }
        Civilization winnerCiv = this.getCivInfo().getGameInfo().getCivilization((String)CollectionsKt.first(winnerList));
        ((Collection)lines2).add(!((Collection)lines2).isEmpty() ? "No world leader was elected." : (Intrinsics.areEqual(winnerCiv, this.getCivInfo()) ? "You have been elected world leader!" : winnerCiv.getNation().getLeaderDisplayName() + " has been elected world leader!"));
        return new DiplomaticVictoryVoteBreakdown(results, CollectionsKt.joinToString$default(lines2, "\n", null, null, 0, null, getDiplomaticVictoryVoteBreakdown.5.INSTANCE, 30, null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getVictoryTypeAchieved() {
        Victory victory;
        Object v0;
        block6: {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Map $this$filterTo$iv$iv;
            if (!this.getCivInfo().isMajorCiv()) {
                return null;
            }
            ArrayList<String> enabledVictories = this.getCivInfo().getGameInfo().getGameParameters().getVictoryTypes();
            Map $this$filter$iv = this.getCivInfo().getGameInfo().getRuleset().getVictories();
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), "Neutral") && enabledVictories.contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add((Victory)it.getValue());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Victory it2 = (Victory)element$iv;
                boolean bl = false;
                if (!(this.getNextMilestone(it2) == null)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Victory victory2 = victory = (Victory)v0;
        if (victory2 != null) {
            return victory2.getName();
        }
        if (Civilization.hasUnique$default(this.getCivInfo(), UniqueType.TriggersVictory, null, 2, null)) {
            return "Neutral";
        }
        return null;
    }

    @Nullable
    public final Milestone getNextMilestone(@NotNull Victory victory) {
        Intrinsics.checkNotNullParameter(victory, "victory");
        for (Milestone milestone : victory.getMilestoneObjects()) {
            if (milestone.hasBeenCompletedBy(this.getCivInfo())) continue;
            return milestone;
        }
        return null;
    }

    public final int amountMilestonesCompleted(@NotNull Victory victory) {
        Intrinsics.checkNotNullParameter(victory, "victory");
        int completed = 0;
        for (Milestone milestone : victory.getMilestoneObjects()) {
            if (!milestone.hasBeenCompletedBy(this.getCivInfo())) break;
            ++completed;
        }
        return completed;
    }

    public final boolean hasWon() {
        return this.getVictoryTypeAchieved() != null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/civilization/managers/VictoryManager$DiplomaticVictoryVoteBreakdown;", "", "results", "Lcom/unciv/models/Counter;", "", "winnerText", "(Lcom/unciv/models/Counter;Ljava/lang/String;)V", "getResults", "()Lcom/unciv/models/Counter;", "getWinnerText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class DiplomaticVictoryVoteBreakdown {
        @NotNull
        private final Counter<String> results;
        @NotNull
        private final String winnerText;

        public DiplomaticVictoryVoteBreakdown(@NotNull Counter<String> results, @NotNull String winnerText) {
            Intrinsics.checkNotNullParameter(results, "results");
            Intrinsics.checkNotNullParameter(winnerText, "winnerText");
            this.results = results;
            this.winnerText = winnerText;
        }

        @NotNull
        public final Counter<String> getResults() {
            return this.results;
        }

        @NotNull
        public final String getWinnerText() {
            return this.winnerText;
        }

        @NotNull
        public final Counter<String> component1() {
            return this.results;
        }

        @NotNull
        public final String component2() {
            return this.winnerText;
        }

        @NotNull
        public final DiplomaticVictoryVoteBreakdown copy(@NotNull Counter<String> results, @NotNull String winnerText) {
            Intrinsics.checkNotNullParameter(results, "results");
            Intrinsics.checkNotNullParameter(winnerText, "winnerText");
            return new DiplomaticVictoryVoteBreakdown(results, winnerText);
        }

        public static /* synthetic */ DiplomaticVictoryVoteBreakdown copy$default(DiplomaticVictoryVoteBreakdown diplomaticVictoryVoteBreakdown, Counter counter, String string, int n, Object object) {
            if ((n & 1) != 0) {
                counter = diplomaticVictoryVoteBreakdown.results;
            }
            if ((n & 2) != 0) {
                string = diplomaticVictoryVoteBreakdown.winnerText;
            }
            return diplomaticVictoryVoteBreakdown.copy(counter, string);
        }

        @NotNull
        public String toString() {
            return "DiplomaticVictoryVoteBreakdown(results=" + this.results + ", winnerText=" + this.winnerText + ')';
        }

        public int hashCode() {
            int result2 = this.results.hashCode();
            result2 = result2 * 31 + this.winnerText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiplomaticVictoryVoteBreakdown)) {
                return false;
            }
            DiplomaticVictoryVoteBreakdown diplomaticVictoryVoteBreakdown = (DiplomaticVictoryVoteBreakdown)other;
            if (!Intrinsics.areEqual(this.results, diplomaticVictoryVoteBreakdown.results)) {
                return false;
            }
            return Intrinsics.areEqual(this.winnerText, diplomaticVictoryVoteBreakdown.winnerText);
        }
    }
}

