/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.GameInfoSerializationVersion;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.IncompatibleGameInfoVersionException;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSettingsMigrationsKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.screens.modmanager.ModUIData;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u0011H\u0002J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110%2\b\b\u0002\u0010)\u001a\u00020\u000fJ\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110%2\u0006\u0010'\u001a\u00020\u0005H\u0002J \u0010*\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00110\u0011\u0012\u0004\u0012\u00020-0+0%J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0005J2\u00100\u001a\u0002012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u000201032\u0016\u00104\u001a\u0012\u0012\b\u0012\u000605j\u0002`6\u0012\u0004\u0012\u00020103J\u000e\u00107\u001a\u00020/2\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u00108\u001a\u0002092\u0006\u0010\u0015\u001a\u00020\u0011J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;J\u000e\u0010=\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0005J4\u0010>\u001a\u0002012\u0006\u0010?\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00112\u001c\b\u0002\u0010@\u001a\u0016\u0012\f\u0012\n\u0018\u000105j\u0004\u0018\u0001`6\u0012\u0004\u0012\u00020103J4\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u00052\u001c\b\u0002\u0010@\u001a\u0016\u0012\f\u0012\n\u0018\u000105j\u0004\u0018\u0001`6\u0012\u0004\u0012\u00020103J<\u0010A\u001a\u0002012\u0006\u0010?\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u0002010C2\u0016\u00104\u001a\u0012\u0012\b\u0012\u000605j\u0002`6\u0012\u0004\u0012\u00020103J\u0014\u0010D\u001a\u0002012\f\u0010E\u001a\b\u0012\u0004\u0012\u00020<0;J4\u0010F\u001a\u0002012\u0006\u0010?\u001a\u0002092\u0006\u0010\u0010\u001a\u00020\u00112\u001c\b\u0002\u0010@\u001a\u0016\u0012\f\u0012\n\u0018\u000105j\u0004\u0018\u0001`6\u0012\u0004\u0012\u00020103J4\u0010F\u001a\u00020\u00112\u0006\u0010?\u001a\u0002092\u0006\u0010\u0012\u001a\u00020\u00052\u001c\b\u0002\u0010@\u001a\u0016\u0012\f\u0012\n\u0018\u000105j\u0004\u0018\u0001`6\u0012\u0004\u0012\u00020103J\u000e\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/unciv/logic/files/UncivFiles;", "", "files", "Lcom/badlogic/gdx/Files;", "customDataDirectory", "", "(Lcom/badlogic/gdx/Files;Ljava/lang/String;)V", "autosaves", "Lcom/unciv/logic/files/Autosaves;", "getAutosaves", "()Lcom/unciv/logic/files/Autosaves;", "getCustomDataDirectory", "()Ljava/lang/String;", "scenarioFolder", "deleteSave", "", "file", "Lcom/badlogic/gdx/files/FileHandle;", "gameName", "emptyFile", "Lcom/badlogic/gdx/utils/SerializationException;", "gameFile", "fileWriter", "Ljava/io/Writer;", "path", "append", "getDataFolder", "getGeneralSettings", "Lcom/unciv/models/metadata/GameSettings;", "getGeneralSettingsFile", "getLocalFile", "fileName", "getModFolder", "modName", "getModsFolder", "getMultiplayerSave", "getMultiplayerSaves", "Lkotlin/sequences/Sequence;", "getSave", "saveFolder", "getSaves", "autoSaves", "getScenarioFiles", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "Lcom/unciv/models/ruleset/Ruleset;", "loadGameByName", "Lcom/unciv/logic/GameInfo;", "loadGameFromCustomLocation", "", "onLoaded", "Lkotlin/Function1;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadGameFromFile", "loadGamePreviewFromFile", "Lcom/unciv/logic/GameInfoPreview;", "loadModCache", "", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "pathToFileHandler", "saveGame", "game", "saveCompletionCallback", "saveGameToCustomLocation", "onSaved", "Lkotlin/Function0;", "saveModCache", "modDataList", "saveMultiplayerGamePreview", "setGeneralSettings", "gameSettings", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
public final class UncivFiles {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Files files;
    @Nullable
    private final String customDataDirectory;
    @NotNull
    private final Autosaves autosaves;
    @NotNull
    private final String scenarioFolder;
    private static boolean saveZipped;
    private static boolean preferExternalStorage;
    @NotNull
    private static PlatformSaverLoader saverLoader;
    @NotNull
    private static final Set<Character> charsForbiddenInFileNames;
    @NotNull
    private static final TextField.TextFieldFilter _fileNameTextFieldFilter;

    public UncivFiles(@NotNull Files files2, @Nullable String customDataDirectory) {
        Intrinsics.checkNotNullParameter(files2, "files");
        this.files = files2;
        this.customDataDirectory = customDataDirectory;
        Object[] objectArray = new Object[]{this.files.getLocalStoragePath(), this.files.getExternalStoragePath()};
        LogKt.debug("Creating UncivFiles, localStoragePath: %s, externalStoragePath: %s", objectArray);
        this.autosaves = new Autosaves(this);
        this.scenarioFolder = "scenarios";
    }

    public /* synthetic */ UncivFiles(Files files2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(files2, string);
    }

    @Nullable
    public final String getCustomDataDirectory() {
        return this.customDataDirectory;
    }

    @NotNull
    public final Autosaves getAutosaves() {
        return this.autosaves;
    }

    @NotNull
    public final FileHandle getLocalFile(@NotNull String fileName) {
        FileHandle fileHandle;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        if (this.customDataDirectory == null) {
            FileHandle fileHandle2 = this.files.local(fileName);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "local(...)");
        } else {
            FileHandle fileHandle3 = this.files.absolute(this.customDataDirectory + File.separator + fileName);
            fileHandle = fileHandle3;
            Intrinsics.checkNotNullExpressionValue(fileHandle3, "absolute(...)");
        }
        return fileHandle;
    }

    @NotNull
    public final FileHandle getModsFolder() {
        return this.getLocalFile("mods");
    }

    @NotNull
    public final FileHandle getModFolder(@NotNull String modName) {
        Intrinsics.checkNotNullParameter(modName, "modName");
        FileHandle fileHandle = this.getModsFolder().child(modName);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
        return fileHandle;
    }

    @NotNull
    public final FileHandle getDataFolder() {
        return this.getLocalFile("");
    }

    @NotNull
    public final FileHandle getSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("SaveFiles", gameName);
    }

    @NotNull
    public final FileHandle getMultiplayerSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("MultiplayerGames", gameName);
    }

    private final FileHandle getSave(String saveFolder, String gameName) {
        FileHandle fileHandle;
        Object[] objectArray = new Object[]{gameName, saveFolder, preferExternalStorage, this.files.getExternalStoragePath()};
        LogKt.debug("Getting save %s from folder %s, preferExternal: %s", objectArray);
        String location = saveFolder + '/' + gameName;
        FileHandle localFile = this.getLocalFile(location);
        FileHandle externalFile = this.files.external(location);
        if (this.files.isExternalStorageAvailable() && (externalFile.exists() && !localFile.exists() || preferExternalStorage && (externalFile.exists() || !localFile.exists()))) {
            if (externalFile.isDirectory()) {
                externalFile.deleteDirectory();
            }
            externalFile.parent().mkdirs();
            fileHandle = externalFile;
        } else {
            fileHandle = localFile;
        }
        FileHandle toReturn = fileHandle;
        Object[] objectArray2 = new Object[]{toReturn.file().getAbsolutePath()};
        LogKt.debug("Save found: %s", objectArray2);
        Intrinsics.checkNotNull(toReturn);
        return toReturn;
    }

    @NotNull
    public final Writer fileWriter(@NotNull String path, boolean append2) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileHandle file = this.pathToFileHandler(path);
        Writer writer = file.writer(append2, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue(writer, "writer(...)");
        return writer;
    }

    public static /* synthetic */ Writer fileWriter$default(UncivFiles uncivFiles, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return uncivFiles.fileWriter(string, bl);
    }

    @NotNull
    public final FileHandle pathToFileHandler(@NotNull String path) {
        FileHandle fileHandle;
        Intrinsics.checkNotNullParameter(path, "path");
        if (preferExternalStorage && this.files.isExternalStorageAvailable()) {
            FileHandle fileHandle2 = this.files.external(path);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "external(...)");
        } else {
            fileHandle = this.getLocalFile(path);
        }
        return fileHandle;
    }

    @NotNull
    public final Sequence<FileHandle> getMultiplayerSaves() {
        return this.getSaves("MultiplayerGames");
    }

    @NotNull
    public final Sequence<FileHandle> getSaves(boolean autoSaves) {
        Sequence<FileHandle> saves = this.getSaves("SaveFiles");
        if (autoSaves) {
            return saves;
        }
        return SequencesKt.filter(saves, getSaves.1.INSTANCE);
    }

    public static /* synthetic */ Sequence getSaves$default(UncivFiles uncivFiles, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return uncivFiles.getSaves(bl);
    }

    private final Sequence<FileHandle> getSaves(String saveFolder) {
        Object[] objectArray = new Object[]{saveFolder, this.files.getExternalStoragePath()};
        LogKt.debug("Getting saves from folder %s, externalStoragePath: %s", objectArray);
        Sequence localFiles = new Sequence<FileHandle>(this, saveFolder){
            final /* synthetic */ UncivFiles this$0;
            final /* synthetic */ String $saveFolder$inlined;
            {
                this.this$0 = uncivFiles;
                this.$saveFolder$inlined = string;
            }

            @NotNull
            public Iterator<FileHandle> iterator() {
                boolean bl = false;
                return ArrayIteratorKt.iterator(this.this$0.getLocalFile(this.$saveFolder$inlined).list());
            }
        };
        Sequence externalFiles = !this.files.isExternalStorageAvailable() ? SequencesKt.emptySequence() : (Intrinsics.areEqual(this.getDataFolder().file().getAbsolutePath(), this.files.external("").file().getAbsolutePath()) ? SequencesKt.emptySequence() : (Sequence)new Sequence<FileHandle>(this, saveFolder){
            final /* synthetic */ UncivFiles this$0;
            final /* synthetic */ String $saveFolder$inlined;
            {
                this.this$0 = uncivFiles;
                this.$saveFolder$inlined = string;
            }

            @NotNull
            public Iterator<FileHandle> iterator() {
                boolean bl = false;
                return ArrayIteratorKt.iterator(UncivFiles.access$getFiles$p(this.this$0).external(this.$saveFolder$inlined).list());
            }
        });
        Object[] objectArray2 = new Object[]{new Function0<String>((Sequence<? extends FileHandle>)localFiles){
            final /* synthetic */ Sequence<FileHandle> $localFiles;
            {
                this.$localFiles = $localFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return SequencesKt.joinToString$default(this.$localFiles, null, "[", "]", 0, null, getSaves.1.INSTANCE, 25, null);
            }
        }, new Function0<String>((Sequence<? extends FileHandle>)externalFiles){
            final /* synthetic */ Sequence<FileHandle> $externalFiles;
            {
                this.$externalFiles = $externalFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return SequencesKt.joinToString$default(this.$externalFiles, null, "[", "]", 0, null, getSaves.1.INSTANCE, 25, null);
            }
        }};
        LogKt.debug("Local files: %s, external files: %s", objectArray2);
        return SequencesKt.plus(localFiles, externalFiles);
    }

    public final boolean deleteSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.deleteSave(this.getSave(gameName));
    }

    public final boolean deleteSave(@NotNull FileHandle file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Object[] objectArray = new Object[]{file.path()};
        LogKt.debug("Deleting save %s", objectArray);
        return file.delete();
    }

    @NotNull
    public final FileHandle saveGame(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getSave(gameName);
        this.saveGame(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.1.INSTANCE;
        }
        return uncivFiles.saveGame(gameInfo, string, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveGame(@NotNull GameInfo game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfo %s to %s", objectArray);
            String string = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            file.writeString(string, false, Charsets.UTF_8.name());
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.2.INSTANCE;
        }
        uncivFiles.saveGame(gameInfo, fileHandle, (Function1<? super Exception, Unit>)function1);
    }

    @NotNull
    public final FileHandle saveMultiplayerGamePreview(@NotNull GameInfoPreview game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getMultiplayerSave(gameName);
        this.saveMultiplayerGamePreview(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveMultiplayerGamePreview$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveMultiplayerGamePreview.1.INSTANCE;
        }
        return uncivFiles.saveMultiplayerGamePreview(gameInfoPreview, string, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveMultiplayerGamePreview(@NotNull GameInfoPreview game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfoPreview %s to %s", objectArray);
            UncivJsonKt.json().toJson((Object)game, file);
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveMultiplayerGamePreview$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveMultiplayerGamePreview.2.INSTANCE;
        }
        uncivFiles.saveMultiplayerGamePreview(gameInfoPreview, fileHandle, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveGameToCustomLocation(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function0<Unit> onSaved, @NotNull Function1<? super Exception, Unit> onError2) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(onSaved, "onSaved");
        Intrinsics.checkNotNullParameter(onError2, "onError");
        String string = game.getCustomSaveLocation();
        if (string == null) {
            string = UncivGame.Companion.getCurrent().getFiles().getLocalFile(gameName).path();
        }
        String saveLocation = string;
        try {
            String data2 = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            Object[] objectArray = new Object[]{game.getGameId(), saveLocation};
            LogKt.debug("Initiating UI to save GameInfo %s to custom location %s", objectArray);
            Intrinsics.checkNotNull(saveLocation);
            saverLoader.saveGame(data2, saveLocation, (Function1<? super String, Unit>)new Function1<String, Unit>(game, onSaved){
                final /* synthetic */ GameInfo $game;
                final /* synthetic */ Function0<Unit> $onSaved;
                {
                    this.$game = $game;
                    this.$onSaved = $onSaved;
                    super(1);
                }

                public final void invoke(@NotNull String location) {
                    Intrinsics.checkNotNullParameter(location, "location");
                    this.$game.setCustomSaveLocation(location);
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onSaved, null){
                        int label;
                        final /* synthetic */ Function0<Unit> $onSaved;
                        {
                            this.$onSaved = $onSaved;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onSaved.invoke();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(onError2){
                final /* synthetic */ Function1<Exception, Unit> $onError;
                {
                    this.$onError = $onError;
                    super(1);
                }

                public final void invoke(@NotNull Exception it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, it, null){
                        int label;
                        final /* synthetic */ Function1<Exception, Unit> $onError;
                        final /* synthetic */ Exception $it;
                        {
                            this.$onError = $onError;
                            this.$it = $it;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onError.invoke(this.$it);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            });
        }
        catch (Exception ex) {
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onError2, ex, null){
                int label;
                final /* synthetic */ Function1<Exception, Unit> $onError;
                final /* synthetic */ Exception $ex;
                {
                    this.$onError = $onError;
                    this.$ex = $ex;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.$onError.invoke(this.$ex);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    @NotNull
    public final GameInfo loadGameByName(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.loadGameFromFile(this.getSave(gameName));
    }

    @NotNull
    public final GameInfo loadGameFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        String gameData = gameFile.readString(Charsets.UTF_8.name());
        CharSequence charSequence = gameData;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            throw this.emptyFile(gameFile);
        }
        Intrinsics.checkNotNull(gameData);
        return Companion.gameInfoFromString(gameData);
    }

    @NotNull
    public final GameInfoPreview loadGamePreviewFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, gameFile);
        if (gameInfoPreview == null) {
            throw this.emptyFile(gameFile);
        }
        return gameInfoPreview;
    }

    private final SerializationException emptyFile(FileHandle gameFile) {
        return new SerializationException("The file for the game " + gameFile.name() + " is empty");
    }

    public final void loadGameFromCustomLocation(@NotNull Function1<? super GameInfo, Unit> onLoaded, @NotNull Function1<? super Exception, Unit> onError2) {
        Intrinsics.checkNotNullParameter(onLoaded, "onLoaded");
        Intrinsics.checkNotNullParameter(onError2, "onError");
        saverLoader.loadGame((Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(onLoaded, onError2){
            final /* synthetic */ Function1<GameInfo, Unit> $onLoaded;
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.$onLoaded = $onLoaded;
                this.$onError = $onError;
                super(2);
            }

            public final void invoke(@NotNull String data2, @NotNull String location) {
                Intrinsics.checkNotNullParameter(data2, "data");
                Intrinsics.checkNotNullParameter(location, "location");
                try {
                    GameInfo game = UncivFiles.Companion.gameInfoFromString(data2);
                    game.setCustomSaveLocation(location);
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onLoaded, game, null){
                        int label;
                        final /* synthetic */ Function1<GameInfo, Unit> $onLoaded;
                        final /* synthetic */ GameInfo $game;
                        {
                            this.$onLoaded = $onLoaded;
                            this.$game = $game;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onLoaded.invoke(this.$game);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
                catch (Exception ex) {
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, ex, null){
                        int label;
                        final /* synthetic */ Function1<Exception, Unit> $onError;
                        final /* synthetic */ Exception $ex;
                        {
                            this.$onError = $onError;
                            this.$ex = $ex;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onError.invoke(this.$ex);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            }
        }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(onError2){
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, it, null){
                    int label;
                    final /* synthetic */ Function1<Exception, Unit> $onError;
                    final /* synthetic */ Exception $it;
                    {
                        this.$onError = $onError;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.$onError.invoke(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
            }
        });
    }

    private final FileHandle getGeneralSettingsFile() {
        return UncivGame.Companion.getCurrent().isConsoleMode() ? new FileHandle("GameSettings.json") : this.getLocalFile("GameSettings.json");
    }

    @NotNull
    public final GameSettings getGeneralSettings() {
        GameSettings gameSettings;
        FileHandle settingsFile = this.getGeneralSettingsFile();
        GameSettings settings = null;
        if (settingsFile.exists()) {
            try {
                settings = UncivJsonKt.json().fromJson(GameSettings.class, settingsFile);
                if (GameSettingsMigrationsKt.isMigrationNecessary(settings)) {
                    JsonValue jsonValue = new JsonReader().parse(settingsFile);
                    Intrinsics.checkNotNullExpressionValue(jsonValue, "parse(...)");
                    GameSettingsMigrationsKt.doMigrations(settings, jsonValue);
                }
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Error reading settings file", ex);
            }
        }
        if ((gameSettings = settings) == null) {
            GameSettings gameSettings2;
            GameSettings $this$getGeneralSettings_u24lambda_u242 = gameSettings2 = new GameSettings();
            boolean bl = false;
            $this$getGeneralSettings_u24lambda_u242.setFreshlyCreated(true);
            gameSettings = gameSettings2;
        }
        return gameSettings;
    }

    public final void setGeneralSettings(@NotNull GameSettings gameSettings) {
        Intrinsics.checkNotNullParameter(gameSettings, "gameSettings");
        this.getGeneralSettingsFile().writeString(UncivJsonKt.json().toJson(gameSettings), false, Charsets.UTF_8.name());
    }

    @NotNull
    public final Sequence<Pair<FileHandle, Ruleset>> getScenarioFiles() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UncivFiles this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = RulesetCache.INSTANCE.values().iterator();
                        while (var3_4.hasNext()) {
                            mod = var3_4.next();
                            if (mod.getFolderLocation() == null || !(scenarioFolder = modFolder.child(UncivFiles.access$getScenarioFolder$p(this.this$0))).exists()) continue;
                            var8_10 = scenarioFolder.list();
                            Intrinsics.checkNotNullExpressionValue(var8_10, "list(...)");
                            var7_8 = var8_10;
                            var8_9 = 0;
                            var9_11 = var7_8.length;
lbl15:
                            // 2 sources

                            while (var8_9 < var9_11) {
                                file = var7_8[var8_9];
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = mod;
                                this.L$3 = var7_8;
                                this.I$0 = var8_9;
                                this.I$1 = var9_11;
                                this.label = 1;
                                v0 = $this$sequence.yield(new Pair<FileHandle, Ruleset>(file, mod), this);
                                if (v0 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl39
                            }
                        }
                        break;
                    }
                    case 1: {
                        var9_11 = this.I$1;
                        var8_9 = this.I$0;
                        var7_8 = (FileHandle[])this.L$3;
                        mod = (Ruleset)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl39:
                        // 2 sources

                        ++var8_9;
                        ** GOTO lbl15
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Pair<? extends FileHandle, Ruleset>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void saveModCache(@NotNull List<ModUIData> modDataList) {
        Intrinsics.checkNotNullParameter(modDataList, "modDataList");
        FileHandle file = this.getLocalFile("ModListCache.json");
        try {
            UncivJsonKt.json().toJson(modDataList, file);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Error saving mod cache", ex);
        }
    }

    @NotNull
    public final List<ModUIData> loadModCache() {
        FileHandle file = this.getLocalFile("ModListCache.json");
        if (!file.exists()) {
            return CollectionsKt.emptyList();
        }
        try {
            return ArraysKt.toList((Object[])UncivJsonKt.fromJsonFile(UncivJsonKt.json(), ModUIData[].class, file));
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Error loading mod cache", ex);
            return CollectionsKt.emptyList();
        }
    }

    private static final boolean _fileNameTextFieldFilter$lambda$3(TextField textField, char c) {
        return !charsForbiddenInFileNames.contains(Character.valueOf(c));
    }

    public static final /* synthetic */ String access$getScenarioFolder$p(UncivFiles $this) {
        return $this.scenarioFolder;
    }

    public static final /* synthetic */ Files access$getFiles$p(UncivFiles $this) {
        return $this.files;
    }

    static {
        saverLoader = PlatformSaverLoader.Companion.getNone();
        Character[] characterArray = new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(':')};
        charsForbiddenInFileNames = SetsKt.setOf(characterArray);
        _fileNameTextFieldFilter = UncivFiles::_fileNameTextFieldFilter$lambda$3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bJ)\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00192\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010!\u001a\u00020\t\u00a2\u0006\u0002\u0010\"J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/unciv/logic/files/UncivFiles$Companion;", "", "()V", "_fileNameTextFieldFilter", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField$TextFieldFilter;", "charsForbiddenInFileNames", "", "", "preferExternalStorage", "", "getPreferExternalStorage", "()Z", "setPreferExternalStorage", "(Z)V", "saveZipped", "getSaveZipped", "setSaveZipped", "saverLoader", "Lcom/unciv/logic/files/PlatformSaverLoader;", "getSaverLoader", "()Lcom/unciv/logic/files/PlatformSaverLoader;", "setSaverLoader", "(Lcom/unciv/logic/files/PlatformSaverLoader;)V", "fileNameTextFieldFilter", "gameInfoFromString", "Lcom/unciv/logic/GameInfo;", "gameData", "", "gameInfoPreviewFromString", "Lcom/unciv/logic/GameInfoPreview;", "gameInfoToString", "game", "forceZip", "updateChecksum", "(Lcom/unciv/logic/GameInfo;Ljava/lang/Boolean;Z)Ljava/lang/String;", "getSettingsForPlatformLaunchers", "Lcom/unciv/models/metadata/GameSettings;", "baseDirectory", "isValidFileName", "fileName", "core"})
    @SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getSaveZipped() {
            return saveZipped;
        }

        public final void setSaveZipped(boolean bl) {
            saveZipped = bl;
        }

        public final boolean getPreferExternalStorage() {
            return preferExternalStorage;
        }

        public final void setPreferExternalStorage(boolean bl) {
            preferExternalStorage = bl;
        }

        @NotNull
        public final PlatformSaverLoader getSaverLoader() {
            return saverLoader;
        }

        public final void setSaverLoader(@NotNull PlatformSaverLoader platformSaverLoader) {
            Intrinsics.checkNotNullParameter(platformSaverLoader, "<set-?>");
            saverLoader = platformSaverLoader;
        }

        @NotNull
        public final GameSettings getSettingsForPlatformLaunchers(@NotNull String baseDirectory) {
            GameSettings gameSettings;
            Intrinsics.checkNotNullParameter(baseDirectory, "baseDirectory");
            FileHandle file = new FileHandle(baseDirectory + File.separator + "GameSettings.json");
            if (file.exists()) {
                try {
                    GameSettings gameSettings2 = UncivJsonKt.json().fromJson(GameSettings.class, file);
                    Intrinsics.checkNotNullExpressionValue(gameSettings2, "fromJson(...)");
                    return gameSettings2;
                }
                catch (Exception ex) {
                    Log.INSTANCE.error("Exception while deserializing GameSettings JSON", ex);
                }
            }
            GameSettings $this$getSettingsForPlatformLaunchers_u24lambda_u240 = gameSettings = new GameSettings();
            boolean bl = false;
            $this$getSettingsForPlatformLaunchers_u24lambda_u240.setFreshlyCreated(true);
            return gameSettings;
        }

        @NotNull
        public final GameInfo gameInfoFromString(@NotNull String gameData) {
            GameInfo gameInfo;
            String string;
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            String fixedData = StringsKt.replace$default(StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)gameData)).toString(), "\r", "", false, 4, null), "\n", "", false, 4, null);
            try {
                string = Gzip.INSTANCE.unzip(fixedData);
            }
            catch (Exception ex) {
                string = fixedData;
            }
            String unzippedJson = string;
            try {
                gameInfo = UncivJsonKt.json().fromJson(GameInfo.class, unzippedJson);
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Exception while deserializing GameInfo JSON", ex);
                GameInfoSerializationVersion onlyVersion = UncivJsonKt.json().fromJson(GameInfoSerializationVersion.class, unzippedJson);
                throw new IncompatibleGameInfoVersionException(onlyVersion.getVersion(), (Throwable)ex);
            }
            GameInfo gameInfo2 = gameInfo;
            if (gameInfo2 == null) {
                throw new UncivShowableException("The file data seems to be corrupted.", null, 2, null);
            }
            GameInfo gameInfo3 = gameInfo2;
            if (gameInfo3.getVersion().compareTo(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION()) > 0) {
                throw new IncompatibleGameInfoVersionException(gameInfo3.getVersion(), null, 2, null);
            }
            gameInfo3.setTransients();
            return gameInfo3;
        }

        @NotNull
        public final GameInfoPreview gameInfoPreviewFromString(@NotNull String gameData) {
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, Gzip.INSTANCE.unzip(gameData));
            Intrinsics.checkNotNullExpressionValue(gameInfoPreview, "fromJson(...)");
            return gameInfoPreview;
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfo game, @Nullable Boolean forceZip, boolean updateChecksum) {
            String string;
            Intrinsics.checkNotNullParameter(game, "game");
            game.setVersion(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION());
            if (updateChecksum) {
                game.setChecksum(game.calculateChecksum());
            }
            String plainJson = UncivJsonKt.json().toJson(game);
            Boolean bl = forceZip;
            if (bl != null ? bl.booleanValue() : this.getSaveZipped()) {
                Intrinsics.checkNotNull(plainJson);
                string = Gzip.INSTANCE.zip(plainJson);
            } else {
                Intrinsics.checkNotNull(plainJson);
                string = plainJson;
            }
            return string;
        }

        public static /* synthetic */ String gameInfoToString$default(Companion companion, GameInfo gameInfo, Boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = null;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.gameInfoToString(gameInfo, bl, bl2);
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfoPreview game) {
            Intrinsics.checkNotNullParameter(game, "game");
            String string = UncivJsonKt.json().toJson(game);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            return Gzip.INSTANCE.zip(string);
        }

        @NotNull
        public final TextField.TextFieldFilter fileNameTextFieldFilter() {
            return _fileNameTextFieldFilter;
        }

        public final boolean isValidFileName(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            return ((CharSequence)fileName).length() > 0 && !StringsKt.endsWith$default((CharSequence)fileName, ' ', false, 2, null) && !StringsKt.startsWith$default((CharSequence)fileName, ' ', false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

