/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J(\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u0004J2\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0004J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/mapunit/movement/MovementCost;", "", "()V", "anyTilesExertingZoneOfControl", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "from", "Lcom/unciv/logic/map/tile/Tile;", "to", "getEnemyMovementPenalty", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "enemyUnit", "getMovementCostBetweenAdjacentTiles", "considerZoneOfControl", "getMovementCostBetweenAdjacentTilesEscort", "includeEscortUnit", "hasDoubleMovement", "terrainName", "", "target", "Lcom/unciv/logic/map/mapunit/MapUnitCache$DoubleMovementTerrainTarget;", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "doubleMovement", "Lcom/unciv/logic/map/mapunit/MapUnitCache$DoubleMovement;", "isMovementAffectedByZoneOfControl", "core"})
@SourceDebugExtension(value={"SMAP\nMovementCost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovementCost.kt\ncom/unciv/logic/map/mapunit/movement/MovementCost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,205:1\n1747#2,3:206\n187#3,3:209\n*S KotlinDebug\n*F\n+ 1 MovementCost.kt\ncom/unciv/logic/map/mapunit/movement/MovementCost\n*L\n93#1:206,3\n114#1:209,3\n*E\n"})
public final class MovementCost {
    @NotNull
    public static final MovementCost INSTANCE = new MovementCost();

    private MovementCost() {
    }

    public final float getMovementCostBetweenAdjacentTilesEscort(@NotNull MapUnit unit, @NotNull Tile from, @NotNull Tile to, boolean considerZoneOfControl, boolean includeEscortUnit) {
        float movementCost;
        float f;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        if (includeEscortUnit && unit.isEscorting()) {
            float f2 = this.getMovementCostBetweenAdjacentTiles(unit, from, to, considerZoneOfControl);
            MapUnit mapUnit = unit.getOtherEscortUnit();
            Intrinsics.checkNotNull(mapUnit);
            f = Math.max(f2, this.getMovementCostBetweenAdjacentTiles(mapUnit, from, to, considerZoneOfControl));
        } else {
            f = movementCost = this.getMovementCostBetweenAdjacentTiles(unit, from, to, considerZoneOfControl);
        }
        if (movementCost < 0.0f) {
            throw new Exception("Got a negative movement cost?!");
        }
        return movementCost;
    }

    public static /* synthetic */ float getMovementCostBetweenAdjacentTilesEscort$default(MovementCost movementCost, MapUnit mapUnit, Tile tile, Tile tile2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return movementCost.getMovementCostBetweenAdjacentTilesEscort(mapUnit, tile, tile2, bl, bl2);
    }

    public final float getMovementCostBetweenAdjacentTiles(@NotNull MapUnit unit, @NotNull Tile from, @NotNull Tile to, boolean considerZoneOfControl) {
        boolean bl;
        float terrainCost;
        float extraCost;
        block26: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Object $this$any$iv;
            StateForConditionals stateForConditionals;
            Civilization civ;
            block25: {
                boolean areConnectedByRiver;
                Intrinsics.checkNotNullParameter(unit, "unit");
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                civ = unit.getCiv();
                if (unit.getCache().getCannotMove()) {
                    return 100.0f;
                }
                if (from.isLand() != to.isLand() && unit.getBaseUnit().isLandUnit() && !unit.getCache().getCanMoveOnWater()) {
                    float f;
                    if (from.isWater() && to.isLand()) {
                        Float f2 = unit.getCache().getCostToDisembark();
                        f = f2 != null ? f2.floatValue() : 100.0f;
                    } else {
                        Float f3 = unit.getCache().getCostToEmbark();
                        f = f3 != null ? f3.floatValue() : 100.0f;
                    }
                    return f;
                }
                if (considerZoneOfControl && this.isMovementAffectedByZoneOfControl(unit, from, to)) {
                    return 100.0f;
                }
                if (unit.getCache().getAllTilesCosts1()) {
                    return 1.0f;
                }
                Civilization toOwner = to.getOwner();
                float f = extraCost = toOwner != null && toOwner.getHasActiveEnemyMovementPenalty() && civ.isAtWarWith(toOwner) ? this.getEnemyMovementPenalty(toOwner, unit) : 0.0f;
                if (from.getUnpillagedRoad() == RoadStatus.Railroad && to.getUnpillagedRoad() == RoadStatus.Railroad) {
                    return RoadStatus.Railroad.getMovement() + extraCost;
                }
                boolean areConnectedByRoad = from.hasConnection(civ) && to.hasConnection(civ);
                boolean bl3 = areConnectedByRiver = from.isAdjacentToRiver() && to.isAdjacentToRiver() && from.isConnectedByRiver(to);
                if (areConnectedByRoad && (!areConnectedByRiver || civ.getTech().getRoadsConnectAcrossRivers())) {
                    return unit.getCiv().getTech().getMovementSpeedOnRoads() + extraCost;
                }
                if (unit.getCache().getIgnoresTerrainCost()) {
                    return 1.0f + extraCost;
                }
                if (areConnectedByRiver) {
                    return 100.0f;
                }
                float f4 = terrainCost = to.isCityCenter() ? 1.0f : (float)to.getLastTerrain().getMovementCost();
                if (unit.getCache().getNoTerrainMovementUniques()) {
                    return terrainCost + extraCost;
                }
                stateForConditionals = new StateForConditionals(unit.getCiv(), null, unit, to, null, null, null, null, null, null, false, 2034, null);
                $this$any$iv = to.getTerrainFeatures();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<Object> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        it = (String)t;
                        boolean bl4 = false;
                        if (!INSTANCE.hasDoubleMovement(unit, (String)it, MapUnitCache.DoubleMovementTerrainTarget.Feature, stateForConditionals)) continue;
                        bl2 = true;
                        break block25;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return terrainCost * 0.5f + extraCost;
            }
            if (unit.getCache().getRoughTerrainPenalty() && to.isRoughTerrain()) {
                return 100.0f;
            }
            if (civ.getNation().getIgnoreHillMovementCost() && to.isHill()) {
                return 1.0f + extraCost;
            }
            if (unit.getCache().getNoBaseTerrainOrHillDoubleMovementUniques()) {
                return terrainCost + extraCost;
            }
            if (this.hasDoubleMovement(unit, to.getBaseTerrain(), MapUnitCache.DoubleMovementTerrainTarget.Base, stateForConditionals)) {
                return terrainCost * 0.5f + extraCost;
            }
            if (this.hasDoubleMovement(unit, "Hill", MapUnitCache.DoubleMovementTerrainTarget.Hill, stateForConditionals) && to.isHill()) {
                return terrainCost * 0.5f + extraCost;
            }
            if (unit.getCache().getNoFilteredDoubleMovementUniques()) {
                return terrainCost + extraCost;
            }
            $this$any$iv = unit.getCache().getDoubleMovementInTerrain();
            $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry entry : $this$any$iv.entrySet()) {
                    it = entry;
                    boolean bl5 = false;
                    boolean bl4 = INSTANCE.hasDoubleMovement((MapUnitCache.DoubleMovement)it.getValue(), MapUnitCache.DoubleMovementTerrainTarget.Filter, stateForConditionals) && Tile.matchesFilter$default(to, (String)it.getKey(), null, 2, null);
                    if (!bl4) continue;
                    bl = true;
                    break block26;
                }
                bl = false;
            }
        }
        if (bl) {
            return terrainCost * 0.5f + extraCost;
        }
        return terrainCost + extraCost;
    }

    public static /* synthetic */ float getMovementCostBetweenAdjacentTiles$default(MovementCost movementCost, MapUnit mapUnit, Tile tile, Tile tile2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return movementCost.getMovementCostBetweenAdjacentTiles(mapUnit, tile, tile2, bl);
    }

    private final boolean hasDoubleMovement(MapUnitCache.DoubleMovement doubleMovement, MapUnitCache.DoubleMovementTerrainTarget target, StateForConditionals stateForConditionals) {
        if (doubleMovement.getTerrainTarget() != target) {
            return false;
        }
        return !(!((Collection)doubleMovement.getUnique().getModifiers()).isEmpty()) || doubleMovement.getUnique().conditionalsApply(stateForConditionals);
    }

    private final boolean hasDoubleMovement(MapUnit unit, String terrainName, MapUnitCache.DoubleMovementTerrainTarget target, StateForConditionals stateForConditionals) {
        MapUnitCache.DoubleMovement doubleMovement = unit.getCache().getDoubleMovementInTerrain().get(terrainName);
        if (doubleMovement == null) {
            return false;
        }
        MapUnitCache.DoubleMovement doubleMovement2 = doubleMovement;
        return this.hasDoubleMovement(doubleMovement2, target, stateForConditionals);
    }

    /*
     * WARNING - void declaration
     */
    private final float getEnemyMovementPenalty(Civilization civInfo, MapUnit enemyUnit) {
        if (civInfo.getEnemyMovementPenaltyUniques() != null) {
            Sequence<Unique> sequence = civInfo.getEnemyMovementPenaltyUniques();
            Intrinsics.checkNotNull(sequence);
            if (SequencesKt.any(sequence)) {
                Sequence<Unique> sequence2 = civInfo.getEnemyMovementPenaltyUniques();
                Intrinsics.checkNotNull(sequence2);
                Sequence<Unique> sequence3 = sequence2;
                int n = 0;
                Iterator<Unique> iterator2 = sequence3.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Unique unique;
                    Unique unique2 = unique = iterator2.next();
                    int n2 = n;
                    boolean bl = false;
                    UniqueType uniqueType = it.getType();
                    Intrinsics.checkNotNull((Object)uniqueType);
                    int n3 = uniqueType == UniqueType.EnemyUnitsSpendExtraMovement && MapUnit.matchesFilter$default(enemyUnit, it.getParams().get(0), false, 2, null) ? Integer.parseInt(it.getParams().get(1)) : 0;
                    n = n2 + n3;
                }
                return n;
            }
        }
        return 0.0f;
    }

    private final boolean isMovementAffectedByZoneOfControl(MapUnit unit, Tile from, Tile to) {
        if (!this.anyTilesExertingZoneOfControl(unit, from, to)) {
            return false;
        }
        return !unit.getCache().getIgnoresZoneOfControl();
    }

    private final boolean anyTilesExertingZoneOfControl(MapUnit unit, Tile from, Tile to) {
        Iterator<Tile> iterator2 = from.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (neighbor.isCityCenter()) {
                if (neighbor.aerialDistanceTo(to) != 1) continue;
                Civilization civilization = unit.getCiv();
                Civilization civilization2 = neighbor.getOwner();
                Intrinsics.checkNotNull(civilization2);
                if (!civilization.isAtWarWith(civilization2)) continue;
                return true;
            }
            if (neighbor.getMilitaryUnit() == null || neighbor.aerialDistanceTo(to) != 1) continue;
            MapUnit mapUnit = neighbor.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!mapUnit.getType().isWaterUnit()) {
                if (!unit.getType().isLandUnit()) continue;
                MapUnit mapUnit2 = neighbor.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit2);
                if (mapUnit2.isEmbarked()) continue;
            }
            Civilization civilization = unit.getCiv();
            MapUnit mapUnit3 = neighbor.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit3);
            if (!civilization.isAtWarWith(mapUnit3.getCiv())) continue;
            return true;
        }
        return false;
    }
}

