/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJE\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\bJ(\u0010\u001f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J$\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\n2\u0006\u0010#\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lcom/unciv/logic/map/tile/TileImprovementFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "activateRemovalImprovement", "", "improvementName", "", "civToActivateBroaderEffects", "Lcom/unciv/logic/civilization/Civilization;", "canBuildImprovement", "", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "civInfo", "canImprovementBeBuiltHere", "resourceIsVisible", "knownFeatureRemovals", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "isNormalizeCheck", "canImprovementBeBuiltHere$core", "getImprovementBuildingProblems", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/ImprovementBuildingProblem;", "markForCreatesOneImprovement", "removeCreatesOneImprovementMarker", "setImprovement", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "triggerImprovementUniques", "civ", "tryProvideProductionToClosestCity", "removedTerrainFeature", "core"})
@SourceDebugExtension(value={"SMAP\nTileImprovementFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,353:1\n1747#2,3:354\n1747#2,3:357\n1747#2,3:360\n2624#2,3:364\n766#2:373\n857#2,2:374\n819#2:376\n847#2:377\n1747#2,3:378\n848#2:381\n766#2:382\n857#2,2:383\n1747#2,3:385\n1747#2,3:388\n2333#2,14:391\n1603#2,9:405\n1855#2:414\n288#2,2:415\n1856#2:418\n1612#2:419\n1747#2,3:420\n819#2:423\n847#2:424\n1747#2,3:425\n848#2:428\n1#3:363\n1#3:417\n1247#4,2:367\n1247#4,2:369\n1247#4,2:371\n*S KotlinDebug\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n*L\n137#1:354,3\n139#1:357,3\n142#1:360,3\n155#1:364,3\n233#1:373\n233#1:374,2\n240#1:376\n240#1:377\n240#1:378,3\n240#1:381\n268#1:382\n268#1:383,2\n290#1:385,3\n296#1:388,3\n313#1:391,14\n118#1:405,9\n118#1:414\n119#1:415,2\n118#1:418\n118#1:419\n121#1:420,3\n123#1:423\n123#1:424\n124#1:425,3\n123#1:428\n118#1:417\n160#1:367,2\n168#1:369,2\n172#1:371,2\n*E\n"})
public final class TileImprovementFunctions {
    @NotNull
    private final Tile tile;

    public TileImprovementFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    public final boolean canBuildImprovement(@NotNull TileImprovement improvement2, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return SequencesKt.none(this.getImprovementBuildingProblems(improvement2, civInfo));
    }

    @NotNull
    public final Sequence<ImprovementBuildingProblem> getImprovementBuildingProblems(@NotNull TileImprovement improvement2, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super ImprovementBuildingProblem>, Continuation<? super Unit>, Object>(civInfo, this, improvement2, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ TileImprovementFunctions this$0;
            final /* synthetic */ TileImprovement $improvement;
            {
                this.$civInfo = $civInfo;
                this.this$0 = $receiver;
                this.$improvement = $improvement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block53: {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            stateForConditionals = new StateForConditionals(this.$civInfo, null, null, this.this$0.getTile(), null, null, null, null, null, null, false, 2038, null);
                            if (this.$improvement.getUniqueTo() != null) {
                                v0 = this.$improvement.getUniqueTo();
                                Intrinsics.checkNotNull(v0);
                                if (!Civilization.matchesFilter$default(this.$civInfo, v0, null, false, 6, null)) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = stateForConditionals;
                                    this.label = 1;
                                    v1 = $this$sequence.yield(ImprovementBuildingProblem.WrongCiv, this);
                                    if (v1 == var15_2) {
                                        return var15_2;
                                    }
                                }
                            }
                            ** GOTO lbl23
                        }
                        case 1: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            var4_5 = this.$civInfo.getCache().getUniqueImprovements();
                            var5_6 = this.$improvement;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl29
                            v2 = false;
                            ** GOTO lbl38
lbl29:
                            // 1 sources

                            var7_17 = $this$any$iv.iterator();
                            while (var7_17.hasNext()) {
                                element$iv /* !! */  = var7_17.next();
                                it = (TileImprovement)element$iv /* !! */ ;
                                $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$1 = false;
                                if (!Intrinsics.areEqual(it.getReplaces(), var5_6.getName())) continue;
                                v2 = true;
                                ** GOTO lbl38
                            }
                            v2 = false;
lbl38:
                            // 3 sources

                            if (v2) {
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 2;
                                v3 = $this$sequence.yield(ImprovementBuildingProblem.Replaced, this);
                                if (v3 == var15_2) {
                                    return var15_2;
                                }
                            }
                            ** GOTO lbl51
                        }
                        case 2: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl51:
                            // 2 sources

                            if (this.$improvement.getTechRequired() != null) {
                                v4 = this.$civInfo.getTech();
                                v5 = this.$improvement.getTechRequired();
                                Intrinsics.checkNotNull(v5);
                                if (!v4.isResearched(v5)) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = stateForConditionals;
                                    this.label = 3;
                                    v6 = $this$sequence.yield(ImprovementBuildingProblem.MissingTech, this);
                                    if (v6 == var15_2) {
                                        return var15_2;
                                    }
                                }
                            }
                            ** GOTO lbl68
                        }
                        case 3: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v6 = $result;
lbl68:
                            // 2 sources

                            $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.Unbuildable, StateForConditionals.Companion.getIgnoreConditionals());
                            $i$f$any = false;
                            $i$f$any = $this$any$iv.iterator();
                            while ($i$f$any.hasNext()) {
                                element$iv = $i$f$any.next();
                                it = (Unique)element$iv;
                                $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$2 = false;
                                if (!it.getModifiers().isEmpty()) continue;
                                v7 = true;
                                ** GOTO lbl79
                            }
                            v7 = false;
lbl79:
                            // 2 sources

                            if (!v7) break;
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 4;
                            v8 = $this$sequence.yield(ImprovementBuildingProblem.Unbuildable, this);
                            if (v8 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl106
                        }
                        case 4: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
                            ** GOTO lbl106
                        }
                    }
                    if (this.$improvement.hasUnique(UniqueType.Unbuildable, stateForConditionals)) {
                        this.L$0 = $this$sequence;
                        this.L$1 = stateForConditionals;
                        this.label = 5;
                        v9 = $this$sequence.yield(ImprovementBuildingProblem.ConditionallyUnbuildable, this);
                        if (v9 == var15_2) {
                            return var15_2;
                        }
                    }
                    ** GOTO lbl106
                    {
                        case 5: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl106:
                            // 4 sources

                            if (this.$improvement.hasUnique(UniqueType.Unavailable, stateForConditionals)) {
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 6;
                                v10 = $this$sequence.yield(ImprovementBuildingProblem.ConditionallyUnbuildable, this);
                                if (v10 == var15_2) {
                                    return var15_2;
                                }
                            }
                            ** GOTO lbl119
                        }
                        case 6: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
lbl119:
                            // 2 sources

                            if (!Intrinsics.areEqual(this.this$0.getTile().getOwner(), this.$civInfo) && !this.$improvement.hasUnique(UniqueType.CanBuildOutsideBorders, stateForConditionals)) {
                                if (this.$improvement.hasUnique(UniqueType.CanBuildJustOutsideBorders, stateForConditionals)) break;
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 7;
                                v11 = $this$sequence.yield(ImprovementBuildingProblem.OutsideBorders, this);
                                if (v11 == var15_2) {
                                    return var15_2;
                                }
                            }
                            ** GOTO lbl158
                        }
                        case 7: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v11 = $result;
                            ** GOTO lbl158
                        }
                    }
                    $this$any$iv = this.this$0.getTile().getNeighbors();
                    $i$f$any = this.$civInfo;
                    $i$f$none = false;
                    for (Iterable element$iv : $this$none$iv) {
                        it = (Tile)element$iv /* !! */ ;
                        $i$a$-none-TileImprovementFunctions$getImprovementBuildingProblems$1$3 = false;
                        if (!Intrinsics.areEqual(it.getOwner(), $i$f$any)) continue;
                        v12 = false;
                        break block53;
                    }
                    v12 = true;
                }
                if (v12) {
                    this.L$0 = $this$sequence;
                    this.L$1 = stateForConditionals;
                    this.label = 8;
                    v13 = $this$sequence.yield(ImprovementBuildingProblem.NotJustOutsideBorders, this);
                    if (v13 == var15_2) {
                        return var15_2;
                    }
                }
                ** GOTO lbl158
                {
                    case 8: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v13 = $result;
lbl158:
                        // 4 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
                        $i$f$any = false;
                        $i$f$none = $this$any$iv.iterator();
                        while ($i$f$none.hasNext()) {
                            element$iv = $i$f$none.next();
                            it = (Unique)element$iv;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$4 = false;
                            if (!(it.conditionalsApply(stateForConditionals) == false)) continue;
                            v14 = true;
                            ** GOTO lbl169
                        }
                        v14 = false;
lbl169:
                        // 2 sources

                        if (v14) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 9;
                            v15 = $this$sequence.yield(ImprovementBuildingProblem.UnmetConditional, this);
                            if (v15 == var15_2) {
                                return var15_2;
                            }
                        }
                        ** GOTO lbl182
                    }
                    case 9: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v15 = $result;
lbl182:
                        // 2 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.ObsoleteWith, stateForConditionals);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$5 = false;
                            if (!$i$f$any.getTech().isResearched(it.getParams().get(0))) continue;
                            v16 = true;
                            ** GOTO lbl194
                        }
                        v16 = false;
lbl194:
                        // 2 sources

                        if (v16) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 10;
                            v17 = $this$sequence.yield(ImprovementBuildingProblem.Obsolete, this);
                            if (v17 == var15_2) {
                                return var15_2;
                            }
                        }
                        ** GOTO lbl207
                    }
                    case 10: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v17 = $result;
lbl207:
                        // 2 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.ConsumesResources, stateForConditionals);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$6 = false;
                            v18 = $i$f$any.getResourceAmount(it.getParams().get(1)) < Integer.parseInt(it.getParams().get(0));
                            if (!v18) continue;
                            v19 = true;
                            ** GOTO lbl220
                        }
                        v19 = false;
lbl220:
                        // 2 sources

                        if (v19) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 11;
                            v20 = $this$sequence.yield(ImprovementBuildingProblem.MissingResources, this);
                            if (v20 == var15_2) {
                                return var15_2;
                            }
                        }
                        ** GOTO lbl233
                    }
                    case 11: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v20 = $result;
lbl233:
                        // 2 sources

                        $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.$improvement, UniqueType.CostsResources, null, 2, null);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$7 = false;
                            if (!((float)$i$f$any.getResourceAmount(it.getParams().get(1)) < (float)Integer.parseInt(it.getParams().get(0)) * (it.isModifiedByGameSpeed() != false ? $i$f$any.getGameInfo().getSpeed().getModifier() : 1.0f))) continue;
                            v21 = true;
                            ** GOTO lbl245
                        }
                        v21 = false;
lbl245:
                        // 2 sources

                        if (v21) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 12;
                            v22 = $this$sequence.yield(ImprovementBuildingProblem.MissingResources, this);
                            if (v22 == var15_2) {
                                return var15_2;
                            }
                        }
                        ** GOTO lbl258
                    }
                    case 12: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v22 = $result;
lbl258:
                        // 2 sources

                        $this$filter$iv = this.this$0.getTile().getRuleset().getNonRoadTileRemovals();
                        var6_16 = this.$civInfo;
                        $i$f$filter = false;
                        element$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            rulesetImprovement = (TileImprovement)element$iv$iv;
                            $i$a$-filter-TileImprovementFunctions$getImprovementBuildingProblems$1$knownFeatureRemovals$1 = false;
                            if (rulesetImprovement.getTechRequired() == null) ** GOTO lbl-1000
                            v23 = var6_16.getTech();
                            v24 = rulesetImprovement.getTechRequired();
                            Intrinsics.checkNotNull(v24);
                            if (v23.isResearched(v24)) lbl-1000:
                            // 2 sources

                            {
                                v25 = true;
                            } else {
                                v25 = false;
                            }
                            if (!v25) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        knownFeatureRemovals = (List)destination$iv$iv;
                        if (!TileImprovementFunctions.canImprovementBeBuiltHere$core$default(this.this$0, this.$improvement, this.this$0.getTile().hasViewableResource(this.$civInfo), knownFeatureRemovals, stateForConditionals, false, 16, null)) {
                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 13;
                            v26 = $this$sequence.yield(ImprovementBuildingProblem.Other, this);
                            if (v26 == var15_2) {
                                return var15_2;
                            }
                        }
                        ** GOTO lbl291
                    }
                    case 13: {
                        ResultKt.throwOnFailure($result);
                        v26 = $result;
lbl291:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super ImprovementBuildingProblem>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super ImprovementBuildingProblem> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canImprovementBeBuiltHere$core(@NotNull TileImprovement improvement2, boolean resourceIsVisible, @Nullable List<TileImprovement> knownFeatureRemovals, @NotNull StateForConditionals stateForConditionals, boolean isNormalizeCheck) {
        Object it;
        Iterator iterator2;
        boolean bl;
        boolean $i$f$any;
        Sequence<Unique> $this$any$iv;
        block39: {
            Intrinsics.checkNotNullParameter(improvement2, "improvement");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            if (Intrinsics.areEqual(improvement2.getName(), this.tile.getImprovement()) && !isNormalizeCheck) {
                return false;
            }
            if (this.tile.isCityCenter()) {
                if (!isNormalizeCheck) return false;
                if (!Intrinsics.areEqual(improvement2.getName(), "City center")) return false;
                return true;
            }
            if (Intrinsics.areEqual(improvement2.getName(), "Cancel improvement order")) {
                if (this.tile.getImprovementInProgress() == null) return false;
                return true;
            }
            $this$any$iv = RoadStatus.getEntries();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                bl = false;
            } else {
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it = (RoadStatus)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((RoadStatus)it).getRemoveAction(), improvement2.getName())) continue;
                    bl = true;
                    break block39;
                }
                bl = false;
            }
        }
        if (!bl) {
            Unique unique;
            boolean bl3;
            block40: {
                if (StringsKt.startsWith$default(improvement2.getName(), "Remove ", false, 2, null)) {
                    boolean bl4;
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                        bl4 = false;
                    } else {
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object t = iterator2.next();
                            it = (String)t;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual("Remove " + (String)it, improvement2.getName())) continue;
                            return true;
                        }
                        bl4 = false;
                    }
                    if (bl4) return true;
                    if (!Intrinsics.areEqual("Remove " + this.tile.getImprovement(), improvement2.getName())) return false;
                    return true;
                }
                $this$any$iv = RoadStatus.getEntries();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                    bl3 = false;
                } else {
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        it = (RoadStatus)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual(((Enum)it).name(), improvement2.getName())) continue;
                        bl3 = true;
                        break block40;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                if (this.tile.isWater()) return false;
                if (RoadStatus.valueOf(improvement2.getName()).compareTo((Enum)this.tile.getRoadStatus()) <= 0) return false;
                return true;
            }
            if (this.tile.getImprovement() != null) {
                TileImprovement tileImprovement = this.tile.getTileImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (tileImprovement.hasUnique(UniqueType.Irremovable, stateForConditionals)) {
                    return false;
                }
            }
            if (this.tile.getLastTerrain().getUnbuildable() && !TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(improvement2, this, stateForConditionals, improvement2, resourceIsVisible, knownFeatureRemovals)) {
                return false;
            }
            List<Unique> it2 = SequencesKt.toList(this.tile.getTerrainMatchingUniques(UniqueType.RestrictedBuildableImprovements, stateForConditionals));
            boolean $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52 = false;
            if (CollectionsKt.any((Iterable)it2)) {
                Iterable iterable = it2;
                boolean $i$f$none = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    return false;
                }
                Iterator bl6 = iterable.iterator();
                do {
                    if (!bl6.hasNext()) return false;
                    Object t = bl6.next();
                    unique = (Unique)t;
                    boolean bl7 = false;
                } while (!TileImprovement.matchesFilter$default(improvement2, unique.getParams().get(0), new StateForConditionals(null, null, null, this.tile, null, null, null, null, null, null, false, 2039, null), false, 4, null));
                boolean bl8 = false;
                if (bl8) {
                    return false;
                }
            }
            boolean bl9 = false;
            if (bl9) {
                return false;
            }
            $this$any$iv = improvement2.getMatchingUniques(UniqueType.CannotBuildOnTile, stateForConditionals);
            boolean $i$f$any2 = false;
            Iterator $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52 = $this$any$iv.iterator();
            while ($i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52.hasNext()) {
                Object t = $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52.next();
                Unique unique2 = (Unique)t;
                boolean bl10 = false;
                if (!this.tile.matchesFilter(unique2.getParams().get(0), stateForConditionals.getCivInfo())) continue;
                return false;
            }
            boolean bl11 = false;
            if (bl11) {
                return false;
            }
            Sequence<Unique> it22 = improvement2.getMatchingUniques(UniqueType.CanOnlyBeBuiltOnTile, stateForConditionals);
            boolean bl12 = false;
            if (SequencesKt.any(it22)) {
                Sequence<Unique> sequence = it22;
                boolean $i$f$any3 = false;
                Iterator<Unique> bl10 = sequence.iterator();
                while (bl10.hasNext()) {
                    Unique unique3;
                    unique = unique3 = bl10.next();
                    boolean bl13 = false;
                    if (!this.tile.matchesFilter(unique.getParams().get(0), stateForConditionals.getCivInfo())) {
                        return false;
                    }
                    boolean bl14 = false;
                    if (!bl14) continue;
                    return false;
                }
                boolean bl15 = false;
                if (bl15) {
                    return false;
                }
            }
            boolean bl16 = false;
            if (bl16) {
                return false;
            }
            $this$any$iv = improvement2.getMatchingUniques(UniqueType.MustBeNextTo, stateForConditionals);
            $i$f$any = false;
            Iterator<Unique> iterator3 = $this$any$iv.iterator();
            while (iterator3.hasNext()) {
                Unique unique4;
                Unique it3 = unique4 = iterator3.next();
                boolean bl17 = false;
                if (!Tile.isAdjacentTo$default(this.tile, it3.getParams().get(0), null, 2, null)) {
                    return false;
                }
                boolean bl18 = false;
                if (!bl18) continue;
                return false;
            }
            boolean bl19 = false;
            if (bl19) {
                return false;
            }
            if (improvement2.hasUnique(UniqueType.CanOnlyImproveResource, stateForConditionals)) {
                if (!resourceIsVisible) return false;
                if (!this.tile.getTileResource().isImprovedBy(improvement2.getName())) {
                    return false;
                }
            }
            if (improvement2.isAllowedOnFeature(this.tile.getLastTerrain())) {
                return true;
            }
            if (this.tile.isLand() && improvement2.canBeBuiltOn("Land")) {
                return true;
            }
            if (this.tile.isWater() && improvement2.canBeBuiltOn("Water")) {
                return true;
            }
            if (improvement2.hasUnique(UniqueType.ImprovementBuildableByFreshWater, stateForConditionals) && Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) {
                return true;
            }
            if (!resourceIsVisible) return false;
            if (!this.tile.getTileResource().isImprovedBy(improvement2.getName())) return false;
            return true;
        }
        boolean bl20 = Intrinsics.areEqual(this.tile.getRoadStatus().getRemoveAction(), improvement2.getName());
        return bl20;
    }

    public static /* synthetic */ boolean canImprovementBeBuiltHere$core$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, boolean bl, List list2, StateForConditionals stateForConditionals, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl3 = bl = tileImprovementFunctions.tile.getResource() != null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            stateForConditionals = new StateForConditionals(null, null, null, tileImprovementFunctions.tile, null, null, null, null, null, null, false, 2039, null);
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return tileImprovementFunctions.canImprovementBeBuiltHere$core(tileImprovement, bl, list2, stateForConditionals, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setImprovement(@Nullable String improvementName, @Nullable Civilization civToActivateBroaderEffects, @Nullable MapUnit unit) {
        TileImprovement improvementObject = (TileImprovement)((Map)this.tile.getRuleset().getTileImprovements()).get(improvementName);
        boolean improvementFieldHasChanged = false;
        String string = improvementName;
        boolean bl = string != null ? StringsKt.startsWith$default(string, "Remove ", false, 2, null) : false;
        if (bl) {
            this.activateRemovalImprovement(improvementName, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Road")) {
            this.tile.setRoadStatus(RoadStatus.Road, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Railroad")) {
            this.tile.setRoadStatus(RoadStatus.Railroad, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Repair")) {
            this.tile.setRepaired();
        } else {
            this.tile.setImprovementIsPillaged(false);
            this.tile.setImprovement(improvementName);
            improvementFieldHasChanged = true;
            this.removeCreatesOneImprovementMarker();
        }
        if (improvementFieldHasChanged && this.tile.getTileMap().hasGameInfo()) {
            for (Civilization civ : this.tile.getTileMap().getGameInfo().getCivilizations()) {
                if (civ.isDefeated() || !civ.isMajorCiv() || !Intrinsics.areEqual(civ, civToActivateBroaderEffects) && !this.tile.isVisible(civ)) continue;
                civ.setLastSeenImprovement(this.tile.getPosition(), improvementName);
            }
        }
        if (improvementObject != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvementObject, UniqueType.RemovesFeaturesIfBuilt, null, 2, null)) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object feature;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.tile.getTerrainFeatureObjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                feature = (Terrain)element$iv$iv;
                boolean bl2 = false;
                String removingAction = "Remove " + ((NamedStats)feature).getName();
                boolean bl3 = ((Map)this.tile.getRuleset().getTileImprovements()).containsKey(removingAction) && !improvementObject.isAllowedOnFeature((Terrain)feature);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List removableTerrainFeatures = (List)destination$iv$iv;
            $this$filter$iv = this.tile.getTerrainFeatures();
            Tile tile = this.tile;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl4;
                block18: {
                    feature = (String)element$iv$iv;
                    boolean bl5 = false;
                    Iterable $this$any$iv = removableTerrainFeatures;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Terrain it = (Terrain)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual(it.getName(), feature)) continue;
                            bl4 = true;
                            break block18;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tile.setTerrainFeatures((List)destination$iv$iv);
        }
        if (civToActivateBroaderEffects != null && improvementObject != null) {
            this.triggerImprovementUniques(improvementObject, civToActivateBroaderEffects, unit);
        }
        City city2 = this.tile.getOwningCity();
        if (civToActivateBroaderEffects != null && city2 != null) {
            CityStats.update$default(city2.getCityStats(), null, false, false, null, 15, null);
            city2.getCiv().getCache().updateCivResources();
            city2.reassignPopulationDeferred();
        }
    }

    public static /* synthetic */ void setImprovement$default(TileImprovementFunctions tileImprovementFunctions, String string, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            civilization = null;
        }
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.setImprovement(string, civilization, mapUnit);
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerImprovementUniques(TileImprovement improvement2, Civilization civ, MapUnit unit) {
        void $this$filterTo$iv$iv;
        Unique unique2;
        StateForConditionals stateForConditionals = new StateForConditionals(civ, null, unit, this.tile, null, null, null, null, null, null, false, 2034, null);
        Iterator<Unique> iterator2 = improvement2.getMatchingUniques(UniqueType.CostsResources, stateForConditionals).iterator();
        while (iterator2.hasNext()) {
            TileResource resource2;
            unique2 = iterator2.next();
            if (this.tile.getRuleset().getTileResources().get(unique2.getParams().get(1)) == null) continue;
            int amount = Integer.parseInt(unique2.getParams().get(0));
            if (unique2.isModifiedByGameSpeed()) {
                amount = (int)((float)amount * civ.getGameInfo().getSpeed().getModifier());
            }
            civ.gainStockpiledResource(resource2, -amount);
        }
        Iterable $this$filter$iv = improvement2.getUniqueObjects();
        boolean $i$f$filter = false;
        Iterable amount = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Unique it = (Unique)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !it.hasTriggerConditional() && it.conditionalsApply(stateForConditionals);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Unique unique2 : (List)destination$iv$iv) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
        for (Unique unique2 : civ.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, stateForConditionals, (Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>(improvement2, stateForConditionals){
            final /* synthetic */ TileImprovement $improvement;
            final /* synthetic */ StateForConditionals $stateForConditionals;
            {
                this.$improvement = $improvement;
                this.$stateForConditionals = $stateForConditionals;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return TileImprovement.matchesFilter$default(this.$improvement, it.getParams().get(0), this.$stateForConditionals, false, 4, null);
            }
        })) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
        if (unit == null) {
            return;
        }
        iterator2 = unit.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, stateForConditionals, (Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>(improvement2, stateForConditionals){
            final /* synthetic */ TileImprovement $improvement;
            final /* synthetic */ StateForConditionals $stateForConditionals;
            {
                this.$improvement = $improvement;
                this.$stateForConditionals = $stateForConditionals;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return TileImprovement.matchesFilter$default(this.$improvement, it.getParams().get(0), this.$stateForConditionals, false, 4, null);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            unique2 = iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
    }

    static /* synthetic */ void triggerImprovementUniques$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.triggerImprovementUniques(tileImprovement, civilization, mapUnit);
    }

    private final void activateRemovalImprovement(String improvementName, Civilization civToActivateBroaderEffects) {
        boolean bl;
        String removedFeatureName;
        block14: {
            Object it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            removedFeatureName = StringsKt.removePrefix(improvementName, (CharSequence)"Remove ");
            TileImprovement currentTileImprovement = this.tile.getTileImprovement();
            if (currentTileImprovement != null) {
                boolean bl2;
                block13: {
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(currentTileImprovement.getTerrainsCanBeBuiltOn().contains(it) && Intrinsics.areEqual(it, removedFeatureName))) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (bl2 && !currentTileImprovement.getTerrainsCanBeBuiltOn().contains(this.tile.getBaseTerrain())) {
                    this.tile.removeImprovement();
                }
            }
            $this$any$iv = RoadStatus.getEntries();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (RoadStatus)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(improvementName, ((RoadStatus)it).getRemoveAction())) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            this.tile.removeRoad();
        } else if (Intrinsics.areEqual(this.tile.getImprovement(), removedFeatureName)) {
            this.tile.removeImprovement();
        } else {
            Terrain removedFeatureObject = this.tile.getRuleset().getTerrains().get(removedFeatureName);
            if (removedFeatureObject != null && civToActivateBroaderEffects != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)removedFeatureObject, UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                this.tryProvideProductionToClosestCity(removedFeatureName, civToActivateBroaderEffects);
            }
            this.tile.removeTerrainFeature(removedFeatureName);
        }
    }

    private final void tryProvideProductionToClosestCity(String removedTerrainFeature, Civilization civ) {
        Stats stats2;
        City closestCity;
        block17: {
            block16: {
                Object v0;
                Iterable $this$minByOrNull$iv = civ.getCities();
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        City it = (City)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.getCenterTile().aerialDistanceTo(this.tile);
                        do {
                            Object e$iv = iterator$iv.next();
                            City it2 = (City)e$iv;
                            $i$a$-minByOrNull-TileImprovementFunctions$tryProvideProductionToClosestCity$closestCity$1 = false;
                            int v$iv = it2.getCenterTile().aerialDistanceTo(this.tile);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                City city2 = v0;
                if (city2 == null) {
                    return;
                }
                closestCity = city2;
                int distance = closestCity.getCenterTile().aerialDistanceTo(this.tile);
                if (distance > 5) {
                    return;
                }
                stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
                Iterator<Object> iterator2 = Tile.getTerrainMatchingUniques$default(this.tile, UniqueType.ProductionBonusWhenRemoved, null, 2, null).iterator();
                while (iterator2.hasNext()) {
                    Unique unique = (Unique)iterator2.next();
                    Stats statsToAdd = unique.getStats();
                    if (unique.isModifiedByGameSpeed()) {
                        statsToAdd = statsToAdd.times(civ.getGameInfo().getSpeed().getModifier());
                    }
                    if (unique.isModifiedByGameProgress()) {
                        statsToAdd = statsToAdd.times(unique.getGameProgressModifier(civ));
                    }
                    stats2.add(statsToAdd);
                }
                if (stats2.isEmpty()) {
                    return;
                }
                if (distance != 1) {
                    stats2 = stats2.times((float)(6 - distance) / 4.0f);
                }
                if (this.tile.getOwningCity() == null) break block16;
                City city3 = this.tile.getOwningCity();
                Intrinsics.checkNotNull(city3);
                if (Intrinsics.areEqual(city3.getCiv(), civ)) break block17;
            }
            stats2 = stats2.times(0.6666667f);
        }
        for (Stats.StatValuePair statValuePair : stats2) {
            Stat stat = statValuePair.component1();
            float value = statValuePair.component2();
            closestCity.addStat(stat, (int)value);
            Object[] objectArray = new Vector2[]{this.tile.getPosition(), closestCity.getLocation()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2[])objectArray);
            objectArray = new String[]{"StatIcons/Production"};
            civ.addNotification("Clearing a [" + removedTerrainFeature + "] has created [" + stats2.toStringForNotifications() + "] for [" + closestCity.getName() + ']', locations, Notification.NotificationCategory.Production, (String[])objectArray);
        }
    }

    public final void markForCreatesOneImprovement(@NotNull String improvement2) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        this.tile.stopWorkingOnImprovement();
        this.tile.queueImprovement(improvement2, -1);
    }

    public final void removeCreatesOneImprovementMarker() {
        if (!this.tile.isMarkedForCreatesOneImprovement()) {
            return;
        }
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.tile.getOwningCity();
        if (isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getCityConstructions()) != null) {
            String string = this.tile.getImprovementInProgress();
            Intrinsics.checkNotNull(string);
            ((CityConstructions)isPartOfGameInfoSerialization).removeCreateOneImprovementConstruction(string);
        }
        this.tile.stopWorkingOnImprovement();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(TileImprovement $this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain, TileImprovementFunctions this$0, StateForConditionals $stateForConditionals, TileImprovement $improvement, boolean $resourceIsVisible, List<TileImprovement> knownFeatureRemovals) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object element$iv3;
        boolean bl;
        List featureRemovals;
        block15: {
            Iterator $this$mapNotNullTo$iv$iv;
            Terrain topTerrain = this$0.tile.getLastTerrain();
            if ($this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.isAllowedOnFeature(topTerrain)) {
                return true;
            }
            if (!$this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.hasUnique(UniqueType.RemovesFeaturesIfBuilt, $stateForConditionals)) {
                return false;
            }
            Collection collection = knownFeatureRemovals;
            if (collection == null || collection.isEmpty()) {
                return false;
            }
            Iterable $this$mapNotNull$iv = this$0.tile.getTerrainFeatures();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TileImprovement it$iv$iv;
                Object v0;
                block14: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String feature = (String)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = this$0.tile.getRuleset().getTileRemovals();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TileImprovement it = (TileImprovement)element$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getName(), "Remove " + feature)) continue;
                        v0 = element$iv2;
                        break block14;
                    }
                    v0 = null;
                }
                if ((TileImprovement)v0 == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            featureRemovals = (List)destination$iv$iv;
            if (featureRemovals.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = featureRemovals;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    TileImprovement it = (TileImprovement)element$iv3;
                    boolean bl6 = false;
                    if (!(!knownFeatureRemovals.contains(it))) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Tile clonedTile = this$0.tile.clone(false);
        Iterable $i$f$any = this$0.tile.getTerrainFeatures();
        Tile tile = clonedTile;
        boolean $i$f$filterNot = false;
        element$iv3 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl7;
            block16: {
                String feature = (String)element$iv$iv;
                boolean bl8 = false;
                Iterable $this$any$iv = featureRemovals;
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv4 : $this$any$iv) {
                        TileImprovement it = (TileImprovement)element$iv4;
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual(StringsKt.removePrefix(it.getName(), (CharSequence)"Remove "), feature)) continue;
                        bl7 = true;
                        break block16;
                    }
                    bl7 = false;
                }
            }
            if (bl7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tile.setTerrainFeatures((List)destination$iv$iv);
        return TileImprovementFunctions.canImprovementBeBuiltHere$core$default(clonedTile.getImprovementFunctions(), $improvement, $resourceIsVisible, knownFeatureRemovals, $stateForConditionals, false, 16, null);
    }

    static /* synthetic */ boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain$default(TileImprovement tileImprovement, TileImprovementFunctions tileImprovementFunctions, StateForConditionals stateForConditionals, TileImprovement tileImprovement2, boolean bl, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        return TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(tileImprovement, tileImprovementFunctions, stateForConditionals, tileImprovement2, bl, list2);
    }
}

