/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.unciv.json.UncivJsonKt;
import com.unciv.logic.multiplayer.storage.AuthStatus;
import com.unciv.logic.multiplayer.storage.FileMetaData;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.FileStorageConflictException;
import com.unciv.logic.multiplayer.storage.FileStorageRateLimitReached;
import com.unciv.logic.multiplayer.storage.MultiplayerFileNotFoundException;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.concurrent.TimersKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\"#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\nJ0\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unciv/logic/multiplayer/storage/DropBox;", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "()V", "rateLimitTimer", "Ljava/util/Timer;", "remainingRateLimitSeconds", "", "authenticate", "", "userId", "", "password", "checkAuthStatus", "Lcom/unciv/logic/multiplayer/storage/AuthStatus;", "deleteFile", "", "fileName", "downloadFile", "Ljava/io/InputStream;", "dropboxApi", "url", "data", "contentType", "dropboxApiArg", "getFileMetaData", "Lcom/unciv/logic/multiplayer/storage/FileMetaData;", "getLocalGameLocation", "loadFileData", "saveFileData", "setPassword", "newPassword", "triggerRateLimit", "response", "Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse;", "ErrorResponse", "MetaData", "core"})
public final class DropBox
implements FileStorage {
    @NotNull
    public static final DropBox INSTANCE = new DropBox();
    private static int remainingRateLimitSeconds;
    @Nullable
    private static Timer rateLimitTimer;

    private DropBox() {
    }

    private final InputStream dropboxApi(String url2, String data2, String contentType2, String dropboxApiArg) {
        if (remainingRateLimitSeconds > 0) {
            throw new FileStorageRateLimitReached(remainingRateLimitSeconds);
        }
        URLConnection uRLConnection = new URI(url2).toURL().openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$dropboxApi_u24lambda_u240 = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$dropboxApi_u24lambda_u240.setRequestMethod("POST");
        $this$dropboxApi_u24lambda_u240.setRequestProperty("Authorization", "Bearer LTdBbopPUQ0AAAAAAAACxh4_Qd1eVMM7IBK3ULV3BgxzWZDMfhmgFbuUNF_rXQWb");
        if (!Intrinsics.areEqual(dropboxApiArg, "")) {
            $this$dropboxApi_u24lambda_u240.setRequestProperty("Dropbox-API-Arg", dropboxApiArg);
        }
        if (!Intrinsics.areEqual(contentType2, "")) {
            $this$dropboxApi_u24lambda_u240.setRequestProperty("Content-Type", contentType2);
        }
        $this$dropboxApi_u24lambda_u240.setDoOutput(true);
        try {
            if (!Intrinsics.areEqual(data2, "")) {
                byte[] byArray = data2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                byte[] postData = byArray;
                DataOutputStream outputStream2 = new DataOutputStream($this$dropboxApi_u24lambda_u240.getOutputStream());
                outputStream2.write(postData);
                outputStream2.flush();
            }
            return $this$dropboxApi_u24lambda_u240.getInputStream();
        }
        catch (Exception ex) {
            LogKt.debug("Dropbox exception", ex);
            BufferedReader reader = new BufferedReader(new InputStreamReader($this$dropboxApi_u24lambda_u240.getErrorStream(), Charsets.UTF_8));
            String responseString = TextStreamsKt.readText(reader);
            Object[] objectArray = new Object[]{responseString};
            LogKt.debug("Response: %s", objectArray);
            ErrorResponse error2 = UncivJsonKt.json().fromJson(ErrorResponse.class, responseString);
            if (StringsKt.startsWith$default(error2.getError_summary(), "too_many_requests/", false, 2, null)) {
                Intrinsics.checkNotNull(error2);
                INSTANCE.triggerRateLimit(error2);
            } else {
                if (StringsKt.startsWith$default(error2.getError_summary(), "path/not_found/", false, 2, null)) {
                    throw new MultiplayerFileNotFoundException(ex);
                }
                if (StringsKt.startsWith$default(error2.getError_summary(), "path/conflict/file", false, 2, null)) {
                    throw new FileStorageConflictException();
                }
            }
            return null;
        }
        catch (Error error3) {
            Log.INSTANCE.error("Dropbox error", error3);
            Object[] objectArray = new Object[]{new Function0<String>($this$dropboxApi_u24lambda_u240){
                final /* synthetic */ HttpURLConnection $this_with;
                {
                    this.$this_with = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return TextStreamsKt.readText(new BufferedReader(new InputStreamReader(this.$this_with.getErrorStream(), Charsets.UTF_8)));
                }
            }};
            LogKt.debug("Error stream: %s", objectArray);
            return null;
        }
    }

    static /* synthetic */ InputStream dropboxApi$default(DropBox dropBox, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        return dropBox.dropboxApi(string, string2, string3, string4);
    }

    private final String getLocalGameLocation(String fileName) {
        return "/MultiplayerGames/" + fileName;
    }

    @Override
    public void deleteFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        DropBox.dropboxApi$default(this, "https://api.dropboxapi.com/2/files/delete_v2", "{\"path\":\"" + this.getLocalGameLocation(fileName) + "\"}", "application/json", null, 8, null);
    }

    @Override
    @NotNull
    public FileMetaData getFileMetaData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream2 = DropBox.dropboxApi$default(this, "https://api.dropboxapi.com/2/files/get_metadata", "{\"path\":\"" + this.getLocalGameLocation(fileName) + "\"}", "application/json", null, 8, null);
        Intrinsics.checkNotNull(inputStream2);
        InputStream stream = inputStream2;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
        MetaData metaData = UncivJsonKt.json().fromJson(MetaData.class, TextStreamsKt.readText(reader));
        Intrinsics.checkNotNullExpressionValue(metaData, "fromJson(...)");
        return metaData;
    }

    @Override
    public void saveFileData(@NotNull String fileName, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNull(this.dropboxApi("https://content.dropboxapi.com/2/files/upload", data2, "application/octet-stream", "{\"path\":\"" + this.getLocalGameLocation(fileName) + "\",\"mode\":{\".tag\":\"overwrite\"}}"));
    }

    @Override
    @NotNull
    public String loadFileData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream2 = this.downloadFile(this.getLocalGameLocation(fileName));
        return TextStreamsKt.readText(new BufferedReader(new InputStreamReader(inputStream2, Charsets.UTF_8)));
    }

    @Override
    public boolean authenticate(@NotNull String userId, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(password, "password");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public AuthStatus checkAuthStatus(@NotNull String userId, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(password, "password");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public boolean setPassword(@NotNull String newPassword) {
        Intrinsics.checkNotNullParameter(newPassword, "newPassword");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final InputStream downloadFile(@NotNull String fileName) {
        InputStream response2;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        InputStream inputStream2 = response2 = DropBox.dropboxApi$default(this, "https://content.dropboxapi.com/2/files/download", null, "text/plain", "{\"path\":\"" + fileName + "\"}", 2, null);
        Intrinsics.checkNotNull(inputStream2);
        return inputStream2;
    }

    private final void triggerRateLimit(ErrorResponse response2) {
        Timer timer2;
        Object object = response2.getError();
        remainingRateLimitSeconds = object != null && (object = ((ErrorResponse.Details)object).getRetry_after()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 300;
        String string = "RateLimitTimer";
        boolean bl = true;
        long l = 0L;
        long l2 = 1000L;
        Timer timer3 = timer2 = TimersKt.timer(string, bl);
        timer3.schedule(new TimerTask(){

            public void run() {
                block1: {
                    TimerTask $this$triggerRateLimit_u24lambda_u241 = this;
                    boolean bl = false;
                    DropBox.access$setRemainingRateLimitSeconds$p(DropBox.INSTANCE.access$getRemainingRateLimitSeconds$p() + -1);
                    if (DropBox.access$getRemainingRateLimitSeconds$p() != 0) break block1;
                    Timer timer2 = DropBox.access$getRateLimitTimer$p();
                    if (timer2 != null) {
                        timer2.cancel();
                    }
                }
            }
        }, l, l2);
        rateLimitTimer = timer2;
        throw new FileStorageRateLimitReached(remainingRateLimitSeconds);
    }

    public static final /* synthetic */ int access$getRemainingRateLimitSeconds$p() {
        return remainingRateLimitSeconds;
    }

    public static final /* synthetic */ void access$setRemainingRateLimitSeconds$p(int n) {
        remainingRateLimitSeconds = n;
    }

    public static final /* synthetic */ Timer access$getRateLimitTimer$p() {
        return rateLimitTimer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse;", "", "()V", "error", "Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse$Details;", "getError", "()Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse$Details;", "setError", "(Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse$Details;)V", "error_summary", "", "getError_summary", "()Ljava/lang/String;", "setError_summary", "(Ljava/lang/String;)V", "Details", "core"})
    private static final class ErrorResponse {
        @NotNull
        private String error_summary = "";
        @Nullable
        private Details error;

        @NotNull
        public final String getError_summary() {
            return this.error_summary;
        }

        public final void setError_summary(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.error_summary = string;
        }

        @Nullable
        public final Details getError() {
            return this.error;
        }

        public final void setError(@Nullable Details details) {
            this.error = details;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/multiplayer/storage/DropBox$ErrorResponse$Details;", "", "()V", "retry_after", "", "getRetry_after", "()Ljava/lang/String;", "setRetry_after", "(Ljava/lang/String;)V", "core"})
        public static final class Details {
            @NotNull
            private String retry_after = "";

            @NotNull
            public final String getRetry_after() {
                return this.retry_after;
            }

            public final void setRetry_after(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.retry_after = string;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/multiplayer/storage/DropBox$MetaData;", "Lcom/unciv/logic/multiplayer/storage/FileMetaData;", "()V", "server_modified", "", "getServer_modified", "()Ljava/lang/String;", "setServer_modified", "(Ljava/lang/String;)V", "getLastModified", "Ljava/util/Date;", "core"})
    private static final class MetaData
    implements FileMetaData {
        @NotNull
        private String server_modified = "";

        @NotNull
        public final String getServer_modified() {
            return this.server_modified;
        }

        public final void setServer_modified(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.server_modified = string;
        }

        @Override
        @NotNull
        public Date getLastModified() {
            return UncivDateFormat.INSTANCE.parseDate(this.server_modified);
        }
    }
}

