/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.simulation;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.simulation.MutableInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0003R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R)\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u00120\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010\u00a8\u0006$"}, d2={"Lcom/unciv/logic/simulation/SimulationStep;", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "statTurns", "", "", "(Lcom/unciv/logic/GameInfo;Ljava/util/List;)V", "civilizations", "", "getCivilizations", "()Ljava/util/List;", "currentPlayer", "getCurrentPlayer", "()Ljava/lang/String;", "setCurrentPlayer", "(Ljava/lang/String;)V", "turnStats", "", "Lcom/unciv/logic/simulation/MutableInt;", "getTurnStats", "()Ljava/util/Map;", "turns", "getTurns", "()I", "setTurns", "(I)V", "victoryType", "getVictoryType", "setVictoryType", "winner", "getWinner", "setWinner", "saveTurnStats", "", "update", "core"})
@SourceDebugExtension(value={"SMAP\nSimulationStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulationStep.kt\ncom/unciv/logic/simulation/SimulationStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n766#2:42\n857#2,2:43\n1549#2:45\n1620#2,3:46\n766#2:63\n857#2,2:64\n372#3,7:49\n372#3,7:56\n1#4:66\n*S KotlinDebug\n*F\n+ 1 SimulationStep.kt\ncom/unciv/logic/simulation/SimulationStep\n*L\n7#1:42\n7#1:43,2\n7#1:45\n7#1:46,3\n26#1:63\n26#1:64,2\n17#1:49,7\n18#1:56,7\n*E\n"})
public final class SimulationStep {
    @NotNull
    private final List<String> civilizations;
    private int turns;
    @Nullable
    private String victoryType;
    @Nullable
    private String winner;
    @NotNull
    private String currentPlayer;
    @NotNull
    private final Map<String, Map<Integer, MutableInt>> turnStats;

    /*
     * WARNING - void declaration
     */
    public SimulationStep(@NotNull GameInfo gameInfo, @NotNull List<Integer> statTurns) {
        Iterator<Integer> $this$mapTo$iv$iv;
        void $this$map$iv;
        Civilization it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(statTurns, "statTurns");
        Iterable iterable = gameInfo.getCivilizations();
        SimulationStep simulationStep = this;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCivName(), "Spectator"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCivName());
        }
        simulationStep.civilizations = (List)destination$iv$iv;
        this.turns = gameInfo.getTurns();
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        this.currentPlayer = gameInfo.getCurrentPlayer();
        this.turnStats = new LinkedHashMap();
        for (String civ : this.civilizations) {
            Map map3;
            $this$mapTo$iv$iv = statTurns.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Map map4;
                int turn = ((Number)$this$mapTo$iv$iv.next()).intValue();
                Map<Object, Object> $this$getOrPut$iv = this.turnStats;
                boolean $i$f$getOrPut22 = false;
                Map value$iv = $this$getOrPut$iv.get(civ);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv.put(civ, answer$iv);
                    map4 = answer$iv;
                } else {
                    map4 = value$iv;
                }
                $this$getOrPut$iv = map4;
                Integer $i$f$getOrPut22 = turn;
                MutableInt mutableInt = new MutableInt(-1);
                $this$getOrPut$iv.put($i$f$getOrPut22, mutableInt);
            }
            Map<String, Map<Integer, MutableInt>> $this$getOrPut$iv = this.turnStats;
            boolean $i$f$getOrPut = false;
            Map value$iv = $this$getOrPut$iv.get(civ);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(civ, answer$iv);
                map3 = answer$iv;
            } else {
                map3 = value$iv;
            }
            map2 = map3;
            Integer n = -1;
            MutableInt mutableInt = new MutableInt(-1);
            map2.put(n, mutableInt);
        }
    }

    public /* synthetic */ SimulationStep(GameInfo gameInfo, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(gameInfo, list2);
    }

    @NotNull
    public final List<String> getCivilizations() {
        return this.civilizations;
    }

    public final int getTurns() {
        return this.turns;
    }

    public final void setTurns(int n) {
        this.turns = n;
    }

    @Nullable
    public final String getVictoryType() {
        return this.victoryType;
    }

    public final void setVictoryType(@Nullable String string) {
        this.victoryType = string;
    }

    @Nullable
    public final String getWinner() {
        return this.winner;
    }

    public final void setWinner(@Nullable String string) {
        this.winner = string;
    }

    @NotNull
    public final String getCurrentPlayer() {
        return this.currentPlayer;
    }

    public final void setCurrentPlayer(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.currentPlayer = string;
    }

    @NotNull
    public final Map<String, Map<Integer, MutableInt>> getTurnStats() {
        return this.turnStats;
    }

    /*
     * WARNING - void declaration
     */
    public final void saveTurnStats(@NotNull GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        int turn = this.victoryType != null ? -1 : gameInfo.getTurns();
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCivName(), "Spectator"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            iterable = civ.getCities();
            int n = 0;
            for (Iterator iterator2 : iterable) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (City)((Object)iterator2);
                int n2 = n;
                boolean bl = false;
                int n3 = it.getPopulation().getPopulation();
                n = n2 + n3;
            }
            int popsum = n;
            Map<Integer, MutableInt> map2 = this.turnStats.get(civ.getCivName());
            Intrinsics.checkNotNull(map2);
            MutableInt mutableInt = map2.get(turn);
            Intrinsics.checkNotNull(mutableInt);
            mutableInt.set(popsum);
        }
    }

    public final void update(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.turns = gameInfo.getTurns();
        this.victoryType = gameInfo.getCurrentPlayerCivilization().getVictoryManager().getVictoryTypeAchieved();
        this.currentPlayer = gameInfo.getCurrentPlayer();
    }
}

