/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.trade;

import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/trade/TradeLogic;", "", "ourCivilization", "Lcom/unciv/logic/civilization/Civilization;", "otherCivilization", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;)V", "currentTrade", "Lcom/unciv/logic/trade/Trade;", "getCurrentTrade", "()Lcom/unciv/logic/trade/Trade;", "getOtherCivilization", "()Lcom/unciv/logic/civilization/Civilization;", "ourAvailableOffers", "Lcom/unciv/logic/trade/TradeOffersList;", "getOurAvailableOffers", "()Lcom/unciv/logic/trade/TradeOffersList;", "getOurCivilization", "theirAvailableOffers", "getTheirAvailableOffers", "acceptTrade", "", "applyGifts", "", "getAvailableOffers", "civInfo", "core"})
@SourceDebugExtension(value={"SMAP\nTradeLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeLogic.kt\ncom/unciv/logic/trade/TradeLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n819#2:196\n847#2,2:197\n766#2:199\n857#2,2:200\n819#2:202\n847#2,2:203\n1747#2,3:205\n819#2:208\n847#2,2:209\n819#2:211\n847#2,2:212\n766#2:214\n857#2,2:215\n223#2,2:217\n1855#2,2:219\n1747#2,3:221\n1747#2,3:224\n*S KotlinDebug\n*F\n+ 1 TradeLogic.kt\ncom/unciv/logic/trade/TradeLogic\n*L\n42#1:196\n42#1:197,2\n43#1:199\n43#1:200,2\n60#1:202\n60#1:203,2\n165#1:205,3\n179#1:208\n179#1:209,2\n181#1:211\n181#1:212,2\n185#1:214\n185#1:215,2\n113#1:217,2\n118#1:219,2\n152#1:221,3\n153#1:224,3\n*E\n"})
public final class TradeLogic {
    @NotNull
    private final Civilization ourCivilization;
    @NotNull
    private final Civilization otherCivilization;
    @NotNull
    private final TradeOffersList ourAvailableOffers;
    @NotNull
    private final TradeOffersList theirAvailableOffers;
    @NotNull
    private final Trade currentTrade;

    public TradeLogic(@NotNull Civilization ourCivilization, @NotNull Civilization otherCivilization) {
        Intrinsics.checkNotNullParameter(ourCivilization, "ourCivilization");
        Intrinsics.checkNotNullParameter(otherCivilization, "otherCivilization");
        this.ourCivilization = ourCivilization;
        this.otherCivilization = otherCivilization;
        this.ourAvailableOffers = this.getAvailableOffers(this.ourCivilization, this.otherCivilization);
        this.theirAvailableOffers = this.getAvailableOffers(this.otherCivilization, this.ourCivilization);
        this.currentTrade = new Trade();
    }

    @NotNull
    public final Civilization getOurCivilization() {
        return this.ourCivilization;
    }

    @NotNull
    public final Civilization getOtherCivilization() {
        return this.otherCivilization;
    }

    @NotNull
    public final TradeOffersList getOurAvailableOffers() {
        return this.ourAvailableOffers;
    }

    @NotNull
    public final TradeOffersList getTheirAvailableOffers() {
        return this.theirAvailableOffers;
    }

    @NotNull
    public final Trade getCurrentTrade() {
        return this.currentTrade;
    }

    /*
     * WARNING - void declaration
     */
    private final TradeOffersList getAvailableOffers(Civilization civInfo, Civilization otherCivilization) {
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        TradeOffersList offers = new TradeOffersList();
        if (civInfo.isCityState() && otherCivilization.isCityState()) {
            return offers;
        }
        if (civInfo.isAtWarWith(otherCivilization)) {
            offers.add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, civInfo.getGameInfo().getSpeed(), 4, null));
        }
        DiplomacyManager diplomacyManager = otherCivilization.getDiplomacyManager(civInfo);
        Intrinsics.checkNotNull(diplomacyManager);
        if (!diplomacyManager.getHasOpenBorders() && !otherCivilization.isCityState() && Civilization.hasUnique$default(civInfo, UniqueType.EnablesOpenBorders, null, 2, null) && Civilization.hasUnique$default(otherCivilization, UniqueType.EnablesOpenBorders, null, 2, null)) {
            offers.add(new TradeOffer("Open Borders", TradeOfferType.Agreement, 0, civInfo.getGameInfo().getSpeed(), 4, null));
        }
        if (civInfo.getDiplomacyFunctions().canSignResearchAgreementNoCostWith(otherCivilization)) {
            offers.add(new TradeOffer("Research Agreement", TradeOfferType.Treaty, civInfo.getDiplomacyFunctions().getResearchAgreementCost(otherCivilization), civInfo.getGameInfo().getSpeed()));
        }
        if (civInfo.getDiplomacyFunctions().canSignDefensivePactWith(otherCivilization)) {
            offers.add(new TradeOffer("Defensive Pact", TradeOfferType.Treaty, 0, civInfo.getGameInfo().getSpeed(), 4, null));
        }
        Iterable iterable = civInfo.getPerTurnResourcesWithOriginsForTrade();
        boolean $i$f$filterNot = false;
        Iterator<Civilization> iterator2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (((ResourceSupplyList.ResourceSupply)it).getResource().getResourceType() == ResourceType.Bonus) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((ResourceSupplyList.ResourceSupply)it).getOrigin(), "Tradable")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ResourceSupplyList.ResourceSupply entry : (List)destination$iv$iv) {
            TradeOfferType resourceTradeOfferType = entry.getResource().getResourceType() == ResourceType.Luxury ? TradeOfferType.Luxury_Resource : TradeOfferType.Strategic_Resource;
            offers.add(new TradeOffer(entry.getResource().getName(), resourceTradeOfferType, entry.getAmount(), civInfo.getGameInfo().getSpeed()));
        }
        for (ResourceSupplyList.ResourceSupply entry : civInfo.getStockpiledResourcesForTrade()) {
            offers.add(new TradeOffer(entry.getResource().getName(), TradeOfferType.Stockpiled_Resource, entry.getAmount(), civInfo.getGameInfo().getSpeed()));
        }
        offers.add(new TradeOffer("Gold", TradeOfferType.Gold, civInfo.getGold(), civInfo.getGameInfo().getSpeed()));
        offers.add(new TradeOffer("Gold per turn", TradeOfferType.Gold_Per_Turn, (int)civInfo.getStats().getStatsForNextTurn().getGold(), civInfo.getGameInfo().getSpeed()));
        if (!(civInfo.isOneCityChallenger() || otherCivilization.isOneCityChallenger() || civInfo.isCityState() || otherCivilization.isCityState())) {
            $this$filterNot$iv = civInfo.getCities();
            $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (((City)it).isCapital() || ((City)it).isInResistance()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (City city2 : (List)destination$iv$iv) {
                offers.add(new TradeOffer(city2.getId(), TradeOfferType.City, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        Sequence<Civilization> otherCivsWeKnow2 = SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(otherCivilization){
            final /* synthetic */ Civilization $otherCivilization;
            {
                this.$otherCivilization = $otherCivilization;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it.getCivName(), this.$otherCivilization.getCivName()) && it.isMajorCiv() && !it.isDefeated();
            }
        });
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.TradeCivIntroductions, null, 2, null)) {
            Sequence<Civilization> civsWeKnowAndTheyDont2 = SequencesKt.filter(otherCivsWeKnow2, (Function1)new Function1<Civilization, Boolean>(otherCivilization){
                final /* synthetic */ Civilization $otherCivilization;
                {
                    this.$otherCivilization = $otherCivilization;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return !this.$otherCivilization.getDiplomacy().containsKey(it.getCivName()) && !it.isDefeated();
                }
            });
            Iterator<Civilization> $i$f$filterNot2 = civsWeKnowAndTheyDont2.iterator();
            while ($i$f$filterNot2.hasNext()) {
                Civilization thirdCiv = $i$f$filterNot2.next();
                offers.add(new TradeOffer(thirdCiv.getCivName(), TradeOfferType.Introduction, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        if (!(civInfo.isCityState() || otherCivilization.isCityState() || IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null))) {
            Sequence<Civilization> civsWeBothKnow2 = SequencesKt.filter(otherCivsWeKnow2, (Function1)new Function1<Civilization, Boolean>(otherCivilization){
                final /* synthetic */ Civilization $otherCivilization;
                {
                    this.$otherCivilization = $otherCivilization;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$otherCivilization.getDiplomacy().containsKey(it.getCivName());
                }
            });
            Sequence<Civilization> civsWeArentAtWarWith2 = SequencesKt.filter(civsWeBothKnow2, (Function1)new Function1<Civilization, Boolean>(civInfo){
                final /* synthetic */ Civilization $civInfo;
                {
                    this.$civInfo = $civInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    DiplomacyManager diplomacyManager = this.$civInfo.getDiplomacyManager(it);
                    Intrinsics.checkNotNull(diplomacyManager);
                    return diplomacyManager.canDeclareWar();
                }
            });
            iterator2 = civsWeArentAtWarWith2.iterator();
            while (iterator2.hasNext()) {
                Civilization thirdCiv = iterator2.next();
                offers.add(new TradeOffer(thirdCiv.getCivName(), TradeOfferType.WarDeclaration, 0, civInfo.getGameInfo().getSpeed(), 4, null));
            }
        }
        return offers;
    }

    /*
     * WARNING - void declaration
     */
    public final void acceptTrade(boolean applyGifts) {
        void $this$filterTo$iv$iv;
        TradeOffer it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable element$iv2;
        DiplomacyManager diplomacyManager;
        DiplomacyManager diplomacyManager2 = this.ourCivilization.getDiplomacyManager(this.otherCivilization);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager ourDiploManager = diplomacyManager2;
        DiplomacyManager diplomacyManager3 = this.otherCivilization.getDiplomacyManager(this.ourCivilization);
        Intrinsics.checkNotNull(diplomacyManager3);
        DiplomacyManager theirDiploManger = diplomacyManager3;
        DiplomacyManager $this$acceptTrade_u24lambda_u243 = diplomacyManager = ourDiploManager;
        boolean bl = false;
        $this$acceptTrade_u24lambda_u243.getTrades().add(this.currentTrade);
        $this$acceptTrade_u24lambda_u243.updateHasOpenBorders();
        DiplomacyManager $this$acceptTrade_u24lambda_u244 = diplomacyManager = theirDiploManger;
        boolean bl2 = false;
        $this$acceptTrade_u24lambda_u244.getTrades().add(this.currentTrade.reverse());
        $this$acceptTrade_u24lambda_u244.updateHasOpenBorders();
        if (applyGifts) {
            boolean bl3;
            block14: {
                Iterable $this$any$iv = this.currentTrade.getOurOffers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Iterable element$iv2 : $this$any$iv) {
                        TradeOffer it2 = (TradeOffer)((Object)element$iv2);
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it2.getName(), "Peace Treaty")) continue;
                        bl3 = true;
                        break block14;
                    }
                    bl3 = false;
                }
            }
            if (!bl3) {
                int theirGoldValueOfTrade;
                int ourGoldValueOfTrade = new TradeEvaluation().getTradeAcceptability(this.currentTrade, this.ourCivilization, this.otherCivilization, false);
                if (ourGoldValueOfTrade > (theirGoldValueOfTrade = new TradeEvaluation().getTradeAcceptability(this.currentTrade.reverse(), this.otherCivilization, this.ourCivilization, false))) {
                    boolean isPureGift = this.currentTrade.getOurOffers().isEmpty();
                    ourDiploManager.giftGold(ourGoldValueOfTrade - RangesKt.coerceAtLeast(theirGoldValueOfTrade, 0), isPureGift);
                } else if (theirGoldValueOfTrade > ourGoldValueOfTrade) {
                    boolean isPureGift = this.currentTrade.getTheirOffers().isEmpty();
                    theirDiploManger.giftGold(theirGoldValueOfTrade - RangesKt.coerceAtLeast(ourGoldValueOfTrade, 0), isPureGift);
                }
            }
        }
        Iterable $this$filterNot$iv = this.currentTrade.getTheirOffers();
        boolean $i$f$filterNot = false;
        element$iv2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (TradeOffer)element$iv$iv;
            boolean bl5 = false;
            if (it.getType() == TradeOfferType.Treaty) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TradeOffer offer : (List)destination$iv$iv) {
            TradeLogic.acceptTrade$transferTrade(this, this.otherCivilization, this.ourCivilization, offer);
        }
        $this$filterNot$iv = this.currentTrade.getOurOffers();
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (TradeOffer)element$iv$iv;
            boolean bl6 = false;
            if (it.getType() == TradeOfferType.Treaty) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TradeOffer offer : (List)destination$iv$iv) {
            TradeLogic.acceptTrade$transferTrade(this, this.ourCivilization, this.otherCivilization, offer);
        }
        Iterable $this$filter$iv = this.currentTrade.getTheirOffers();
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TradeOffer)element$iv$iv;
            boolean bl7 = false;
            if (!(it.getType() == TradeOfferType.Treaty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (TradeOffer offer : (List)destination$iv$iv) {
            TradeLogic.acceptTrade$transferTrade(this, this.otherCivilization, this.ourCivilization, offer);
        }
        this.ourCivilization.getCache().updateCivResources();
        this.ourCivilization.updateStatsForNextTurn();
        this.otherCivilization.getCache().updateCivResources();
        this.otherCivilization.updateStatsForNextTurn();
    }

    public static /* synthetic */ void acceptTrade$default(TradeLogic tradeLogic, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        tradeLogic.acceptTrade(bl);
    }

    /*
     * Unable to fully structure code
     */
    private static final void acceptTrade$transferTrade(TradeLogic this$0, Civilization from, Civilization to, TradeOffer offer) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                to.addGold(offer.getAmount());
                from.addGold(-offer.getAmount());
                break;
            }
            case 2: {
                TechManager.addTechnology$default(to.getTech(), offer.getName(), false, 2, null);
                break;
            }
            case 3: {
                $this$first$iv = from.getCities();
                $i$f$first = false;
                for (T element$iv : $this$first$iv) {
                    it = (City)element$iv;
                    $i$a$-first-TradeLogic$acceptTrade$transferTrade$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    ** GOTO lbl18
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl18:
                // 1 sources

                city = (City)element$iv;
                city.getEspionage().removeAllPresentSpies(SpyFleeReason.CityBought);
                city.moveToCiv(to);
                $this$first$iv = SequencesKt.toList(city.getCenterTile().getUnits());
                $i$f$forEach = false;
                var7_9 = $this$forEach$iv.iterator();
                while (var7_9.hasNext()) {
                    element$iv = var7_9.next();
                    it = (MapUnit)element$iv;
                    $i$a$-forEach-TradeLogic$acceptTrade$transferTrade$1 = false;
                    it.getMovement().teleportToClosestMoveableTile();
                }
                $this$forEach$iv = city.getTiles().iterator();
                while ($this$forEach$iv.hasNext()) {
                    tile = $this$forEach$iv.next();
                    for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
                        if (unit.getCiv().getDiplomacyFunctions().canPassThroughTiles(to) || unit.getCache().getCanEnterForeignTerrain()) continue;
                        unit.getMovement().teleportToClosestMoveableTile();
                    }
                }
                to.getCache().updateOurTiles();
                from.getCache().updateOurTiles();
                if (!to.isHuman() || Intrinsics.areEqual(city.getFoundingCiv(), "") || Intrinsics.areEqual(from.getCivName(), city.getFoundingCiv()) || Intrinsics.areEqual(to.getCivName(), city.getFoundingCiv())) break;
                to.getPopupAlerts().add(new PopupAlert(AlertType.CityTraded, city.getId()));
                break;
            }
            case 4: {
                if (Intrinsics.areEqual(offer.getName(), "Peace Treaty")) {
                    v0 = to.getDiplomacyManager(from);
                    Intrinsics.checkNotNull(v0);
                    v0.makePeace();
                }
                if (Intrinsics.areEqual(offer.getName(), "Research Agreement")) {
                    to.addGold(-offer.getAmount());
                    from.addGold(-offer.getAmount());
                    v1 = to.getDiplomacyManager(from);
                    Intrinsics.checkNotNull(v1);
                    v1.setFlag(DiplomacyFlags.ResearchAgreement, offer.getDuration());
                    v2 = from.getDiplomacyManager(to);
                    Intrinsics.checkNotNull(v2);
                    v2.setFlag(DiplomacyFlags.ResearchAgreement, offer.getDuration());
                }
                if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) break;
                v3 = to.getDiplomacyManager(from);
                Intrinsics.checkNotNull(v3);
                v3.signDefensivePact(offer.getDuration());
                break;
            }
            case 5: {
                DiplomacyFunctions.makeCivilizationsMeet$default(to.getDiplomacyFunctions(), to.getGameInfo().getCivilization(offer.getName()), false, 2, null);
                break;
            }
            case 6: {
                nameOfCivToDeclareWarOn = offer.getName();
                $this$any$iv = this$0.currentTrade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl75
                v4 = false;
                ** GOTO lbl82
lbl75:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$1 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false)) continue;
                    v4 = true;
                    ** GOTO lbl82
                }
                v4 = false;
lbl82:
                // 3 sources

                if (!v4) ** GOTO lbl-1000
                $this$any$iv = this$0.currentTrade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl88
                v5 = false;
                ** GOTO lbl95
lbl88:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeLogic$acceptTrade$transferTrade$warType$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), nameOfCivToDeclareWarOn) != false)) continue;
                    v5 = true;
                    ** GOTO lbl95
                }
                v5 = false;
lbl95:
                // 3 sources

                if (v5) {
                    v6 = WarType.TeamWar;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = WarType.JoinWar;
                }
                warType = v6;
                v7 = from.getDiplomacyManager(nameOfCivToDeclareWarOn);
                Intrinsics.checkNotNull(v7);
                v7.declareWar(new DeclareWarReason(warType, to));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

