/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models;

import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.stats.INamed;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\u0006\u0010/\u001a\u00020\u0000J\f\u00100\u001a\b\u0012\u0004\u0012\u00020.01J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020.012\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u00020\u0004J\u0006\u00108\u001a\u00020\u0004J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0004J\u0006\u0010<\u001a\u00020:J\u0006\u0010=\u001a\u00020:J\u0006\u0010>\u001a\u00020:J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020.012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040@H\u0002J$\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020\u00042\b\b\u0002\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u000106J&\u0010F\u001a\u00020:2\u0006\u0010B\u001a\u00020\u00042\b\b\u0002\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u000106H\u0002J\u000e\u0010G\u001a\u00020+2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\b\u0010I\u001a\u00020+H\u0002R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001cj\b\u0012\u0004\u0012\u00020\u0004`\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001cj\b\u0012\u0004\u0012\u00020\u0004`\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014\u00a8\u0006J"}, d2={"Lcom/unciv/models/Religion;", "Lcom/unciv/models/stats/INamed;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "name", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "foundingCivName", "(Ljava/lang/String;Lcom/unciv/logic/GameInfo;Ljava/lang/String;)V", "()V", "buildingsPurchasableByBeliefs", "", "getBuildingsPurchasableByBeliefs", "()Ljava/util/List;", "buildingsPurchasableByBeliefs$delegate", "Lkotlin/Lazy;", "displayName", "getDisplayName", "()Ljava/lang/String;", "setDisplayName", "(Ljava/lang/String;)V", "followerBeliefUniqueMap", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getFollowerBeliefUniqueMap", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "setFollowerBeliefUniqueMap", "(Lcom/unciv/models/ruleset/unique/UniqueMap;)V", "followerBeliefs", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "founderBeliefUniqueMap", "getFounderBeliefUniqueMap", "setFounderBeliefUniqueMap", "founderBeliefs", "getFoundingCivName", "setFoundingCivName", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "getName", "setName", "addBeliefs", "", "beliefs", "", "Lcom/unciv/models/ruleset/Belief;", "clone", "getAllBeliefsOrdered", "Lkotlin/sequences/Sequence;", "getBeliefs", "beliefType", "Lcom/unciv/models/ruleset/BeliefType;", "getFounder", "Lcom/unciv/logic/civilization/Civilization;", "getIconName", "getReligionDisplayName", "hasBelief", "", "belief", "isEnhancedReligion", "isMajorReligion", "isPantheon", "mapToExistingBeliefs", "", "matchesFilter", "filter", "state", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "civ", "matchesSingleFilter", "setTransients", "unlockedBuildingsPurchasable", "updateUniqueMaps", "core"})
public final class Religion
implements INamed,
IsPartOfGameInfoSerialization {
    public String name;
    @Nullable
    private String displayName;
    public String foundingCivName;
    @NotNull
    private HashSet<String> founderBeliefs;
    @NotNull
    private HashSet<String> followerBeliefs;
    @NotNull
    private transient UniqueMap founderBeliefUniqueMap;
    @NotNull
    private transient UniqueMap followerBeliefUniqueMap;
    public transient GameInfo gameInfo;
    @NotNull
    private final transient Lazy buildingsPurchasableByBeliefs$delegate;

    public Religion() {
        this.founderBeliefs = new HashSet();
        this.followerBeliefs = new HashSet();
        this.founderBeliefUniqueMap = new UniqueMap();
        this.followerBeliefUniqueMap = new UniqueMap();
        this.buildingsPurchasableByBeliefs$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ Religion this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return Religion.access$unlockedBuildingsPurchasable(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("name");
        return null;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@Nullable String string) {
        this.displayName = string;
    }

    @NotNull
    public final String getFoundingCivName() {
        String string = this.foundingCivName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("foundingCivName");
        return null;
    }

    public final void setFoundingCivName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.foundingCivName = string;
    }

    @NotNull
    public final UniqueMap getFounderBeliefUniqueMap() {
        return this.founderBeliefUniqueMap;
    }

    public final void setFounderBeliefUniqueMap(@NotNull UniqueMap uniqueMap2) {
        Intrinsics.checkNotNullParameter(uniqueMap2, "<set-?>");
        this.founderBeliefUniqueMap = uniqueMap2;
    }

    @NotNull
    public final UniqueMap getFollowerBeliefUniqueMap() {
        return this.followerBeliefUniqueMap;
    }

    public final void setFollowerBeliefUniqueMap(@NotNull UniqueMap uniqueMap2) {
        Intrinsics.checkNotNullParameter(uniqueMap2, "<set-?>");
        this.followerBeliefUniqueMap = uniqueMap2;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo != null) {
            return gameInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "<set-?>");
        this.gameInfo = gameInfo;
    }

    @NotNull
    public final List<String> getBuildingsPurchasableByBeliefs() {
        Lazy lazy = this.buildingsPurchasableByBeliefs$delegate;
        return (List)lazy.getValue();
    }

    public Religion(@NotNull String name2, @NotNull GameInfo gameInfo, @NotNull String foundingCivName) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(foundingCivName, "foundingCivName");
        this();
        this.setName(name2);
        this.setFoundingCivName(foundingCivName);
        this.setGameInfo(gameInfo);
    }

    @NotNull
    public final Religion clone() {
        Religion toReturn = new Religion(this.getName(), this.getGameInfo(), this.getFoundingCivName());
        toReturn.displayName = this.displayName;
        toReturn.founderBeliefs.addAll((Collection<String>)this.founderBeliefs);
        toReturn.followerBeliefs.addAll((Collection<String>)this.followerBeliefs);
        return toReturn;
    }

    public final void setTransients(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.setGameInfo(gameInfo);
        this.updateUniqueMaps();
    }

    private final void updateUniqueMaps() {
        this.followerBeliefUniqueMap = new UniqueMap(SequencesKt.flatMapIterable(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), updateUniqueMaps.1.INSTANCE));
        this.founderBeliefUniqueMap = new UniqueMap(SequencesKt.flatMapIterable(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), updateUniqueMaps.2.INSTANCE));
    }

    public final void addBeliefs(@NotNull Iterable<Belief> beliefs) {
        Intrinsics.checkNotNullParameter(beliefs, "beliefs");
        block4: for (Belief belief2 : beliefs) {
            switch (WhenMappings.$EnumSwitchMapping$0[belief2.getType().ordinal()]) {
                case 1: 
                case 2: {
                    this.founderBeliefs.add(belief2.getName());
                    continue block4;
                }
                case 3: 
                case 4: {
                    this.followerBeliefs.add(belief2.getName());
                    continue block4;
                }
            }
        }
        this.updateUniqueMaps();
    }

    @NotNull
    public final String getIconName() {
        return this.isPantheon() ? "Pantheon" : this.getName();
    }

    @NotNull
    public final String getReligionDisplayName() {
        String string;
        if (this.displayName != null) {
            String string2 = this.displayName;
            string = string2;
            Intrinsics.checkNotNull(string2);
        } else {
            string = this.getName();
        }
        return string;
    }

    private final Sequence<Belief> mapToExistingBeliefs(Set<String> beliefs) {
        LinkedHashMap<String, Belief> rulesetBeliefs = this.getGameInfo().getRuleset().getBeliefs();
        return SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)beliefs), (Function1)new Function1<String, Belief>(rulesetBeliefs){
            final /* synthetic */ LinkedHashMap<String, Belief> $rulesetBeliefs;
            {
                this.$rulesetBeliefs = $rulesetBeliefs;
                super(1);
            }

            @Nullable
            public final Belief invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$rulesetBeliefs.get(it);
            }
        });
    }

    @NotNull
    public final Sequence<Belief> getBeliefs(@NotNull BeliefType beliefType) {
        HashSet<String> hashSet;
        Intrinsics.checkNotNullParameter((Object)beliefType, "beliefType");
        if (beliefType == BeliefType.Any) {
            return this.mapToExistingBeliefs(CollectionsKt.toHashSet(SetsKt.plus((Set)this.founderBeliefs, (Iterable)this.followerBeliefs)));
        }
        if (beliefType.isFollower()) {
            hashSet = this.followerBeliefs;
        } else if (beliefType.isFounder()) {
            hashSet = this.founderBeliefs;
        } else {
            Intrinsics.checkNotNull(null);
            throw new KotlinNothingValueException();
        }
        HashSet<String> beliefs = hashSet;
        return SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)beliefs), (Function1)new Function1<Belief, Boolean>(beliefType){
            final /* synthetic */ BeliefType $beliefType;
            {
                this.$beliefType = $beliefType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Belief it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getType() == this.$beliefType;
            }
        });
    }

    @NotNull
    public final Sequence<Belief> getAllBeliefsOrdered() {
        return SequencesKt.plus(SequencesKt.plus(SequencesKt.plus(SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), getAllBeliefsOrdered.1.INSTANCE), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), getAllBeliefsOrdered.2.INSTANCE)), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.followerBeliefs), getAllBeliefsOrdered.3.INSTANCE)), SequencesKt.filter(this.mapToExistingBeliefs((Set<String>)this.founderBeliefs), getAllBeliefsOrdered.4.INSTANCE));
    }

    public final boolean hasBelief(@NotNull String belief2) {
        Intrinsics.checkNotNullParameter(belief2, "belief");
        return this.followerBeliefs.contains(belief2) || this.founderBeliefs.contains(belief2);
    }

    public final boolean isPantheon() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Pantheon)) && !this.isMajorReligion();
    }

    public final boolean isMajorReligion() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Founder));
    }

    public final boolean isEnhancedReligion() {
        return SequencesKt.any(this.getBeliefs(BeliefType.Enhancer));
    }

    @NotNull
    public final Civilization getFounder() {
        return this.getGameInfo().getCivilization(this.getFoundingCivName());
    }

    public final boolean matchesFilter(@NotNull String filter2, @NotNull StateForConditionals state, @Nullable Civilization civ) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(state, "state");
        return MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, new Function1<String, Boolean>(this, state, civ){
            final /* synthetic */ Religion this$0;
            final /* synthetic */ StateForConditionals $state;
            final /* synthetic */ Civilization $civ;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Religion.access$matchesSingleFilter(this.this$0, it, this.$state, this.$civ);
            }
        }, false, 4, null);
    }

    public static /* synthetic */ boolean matchesFilter$default(Religion religion, String string, StateForConditionals stateForConditionals, Civilization civilization, int n, Object object) {
        if ((n & 2) != 0) {
            stateForConditionals = StateForConditionals.Companion.getIgnoreConditionals();
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        return religion.matchesFilter(string, stateForConditionals, civilization);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchesSingleFilter(String filter2, StateForConditionals state, Civilization civ) {
        Civilization foundingCiv = this.getFounder();
        switch (filter2) {
            case "any": {
                return true;
            }
            case "major": {
                return this.isMajorReligion();
            }
            case "enhanced": {
                return this.isEnhancedReligion();
            }
            case "your": {
                return Intrinsics.areEqual(civ, foundingCiv);
            }
            case "foreign": {
                if (civ == null) return false;
                if (Intrinsics.areEqual(civ, foundingCiv)) return false;
                return true;
            }
            case "enemy": {
                if (civ == null) return false;
                if (!civ.knows(foundingCiv)) return false;
                boolean bl = true;
                boolean known2 = bl;
                if (!known2) return false;
                Civilization civilization = civ;
                Intrinsics.checkNotNull(civilization);
                if (!civilization.isAtWarWith(foundingCiv)) return false;
                return true;
            }
        }
        if (Intrinsics.areEqual(filter2, this.getName())) {
            return true;
        }
        if (SequencesKt.contains(SequencesKt.map(this.getBeliefs(BeliefType.Any), matchesSingleFilter.1.INSTANCE), filter2)) {
            return true;
        }
        if (this.founderBeliefUniqueMap.hasMatchingUnique(filter2, state)) {
            return true;
        }
        if (!this.followerBeliefUniqueMap.hasMatchingUnique(filter2, state)) return false;
        return true;
    }

    static /* synthetic */ boolean matchesSingleFilter$default(Religion religion, String string, StateForConditionals stateForConditionals, Civilization civilization, int n, Object object) {
        if ((n & 2) != 0) {
            stateForConditionals = StateForConditionals.Companion.getIgnoreConditionals();
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        return religion.matchesSingleFilter(string, stateForConditionals, civilization);
    }

    private final List<String> unlockedBuildingsPurchasable() {
        return SequencesKt.toList(SequencesKt.filter(SequencesKt.flatMap(this.getAllBeliefsOrdered(), unlockedBuildingsPurchasable.1.INSTANCE), (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ Religion this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.getGameInfo().getRuleset().getBuildings().containsKey(it);
            }
        }));
    }

    public static final /* synthetic */ boolean access$matchesSingleFilter(Religion $this, String filter2, StateForConditionals state, Civilization civ) {
        return $this.matchesSingleFilter(filter2, state, civ);
    }

    public static final /* synthetic */ List access$unlockedBuildingsPurchasable(Religion $this) {
        return $this.unlockedBuildingsPurchasable();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeliefType.values().length];
            try {
                nArray[BeliefType.Founder.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Enhancer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Pantheon.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeliefType.Follower.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

