/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.models.ruleset.RejectionReasonType;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/unciv/models/ruleset/RejectionReason;", "", "type", "Lcom/unciv/models/ruleset/RejectionReasonType;", "errorMessage", "", "shouldShow", "", "(Lcom/unciv/models/ruleset/RejectionReasonType;Ljava/lang/String;Z)V", "getErrorMessage", "()Ljava/lang/String;", "getShouldShow", "()Z", "getType", "()Lcom/unciv/models/ruleset/RejectionReasonType;", "getRejectionPrecedence", "", "hasAReasonToBeRemovedFromQueue", "isConstructionRejection", "isImportantRejection", "isNeverVisible", "techPolicyEraWonderRequirements", "Companion", "core"})
public final class RejectionReason {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RejectionReasonType type;
    @NotNull
    private final String errorMessage;
    private final boolean shouldShow;
    @NotNull
    private static final HashSet<RejectionReasonType> techPolicyEraWonderRequirements;
    @NotNull
    private static final HashSet<RejectionReasonType> reasonsToDefinitivelyRemoveFromQueue;
    @NotNull
    private static final List<RejectionReasonType> orderedImportantRejectionTypes;
    @NotNull
    private static final List<RejectionReasonType> constructionRejectionReasonType;
    @NotNull
    private static final List<RejectionReasonType> neverVisible;

    public RejectionReason(@NotNull RejectionReasonType type2, @NotNull String errorMessage2, boolean shouldShow) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(errorMessage2, "errorMessage");
        this.type = type2;
        this.errorMessage = errorMessage2;
        this.shouldShow = shouldShow;
    }

    public /* synthetic */ RejectionReason(RejectionReasonType rejectionReasonType, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = rejectionReasonType.getErrorMessage();
        }
        if ((n & 4) != 0) {
            bl = rejectionReasonType.getShouldShow();
        }
        this(rejectionReasonType, string, bl);
    }

    @NotNull
    public final RejectionReasonType getType() {
        return this.type;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final boolean getShouldShow() {
        return this.shouldShow;
    }

    public final boolean techPolicyEraWonderRequirements() {
        return techPolicyEraWonderRequirements.contains((Object)this.type);
    }

    public final boolean hasAReasonToBeRemovedFromQueue() {
        return reasonsToDefinitivelyRemoveFromQueue.contains((Object)this.type);
    }

    public final boolean isImportantRejection() {
        return orderedImportantRejectionTypes.contains((Object)this.type);
    }

    public final boolean isConstructionRejection() {
        return constructionRejectionReasonType.contains((Object)this.type);
    }

    public final boolean isNeverVisible() {
        return neverVisible.contains((Object)this.type);
    }

    public final int getRejectionPrecedence() {
        return orderedImportantRejectionTypes.indexOf((Object)this.type);
    }

    static {
        RejectionReasonType[] rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Obsoleted, RejectionReasonType.RequiresTech, RejectionReasonType.RequiresPolicy, RejectionReasonType.MorePolicyBranches, RejectionReasonType.RequiresBuildingInSomeCity};
        techPolicyEraWonderRequirements = SetsKt.hashSetOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Obsoleted, RejectionReasonType.WonderAlreadyBuilt, RejectionReasonType.NationalWonderAlreadyBuilt, RejectionReasonType.CannotBeBuiltWith, RejectionReasonType.MaxNumberBuildable};
        reasonsToDefinitivelyRemoveFromQueue = SetsKt.hashSetOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.ShouldNotBeDisplayed, RejectionReasonType.WonderBeingBuiltElsewhere, RejectionReasonType.RequiresBuildingInAllCities, RejectionReasonType.RequiresBuildingInThisCity, RejectionReasonType.RequiresBuildingInSomeCity, RejectionReasonType.RequiresBuildingInSomeCities, RejectionReasonType.CanOnlyBeBuiltInSpecificCities, RejectionReasonType.CannotBeBuiltUnhappiness, RejectionReasonType.PopulationRequirement, RejectionReasonType.ConsumesResources, RejectionReasonType.CanOnlyBePurchased, RejectionReasonType.MaxNumberBuildable, RejectionReasonType.NoPlaceToPutUnit};
        orderedImportantRejectionTypes = CollectionsKt.listOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.Unbuildable, RejectionReasonType.CannotBeBuiltUnhappiness, RejectionReasonType.CannotBeBuilt, RejectionReasonType.CanOnlyBeBuiltInSpecificCities};
        constructionRejectionReasonType = CollectionsKt.listOf(rejectionReasonTypeArray);
        rejectionReasonTypeArray = new RejectionReasonType[]{RejectionReasonType.AlreadyBuilt, RejectionReasonType.WonderAlreadyBuilt, RejectionReasonType.NationalWonderAlreadyBuilt, RejectionReasonType.DisabledBySetting, RejectionReasonType.UniqueToOtherNation, RejectionReasonType.ReplacedByOurUnique, RejectionReasonType.Obsoleted, RejectionReasonType.WonderBeingBuiltElsewhere, RejectionReasonType.RequiresTech, RejectionReasonType.NoSettlerForOneCityPlayers, RejectionReasonType.WaterUnitsInCoastalCities};
        neverVisible = CollectionsKt.listOf(rejectionReasonTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\tj\b\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/RejectionReason$Companion;", "", "()V", "constructionRejectionReasonType", "", "Lcom/unciv/models/ruleset/RejectionReasonType;", "neverVisible", "orderedImportantRejectionTypes", "reasonsToDefinitivelyRemoveFromQueue", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "techPolicyEraWonderRequirements", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

