/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.unique.UniqueTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/unciv/models/ruleset/RuinReward;", "Lcom/unciv/models/ruleset/RulesetObject;", "()V", "color", "", "getColor", "()Ljava/lang/String;", "excludedDifficulties", "", "getExcludedDifficulties", "()Ljava/util/List;", "notification", "getNotification", "weight", "", "getWeight", "()I", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "isUnavailableBySettings", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "makeLink", "core"})
public final class RuinReward
extends RulesetObject {
    @NotNull
    private final String notification;
    @NotNull
    private final List<String> excludedDifficulties = CollectionsKt.emptyList();
    private final int weight;
    @NotNull
    private final String color;

    public RuinReward() {
        this.notification = "";
        this.weight = 1;
        this.color = "";
    }

    @NotNull
    public final String getNotification() {
        return this.notification;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Ruins;
    }

    @NotNull
    public final List<String> getExcludedDifficulties() {
        return this.excludedDifficulties;
    }

    public final int getWeight() {
        return this.weight;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "";
    }

    @Override
    public boolean isUnavailableBySettings(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        return this.excludedDifficulties.contains(gameInfo.getDifficulty()) || super.isUnavailableBySettings(gameInfo);
    }
}

