/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.map.MapParameters;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J4\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000fj\b\u0012\u0004\u0012\u00020\u0002`\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0017J\u001c\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J*\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000fj\b\u0012\u0004\u0012\u00020\u0002`\u00102\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0003J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/unciv/models/ruleset/RulesetCache;", "Ljava/util/HashMap;", "", "Lcom/unciv/models/ruleset/Ruleset;", "Lkotlin/collections/HashMap;", "()V", "uniqueMisspellingThreshold", "", "getUniqueMisspellingThreshold", "()D", "setUniqueMisspellingThreshold", "(D)V", "checkCombinedModLinks", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "baseRuleset", "tryFixUnknownUniques", "", "getComplexRuleset", "parameters", "Lcom/unciv/logic/map/MapParameters;", "Lcom/unciv/models/metadata/GameParameters;", "extensionRulesets", "", "optionalBaseRuleset", "getSortedBaseRulesets", "", "getVanillaRuleset", "loadRulesets", "consoleMode", "noMods", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetCache.kt\ncom/unciv/models/ruleset/RulesetCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,189:1\n1747#2,3:190\n766#2:193\n857#2,2:194\n1549#2:196\n1620#2,3:197\n614#3:200\n*S KotlinDebug\n*F\n+ 1 RulesetCache.kt\ncom/unciv/models/ruleset/RulesetCache\n*L\n69#1:190,3\n98#1:193\n98#1:194,2\n99#1:196\n99#1:197,3\n152#1:200\n*E\n"})
public final class RulesetCache
extends HashMap<String, Ruleset> {
    @NotNull
    public static final RulesetCache INSTANCE = new RulesetCache();
    private static double uniqueMisspellingThreshold = 0.15;

    private RulesetCache() {
    }

    public final double getUniqueMisspellingThreshold() {
        return uniqueMisspellingThreshold;
    }

    public final void setUniqueMisspellingThreshold(double d) {
        uniqueMisspellingThreshold = d;
    }

    @NotNull
    public final List<String> loadRulesets(boolean consoleMode, boolean noMods) {
        Object[] $this$loadRulesets_u24lambda_u240;
        HashMap newRulesets = new HashMap();
        for (BaseRuleset ruleset2 : BaseRuleset.getEntries()) {
            Object[] objectArray;
            String fileName = "jsons/" + ruleset2.getFullName();
            FileHandle fileHandle = consoleMode ? new FileHandle(fileName) : Gdx.files.internal(fileName);
            Map map2 = newRulesets;
            String string = ruleset2.getFullName();
            $this$loadRulesets_u24lambda_u240 = objectArray = new Ruleset();
            boolean bl = false;
            $this$loadRulesets_u24lambda_u240.setName(ruleset2.getFullName());
            Intrinsics.checkNotNull(fileHandle);
            $this$loadRulesets_u24lambda_u240.load(fileHandle);
            map2.put(string, objectArray);
        }
        this.putAll(newRulesets);
        ArrayList errorLines = new ArrayList();
        if (!noMods) {
            FileHandle[] modsHandles = consoleMode ? new FileHandle("mods").list() : UncivGame.Companion.getCurrent().getFiles().getModsFolder().list();
            Intrinsics.checkNotNull(modsHandles);
            for (FileHandle modFolder : modsHandles) {
                String string = modFolder.name();
                Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                if (StringsKt.startsWith$default((CharSequence)string, '.', false, 2, null) || !modFolder.isDirectory()) continue;
                try {
                    boolean bl;
                    Function1 logFilter2;
                    RulesetErrorList modLinksErrors;
                    block10: {
                        Ruleset modRuleset = new Ruleset();
                        String string2 = modFolder.name();
                        Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
                        modRuleset.setName(string2);
                        FileHandle fileHandle = modFolder.child("jsons");
                        Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
                        modRuleset.load(fileHandle);
                        modRuleset.setFolderLocation(modFolder);
                        ((Map)newRulesets).put(modRuleset.getName(), modRuleset);
                        $this$loadRulesets_u24lambda_u240 = new Object[]{modRuleset.getName()};
                        LogKt.debug("Mod loaded successfully: %s", $this$loadRulesets_u24lambda_u240);
                        if (!Log.shouldLog$default(Log.INSTANCE, null, 1, null)) continue;
                        modLinksErrors = Ruleset.getErrorList$default(modRuleset, false, 1, null);
                        logFilter2 = modRuleset.getModOptions().isBaseRuleset() ? (Function1)loadRulesets.logFilter.1.INSTANCE : (Function1)loadRulesets.logFilter.2.INSTANCE;
                        Iterable $this$any$iv = modLinksErrors;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                if (!((Boolean)logFilter2.invoke(element$iv)).booleanValue()) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    Object[] objectArray = new Object[]{modLinksErrors.getErrorText(logFilter2)};
                    LogKt.debug("checkModLinks errors: %s", objectArray);
                }
                catch (Exception ex) {
                    ((Collection)errorLines).add("Exception loading mod '" + modFolder.name() + "':");
                    ((Collection)errorLines).add("  " + ex.getLocalizedMessage());
                    Collection collection = errorLines;
                    Throwable throwable = ex.getCause();
                    collection.add("  " + (throwable != null ? throwable.getLocalizedMessage() : null));
                }
            }
            if (Log.shouldLog$default(Log.INSTANCE, null, 1, null)) {
                for (String line : errorLines) {
                    Intrinsics.checkNotNull(line);
                    LogKt.debug(line, new Object[0]);
                }
            }
        }
        this.clear();
        this.putAll(newRulesets);
        return errorLines;
    }

    public static /* synthetic */ List loadRulesets$default(RulesetCache rulesetCache, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return rulesetCache.loadRulesets(bl, bl2);
    }

    @NotNull
    public final Ruleset getVanillaRuleset() {
        Object object = this.get((Object)BaseRuleset.Civ_V_Vanilla.getFullName());
        Intrinsics.checkNotNull(object);
        return ((Ruleset)object).clone();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getSortedBaseRulesets() {
        void $this$mapTo$iv$iv;
        Ruleset it;
        Iterable $this$filterTo$iv$iv;
        Collection<Ruleset> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Ruleset)element$iv$iv;
            boolean bl = false;
            if (!it.getModOptions().isBaseRuleset()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Ruleset)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        List<String> baseRulesets = CollectionsKt.distinct((List)destination$iv$iv);
        if (baseRulesets.size() < 2) {
            return baseRulesets;
        }
        Function1[] function1Array = new Function1[]{getSortedBaseRulesets.1.INSTANCE, getSortedBaseRulesets.2.INSTANCE};
        return CollectionsKt.sortedWith((Iterable)baseRulesets, ComparisonsKt.compareBy(function1Array));
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull MapParameters parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        return this.getComplexRuleset(parameters2.getMods(), parameters2.getBaseRuleset());
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull GameParameters parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        return this.getComplexRuleset(parameters2.getMods(), parameters2.getBaseRuleset());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Ruleset getComplexRuleset(@NotNull LinkedHashSet<String> mods, @Nullable String optionalBaseRuleset) {
        Intrinsics.checkNotNullParameter(mods, "mods");
        if (!((Map)this).containsKey(optionalBaseRuleset)) ** GOTO lbl-1000
        v0 = ((Map)this).get(optionalBaseRuleset);
        Intrinsics.checkNotNull(v0);
        if (((Ruleset)v0).getModOptions().isBaseRuleset()) {
            v1 = ((Map)this).get(optionalBaseRuleset);
            Intrinsics.checkNotNull(v1);
            v2 = (Ruleset)v1;
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.getVanillaRuleset();
        }
        baseRuleset = v2;
        loadedMods = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)mods), getComplexRuleset.loadedMods.1.INSTANCE), (Function1)new Function1<String, Ruleset>(this){
            final /* synthetic */ RulesetCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Ruleset invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Object object = this.this$0.get((Object)it);
                Intrinsics.checkNotNull(object);
                return (Ruleset)object;
            }
        }), getComplexRuleset.loadedMods.3.INSTANCE);
        return this.getComplexRuleset(baseRuleset, SequencesKt.asIterable(loadedMods));
    }

    public static /* synthetic */ Ruleset getComplexRuleset$default(RulesetCache rulesetCache, LinkedHashSet linkedHashSet, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return rulesetCache.getComplexRuleset(linkedHashSet, string);
    }

    @NotNull
    public final Ruleset getComplexRuleset(@NotNull Ruleset baseRuleset, @NotNull Iterable<Ruleset> extensionRulesets) {
        Sequence<Ruleset> loadedMods2;
        Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
        Intrinsics.checkNotNullParameter(extensionRulesets, "extensionRulesets");
        Ruleset newRuleset = new Ruleset();
        Sequence<Ruleset> $this$sortedByDescending$iv = loadedMods2 = SequencesKt.plus(CollectionsKt.asSequence(extensionRulesets), baseRuleset);
        boolean $i$f$sortedByDescending = false;
        Iterator<Ruleset> iterator2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Ruleset it = (Ruleset)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getModOptions().isBaseRuleset());
                it = (Ruleset)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getModOptions().isBaseRuleset());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Ruleset mod = iterator2.next();
            if (mod.getModOptions().isBaseRuleset()) {
                newRuleset.getModOptions().setUniques(new ArrayList<String>());
                newRuleset.getModOptions().setBaseRuleset(true);
                newRuleset.getModOptions().setTileset(mod.getModOptions().getTileset());
                newRuleset.getModOptions().setUnitset(mod.getModOptions().getUnitset());
            }
            newRuleset.add(mod);
            ((Collection)newRuleset.getMods()).add(mod.getName());
        }
        newRuleset.updateBuildingCosts$core();
        newRuleset.updateResourceTransients$core();
        return newRuleset;
    }

    @NotNull
    public final RulesetErrorList checkCombinedModLinks(@NotNull LinkedHashSet<String> mods, @Nullable String baseRuleset, boolean tryFixUnknownUniques) {
        RulesetErrorList rulesetErrorList;
        Intrinsics.checkNotNullParameter(mods, "mods");
        try {
            Ruleset newRuleset = this.getComplexRuleset(mods, baseRuleset);
            newRuleset.getModOptions().setBaseRuleset(true);
            rulesetErrorList = newRuleset.getErrorList(tryFixUnknownUniques);
        }
        catch (UncivShowableException ex) {
            rulesetErrorList = RulesetErrorList.Companion.of$default(RulesetErrorList.Companion, ex.getMessage(), RulesetErrorSeverity.Error, null, null, null, 28, null);
        }
        return rulesetErrorList;
    }

    public static /* synthetic */ RulesetErrorList checkCombinedModLinks$default(RulesetCache rulesetCache, LinkedHashSet linkedHashSet, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return rulesetCache.checkCombinedModLinks(linkedHashSet, string, bl);
    }
}

