/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unique.expressions.Expressions;
import com.unciv.models.ruleset.unique.expressions.Operator;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00018B+\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH&\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010'\u001a\u0004\u0018\u00010!*\u00020(2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0004R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00108\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nj\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7\u00a8\u00069"}, d2={"Lcom/unciv/models/ruleset/unique/Countables;", "", "text", "", "shortDocumentation", "documentationStrings", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "documentationHeader", "getDocumentationHeader", "()Ljava/lang/String;", "getDocumentationStrings", "()Ljava/util/List;", "example", "getExample", "matchesWithRuleset", "", "getMatchesWithRuleset", "()Z", "noPlaceholders", "getNoPlaceholders", "placeholderText", "getPlaceholderText", "getText", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getDeprecationAnnotation", "Lkotlin/Deprecated;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "matches", "getTranslatedErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueParameterType;", "Integer", "Turns", "Year", "Cities", "Units", "Stats", "PolicyBranches", "FilteredCities", "FilteredUnits", "FilteredBuildings", "RemainingCivs", "OwnedTiles", "TileResources", "CityStates", "Expression", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,269:1\n1549#2:270\n1620#2,3:271\n37#3,2:274\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables\n*L\n224#1:270\n224#1:271,3\n225#1:274,2\n*E\n"})
public abstract class Countables
extends Enum<Countables> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String text;
    @NotNull
    private final String shortDocumentation;
    @NotNull
    private final List<String> documentationStrings;
    @NotNull
    private final String placeholderText;
    private final boolean matchesWithRuleset;
    @VisibleForTesting
    private final boolean noPlaceholders;
    @NotNull
    private static final Map<Ruleset, Set<String>> autocompleteCache;
    public static final /* enum */ Countables Integer;
    public static final /* enum */ Countables Turns;
    public static final /* enum */ Countables Year;
    public static final /* enum */ Countables Cities;
    public static final /* enum */ Countables Units;
    public static final /* enum */ Countables Stats;
    public static final /* enum */ Countables PolicyBranches;
    public static final /* enum */ Countables FilteredCities;
    public static final /* enum */ Countables FilteredUnits;
    public static final /* enum */ Countables FilteredBuildings;
    public static final /* enum */ Countables RemainingCivs;
    public static final /* enum */ Countables OwnedTiles;
    public static final /* enum */ Countables TileResources;
    @Deprecated(message="because it was never actually supported", replaceWith=@ReplaceWith(expression="Remaining [City-State] Civilizations", imports={}), level=DeprecationLevel.ERROR)
    public static final /* enum */ Countables CityStates;
    public static final /* enum */ Countables Expression;
    private static final /* synthetic */ Countables[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Countables(String text2, String shortDocumentation, List<String> documentationStrings2) {
        this.text = text2;
        this.shortDocumentation = shortDocumentation;
        this.documentationStrings = documentationStrings2;
        this.placeholderText = TranslationsKt.getPlaceholderText(this.text);
        this.noPlaceholders = !StringsKt.contains$default((CharSequence)this.text, '[', false, 2, null);
    }

    /* synthetic */ Countables(String string, int n, String string2, String string3, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        if ((n2 & 2) != 0) {
            string3 = "";
        }
        if ((n2 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string2, string3, list2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public List<String> getDocumentationStrings() {
        return this.documentationStrings;
    }

    @NotNull
    public final String getPlaceholderText() {
        return this.placeholderText;
    }

    public boolean getMatchesWithRuleset() {
        return this.matchesWithRuleset;
    }

    public boolean getNoPlaceholders() {
        return this.noPlaceholders;
    }

    public boolean matches(@NotNull String parameterText) {
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        return this.getNoPlaceholders() ? Intrinsics.areEqual(parameterText, this.text) : TranslationsKt.equalsPlaceholderText(parameterText, this.placeholderText);
    }

    @NotNull
    public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return SetsKt.setOf(this.text);
    }

    public boolean matches(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return false;
    }

    @Nullable
    public abstract java.lang.Integer eval(@NotNull String var1, @NotNull StateForConditionals var2);

    @NotNull
    public String getDocumentationHeader() {
        return '`' + this.text + '`' + (((CharSequence)this.shortDocumentation).length() == 0 ? "" : " - " + this.shortDocumentation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getExample() {
        void $this$mapTo$iv$iv;
        if (this.getNoPlaceholders()) {
            return this.text;
        }
        Iterable $this$map$iv = TranslationsKt.getPlaceholderParameters(this.text);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UniqueParameterType.Companion.safeValueOf((String)it).getDocExample());
        }
        List placeholderParams = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = placeholderParams;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return TranslationsKt.fillPlaceholders(this.text, Arrays.copyOf(stringArray, stringArray.length));
    }

    @Nullable
    public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return null;
    }

    @Nullable
    public final Deprecated getDeprecationAnnotation() {
        Class clazz = ((Enum)this).getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "getDeclaringClass(...)");
        return clazz.getField(this.name()).getAnnotation(Deprecated.class);
    }

    @Nullable
    protected final UniqueType.UniqueParameterErrorSeverity getTranslatedErrorSeverity(@NotNull UniqueParameterType $this$getTranslatedErrorSeverity, @NotNull String parameterText, @NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter((Object)$this$getTranslatedErrorSeverity, "<this>");
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return $this$getTranslatedErrorSeverity.getErrorSeverity(CollectionsKt.first(TranslationsKt.getPlaceholderParameters(parameterText)), ruleset2);
    }

    public static Countables[] values() {
        return (Countables[])$VALUES.clone();
    }

    public static Countables valueOf(String value) {
        return Enum.valueOf(Countables.class, value);
    }

    @NotNull
    public static EnumEntries<Countables> getEntries() {
        return $ENTRIES;
    }

    static {
        Integer = new Integer("Integer", 0);
        Turns = new Turns("Turns", 1);
        Year = new Year("Year", 2);
        Cities = new Cities("Cities", 3);
        Units = new Units("Units", 4);
        Stats = new Stats("Stats", 5);
        PolicyBranches = new PolicyBranches("PolicyBranches", 6);
        FilteredCities = new FilteredCities("FilteredCities", 7);
        FilteredUnits = new FilteredUnits("FilteredUnits", 8);
        FilteredBuildings = new FilteredBuildings("FilteredBuildings", 9);
        RemainingCivs = new RemainingCivs("RemainingCivs", 10);
        OwnedTiles = new OwnedTiles("OwnedTiles", 11);
        TileResources = new TileResources("TileResources", 12);
        CityStates = new CityStates("CityStates", 13);
        Expression = new Expression("Expression", 14);
        $VALUES = countablesArray = new Countables[]{Countables.Integer, Countables.Turns, Countables.Year, Countables.Cities, Countables.Units, Countables.Stats, Countables.PolicyBranches, Countables.FilteredCities, Countables.FilteredUnits, Countables.FilteredBuildings, Countables.RemainingCivs, Countables.OwnedTiles, Countables.TileResources, Countables.CityStates, Countables.Expression};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        autocompleteCache = new LinkedHashMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Cities;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    static final class Cities
    extends Countables {
        /*
         * WARNING - void declaration
         */
        Cities() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            Object object = stateForConditionals.getCivInfo();
            return object != null && (object = ((Civilization)object).getCities()) != null ? java.lang.Integer.valueOf(object.size()) : null;
        }
    }

    @Deprecated(message="because it was never actually supported", replaceWith=@ReplaceWith(expression="Remaining [City-State] Civilizations", imports={}), level=DeprecationLevel.ERROR)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$CityStates;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$CityStates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1774#2,4:270\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$CityStates\n*L\n166#1:270,4\n*E\n"})
    static final class CityStates
    extends Countables {
        /*
         * WARNING - void declaration
         */
        CityStates() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            int n;
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            Object object = stateForConditionals.getGameInfo();
            if (object == null || (object = ((GameInfo)object).getCivilizations()) == null) {
                return null;
            }
            Object civilizations = object;
            Iterable $this$count$iv = (Iterable)civilizations;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    if (!(it.isAlive() && it.isCityState()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Companion;", "", "()V", "autocompleteCache", "", "Lcom/unciv/models/ruleset/Ruleset;", "", "", "getCountableAmount", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "getKnownValuesForAutocomplete", "getMatching", "Lcom/unciv/models/ruleset/unique/Countables;", "isKnownValue", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,269:1\n288#2,2:270\n1789#2,3:275\n372#3,3:272\n375#3,4:278\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$Companion\n*L\n238#1:270,2\n257#1:275,3\n256#1:272,3\n256#1:278,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Countables getMatching(@NotNull String parameterText, @Nullable Ruleset ruleset2) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter(parameterText, "parameterText");
                Iterable $this$firstOrNull$iv = Countables.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Countables it = (Countables)((Object)element$iv);
                    boolean bl = false;
                    boolean bl2 = it.getMatchesWithRuleset() ? ruleset2 != null && it.matches(parameterText, ruleset2) : it.matches(parameterText);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        @Nullable
        public final java.lang.Integer getCountableAmount(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            GameInfo gameInfo = stateForConditionals.getGameInfo();
            Ruleset ruleset2 = gameInfo != null ? gameInfo.getRuleset() : null;
            Countables countables = this.getMatching(parameterText, ruleset2);
            if (countables == null) {
                return null;
            }
            Countables countable = countables;
            java.lang.Integer n = countable.eval(parameterText, stateForConditionals);
            if (n == null) {
                return null;
            }
            int potentialResult = n;
            return potentialResult;
        }

        public final boolean isKnownValue(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getMatching(parameterText, ruleset2) != null;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Object v;
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Map $this$getOrPut$iv = autocompleteCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(ruleset2);
            if (value$iv == null) {
                void $this$fold$iv;
                void initial$iv;
                boolean bl = false;
                Iterable iterable = Countables.getEntries();
                Set set2 = SetsKt.emptySet();
                boolean $i$f$fold = false;
                Set accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void next;
                    Countables countables = (Countables)((Object)element$iv);
                    void acc = accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = SetsKt.plus(acc, (Iterable)next.getKnownValuesForAutocomplete(ruleset2));
                }
                void answer$iv = accumulator$iv;
                $this$getOrPut$iv.put(ruleset2, answer$iv);
                v = answer$iv;
            } else {
                v = value$iv;
            }
            return (Set)v;
        }

        @Nullable
        public final UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Countables countables = this.getMatching(parameterText, ruleset2);
            if (countables == null) {
                return UniqueType.UniqueParameterErrorSeverity.RulesetSpecific;
            }
            Countables countable = countables;
            return countable.getErrorSeverity(parameterText, ruleset2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Expression;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationHeader", "", "getDocumentationHeader", "()Ljava/lang/String;", "documentationStrings", "", "getDocumentationStrings", "()Ljava/util/List;", "engine", "Lcom/unciv/models/ruleset/unique/expressions/Expressions;", "example", "getExample", "matchesWithRuleset", "", "getMatchesWithRuleset", "()Z", "noPlaceholders", "getNoPlaceholders", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "matches", "core"})
    static final class Expression
    extends Countables {
        private final boolean noPlaceholders;
        @NotNull
        private final Expressions engine = new Expressions();
        private final boolean matchesWithRuleset;
        @NotNull
        private final String example;
        @NotNull
        private final String documentationHeader;
        @NotNull
        private final List<String> documentationStrings;

        /*
         * WARNING - void declaration
         */
        Expression() {
            void var1_1;
            this.matchesWithRuleset = true;
            this.example = "[Iron] + 2";
            this.documentationHeader = "Evaluate expressions!";
            String[] stringArray = new String[]{"Expressions support arbitrary math operations, and can include other countables, when surrounded by square brackets.", "For example, since `Cities` is a countable, and `[Melee] units` is a countable, you can have something like: `([[Melee] units] + 1) / [Cities]` (the whitespace is optional but helps readability)", "Since on translation, the brackets are removed, the expression will be displayed as `(Melee units + 1) / Cities`", "Supported operations between 2 values are: " + CollectionsKt.joinToString$default(Operator.BinaryOperators.getEntries(), null, null, null, 0, null, documentationStrings.1.INSTANCE, 31, null), "Supported operations on 1 value are: " + CollectionsKt.joinToString$default(Operator.UnaryOperators.getEntries(), null, null, null, 0, null, documentationStrings.2.INSTANCE, 31, null)};
            this.documentationStrings = CollectionsKt.listOf(stringArray);
        }

        @Override
        public boolean getNoPlaceholders() {
            return this.noPlaceholders;
        }

        @Override
        public boolean getMatchesWithRuleset() {
            return this.matchesWithRuleset;
        }

        @Override
        public boolean matches(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.engine.matches(parameterText, ruleset2);
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            return this.engine.eval(parameterText, stateForConditionals);
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.engine.getErrorSeverity(parameterText, ruleset2);
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return SetsKt.emptySet();
        }

        @Override
        @NotNull
        public String getExample() {
            return this.example;
        }

        @Override
        @NotNull
        public String getDocumentationHeader() {
            return this.documentationHeader;
        }

        @Override
        @NotNull
        public List<String> getDocumentationStrings() {
            return this.documentationStrings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$FilteredBuildings;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredBuildings\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,269:1\n1268#2,3:270\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredBuildings\n*L\n115#1:270,3\n*E\n"})
    static final class FilteredBuildings
    extends Countables {
        /*
         * WARNING - void declaration
         */
        FilteredBuildings() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            String filter2 = TranslationsKt.getPlaceholderParameters(parameterText).get(0);
            Object object = stateForConditionals.getCivInfo();
            if (object == null || (object = ((Civilization)object).getCities()) == null) {
                return null;
            }
            Object cities = object;
            Iterable iterable = (Iterable)cities;
            int n = 0;
            for (Object t : iterable) {
                void city2;
                City city3 = (City)t;
                int n2 = n;
                boolean bl = false;
                Sequence<Building> $this$count$iv = city2.getCityConstructions().getBuiltBuildings();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Building> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Building element$iv;
                    Building it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Building.matchesFilter$default(it, filter2, null, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n3 = count$iv;
                n = n2 + n3;
            }
            return n;
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getTranslatedErrorSeverity(UniqueParameterType.BuildingFilter, parameterText, ruleset2);
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$FilteredCities;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredCities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1774#2,4:270\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredCities\n*L\n92#1:270,4\n*E\n"})
    static final class FilteredCities
    extends Countables {
        /*
         * WARNING - void declaration
         */
        FilteredCities() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            int n;
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            String filter2 = TranslationsKt.getPlaceholderParameters(parameterText).get(0);
            Object object = stateForConditionals.getCivInfo();
            if (object == null || (object = ((Civilization)object).getCities()) == null) {
                return null;
            }
            Object cities = object;
            Iterable $this$count$iv = (Iterable)cities;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    City it = (City)element$iv;
                    boolean bl = false;
                    if (!City.matchesFilter$default(it, filter2, null, false, 6, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n;
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getTranslatedErrorSeverity(UniqueParameterType.CityFilter, parameterText, ruleset2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$FilteredUnits;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredUnits\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1268#2,3:270\n1620#3,3:273\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$FilteredUnits\n*L\n102#1:270,3\n107#1:273,3\n*E\n"})
    static final class FilteredUnits
    extends Countables {
        /*
         * WARNING - void declaration
         */
        FilteredUnits() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            String filter2 = TranslationsKt.getPlaceholderParameters(parameterText).get(0);
            Object object = stateForConditionals.getCivInfo();
            if (object == null || (object = ((Civilization)object).getUnits()) == null) {
                return null;
            }
            Object unitManager = object;
            Sequence<MapUnit> $this$count$iv = ((UnitManager)unitManager).getCivUnits();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!MapUnit.matchesFilter$default(it, filter2, false, 2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            return count$iv;
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getTranslatedErrorSeverity(UniqueParameterType.MapUnitFilter, parameterText, ruleset2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            void var3_3;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Set<String> set2 = ruleset2.getUnitTypes().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            Set<String> set3 = ruleset2.getUnits().keySet();
            Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
            Iterable iterable = SetsKt.plus(set2, (Iterable)set3);
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add('[' + (String)it + "] Units");
            }
            return (Set)var3_3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Integer;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationHeader", "", "getDocumentationHeader", "()Ljava/lang/String;", "example", "getExample", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "matches", "", "core"})
    static final class Integer
    extends Countables {
        @NotNull
        private final String documentationHeader;
        @NotNull
        private final String example;

        /*
         * WARNING - void declaration
         */
        Integer() {
            void var1_1;
            this.documentationHeader = "Integer constant - any positive or negative integer number";
            this.example = "123";
        }

        @Override
        @NotNull
        public String getDocumentationHeader() {
            return this.documentationHeader;
        }

        @Override
        public boolean matches(@NotNull String parameterText) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            return StringsKt.toIntOrNull(parameterText) != null;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            return StringsKt.toIntOrNull(parameterText);
        }

        @Override
        @NotNull
        public String getExample() {
            return this.example;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$OwnedTiles;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$OwnedTiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,269:1\n1#2:270\n1268#3,3:271\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$OwnedTiles\n*L\n138#1:271,3\n*E\n"})
    static final class OwnedTiles
    extends Countables {
        /*
         * WARNING - void declaration
         */
        OwnedTiles() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            String filter2 = TranslationsKt.getPlaceholderParameters(parameterText).get(0);
            Object object = stateForConditionals.getCivInfo();
            if (object == null || (object = ((Civilization)object).getCities()) == null) {
                return null;
            }
            Object cities = object;
            Iterable iterable = (Iterable)cities;
            int n = 0;
            for (Object t : iterable) {
                void city2;
                City city3 = (City)t;
                int n2 = n;
                boolean bl = false;
                Sequence<Tile> $this$count$iv = city2.getTiles();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Tile.matchesFilter$default(it, filter2, null, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n3 = count$iv;
                n = n2 + n3;
            }
            return n;
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getTranslatedErrorSeverity(UniqueParameterType.TileFilter, parameterText, ruleset2);
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$PolicyBranches;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    static final class PolicyBranches
    extends Countables {
        /*
         * WARNING - void declaration
         */
        PolicyBranches() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            Civilization civilization = stateForConditionals.getCivInfo();
            return civilization != null ? java.lang.Integer.valueOf(civilization.getCompletedPolicyBranchesCount()) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$RemainingCivs;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getErrorSeverity", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getKnownValuesForAutocomplete", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$RemainingCivs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1774#2,4:270\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$RemainingCivs\n*L\n127#1:270,4\n*E\n"})
    static final class RemainingCivs
    extends Countables {
        /*
         * WARNING - void declaration
         */
        RemainingCivs() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            int n;
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            String filter2 = TranslationsKt.getPlaceholderParameters(parameterText).get(0);
            Object object = stateForConditionals.getGameInfo();
            if (object == null || (object = ((GameInfo)object).getCivilizations()) == null) {
                return null;
            }
            Object civilizations = object;
            Iterable $this$count$iv = (Iterable)civilizations;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    if (!(it.isAlive() && Civilization.matchesFilter$default(it, filter2, null, false, 6, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n;
        }

        @Override
        @Nullable
        public UniqueType.UniqueParameterErrorSeverity getErrorSeverity(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return this.getTranslatedErrorSeverity(UniqueParameterType.CivFilter, parameterText, ruleset2);
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0012\u0010\u0018\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Stats;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationHeader", "", "getDocumentationHeader", "()Ljava/lang/String;", "documentationStrings", "", "getDocumentationStrings", "()Ljava/util/List;", "example", "getExample", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getKnownValuesForAutocomplete", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "matches", "", "niceJoin", "", "core"})
    static final class Stats
    extends Countables {
        @NotNull
        private final String documentationHeader = "Stat name (" + this.niceJoin((Iterable<String>)Stat.Companion.names()) + ')';
        @NotNull
        private final List<String> documentationStrings = CollectionsKt.listOf("Gets the stat *reserve*, not the amount per turn (can be city stats or civilization stats, depending on where the unique is used)");
        @NotNull
        private final String example;

        /*
         * WARNING - void declaration
         */
        Stats() {
            void var1_1;
            this.example = "Science";
        }

        @Override
        @NotNull
        public String getDocumentationHeader() {
            return this.documentationHeader;
        }

        @Override
        @NotNull
        public List<String> getDocumentationStrings() {
            return this.documentationStrings;
        }

        @Override
        public boolean matches(@NotNull String parameterText) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            return Stat.Companion.isStat(parameterText);
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            Stat stat = Stat.Companion.safeValueOf(parameterText);
            if (stat == null) {
                return null;
            }
            Stat relevantStat = stat;
            if (relevantStat == Stat.Happiness) {
                Civilization civilization = stateForConditionals.getCivInfo();
                return civilization != null ? java.lang.Integer.valueOf(civilization.getHappiness()) : null;
            }
            return stateForConditionals.getStatAmount(relevantStat);
        }

        @Override
        @NotNull
        public String getExample() {
            return this.example;
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return Stat.Companion.names();
        }

        private final String niceJoin(Iterable<String> $this$niceJoin) {
            String $this$niceJoin_u24lambda_u240 = CollectionsKt.joinToString$default($this$niceJoin, "`, `", "`", "`", 0, null, null, 56, null);
            boolean bl = false;
            int index = StringsKt.lastIndexOf$default((CharSequence)$this$niceJoin_u24lambda_u240, "`, `", 0, false, 6, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string = $this$niceJoin_u24lambda_u240.substring(0, index);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append("` or `");
            String string2 = $this$niceJoin_u24lambda_u240.substring(index + 4);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return stringBuilder2.append(string2).toString();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$TileResources;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationHeader", "", "getDocumentationHeader", "()Ljava/lang/String;", "documentationStrings", "", "getDocumentationStrings", "()Ljava/util/List;", "example", "getExample", "matchesWithRuleset", "", "getMatchesWithRuleset", "()Z", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "getKnownValuesForAutocomplete", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "matches", "core"})
    static final class TileResources
    extends Countables {
        @NotNull
        private final String documentationHeader;
        @NotNull
        private final List<String> documentationStrings;
        private final boolean matchesWithRuleset;
        @NotNull
        private final String example;

        /*
         * WARNING - void declaration
         */
        TileResources() {
            void var1_1;
            this.documentationHeader = "Resource name - From [TileResources.json](3-Map-related-JSON-files.md#tileresourcesjson)";
            String[] stringArray = new String[]{"Can be city stats or civilization stats, depending on where the unique is used", "For example: If a unique is placed on a building, then the retrieved resources will be of the city. If placed on a policy, they will be of the civilization.", "This can make a difference for e.g. local resources, which are counted per city."};
            this.documentationStrings = CollectionsKt.listOf(stringArray);
            this.matchesWithRuleset = true;
            this.example = "Iron";
        }

        @Override
        @NotNull
        public String getDocumentationHeader() {
            return this.documentationHeader;
        }

        @Override
        @NotNull
        public List<String> getDocumentationStrings() {
            return this.documentationStrings;
        }

        @Override
        public boolean getMatchesWithRuleset() {
            return this.matchesWithRuleset;
        }

        @Override
        public boolean matches(@NotNull String parameterText, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return ((Map)ruleset2.getTileResources()).containsKey(parameterText);
        }

        @Override
        @NotNull
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            return stateForConditionals.getResourceAmount(parameterText);
        }

        @Override
        @NotNull
        public String getExample() {
            return this.example;
        }

        @Override
        @NotNull
        public Set<String> getKnownValuesForAutocomplete(@NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Set<String> set2 = ruleset2.getTileResources().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            return set2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Turns;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationStrings", "", "", "getDocumentationStrings", "()Ljava/util/List;", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    static final class Turns
    extends Countables {
        @NotNull
        private final List<String> documentationStrings = CollectionsKt.listOf("Always starts at zero irrespective of game speed or start era");

        /*
         * WARNING - void declaration
         */
        Turns() {
            void var1_1;
        }

        @Override
        @NotNull
        public List<String> getDocumentationStrings() {
            return this.documentationStrings;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            GameInfo gameInfo = stateForConditionals.getGameInfo();
            return gameInfo != null ? java.lang.Integer.valueOf(gameInfo.getTurns()) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Units;", "Lcom/unciv/models/ruleset/unique/Countables;", "eval", "", "parameterText", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    static final class Units
    extends Countables {
        /*
         * WARNING - void declaration
         */
        Units() {
            void var1_1;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            Object object = stateForConditionals.getCivInfo();
            return object != null && (object = ((Civilization)object).getUnits()) != null ? java.lang.Integer.valueOf(((UnitManager)object).getCivUnitsSize()) : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/unique/Countables$Year;", "Lcom/unciv/models/ruleset/unique/Countables;", "documentationStrings", "", "", "getDocumentationStrings", "()Ljava/util/List;", "eval", "", "parameterText", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
    @SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables$Year\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
    static final class Year
    extends Countables {
        @NotNull
        private final List<String> documentationStrings = CollectionsKt.listOf("Depends on game speed or start era, negative for years BC");

        /*
         * WARNING - void declaration
         */
        Year() {
            void var1_1;
        }

        @Override
        @NotNull
        public List<String> getDocumentationStrings() {
            return this.documentationStrings;
        }

        @Override
        @Nullable
        public java.lang.Integer eval(@NotNull String parameterText, @NotNull StateForConditionals stateForConditionals) {
            java.lang.Integer n;
            Intrinsics.checkNotNullParameter(parameterText, "parameterText");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            GameInfo gameInfo = stateForConditionals.getGameInfo();
            if (gameInfo != null) {
                GameInfo $this$eval_u24lambda_u240 = gameInfo;
                boolean bl = false;
                n = $this$eval_u24lambda_u240.getYear($this$eval_u24lambda_u240.getTurns());
            } else {
                n = null;
            }
            return n;
        }
    }
}

