/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.skins;

import com.badlogic.gdx.graphics.Color;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R6\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0019j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a`\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/unciv/models/skins/SkinConfig;", "", "()V", "initialCapacity", "", "(I)V", "baseColor", "Lcom/badlogic/gdx/graphics/Color;", "getBaseColor", "()Lcom/badlogic/gdx/graphics/Color;", "setBaseColor", "(Lcom/badlogic/gdx/graphics/Color;)V", "clearColor", "getClearColor", "setClearColor", "defaultVariantTint", "getDefaultVariantTint", "setDefaultVariantTint", "fallbackSkin", "", "getFallbackSkin", "()Ljava/lang/String;", "setFallbackSkin", "(Ljava/lang/String;)V", "skinVariants", "Ljava/util/HashMap;", "Lcom/unciv/models/skins/SkinConfig$SkinElement;", "Lkotlin/collections/HashMap;", "getSkinVariants", "()Ljava/util/HashMap;", "setSkinVariants", "(Ljava/util/HashMap;)V", "clone", "updateConfig", "", "other", "SkinElement", "core"})
@SourceDebugExtension(value={"SMAP\nSkinConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinConfig.kt\ncom/unciv/models/skins/SkinConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class SkinConfig {
    @NotNull
    private Color baseColor = new Color(4228543);
    @NotNull
    private Color clearColor = new Color(13311);
    @Nullable
    private Color defaultVariantTint;
    @Nullable
    private String fallbackSkin = "Minimal";
    @NotNull
    private HashMap<String, SkinElement> skinVariants;

    public SkinConfig(int initialCapacity) {
        this.skinVariants = new HashMap(initialCapacity);
    }

    @NotNull
    public final Color getBaseColor() {
        return this.baseColor;
    }

    public final void setBaseColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.baseColor = color;
    }

    @NotNull
    public final Color getClearColor() {
        return this.clearColor;
    }

    public final void setClearColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.clearColor = color;
    }

    @Nullable
    public final Color getDefaultVariantTint() {
        return this.defaultVariantTint;
    }

    public final void setDefaultVariantTint(@Nullable Color color) {
        this.defaultVariantTint = color;
    }

    @Nullable
    public final String getFallbackSkin() {
        return this.fallbackSkin;
    }

    public final void setFallbackSkin(@Nullable String string) {
        this.fallbackSkin = string;
    }

    @NotNull
    public final HashMap<String, SkinElement> getSkinVariants() {
        return this.skinVariants;
    }

    public final void setSkinVariants(@NotNull HashMap<String, SkinElement> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.skinVariants = hashMap;
    }

    public SkinConfig() {
        this(16);
    }

    @NotNull
    public final SkinConfig clone() {
        SkinConfig skinConfig;
        SkinConfig it = skinConfig = new SkinConfig(this.skinVariants.size());
        boolean bl = false;
        it.updateConfig(this);
        return skinConfig;
    }

    public final void updateConfig(@NotNull SkinConfig other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Color color = other.baseColor.cpy();
        Intrinsics.checkNotNullExpressionValue(color, "cpy(...)");
        this.baseColor = color;
        Color color2 = other.clearColor.cpy();
        Intrinsics.checkNotNullExpressionValue(color2, "cpy(...)");
        this.clearColor = color2;
        Color color3 = other.defaultVariantTint;
        this.defaultVariantTint = color3 != null ? color3.cpy() : null;
        this.fallbackSkin = other.fallbackSkin;
        this.skinVariants.putAll((Map<String, SkinElement>)other.skinVariants);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/unciv/models/skins/SkinConfig$SkinElement;", "", "()V", "alpha", "", "getAlpha", "()Ljava/lang/Float;", "Ljava/lang/Float;", "foregroundColor", "Lcom/badlogic/gdx/graphics/Color;", "getForegroundColor", "()Lcom/badlogic/gdx/graphics/Color;", "iconColor", "getIconColor", "image", "", "getImage", "()Ljava/lang/String;", "tint", "getTint", "core"})
    public static final class SkinElement {
        @Nullable
        private final String image;
        @Nullable
        private final Color tint;
        @Nullable
        private final Float alpha;
        @Nullable
        private final Color foregroundColor;
        @Nullable
        private final Color iconColor;

        @Nullable
        public final String getImage() {
            return this.image;
        }

        @Nullable
        public final Color getTint() {
            return this.tint;
        }

        @Nullable
        public final Float getAlpha() {
            return this.alpha;
        }

        @Nullable
        public final Color getForegroundColor() {
            return this.foregroundColor;
        }

        @Nullable
        public final Color getIconColor() {
            return this.iconColor;
        }
    }
}

