/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0006\u0010\u0018\u001a\u00020\u000fJ\u001a\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u0012H\u0002R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerImprovement;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "<set-?>", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "improvementIcon", "getImprovementIcon", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "improvementPlusPillagedID", "", "determineVisibility", "", "dimImprovement", "dim", "", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "reset", "updateImprovementIcon", "show", "core"})
public final class TileLayerImprovement
extends TileLayer {
    @Nullable
    private String improvementPlusPillagedID;
    @Nullable
    private Actor improvementIcon;

    public TileLayerImprovement(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
    }

    @Nullable
    public final Actor getImprovementIcon() {
        return this.improvementIcon;
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean showResourcesAndImprovements = this.getTileGroup() instanceof WorldTileGroup ? UncivGame.Companion.getCurrent().getSettings().getShowResourcesAndImprovements() : true;
        this.updateImprovementIcon(viewingCiv, showResourcesAndImprovements);
    }

    public final void dimImprovement(boolean dim) {
        Actor actor = this.improvementIcon;
        if ((actor != null ? actor.getColor() : null) != null) {
            (actor != null ? actor.getColor() : null).a = dim ? 0.5f : 1.0f;
        }
    }

    private final void updateImprovementIcon(Civilization viewingCiv, boolean show) {
        String newImprovementPlusPillagedID;
        String improvementToShow = this.getTile().getShownImprovement(viewingCiv);
        String string = improvementToShow == null ? null : (newImprovementPlusPillagedID = this.getTile().getImprovementIsPillaged() ? improvementToShow + "-Pillaged" : improvementToShow);
        if (!Intrinsics.areEqual(this.improvementPlusPillagedID, newImprovementPlusPillagedID)) {
            this.improvementPlusPillagedID = newImprovementPlusPillagedID;
            Actor actor = this.improvementIcon;
            if (actor != null) {
                actor.remove();
            }
            this.improvementIcon = null;
        }
        if (this.improvementPlusPillagedID != null && show && this.improvementIcon == null) {
            String string2 = improvementToShow;
            Intrinsics.checkNotNull(string2);
            Portrait icon = ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, string2, 0.0f, this.getTile().getImprovementIsPillaged(), 2, null);
            Scene2dExtensionsKt.center((Actor)icon, this.getTileGroup());
            icon.setX(icon.getX() - (float)22);
            icon.setY(icon.getY() - (float)12);
            this.addActor(icon);
            this.improvementIcon = icon;
        }
        Actor actor = this.improvementIcon;
        if (actor != null) {
            actor.setVisible(show);
        }
    }

    @Override
    protected void determineVisibility() {
        Actor actor = this.improvementIcon;
        this.setVisible(actor != null ? actor.isVisible() : false);
    }

    public final void reset() {
        this.updateImprovementIcon(null, false);
    }
}

