/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/components/widgets/AutoScrollPane;", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "widget", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "skin", "Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;)V", "styleName", "", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;Ljava/lang/String;)V", "style", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane$ScrollPaneStyle;", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane$ScrollPaneStyle;)V", "savedFocus", "ensureListener", "", "setScrollingDisabled", "x", "", "y", "MouseOverListener", "core"})
@SourceDebugExtension(value={"SMAP\nAutoScrollPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoScrollPane.kt\ncom/unciv/ui/components/widgets/AutoScrollPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n288#2,2:121\n*S KotlinDebug\n*F\n+ 1 AutoScrollPane.kt\ncom/unciv/ui/components/widgets/AutoScrollPane\n*L\n110#1:121,2\n*E\n"})
public class AutoScrollPane
extends ScrollPane {
    @Nullable
    private Actor savedFocus;

    public AutoScrollPane(@Nullable Actor widget, @NotNull ScrollPane.ScrollPaneStyle style) {
        Intrinsics.checkNotNullParameter(style, "style");
        super(widget, style);
        this.ensureListener();
    }

    public /* synthetic */ AutoScrollPane(Actor actor, ScrollPane.ScrollPaneStyle scrollPaneStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scrollPaneStyle = new ScrollPane.ScrollPaneStyle();
        }
        this(actor, scrollPaneStyle);
    }

    public AutoScrollPane(@Nullable Actor widget, @NotNull Skin skin) {
        Intrinsics.checkNotNullParameter(skin, "skin");
        ScrollPane.ScrollPaneStyle scrollPaneStyle = skin.get(ScrollPane.ScrollPaneStyle.class);
        Intrinsics.checkNotNullExpressionValue(scrollPaneStyle, "get(...)");
        this(widget, scrollPaneStyle);
    }

    public AutoScrollPane(@Nullable Actor widget, @NotNull Skin skin, @NotNull String styleName) {
        Intrinsics.checkNotNullParameter(skin, "skin");
        Intrinsics.checkNotNullParameter(styleName, "styleName");
        ScrollPane.ScrollPaneStyle scrollPaneStyle = skin.get(styleName, ScrollPane.ScrollPaneStyle.class);
        Intrinsics.checkNotNullExpressionValue(scrollPaneStyle, "get(...)");
        this(widget, scrollPaneStyle);
    }

    @Override
    public void setScrollingDisabled(boolean x, boolean y) {
        super.setScrollingDisabled(x, y);
        this.ensureListener();
    }

    private final void ensureListener() {
        Object v1;
        block5: {
            DelayedRemovalArray<EventListener> delayedRemovalArray = this.getListeners();
            Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "getListeners(...)");
            Iterable $this$firstOrNull$iv = delayedRemovalArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EventListener it = (EventListener)element$iv;
                boolean bl = false;
                if (!(it instanceof MouseOverListener)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        EventListener existingListener = v1;
        if (this.isScrollingDisabledX() && this.isScrollingDisabledY()) {
            if (existingListener != null) {
                this.removeListener(existingListener);
            }
        } else if (existingListener == null) {
            this.addListener(new MouseOverListener());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/components/widgets/AutoScrollPane$MouseOverListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/ClickListener;", "()V", "enter", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "pointer", "", "fromActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "exit", "toActor", "core"})
    private static final class MouseOverListener
    extends ClickListener {
        @Override
        public void enter(@NotNull InputEvent event, float x, float y, int pointer, @Nullable Actor fromActor) {
            Intrinsics.checkNotNullParameter(event, "event");
            Actor actor = event.getListenerActor();
            Intrinsics.checkNotNull(actor, "null cannot be cast to non-null type com.unciv.ui.components.widgets.AutoScrollPane");
            AutoScrollPane thisScroll = (AutoScrollPane)actor;
            Stage stage = thisScroll.getStage();
            if (stage == null) {
                return;
            }
            Stage stage2 = stage;
            Actor actor2 = fromActor;
            boolean bl = actor2 != null ? actor2.isDescendantOf(thisScroll) : false;
            if (bl) {
                return;
            }
            if (thisScroll.savedFocus == null) {
                thisScroll.savedFocus = stage2.getScrollFocus();
            }
            stage2.setScrollFocus(thisScroll);
        }

        @Override
        public void exit(@NotNull InputEvent event, float x, float y, int pointer, @Nullable Actor toActor) {
            Intrinsics.checkNotNullParameter(event, "event");
            Actor actor = event.getListenerActor();
            Intrinsics.checkNotNull(actor, "null cannot be cast to non-null type com.unciv.ui.components.widgets.AutoScrollPane");
            AutoScrollPane thisScroll = (AutoScrollPane)actor;
            Stage stage = thisScroll.getStage();
            if (stage == null) {
                return;
            }
            Stage stage2 = stage;
            Actor actor2 = toActor;
            boolean bl = actor2 != null ? actor2.isDescendantOf(thisScroll) : false;
            if (bl) {
                return;
            }
            if (Intrinsics.areEqual(stage2.getScrollFocus(), thisScroll)) {
                stage2.setScrollFocus(thisScroll.savedFocus);
            }
            thisScroll.savedFocus = null;
        }
    }
}

