/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.unciv.UncivGame;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B\u009f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u0012\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u00100\u001a\u00020\u0015J\u000e\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0003J\b\u00103\u001a\u00020\tH\u0002J\u0006\u00104\u001a\u00020\u0015J\u0006\u00105\u001a\u00020\u0015J\u0010\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002J\u0012\u00109\u001a\u00020\u00152\b\b\u0002\u0010:\u001a\u00020\tH\u0002J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<*\b\u0012\u0004\u0012\u00020\u00070<H\u0002R\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR$\u0010(\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010)\"\u0004\b-\u0010+R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006>"}, d2={"Lcom/unciv/ui/components/widgets/ExpanderTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "title", "", "fontSize", "", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "startsOutOpened", "", "defaultPad", "", "topPad", "headerPad", "expanderWidth", "expanderHeight", "persistenceID", "toggleKey", "Lcom/unciv/ui/components/input/KeyboardBinding;", "onChange", "Lkotlin/Function0;", "", "initContent", "Lkotlin/Function1;", "(Ljava/lang/String;ILcom/badlogic/gdx/scenes/scene2d/Actor;ZFFFFFLjava/lang/String;Lcom/unciv/ui/components/input/KeyboardBinding;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "contentWrapper", "header", "getHeader", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "headerContent", "getHeaderContent", "headerIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getHeaderIcon", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "headerLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "innerTable", "getInnerTable", "value", "isHeaderIconVisible", "()Z", "setHeaderIconVisible", "(Z)V", "isOpen", "setOpen", "getTitle", "()Ljava/lang/String;", "setDynamicHeaderSize", "setText", "text", "testForBorderedTable", "toggle", "toggleOnIconOnly", "tryAutoScroll", "scrollPane", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "update", "noAnimation", "resetFixedSize", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nExpanderTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpanderTab.kt\ncom/unciv/ui/components/widgets/ExpanderTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class ExpanderTab
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @Nullable
    private final String persistenceID;
    @Nullable
    private final Function0<Unit> onChange;
    @NotNull
    private final Table header;
    @NotNull
    private final Table headerContent;
    @NotNull
    private final Label headerLabel;
    @NotNull
    private final Image headerIcon;
    @NotNull
    private final Table contentWrapper;
    @NotNull
    private final Table innerTable;
    private boolean isOpen;
    private static final float arrowSize = 18.0f;
    @NotNull
    private static final String arrowImage = "OtherIcons/BackArrow";
    @NotNull
    private static final Color arrowColor = new Color(1.0f, 0.96f, 0.75f, 1.0f);
    private static final float animationDuration = 0.2f;
    @NotNull
    private static final HashMap<String, Boolean> persistedStates = new HashMap();

    public ExpanderTab(@NotNull String title, int fontSize, @Nullable Actor icon, boolean startsOutOpened, float defaultPad, float topPad, float headerPad, float expanderWidth, float expanderHeight, @Nullable String persistenceID, @NotNull KeyboardBinding toggleKey, @Nullable Function0<Unit> onChange, @Nullable Function1<? super Table, Unit> initContent) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter((Object)toggleKey, "toggleKey");
        super(BaseScreen.Companion.getSkin());
        this.title = title;
        this.persistenceID = persistenceID;
        this.onChange = onChange;
        this.header = new Table(this.getSkin());
        this.headerContent = new Table();
        this.headerLabel = Scene2dExtensionsKt.toLabel$default(this.title, null, fontSize, 0, true, 5, null);
        this.headerIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, arrowImage, null, 2, null);
        this.contentWrapper = new Table();
        this.innerTable = new Table();
        Boolean bl = (Boolean)((Map)persistedStates).get(this.persistenceID);
        this.isOpen = bl != null ? bl : startsOutOpened;
        this.header.defaults().pad(headerPad);
        if (expanderHeight > 0.0f) {
            this.header.defaults().height(expanderHeight);
        }
        this.headerIcon.setSize(18.0f, 18.0f);
        this.headerIcon.setOrigin(1);
        this.headerIcon.setRotation(0.0f);
        this.headerIcon.setColor(arrowColor);
        this.header.background(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/ExpanderTab", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 2, null));
        if (icon != null) {
            this.header.add(icon);
        }
        this.header.add((Actor)this.headerLabel);
        this.header.add((Actor)this.headerContent).growX();
        this.header.add((Actor)this.headerIcon).size(18.0f).align(1);
        this.header.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(this.header, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.toggle();
            }
        });
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this.header), toggleKey, 0, 2, null);
        if (!(expanderWidth == 0.0f)) {
            this.defaults().minWidth(expanderWidth);
        }
        this.defaults().growX();
        this.contentWrapper.defaults().growX().pad(topPad, defaultPad, defaultPad, defaultPad);
        this.innerTable.defaults().growX();
        this.add((Actor)this.header).fill().row();
        this.add((Actor)this.contentWrapper);
        this.contentWrapper.add((Actor)this.innerTable);
        Function1<? super Table, Unit> function1 = initContent;
        if (function1 != null) {
            function1.invoke(this.innerTable);
        }
        if (expanderWidth == 0.0f) {
            if (this.innerTable.needsLayout()) {
                this.contentWrapper.pack();
            }
            this.getCell((Actor)this.header).minWidth(this.contentWrapper.getWidth());
        }
        this.update(true);
    }

    public /* synthetic */ ExpanderTab(String string, int n, Actor actor, boolean bl, float f, float f2, float f3, float f4, float f5, String string2, KeyboardBinding keyboardBinding, Function0 function0, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 24;
        }
        if ((n2 & 4) != 0) {
            actor = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            f = 10.0f;
        }
        if ((n2 & 0x20) != 0) {
            f2 = f;
        }
        if ((n2 & 0x40) != 0) {
            f3 = 10.0f;
        }
        if ((n2 & 0x80) != 0) {
            f4 = 0.0f;
        }
        if ((n2 & 0x100) != 0) {
            f5 = 0.0f;
        }
        if ((n2 & 0x200) != 0) {
            string2 = null;
        }
        if ((n2 & 0x400) != 0) {
            keyboardBinding = KeyboardBinding.None;
        }
        if ((n2 & 0x800) != 0) {
            function0 = null;
        }
        if ((n2 & 0x1000) != 0) {
            function1 = null;
        }
        this(string, n, actor, bl, f, f2, f3, f4, f5, string2, keyboardBinding, function0, function1);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Table getHeader() {
        return this.header;
    }

    @NotNull
    public final Table getHeaderContent() {
        return this.headerContent;
    }

    @NotNull
    public final Image getHeaderIcon() {
        return this.headerIcon;
    }

    @NotNull
    public final Table getInnerTable() {
        return this.innerTable;
    }

    public final boolean isOpen() {
        return this.isOpen;
    }

    private final void setOpen(boolean value) {
        if (value == this.isOpen) {
            return;
        }
        this.isOpen = value;
        ExpanderTab.update$default(this, false, 1, null);
    }

    public final boolean isHeaderIconVisible() {
        return this.headerIcon.isVisible();
    }

    public final void setHeaderIconVisible(boolean value) {
        this.headerIcon.setVisible(value);
    }

    private final void update(boolean noAnimation) {
        if (this.persistenceID != null) {
            ((Map)persistedStates).put(this.persistenceID, this.isOpen);
        }
        if (noAnimation || !UncivGame.Companion.getCurrent().getSettings().getContinuousRendering()) {
            this.contentWrapper.clear();
            if (this.isOpen) {
                this.contentWrapper.add((Actor)this.innerTable);
            }
            this.headerIcon.setRotation(this.isOpen ? 90.0f : 0.0f);
            if (!noAnimation) {
                Function0<Unit> function0 = this.onChange;
                if (function0 != null) {
                    function0.invoke();
                }
            }
            return;
        }
        Object object = Interpolation.linear;
        Object $this$update_u24lambda_u240 = object = new FloatAction(this, (Interpolation)object){
            final /* synthetic */ ExpanderTab this$0;
            {
                this.this$0 = $receiver;
                super(90.0f, 0.0f, 0.2f, $super_call_param$1);
            }

            protected void update(float percent) {
                block2: {
                    super.update(percent);
                    this.this$0.getHeaderIcon().setRotation(this.getValue());
                    if (!this.isComplete()) break block2;
                    ExpanderTab.access$getContentWrapper$p(this.this$0).clear();
                    if (this.this$0.isOpen()) {
                        ExpanderTab.access$getContentWrapper$p(this.this$0).add((Actor)this.this$0.getInnerTable());
                    }
                    Function0 function0 = ExpanderTab.access$getOnChange$p(this.this$0);
                    if (function0 != null) {
                        function0.invoke();
                    }
                }
            }
        };
        boolean bl = false;
        ((TemporalAction)$this$update_u24lambda_u240).setReverse(this.isOpen);
        Object action2 = object;
        this.addAction((Action)action2);
    }

    static /* synthetic */ void update$default(ExpanderTab expanderTab2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        expanderTab2.update(bl);
    }

    public final void toggle() {
        this.setOpen(!this.isOpen);
        if (this.getParent() instanceof Table && this.getParent().getParent() instanceof ScrollPane) {
            Group group = this.getParent().getParent();
            Intrinsics.checkNotNull(group, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.ScrollPane");
            this.tryAutoScroll((ScrollPane)group);
        } else if (this.testForBorderedTable()) {
            Group group = this.getParent().getParent().getParent();
            Intrinsics.checkNotNull(group, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.ScrollPane");
            this.tryAutoScroll((ScrollPane)group);
        }
    }

    private final boolean testForBorderedTable() {
        if (!(this.getParent() instanceof Table)) {
            return false;
        }
        Group group = this.getParent().getParent();
        Table table2 = group instanceof Table ? (Table)group : null;
        if (table2 == null) {
            return false;
        }
        Table borderTable = table2;
        if (!(this.getParent().getParent().getParent() instanceof ScrollPane)) {
            return false;
        }
        return borderTable.getCells().size == 1 && borderTable.getBackground() != null && borderTable.getPadTop() == 2.0f;
    }

    private final void tryAutoScroll(ScrollPane scrollPane) {
        if (scrollPane.isScrollingDisabledY()) {
            return;
        }
        float heightToShow = this.header.getHeight();
        float yToShow = this.getY() + this.getHeight() - heightToShow + (Intrinsics.areEqual(scrollPane.getActor(), this.getParent()) ? 0.0f : this.getParent().getY());
        scrollPane.scrollTo(0.0f, yToShow, this.header.getWidth(), heightToShow);
    }

    public final void setText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.headerLabel.setText(text2);
    }

    public final void toggleOnIconOnly() {
        ActivationExtensionsKt.clearActivationActions$default(this.header, ActivationTypes.Tap, false, 2, null);
        ActivationExtensionsKt.onActivation(this.headerIcon, new Function0<Unit>(this){
            final /* synthetic */ ExpanderTab this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.toggle();
            }
        });
    }

    private final Cell<Actor> resetFixedSize(Cell<Actor> $this$resetFixedSize) {
        $this$resetFixedSize.minHeight(Value.minHeight);
        $this$resetFixedSize.prefHeight(Value.prefHeight);
        $this$resetFixedSize.maxHeight(Value.maxHeight);
        $this$resetFixedSize.minWidth(Value.minWidth);
        $this$resetFixedSize.prefWidth(Value.prefHeight);
        $this$resetFixedSize.maxWidth(Value.maxWidth);
        return $this$resetFixedSize;
    }

    public final void setDynamicHeaderSize() {
        Cell cell2 = this.header.getCells().get(0);
        Intrinsics.checkNotNull(cell2);
        this.resetFixedSize(cell2).center();
        Cell cell3 = this.header.getCells().get(1);
        Intrinsics.checkNotNull(cell3);
        this.resetFixedSize(cell3).center();
    }

    public static final /* synthetic */ Table access$getContentWrapper$p(ExpanderTab $this) {
        return $this.contentWrapper;
    }

    public static final /* synthetic */ Function0 access$getOnChange$p(ExpanderTab $this) {
        return $this.onChange;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/components/widgets/ExpanderTab$Companion;", "", "()V", "animationDuration", "", "arrowColor", "Lcom/badlogic/gdx/graphics/Color;", "arrowImage", "", "arrowSize", "persistedStates", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "wasOpen", "persistenceID", "(Ljava/lang/String;)Ljava/lang/Boolean;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Boolean wasOpen(@NotNull String persistenceID) {
            Intrinsics.checkNotNullParameter(persistenceID, "persistenceID");
            return (Boolean)persistedStates.get(persistenceID);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

