/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u0005H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R\u001a\u0010 \u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0015\"\u0004\b\"\u0010\u0017R\u000e\u0010#\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/unciv/ui/components/widgets/FlagBackground;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "drawable", "Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;", "size", "", "(Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;F)V", "drawOutline", "", "getDrawOutline", "()Z", "setDrawOutline", "(Z)V", "drawableInner", "getDrawableInner", "()Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;", "setDrawableInner", "(Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;)V", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "getInnerColor", "()Lcom/badlogic/gdx/graphics/Color;", "setInnerColor", "(Lcom/badlogic/gdx/graphics/Color;)V", "innerHeight", "innerMultiplier", "innerOffsetX", "innerOffsetY", "innerWidth", "outerColor", "getOuterColor", "setOuterColor", "outlineColor", "getOutlineColor", "setOutlineColor", "outlineHeight", "outlineMultiplier", "outlineOffsetX", "outlineOffsetY", "outlineWidth", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getDrawable", "core"})
final class FlagBackground
extends Image {
    @Nullable
    private TextureRegionDrawable drawableInner;
    @NotNull
    private Color innerColor;
    @NotNull
    private Color outerColor;
    @NotNull
    private Color outlineColor;
    private boolean drawOutline;
    private final float innerMultiplier;
    private final float outlineMultiplier;
    private final float innerWidth;
    private final float innerHeight;
    private final float innerOffsetX;
    private final float innerOffsetY;
    private final float outlineWidth;
    private final float outlineHeight;
    private final float outlineOffsetX;
    private final float outlineOffsetY;

    public FlagBackground(@NotNull TextureRegionDrawable drawable, float size2) {
        Intrinsics.checkNotNullParameter(drawable, "drawable");
        super(drawable);
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.innerColor = color;
        Color color2 = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color2, "RED");
        this.outerColor = color2;
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
        this.outlineColor = color3;
        this.innerMultiplier = 0.88f;
        this.outlineMultiplier = 1.08f;
        float ratio = this.getHeight() / this.getWidth();
        this.setWidth(size2);
        this.setHeight(size2 * ratio);
        this.innerWidth = this.getWidth() * this.innerMultiplier;
        this.innerHeight = this.getHeight() * this.innerMultiplier;
        this.innerOffsetX = (this.getWidth() - this.innerWidth) / (float)2;
        this.innerOffsetY = (this.getHeight() - this.innerHeight) / (float)2;
        this.outlineWidth = this.getWidth() * this.outlineMultiplier;
        this.outlineHeight = this.getHeight() * this.outlineMultiplier;
        this.outlineOffsetX = (this.outlineWidth - this.getWidth()) / (float)2;
        this.outlineOffsetY = (this.outlineHeight - this.getHeight()) / (float)2;
    }

    @Nullable
    public final TextureRegionDrawable getDrawableInner() {
        return this.drawableInner;
    }

    public final void setDrawableInner(@Nullable TextureRegionDrawable textureRegionDrawable) {
        this.drawableInner = textureRegionDrawable;
    }

    @NotNull
    public final Color getInnerColor() {
        return this.innerColor;
    }

    public final void setInnerColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.innerColor = color;
    }

    @NotNull
    public final Color getOuterColor() {
        return this.outerColor;
    }

    public final void setOuterColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.outerColor = color;
    }

    @NotNull
    public final Color getOutlineColor() {
        return this.outlineColor;
    }

    public final void setOutlineColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.outlineColor = color;
    }

    public final boolean getDrawOutline() {
        return this.drawOutline;
    }

    public final void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    @Override
    @NotNull
    public TextureRegionDrawable getDrawable() {
        Drawable drawable = super.getDrawable();
        Intrinsics.checkNotNull(drawable, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable");
        return (TextureRegionDrawable)drawable;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        float alpha = this.getColor().a * parentAlpha;
        TextureRegionDrawable drawable = this.getDrawable();
        if (this.drawOutline) {
            Batch batch2 = batch;
            if (batch2 != null) {
                batch2.setColor(this.outlineColor.r, this.outlineColor.g, this.outlineColor.b, this.outlineColor.a * alpha);
            }
            drawable.draw(batch, this.getX() - this.outlineOffsetX, this.getY() - this.outlineOffsetY, this.outlineWidth, this.outlineHeight);
        }
        Batch batch3 = batch;
        if (batch3 != null) {
            batch3.setColor(this.outerColor.r, this.outerColor.g, this.outerColor.b, this.outerColor.a * alpha);
        }
        drawable.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        Batch batch4 = batch;
        if (batch4 != null) {
            batch4.setColor(this.innerColor.r, this.innerColor.g, this.innerColor.b, this.innerColor.a * alpha);
        }
        if (this.drawableInner == null) {
            drawable.draw(batch, this.getX() + this.innerOffsetX, this.getY() + this.innerOffsetY, this.innerWidth, this.innerHeight);
        } else {
            TextureRegionDrawable textureRegionDrawable = this.drawableInner;
            Intrinsics.checkNotNull(textureRegionDrawable);
            textureRegionDrawable.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }
}

