/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.unciv.logic.event.EventBus;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.TextFieldWithFixes;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.components.widgets.UncivTextField$VisibleAreaChangedListener$1$1$1$invokeSuspend$;
import com.unciv.ui.components.widgets.UncivTextField$addPopupCloseListener$;
import com.unciv.ui.components.widgets.UncivTextField$scrollAscendantToTextField$;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B:\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012!\b\u0002\u0010\u0005\u001a\u001b\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u001b\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField;", "Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "hint", "", "preEnteredText", "onFocusChange", "Lkotlin/Function2;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "hideKeyboard", "Lkotlin/Function0;", "isAndroid", "addPopupCloseListener", "scrollAscendantToTextField", "TextfieldPopup", "UncivTextFieldFocusListener", "VisibleAreaChangedListener", "core"})
@SourceDebugExtension(value={"SMAP\nUncivTextField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField\n+ 2 Scene2dExtensions.kt\ncom/unciv/ui/components/extensions/Scene2dExtensionsKt\n*L\n1#1,193:1\n148#2:194\n148#2:195\n*S KotlinDebug\n*F\n+ 1 UncivTextField.kt\ncom/unciv/ui/components/widgets/UncivTextField\n*L\n101#1:194\n115#1:195\n*E\n"})
public final class UncivTextField
extends TextFieldWithFixes {
    @Nullable
    private final Function2<TextField, Boolean, Unit> onFocusChange;
    private final boolean isAndroid;
    @NotNull
    private final Function0<Unit> hideKeyboard;

    public UncivTextField(@NotNull String hint, @NotNull String preEnteredText, @Nullable Function2<? super TextField, ? super Boolean, Unit> onFocusChange) {
        Intrinsics.checkNotNullParameter(hint, "hint");
        Intrinsics.checkNotNullParameter(preEnteredText, "preEnteredText");
        super(preEnteredText, BaseScreen.Companion.getSkin());
        this.onFocusChange = onFocusChange;
        this.isAndroid = Gdx.app.getType() == Application.ApplicationType.Android;
        this.hideKeyboard = hideKeyboard.1.INSTANCE;
        this.setMessageText(TranslationsKt.tr$default(hint, false, false, 3, null));
        this.addListener(new UncivTextFieldFocusListener());
        if (this.isAndroid) {
            this.addListener(new VisibleAreaChangedListener());
        }
    }

    public /* synthetic */ UncivTextField(String string, String string2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        this(string, string2, function2);
    }

    private final void addPopupCloseListener() {
        Popup popup2;
        Actor $this$getAscendant$iv = this;
        boolean $i$f$getAscendant = false;
        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, addPopupCloseListener$$inlined$getAscendant$1.INSTANCE);
        if (!(actor instanceof Popup)) {
            actor = null;
        }
        if ((popup2 = (Popup)actor) != null && !popup2.getCloseListeners().contains(this.hideKeyboard)) {
            popup2.getCloseListeners().add(this.hideKeyboard);
        }
    }

    private final boolean scrollAscendantToTextField() {
        Stage stage = this.getStage();
        UncivStage uncivStage = stage instanceof UncivStage ? (UncivStage)stage : null;
        if (uncivStage == null) {
            return false;
        }
        UncivStage stage2 = uncivStage;
        Actor $this$getAscendant$iv = this;
        boolean $i$f$getAscendant = false;
        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, scrollAscendantToTextField$$inlined$getAscendant$1.INSTANCE);
        if (!(actor instanceof ScrollPane)) {
            actor = null;
        }
        ScrollPane scrollPane = (ScrollPane)actor;
        Rectangle visibleArea = stage2.getLastKnownVisibleArea();
        Rectangle textFieldStageBoundingBox = Scene2dExtensionsKt.getStageBoundingBox(this);
        if (scrollPane == null) {
            return visibleArea.contains(textFieldStageBoundingBox);
        }
        Rectangle scrollPaneBounds = Scene2dExtensionsKt.getStageBoundingBox(scrollPane);
        Rectangle visibleScrollPaneArea = Scene2dExtensionsKt.getOverlap(scrollPaneBounds, visibleArea);
        if (visibleScrollPaneArea == null) {
            return false;
        }
        if (visibleScrollPaneArea.contains(textFieldStageBoundingBox)) {
            return true;
        }
        Actor scrollContent = scrollPane.getActor();
        Vector2 textFieldScrollContentCoords = this.localToAscendantCoordinates(scrollContent, new Vector2(0.0f, 0.0f));
        float pixelsNotVisibleOnLeftSide = RangesKt.coerceAtLeast(visibleScrollPaneArea.x - scrollPaneBounds.x, 0.0f);
        float textFieldDistanceFromLeftSide = textFieldScrollContentCoords.x;
        float pixelsNotVisibleOnRightSide = RangesKt.coerceAtLeast(Scene2dExtensionsKt.getRight(scrollPaneBounds) - Scene2dExtensionsKt.getRight(visibleScrollPaneArea), 0.0f);
        float textFieldDistanceFromRightSide = scrollContent.getWidth() - (textFieldScrollContentCoords.x + this.getWidth());
        float pixelsNotVisibleOnTop = RangesKt.coerceAtLeast(Scene2dExtensionsKt.getTop(scrollPaneBounds) - Scene2dExtensionsKt.getTop(visibleScrollPaneArea), 0.0f);
        float textFieldDistanceFromTop = scrollContent.getHeight() - (textFieldScrollContentCoords.y + this.getHeight());
        float pixelsNotVisibleOnBottom = RangesKt.coerceAtLeast(visibleScrollPaneArea.y - scrollPaneBounds.y, 0.0f);
        float textFieldDistanceFromBottom = textFieldScrollContentCoords.y;
        if (visibleScrollPaneArea.width < this.getWidth() || visibleScrollPaneArea.height < this.getHeight() || pixelsNotVisibleOnLeftSide > textFieldDistanceFromLeftSide || pixelsNotVisibleOnRightSide > textFieldDistanceFromRightSide || pixelsNotVisibleOnTop > textFieldDistanceFromTop || pixelsNotVisibleOnBottom > textFieldDistanceFromBottom) {
            return false;
        }
        float scrollXMiddle = textFieldScrollContentCoords.x - this.getWidth() / (float)2 + visibleScrollPaneArea.width / (float)2;
        scrollPane.setScrollX(pixelsNotVisibleOnLeftSide + scrollXMiddle);
        float scrollYMiddleGdxOrigin = textFieldScrollContentCoords.y + this.getHeight() / (float)2 + visibleScrollPaneArea.height / (float)2;
        scrollPane.setScrollY(pixelsNotVisibleOnTop + scrollContent.getHeight() - scrollYMiddleGdxOrigin);
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$TextfieldPopup;", "Lcom/unciv/ui/popups/Popup;", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "popupTextfield", "Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "getPopupTextfield", "()Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "core"})
    private final class TextfieldPopup
    extends Popup {
        @NotNull
        private final TextFieldWithFixes popupTextfield;

        public TextfieldPopup() {
            Stage stage = UncivTextField.this.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            super(stage, null, 0.0f, 6, null);
            this.popupTextfield = new TextFieldWithFixes(UncivTextField.this);
            Popup popup2 = this;
            String string = this.popupTextfield.getMessageText();
            Intrinsics.checkNotNullExpressionValue(string, "getMessageText(...)");
            Popup.addGoodSizedLabel$default(popup2, string, 0, false, 6, null).colspan(2).row();
            this.add((Actor)this.popupTextfield).width(this.getStageToShowOn().getWidth() / (float)2).colspan(2).row();
            Popup.addCloseButton$default(this, "Cancel", null, null, null, 14, null).left();
            Popup.addOKButton$default(this, null, null, null, null, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    UncivTextField.this.copyTextAndSelection(this.getPopupTextfield());
                }
            }, 15, null).right().row();
            this.getShowListeners().add(new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.getStageToShowOn().setKeyboardFocus(this.getPopupTextfield());
                }
            });
            this.getCloseListeners().add(new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.getStageToShowOn().setKeyboardFocus(null);
                    Gdx.input.setOnscreenKeyboardVisible(false);
                }
            });
        }

        @NotNull
        public final TextFieldWithFixes getPopupTextfield() {
            return this.popupTextfield;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$UncivTextFieldFocusListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/FocusListener;", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "keyboardFocusChanged", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/utils/FocusListener$FocusEvent;", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "focused", "", "core"})
    private final class UncivTextFieldFocusListener
    extends FocusListener {
        @Override
        public void keyboardFocusChanged(@NotNull FocusListener.FocusEvent event, @NotNull Actor actor, boolean focused) {
            block2: {
                Intrinsics.checkNotNullParameter(event, "event");
                Intrinsics.checkNotNullParameter(actor, "actor");
                if (focused) {
                    UncivTextField.this.scrollAscendantToTextField();
                    if (UncivTextField.this.isAndroid) {
                        UncivTextField.this.addPopupCloseListener();
                        Gdx.input.setOnscreenKeyboardVisible(true);
                    }
                }
                Function2 function2 = UncivTextField.this.onFocusChange;
                if (function2 == null) break block2;
                function2.invoke(UncivTextField.this, focused);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/components/widgets/UncivTextField$VisibleAreaChangedListener;", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "(Lcom/unciv/ui/components/widgets/UncivTextField;)V", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "touchDown", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "pointer", "", "button", "core"})
    private final class VisibleAreaChangedListener
    extends InputListener {
        @NotNull
        private final EventBus.EventReceiver events = new EventBus.EventReceiver();

        public VisibleAreaChangedListener() {
            EventBus.EventReceiver.receive$default(this.events, Reflection.getOrCreateKotlinClass(UncivStage.VisibleAreaChanged.class), null, new Function1<UncivStage.VisibleAreaChanged, Unit>(){

                @Override
                public final void invoke(@NotNull UncivStage.VisibleAreaChanged it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (UncivTextField.this.getStage() == null || !UncivTextField.this.hasKeyboardFocus()) {
                        return;
                    }
                    Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(UncivTextField.this, null){
                        int label;
                        final /* synthetic */ UncivTextField this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    this.label = 1;
                                    v0 = DelayKt.delay(100L, this);
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    this.label = 2;
                                    v1 = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ UncivTextField this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        @Override
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    if (this.this$0.getStage() == null) {
                                                        return Unit.INSTANCE;
                                                    }
                                                    if (this.this$0.scrollAscendantToTextField()) {
                                                        ScrollPane scrollPane;
                                                        Actor $this$getAscendant$iv = this.this$0;
                                                        boolean $i$f$getAscendant = false;
                                                        Actor actor = Scene2dExtensionsKt.getAscendant($this$getAscendant$iv, VisibleAreaChangedListener$1$1$1$invokeSuspend$$inlined$getAscendant$1.INSTANCE);
                                                        if (!(actor instanceof ScrollPane)) {
                                                            actor = null;
                                                        }
                                                        ScrollPane scrollPane2 = scrollPane = (ScrollPane)actor;
                                                        if (scrollPane2 != null) {
                                                            scrollPane2.updateVisualScroll();
                                                        }
                                                    } else {
                                                        Popup.open$default(this.this$0.new TextfieldPopup(), false, 1, null);
                                                    }
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @Override
                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Override
                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, this);
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl21
                                }
                                case 2: {
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
lbl21:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Override
                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Override
                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                }
            }, 2, null);
        }

        @Override
        public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, int button) {
            Intrinsics.checkNotNullParameter(event, "event");
            UncivTextField.this.addPopupCloseListener();
            return false;
        }
    }
}

