/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/images/PortraitResource;", "Lcom/unciv/ui/images/Portrait;", "name", "", "size", "", "amount", "", "(Ljava/lang/String;FI)V", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getCircleImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getDefaultInnerBackgroundTint", "Lcom/badlogic/gdx/graphics/Color;", "core"})
public final class PortraitResource
extends Portrait {
    public PortraitResource(@NotNull String name2, float size2, int amount) {
        Intrinsics.checkNotNullParameter(name2, "name");
        super(Portrait.Type.Resource, name2, size2, 0.0f, 8, null);
        if (amount > 0) {
            String string = TranslationsKt.tr(amount);
            Color color = Color.WHITE;
            Intrinsics.checkNotNull(color);
            Label label2 = Scene2dExtensionsKt.toLabel$default(string, color, 8, 1, false, 8, null);
            IconCircleGroup amountGroup = Scene2dExtensionsKt.surroundWithCircle$default(label2, size2 / (float)2, true, ImageGetter.INSTANCE.getCHARCOAL(), null, 8, null);
            label2.setY(label2.getY() - 0.5f);
            amountGroup.setX(this.getWidth() - amountGroup.getWidth() * (float)3 / (float)4);
            amountGroup.setY(-amountGroup.getHeight() / (float)4);
            this.addActor(amountGroup);
        }
    }

    public /* synthetic */ PortraitResource(String string, float f, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, f, n);
    }

    @Override
    @NotNull
    protected Image getCircleImage() {
        return ImageGetter.getImage$default(ImageGetter.INSTANCE, "ResourceIcons/Circle", null, 2, null);
    }

    @Override
    @NotNull
    public Color getDefaultInnerBackgroundTint() {
        Object object = this.getRuleset().getTileResources().get(this.getImageName());
        if (object == null || (object = ((TileResource)object).getResourceType()) == null || (object = ((ResourceType)((Object)object)).getColor()) == null) {
            Color color = Color.WHITE;
            object = color;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        }
        return object;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }
}

