/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.city.City;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\bH\u0002J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0015J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J&\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;", "", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "preferredBuyStat", "Lcom/unciv/models/stats/Stat;", "askToBuyConstruction", "", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "tile", "Lcom/unciv/logic/map/tile/Tile;", "buyButtonOnClick", "getBuyButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getBuyButtons", "", "Lcom/unciv/models/ruleset/IConstruction;", "hasBuyButtons", "", "isConstructionPurchaseShown", "purchaseConstruction", "ConfirmBuyPopup", "core"})
@SourceDebugExtension(value={"SMAP\nBuyButtonFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuyButtonFactory.kt\ncom/unciv/ui/screens/cityscreen/BuyButtonFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1603#2,9:197\n1855#2:206\n1856#2:208\n1612#2:209\n1#3:207\n*S KotlinDebug\n*F\n+ 1 BuyButtonFactory.kt\ncom/unciv/ui/screens/cityscreen/BuyButtonFactory\n*L\n41#1:197,9\n41#1:206\n41#1:208\n41#1:209\n41#1:207\n*E\n"})
public final class BuyButtonFactory {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private Stat preferredBuyStat;

    public BuyButtonFactory(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.preferredBuyStat = Stat.Gold;
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    public final boolean hasBuyButtons(@Nullable IConstruction construction2) {
        return !((Collection)this.getBuyButtons(construction2)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextButton> getBuyButtons(@Nullable IConstruction construction2) {
        boolean selection;
        boolean bl = selection = this.cityScreen.getSelectedConstruction() != null || this.cityScreen.getSelectedQueueEntry() >= 0;
        if (selection && construction2 != null && !(construction2 instanceof PerpetualConstruction)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = Stat.Companion.getStatsUsableToBuy();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TextButton it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Stat it = (Stat)element$iv$iv;
                boolean bl3 = false;
                if (this.getBuyButton((INonPerpetualConstruction)construction2, it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final TextButton getBuyButton(INonPerpetualConstruction construction2, Stat stat) {
        if (!Stat.Companion.getStatsUsableToBuy().contains(stat) || construction2 == null) {
            return null;
        }
        City city2 = this.cityScreen.getCity$core();
        TextButton button = Scene2dExtensionsKt.toTextButton$default("", null, false, 3, null);
        if (!this.isConstructionPurchaseShown(construction2, stat)) {
            if (stat != Stat.Gold || construction2.canBePurchasedWithAnyStat(city2)) {
                return null;
            }
            button.setText(TranslationsKt.tr$default("Buy", false, false, 3, null));
            Scene2dExtensionsKt.disable(button);
        } else {
            Integer n = construction2.getStatBuyCost(city2, stat);
            Intrinsics.checkNotNull(n);
            int constructionBuyCost = n;
            button.setText(TranslationsKt.tr$default("Buy", false, false, 3, null) + ' ' + TranslationsKt.tr(constructionBuyCost) + stat.getCharacter());
            ActivationExtensionsKt.onActivation$default(button, null, KeyboardBinding.BuyConstruction, new Function0<Unit>(button, this, construction2, stat){
                final /* synthetic */ TextButton $button;
                final /* synthetic */ BuyButtonFactory this$0;
                final /* synthetic */ INonPerpetualConstruction $construction;
                final /* synthetic */ Stat $stat;
                {
                    this.$button = $button;
                    this.this$0 = $receiver;
                    this.$construction = $construction;
                    this.$stat = $stat;
                    super(0);
                }

                public final void invoke() {
                    Scene2dExtensionsKt.disable(this.$button);
                    BuyButtonFactory.access$buyButtonOnClick(this.this$0, this.$construction, this.$stat);
                }
            }, 1, null);
            Scene2dExtensionsKt.setEnabled(button, this.cityScreen.getCanChangeState() && city2.getCityConstructions().isConstructionPurchaseAllowed(construction2, stat, constructionBuyCost));
            this.preferredBuyStat = stat;
            if (city2.getCityConstructions().isConstructionPurchaseBlockedByUnit(construction2)) {
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, button, "Move unit out of city first", 26.0f, false, 0, 0, false, null, 120, null);
            }
        }
        button.getLabelCell().pad(5.0f);
        return button;
    }

    static /* synthetic */ TextButton getBuyButton$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        return buyButtonFactory.getBuyButton(iNonPerpetualConstruction, stat);
    }

    private final void buyButtonOnClick(INonPerpetualConstruction construction2, Stat stat) {
        if (!(construction2 instanceof Building) || !((Building)construction2).hasCreateOneImprovementUnique()) {
            BuyButtonFactory.askToBuyConstruction$default(this, construction2, stat, null, 4, null);
            return;
        }
        if (this.cityScreen.getSelectedQueueEntry() < 0) {
            this.cityScreen.startPickTileForCreatesOneImprovement((Building)construction2, stat, true);
            return;
        }
        TileImprovement tileImprovement = ((Building)construction2).getImprovementToCreate(this.cityScreen.getCity$core().getRuleset(), this.cityScreen.getCity$core().getCiv());
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement2 = tileImprovement;
        Tile tileForImprovement = this.cityScreen.getCity$core().getCityConstructions().getTileForImprovement(improvement2.getName());
        this.askToBuyConstruction(construction2, stat, tileForImprovement);
    }

    static /* synthetic */ void buyButtonOnClick$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = buyButtonFactory.preferredBuyStat;
        }
        buyButtonFactory.buyButtonOnClick(iNonPerpetualConstruction, stat);
    }

    public final void askToBuyConstruction(@NotNull INonPerpetualConstruction construction2, @NotNull Stat stat, @Nullable Tile tile) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        Intrinsics.checkNotNullParameter(stat, "stat");
        if (!this.isConstructionPurchaseShown(construction2, stat)) {
            return;
        }
        City city2 = this.cityScreen.getCity$core();
        Integer n = construction2.getStatBuyCost(city2, stat);
        Intrinsics.checkNotNull(n);
        int constructionStatBuyCost = n;
        if (!city2.getCityConstructions().isConstructionPurchaseAllowed(construction2, stat, constructionStatBuyCost)) {
            return;
        }
        PopupKt.closeAllPopups(this.cityScreen);
        new ConfirmBuyPopup(construction2, stat, constructionStatBuyCost, tile);
    }

    public static /* synthetic */ void askToBuyConstruction$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = buyButtonFactory.preferredBuyStat;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        buyButtonFactory.askToBuyConstruction(iNonPerpetualConstruction, stat, tile);
    }

    private final boolean isConstructionPurchaseShown(INonPerpetualConstruction construction2, Stat stat) {
        City city2 = this.cityScreen.getCity$core();
        return construction2.canBePurchasedWithStat(city2, stat);
    }

    private final void purchaseConstruction(INonPerpetualConstruction construction2, Stat stat, Tile tile) {
        block6: {
            IConstruction newConstruction;
            City city2;
            block5: {
                SoundPlayer.INSTANCE.play(stat.getPurchaseSound());
                city2 = this.cityScreen.getCity$core();
                if (!city2.getCityConstructions().purchaseConstruction(construction2, this.cityScreen.getSelectedQueueEntry(), false, stat, tile)) {
                    Popup popup2;
                    Popup $this$purchaseConstruction_u24lambda_u241 = popup2 = new Popup(this.cityScreen, null, 0.0f, 6, null);
                    boolean bl = false;
                    $this$purchaseConstruction_u24lambda_u241.add((CharSequence)TranslationsKt.tr$default("No space available to place [" + construction2.getName() + "] near [" + city2.getName() + ']', false, false, 3, null)).row();
                    Popup.addCloseButton$default($this$purchaseConstruction_u24lambda_u241, null, null, null, null, 15, null);
                    Popup.open$default($this$purchaseConstruction_u24lambda_u241, false, 1, null);
                    return;
                }
                if (this.cityScreen.getSelectedQueueEntry() >= 0) break block5;
                IConstruction iConstruction = this.cityScreen.getSelectedConstruction();
                if (iConstruction != null ? iConstruction.isBuildable(city2.getCityConstructions()) : false) break block6;
            }
            this.cityScreen.setSelectedQueueEntry(-1);
            this.cityScreen.clearSelection();
            city2.getCityConstructions().chooseNextConstruction();
            if (((CharSequence)city2.getCityConstructions().getCurrentConstructionFromQueue()).length() > 0 && (newConstruction = city2.getCityConstructions().getCurrentConstruction()) instanceof INonPerpetualConstruction) {
                this.cityScreen.selectConstruction(newConstruction);
            }
        }
        City.reassignPopulation$default(this.cityScreen.getCity$core(), false, 1, null);
        this.cityScreen.update$core();
    }

    static /* synthetic */ void purchaseConstruction$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        buyButtonFactory.purchaseConstruction(iNonPerpetualConstruction, stat, tile);
    }

    public static final /* synthetic */ void access$buyButtonOnClick(BuyButtonFactory $this, INonPerpetualConstruction construction2, Stat stat) {
        $this.buyButtonOnClick(construction2, stat);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory$ConfirmBuyPopup;", "Lcom/unciv/ui/popups/Popup;", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "Lcom/unciv/models/stats/Stat;", "constructionStatBuyCost", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;Lcom/unciv/models/ruleset/INonPerpetualConstruction;Lcom/unciv/models/stats/Stat;ILcom/unciv/logic/map/tile/Tile;)V", "core"})
    private final class ConfirmBuyPopup
    extends Popup {
        public ConfirmBuyPopup(final @NotNull INonPerpetualConstruction construction2, final Stat stat, @Nullable int constructionStatBuyCost, final Tile tile) {
            Intrinsics.checkNotNullParameter(construction2, "construction");
            Intrinsics.checkNotNullParameter(stat, "stat");
            super(BuyButtonFactory.this.getCityScreen().getStage(), null, 0.0f, 6, null);
            City city2 = BuyButtonFactory.this.getCityScreen().getCity$core();
            int balance = city2.getStatReserve(stat);
            Religion majorityReligion = city2.getReligion().getMajorityReligion();
            Religion yourReligion = city2.getCiv().getReligionManager().getReligion();
            boolean isBuyingWithFaithForForeignReligion = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)construction2, UniqueType.ReligiousUnit, null, 2, null) && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)construction2, UniqueType.TakeReligionOverBirthCity, null, 2, null) && !Intrinsics.areEqual(majorityReligion, yourReligion);
            Popup.addGoodSizedLabel$default(this, "Currently you have [" + balance + "] [" + stat.name() + "].", 0, false, 6, null).padBottom(10.0f).row();
            if (isBuyingWithFaithForForeignReligion) {
                Popup.addGoodSizedLabel$default(this, "You are buying a religious unit in a city that doesn't follow the religion you founded ([" + ConfirmBuyPopup._init_$getName(yourReligion) + "]). This means that the unit is tied to that foreign religion ([" + ConfirmBuyPopup._init_$getName(majorityReligion) + "]) and will be less useful.", 0, false, 6, null).row();
                Cell $this$_init__u24lambda_u240 = Popup.addGoodSizedLabel$default(this, "Are you really sure you want to purchase this unit?", 24, false, 4, null);
                boolean bl = false;
                ((Label)$this$_init__u24lambda_u240.getActor()).setColor(Color.FIREBRICK);
                $this$_init__u24lambda_u240.padBottom(10.0f);
                $this$_init__u24lambda_u240.row();
            }
            Popup.addGoodSizedLabel$default(this, "Would you like to purchase [" + construction2.getName() + "] for [" + constructionStatBuyCost + "] [" + stat.getCharacter() + "]?", 0, false, 6, null).row();
            this.addCloseButton("Cancel", KeyboardBinding.Cancel, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    BuyButtonFactory.this.getCityScreen().update$core();
                }
            });
            TextButton.TextButtonStyle confirmStyle = BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class);
            this.addOKButton("Purchase", KeyboardBinding.Confirm, confirmStyle, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    BuyButtonFactory.this.purchaseConstruction(construction2, stat, tile);
                }
            });
            this.equalizeLastTwoButtonWidths();
            this.open(true);
        }

        private static final String _init_$getName(Religion $this$_init__u24getName) {
            Object object = $this$_init__u24getName;
            if (object == null || (object = ((Religion)object).getReligionDisplayName()) == null) {
                object = "???";
            }
            return object;
        }
    }
}

