/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.models.Counter;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.CityScreenConstructionMenu;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.BuyButtonFactory;
import com.unciv.ui.screens.cityscreen.CityConstructionsTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.cityscreen.ConstructionButtonDTO;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J \u0010.\u001a\u00020\u00112\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-H\u0002J\b\u00101\u001a\u00020(H\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u0012\u0012\u0004\u0012\u00020406j\b\u0012\u0004\u0012\u000204`7H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020<H\u0002J \u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020<2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u0010@\u001a\u00020\u001aJ<\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020D2\u0006\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020<2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0FH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020<H\u0002J\u0018\u0010J\u001a\u00020\b2\u0006\u0010>\u001a\u00020 2\u0006\u0010I\u001a\u00020<H\u0002J \u0010K\u001a\u00020\b2\u0006\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020<2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u0010L\u001a\u00020\b2\u0006\u0010>\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J\n\u0010M\u001a\u0004\u0018\u00010NH\u0002J\u0006\u0010O\u001a\u00020\u001aJ\"\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u0011H\u0002J\u0018\u0010T\u001a\u00020(2\u0006\u0010U\u001a\u00020\b2\u0006\u0010R\u001a\u00020\u0011H\u0002J\b\u0010V\u001a\u00020\u0011H\u0002J\b\u0010W\u001a\u00020(H\u0002J \u0010X\u001a\u00020(2\u0006\u0010>\u001a\u00020 2\u000e\b\u0002\u0010Y\u001a\b\u0012\u0004\u0012\u00020(0ZH\u0002J\u0010\u0010[\u001a\u00020(2\b\u0010\\\u001a\u0004\u0018\u00010+J\b\u0010]\u001a\u00020(H\u0002J\u0012\u0010^\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\b\u0010_\u001a\u00020(H\u0002J\u0012\u0010`\u001a\u00020(2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0016\u0010a\u001a\u00020(2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020<0cH\u0002JF\u0010d\u001a\u00020(*\u00020\b2\u0006\u0010;\u001a\u00020<2\u0016\u0010e\u001a\u0012\u0012\u0004\u0012\u00020\b06j\b\u0012\u0004\u0012\u00020\b`72\u0006\u0010f\u001a\u00020\u001a2\u0006\u0010g\u001a\u00020D2\b\b\u0002\u0010h\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i\u00b2\u0006\n\u0010j\u001a\u00020kX\u008a\u0084\u0002"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityConstructionsTable;", "", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "availableConstructionsScrollPane", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "availableConstructionsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "buttonsTable", "buyButtonFactory", "Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;", "constructionsQueueScrollPane", "constructionsQueueTable", "highlightColor", "Lcom/badlogic/gdx/graphics/Color;", "value", "", "isVisible", "()Z", "setVisible", "(Z)V", "lowerTable", "lowerTableScrollCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "miniQueueHeight", "", "pad", "posFromEdge", "queueExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "selectedQueueEntry", "", "getSelectedQueueEntry", "()I", "setSelectedQueueEntry", "(I)V", "stageHeight", "upperTable", "addActorsToStage", "", "addConstructionToQueue", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "cannotAddConstructionToQueue", "city", "Lcom/unciv/logic/city/City;", "ensureQueueEntryVisible", "getConstructionButton", "constructionButtonDTO", "Lcom/unciv/ui/screens/cityscreen/ConstructionButtonDTO;", "getConstructionButtonDTOs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getConstructionSound", "Lcom/unciv/models/UncivSound;", "getHeader", "title", "", "getLowerPriorityButton", "constructionQueueIndex", "name", "getLowerWidth", "getMovePriorityButton", "arrowDirection", "binding", "Lcom/unciv/ui/components/input/KeyboardBinding;", "movePriority", "Lkotlin/Function1;", "getProgressBar", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "constructionName", "getQueueEntry", "getRaisePriorityButton", "getRemoveFromQueueButton", "getSelectedQueueButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getUpperWidth", "highlightConstructionButton", "pickConstructionButton", "highlight", "clearOthers", "highlightQueueEntry", "queueEntry", "isSelectedQueueEntry", "resizeAvailableConstructionsScrollPane", "selectQueueEntry", "onBeforeUpdate", "Lkotlin/Function0;", "update", "selectedConstruction", "updateAvailableConstructions", "updateButtons", "updateConstructionQueue", "updateQueueAndButtons", "updateQueuePreview", "queue", "", "addCategory", "list", "prefWidth", "toggleKey", "startsOutOpened", "core", "unselected", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;"})
@SourceDebugExtension(value={"SMAP\nCityConstructionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityConstructionsTable.kt\ncom/unciv/ui/screens/cityscreen/CityConstructionsTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,797:1\n1864#2,3:798\n1864#2,3:801\n766#2:818\n857#2,2:819\n766#2:822\n857#2,2:823\n1549#2:825\n1620#2,3:826\n800#2,11:829\n800#2,11:840\n800#2,11:851\n1839#3,14:804\n1#4:821\n*S KotlinDebug\n*F\n+ 1 CityConstructionsTable.kt\ncom/unciv/ui/screens/cityscreen/CityConstructionsTable\n*L\n222#1:798,3\n250#1:801,3\n313#1:818\n313#1:819,2\n519#1:822\n519#1:823,2\n519#1:825\n519#1:826,3\n623#1:829,11\n625#1:840,11\n633#1:851,11\n300#1:804,14\n*E\n"})
public final class CityConstructionsTable {
    @NotNull
    private final CityScreen cityScreen;
    private int selectedQueueEntry;
    @NotNull
    private final Table upperTable;
    @NotNull
    private final AutoScrollPane constructionsQueueScrollPane;
    @NotNull
    private final Table constructionsQueueTable;
    @NotNull
    private final ExpanderTab queueExpander;
    @NotNull
    private final Table buttonsTable;
    @NotNull
    private final BuyButtonFactory buyButtonFactory;
    @NotNull
    private final Table lowerTable;
    @NotNull
    private final AutoScrollPane availableConstructionsScrollPane;
    @NotNull
    private final Table availableConstructionsTable;
    @NotNull
    private final Cell<AutoScrollPane> lowerTableScrollCell;
    private final float pad;
    private final float miniQueueHeight;
    private final float posFromEdge;
    private final float stageHeight;
    @NotNull
    private final Color highlightColor;

    public CityConstructionsTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.selectedQueueEntry = -1;
        this.upperTable = new Table(BaseScreen.Companion.getSkin());
        this.constructionsQueueTable = new Table();
        this.buttonsTable = new Table();
        this.buyButtonFactory = new BuyButtonFactory(this.cityScreen);
        this.lowerTable = new Table();
        this.availableConstructionsTable = new Table();
        this.pad = 10.0f;
        this.miniQueueHeight = 54.0f;
        this.posFromEdge = 5.0f;
        this.stageHeight = this.cityScreen.getStage().getHeight();
        Color color = Color.GREEN;
        Intrinsics.checkNotNullExpressionValue(color, "GREEN");
        this.highlightColor = Scene2dExtensionsKt.darken(color, 0.4f);
        Actor actor = this.constructionsQueueTable;
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
        this.constructionsQueueScrollPane = new AutoScrollPane((Actor)Scene2dExtensionsKt.addBorder$default(actor, 2.0f, color2, false, 4, null), null, 2, null);
        this.constructionsQueueScrollPane.setOverscroll(false, false);
        this.constructionsQueueTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/ConstructionsQueueTable", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
        float f = this.miniQueueHeight;
        this.queueExpander = new ExpanderTab("Construction queue", 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, f, null, null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                cityScreen.update$core();
            }
        }, null, 5862, null);
        this.upperTable.defaults().left().top();
        this.upperTable.add((Actor)this.constructionsQueueScrollPane).padBottom(this.pad).maxHeight(this.stageHeight * (float)3 / (float)4).row();
        this.upperTable.add((Actor)this.buttonsTable).height(Scene2dExtensionsKt.toTextButton$default("", null, false, 3, null).getHeight()).padBottom(this.pad).row();
        Actor actor2 = this.availableConstructionsTable;
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
        this.availableConstructionsScrollPane = new AutoScrollPane((Actor)Scene2dExtensionsKt.addBorder$default(actor2, 2.0f, color3, false, 4, null), null, 2, null);
        this.availableConstructionsScrollPane.setOverscroll(false, false);
        this.availableConstructionsTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/AvailableConstructionsTable", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
        Cell<Actor> cell2 = this.lowerTable.add((Actor)this.availableConstructionsScrollPane).bottom();
        Intrinsics.checkNotNullExpressionValue(cell2, "bottom(...)");
        this.lowerTableScrollCell = cell2;
        this.lowerTable.row();
    }

    public final int getSelectedQueueEntry() {
        return this.selectedQueueEntry;
    }

    public final void setSelectedQueueEntry(int n) {
        this.selectedQueueEntry = n;
    }

    public final boolean isVisible() {
        return this.upperTable.isVisible();
    }

    public final void setVisible(boolean value) {
        this.upperTable.setVisible(value);
        this.lowerTable.setVisible(value);
    }

    public final float getUpperWidth() {
        return Scene2dExtensionsKt.packIfNeeded(this.upperTable).getWidth();
    }

    public final float getLowerWidth() {
        return Math.max(Scene2dExtensionsKt.packIfNeeded(this.lowerTable).getWidth(), this.getUpperWidth());
    }

    public final void addActorsToStage() {
        this.cityScreen.getStage().addActor(this.upperTable);
        this.cityScreen.getStage().addActor(this.lowerTable);
        this.lowerTable.setPosition(this.posFromEdge, this.posFromEdge, 12);
    }

    public final void update(@Nullable IConstruction selectedConstruction) {
        this.updateQueueAndButtons(selectedConstruction);
        this.updateAvailableConstructions();
    }

    private final void updateQueueAndButtons(IConstruction construction2) {
        this.updateButtons(construction2);
        this.updateConstructionQueue();
        this.upperTable.pack();
        this.upperTable.setPosition(this.posFromEdge, this.stageHeight - this.posFromEdge, 10);
        this.lowerTableScrollCell.maxHeight(RangesKt.coerceAtLeast(this.stageHeight - this.upperTable.getHeight() - (float)2 * this.posFromEdge, 20.0f));
    }

    private final void updateButtons(IConstruction construction2) {
        if (!this.cityScreen.getCanChangeState()) {
            return;
        }
        if (this.cityScreen.getCity$core().isPuppet() && !SequencesKt.any(City.getMatchingUniques$default(this.cityScreen.getCity$core(), UniqueType.MayBuyConstructionsInPuppets, null, false, 6, null))) {
            return;
        }
        this.buttonsTable.clear();
        for (TextButton button : this.buyButtonFactory.getBuyButtons(construction2)) {
            this.buttonsTable.add((Actor)button).width(120.0f).padRight(10.0f);
        }
        List<String> queue = this.cityScreen.getCity$core().getCityConstructions().getConstructionQueue();
        int button = queue.size();
        int n = this.selectedQueueEntry;
        boolean bl = 0 <= n ? n < button : false;
        if (bl && queue.size() > 1) {
            String constructionName = queue.get(this.selectedQueueEntry);
            Table raiseButton = this.getRaisePriorityButton(this.selectedQueueEntry, constructionName, this.cityScreen.getCity$core());
            Scene2dExtensionsKt.setEnabled(raiseButton, this.cityScreen.canCityBeChanged() && this.selectedQueueEntry > 0);
            this.buttonsTable.add((Actor)raiseButton).padRight(5.0f);
            Table lowerButton = this.getLowerPriorityButton(this.selectedQueueEntry, constructionName, this.cityScreen.getCity$core());
            Scene2dExtensionsKt.setEnabled(lowerButton, this.selectedQueueEntry != CollectionsKt.getLastIndex(queue) && this.cityScreen.canCityBeChanged());
            this.buttonsTable.add((Actor)lowerButton).padRight(5.0f);
            if (this.cityScreen.canCityBeChanged() && !this.queueExpander.isOpen()) {
                int n2 = this.selectedQueueEntry;
                boolean bl2 = 1 <= n2 ? n2 < 5 : false;
                if (bl2) {
                    this.buttonsTable.add((Actor)this.getRemoveFromQueueButton(this.selectedQueueEntry, this.cityScreen.getCity$core())).padLeft(10.0f);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConstructionQueue() {
        float queueScrollY = this.constructionsQueueScrollPane.getScrollY();
        this.constructionsQueueTable.clear();
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        String currentConstruction = cityConstructions.getCurrentConstructionFromQueue();
        List<String> queue = cityConstructions.getConstructionQueue();
        this.constructionsQueueTable.defaults().pad(0.0f);
        this.constructionsQueueTable.add((Actor)this.getHeader("Current construction")).fillX();
        Scene2dExtensionsKt.addSeparator$default(this.constructionsQueueTable, null, 0, 0.0f, 7, null);
        if (!Intrinsics.areEqual(currentConstruction, "")) {
            this.constructionsQueueTable.add((Actor)this.getQueueEntry(0, currentConstruction)).expandX().fillX().row();
        } else {
            this.constructionsQueueTable.add((Actor)Scene2dExtensionsKt.toLabel("Pick a construction")).height(50.0f).pad(2.0f).row();
        }
        this.queueExpander.getInnerTable().clear();
        this.queueExpander.getHeaderContent().clear();
        this.queueExpander.setHeaderIconVisible(queue.size() >= 2);
        this.queueExpander.getHeader().pad(0.0f);
        this.queueExpander.setText(TranslationsKt.tr$default("Construction queue", false, false, 3, null));
        Iterable $this$forEachIndexed$iv = queue;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void constructionName;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            if (i == 0) continue;
            this.queueExpander.getInnerTable().add((Actor)this.getQueueEntry(i, (String)constructionName)).expandX().fillX().row();
            if (i == CollectionsKt.getLastIndex(queue)) continue;
            Scene2dExtensionsKt.addSeparator$default(this.queueExpander.getInnerTable(), null, 0, 0.0f, 7, null);
        }
        if (!this.queueExpander.isOpen()) {
            this.updateQueuePreview(queue);
        }
        this.constructionsQueueTable.add((Actor)this.queueExpander).fillX().pad(2.0f);
        this.constructionsQueueScrollPane.layout();
        this.constructionsQueueScrollPane.setScrollY(queueScrollY);
        this.constructionsQueueScrollPane.updateVisualScroll();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateQueuePreview(List<String> queue) {
        this.queueExpander.getHeader().pad(-5.0f, 0.0f, -5.0f, 0.0f);
        int n = queue.size();
        String title = (0 <= n ? n < 2 : false) ? TranslationsKt.tr$default("Queue empty", false, false, 3, null) : ((2 <= n ? n < 5 : false) ? TranslationsKt.tr$default("Queue", false, false, 3, null) : "");
        this.queueExpander.setText(title);
        Iterable $this$forEachIndexed$iv = queue;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n2;
            boolean bl = false;
            boolean bl2 = 1 <= i ? i < 4 : false;
            if (bl2) {
                void constructionName;
                Color color = this.selectedQueueEntry == i ? this.highlightColor : BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
                IconCircleGroup image2 = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.INSTANCE.getConstructionPortrait((String)constructionName, 40.0f), this.miniQueueHeight, false, color, null, 8, null);
                image2.addListener(new ClickListener(this, (String)constructionName, i){
                    final /* synthetic */ CityConstructionsTable this$0;
                    final /* synthetic */ String $constructionName;
                    final /* synthetic */ int $i;
                    {
                        this.this$0 = $receiver;
                        this.$constructionName = $constructionName;
                        this.$i = $i;
                    }

                    public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, int button) {
                        Intrinsics.checkNotNullParameter(event, "event");
                        event.stop();
                        return super.touchDown(event, x, y, pointer, button);
                    }

                    public void touchUp(@NotNull InputEvent event, float x, float y, int pointer, int button) {
                        Intrinsics.checkNotNullParameter(event, "event");
                        CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$constructionName);
                        this.this$0.setSelectedQueueEntry(this.$i);
                        CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                        event.stop();
                        super.touchUp(event, x, y, pointer, button);
                    }
                });
                this.queueExpander.getHeaderContent().add((Actor)image2);
            }
            if (i != 4) continue;
            this.queueExpander.getHeaderContent().add((Actor)Scene2dExtensionsKt.toLabel("(+{" + (queue.size() - i) + "})"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<ConstructionButtonDTO> getConstructionButtonDTOs() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String buttonText;
        Object entry;
        ArrayList<ConstructionButtonDTO> constructionButtonDTOList = new ArrayList<ConstructionButtonDTO>();
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        Collection<BaseUnit> collection = city2.getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
        Collection<Building> collection2 = city2.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Sequence constructionsSequence = SequencesKt.plus(sequence, CollectionsKt.asSequence((Iterable)collection2));
        CityStats.updateTileStats$default(city2.getCityStats(), null, 1, null);
        Iterator<Object> iterator2 = SequencesKt.filter(constructionsSequence, new Function1<?, Boolean>(cityConstructions){
            final /* synthetic */ CityConstructions $cityConstructions;
            {
                this.$cityConstructions = $cityConstructions;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IHasUniques it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ((INonPerpetualConstruction)it).shouldBeDisplayed(this.$cityConstructions);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Object v3;
            void $this$minByOrNull$iv;
            entry = (IHasUniques)iterator2.next();
            boolean useStoredProduction = entry instanceof Building || !cityConstructions.isBeingConstructedOrEnqueued(((INonPerpetualConstruction)entry).getName());
            buttonText = ((Object)StringsKt.trim((CharSequence)cityConstructions.getTurnsToConstructionString$core((IConstruction)entry, useStoredProduction))).toString();
            Counter<String> resourcesRequired = entry instanceof BaseUnit ? ((INonPerpetualConstruction)entry).getResourceRequirementsPerTurn(city2.getCiv().getState()) : ((INonPerpetualConstruction)entry).getResourceRequirementsPerTurn(city2.getState());
            Sequence<RejectionReason> sequence2 = SequencesKt.filter(((INonPerpetualConstruction)entry).getRejectionReasons(cityConstructions), getConstructionButtonDTOs.mostImportantRejection.1.INSTANCE);
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    RejectionReason it = (RejectionReason)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getRejectionPrecedence();
                    do {
                        Object e$iv = iterator$iv.next();
                        RejectionReason it2 = (RejectionReason)e$iv;
                        $i$a$-minByOrNull-CityConstructionsTable$getConstructionButtonDTOs$mostImportantRejection$2 = false;
                        int v$iv = it2.getRejectionPrecedence();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            RejectionReason mostImportantRejection2 = v3;
            constructionButtonDTOList.add(new ConstructionButtonDTO((IConstruction)entry, buttonText, (HashMap<String, Integer>)(resourcesRequired.isEmpty() ? null : resourcesRequired), mostImportantRejection2));
        }
        entry = PerpetualConstruction.Companion.getPerpetualConstructionsMap().values();
        boolean $i$f$filter = false;
        buttonText = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerpetualConstruction it = (PerpetualConstruction)element$iv$iv;
            boolean bl = false;
            if (!it.shouldBeDisplayed(cityConstructions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PerpetualConstruction specialConstruction : (List)destination$iv$iv) {
            constructionButtonDTOList.add(new ConstructionButtonDTO(specialConstruction, TranslationsKt.tr$default("Produce [" + specialConstruction.getName() + ']', false, false, 3, null) + ' ' + ((Object)StringsKt.trim((CharSequence)PerpetualConstruction.getProductionTooltip$default(specialConstruction, city2, false, 2, null))).toString(), null, null, 12, null));
        }
        return constructionButtonDTOList;
    }

    private final void updateAvailableConstructions() {
        float constructionsScrollY = this.availableConstructionsScrollPane.getScrollY();
        if (!this.availableConstructionsTable.hasChildren()) {
            this.availableConstructionsTable.add((Actor)Scene2dExtensionsKt.toLabel("Loading...")).pad(10.0f);
        }
        Concurrency.run$default(Concurrency.INSTANCE, "Construction info gathering - " + this.cityScreen.getCity$core().getName(), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, constructionsScrollY, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ float $constructionsScrollY;
            {
                this.this$0 = $receiver;
                this.$constructionsScrollY = $constructionsScrollY;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        ArrayList constructionButtonDTOList = CityConstructionsTable.access$getConstructionButtonDTOs(this.this$0);
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (ArrayList<ConstructionButtonDTO>)constructionButtonDTOList, this.$constructionsScrollY, null){
                            int label;
                            final /* synthetic */ CityConstructionsTable this$0;
                            final /* synthetic */ ArrayList<ConstructionButtonDTO> $constructionButtonDTOList;
                            final /* synthetic */ float $constructionsScrollY;
                            {
                                this.this$0 = $receiver;
                                this.$constructionButtonDTOList = $constructionButtonDTOList;
                                this.$constructionsScrollY = $constructionsScrollY;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(var1_1);
                                        units = new ArrayList<Table>();
                                        buildableWonders = new ArrayList<E>();
                                        buildableNationalWonders = new ArrayList<E>();
                                        buildableBuildings = new ArrayList<E>();
                                        specialConstructions = new ArrayList<Table>();
                                        blacklisted = new ArrayList<Table>();
                                        disabledAutoAssignConstructions = GUI.INSTANCE.getSettings().getDisabledAutoAssignConstructions();
                                        maxButtonWidth = new Ref.FloatRef();
                                        maxButtonWidth.element = CityConstructionsTable.access$getConstructionsQueueTable$p(this.this$0).getWidth();
                                        for (ConstructionButtonDTO dto : this.$constructionButtonDTOList) {
                                            if (!(dto.getConstruction() instanceof Building)) ** GOTO lbl43
                                            v0 = dto.getRejectionReason();
                                            if ((v0 != null ? v0.getType() : null) != RejectionReasonType.RequiresBuildingInThisCity) ** GOTO lbl43
                                            var12_12 = this.$constructionButtonDTOList;
                                            var13_14 = this.this$0;
                                            $i$f$any = false;
                                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl25
                                            v1 = false;
                                            ** GOTO lbl42
lbl25:
                                            // 2 sources

                                            for (T element$iv : $this$any$iv) {
                                                it = (ConstructionButtonDTO)element$iv;
                                                $i$a$-any-CityConstructionsTable$updateAvailableConstructions$1$1$1 = false;
                                                if (!(it.getConstruction() instanceof Building)) ** GOTO lbl-1000
                                                if (Intrinsics.areEqual(it.getConstruction().getName(), ((Building)dto.getConstruction()).getRequiredBuilding()) || Intrinsics.areEqual(((Building)it.getConstruction()).getReplaces(), ((Building)dto.getConstruction()).getRequiredBuilding())) ** GOTO lbl-1000
                                                v2 = (Building)it.getConstruction();
                                                v3 = ((Building)dto.getConstruction()).getRequiredBuilding();
                                                Intrinsics.checkNotNull(v3);
                                                if (v2.hasUnique(v3, CityConstructionsTable.access$getCityScreen$p((CityConstructionsTable)var13_14).getCity$core().getState())) lbl-1000:
                                                // 2 sources

                                                {
                                                    v4 = true;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    v4 = false;
                                                }
                                                if (!v4) continue;
                                                v1 = true;
                                                ** GOTO lbl42
                                            }
                                            v1 = false;
lbl42:
                                            // 3 sources

                                            if (v1) continue;
lbl43:
                                            // 3 sources

                                            Intrinsics.checkNotNull(dto);
                                            constructionButton = CityConstructionsTable.access$getConstructionButton(this.this$0, dto);
                                            if (disabledAutoAssignConstructions.contains(dto.getConstruction().getName())) {
                                                blacklisted.add(constructionButton);
                                            } else {
                                                var13_14 = dto.getConstruction();
                                                if (var13_14 instanceof BaseUnit) {
                                                    units.add(constructionButton);
                                                } else if (var13_14 instanceof Building) {
                                                    if (((Building)dto.getConstruction()).isWonder()) {
                                                        ((Collection)buildableWonders).add(constructionButton);
                                                    } else if (((Building)dto.getConstruction()).isNationalWonder()) {
                                                        ((Collection)buildableNationalWonders).add(constructionButton);
                                                    } else {
                                                        ((Collection)buildableBuildings).add(constructionButton);
                                                    }
                                                } else if (var13_14 instanceof PerpetualConstruction) {
                                                    specialConstructions.add(constructionButton);
                                                }
                                            }
                                            maxButtonWidth.element = Math.max(maxButtonWidth.element, Scene2dExtensionsKt.packIfNeeded(constructionButton).getWidth());
                                        }
                                        var10_10 = CityConstructionsTable.access$getAvailableConstructionsTable$p(this.this$0);
                                        var11_11 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u241 = var10_10;
                                        $i$a$-apply-CityConstructionsTable$updateAvailableConstructions$1$1$2 = false;
                                        $this$invokeSuspend_u24lambda_u241.clear();
                                        $this$invokeSuspend_u24lambda_u241.defaults().left().bottom();
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Units", units, maxButtonWidth.element, KeyboardBinding.BuildUnits, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Buildings", buildableBuildings, maxButtonWidth.element, KeyboardBinding.BuildBuildings, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Wonders", buildableWonders, maxButtonWidth.element, KeyboardBinding.BuildWonders, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "National Wonders", buildableNationalWonders, maxButtonWidth.element, KeyboardBinding.BuildNationalWonders, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Other", specialConstructions, maxButtonWidth.element, KeyboardBinding.BuildOther, false, 16, null);
                                        CityConstructionsTable.access$addCategory(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Disabled", blacklisted, maxButtonWidth.element, KeyboardBinding.BuildDisabled, false);
                                        $this$invokeSuspend_u24lambda_u241.pack();
                                        var10_10 = CityConstructionsTable.access$getAvailableConstructionsScrollPane$p(this.this$0);
                                        var11_11 = this.this$0;
                                        var12_13 = this.$constructionsScrollY;
                                        $this$invokeSuspend_u24lambda_u242 = var10_10;
                                        $i$a$-apply-CityConstructionsTable$updateAvailableConstructions$1$1$3 = false;
                                        $this$invokeSuspend_u24lambda_u242.setSize(maxButtonWidth.element, Math.min(CityConstructionsTable.access$getAvailableConstructionsTable$p(var11_11).getPrefHeight(), CityConstructionsTable.access$getLowerTableScrollCell$p(var11_11).getMaxHeight()));
                                        $this$invokeSuspend_u24lambda_u242.layout();
                                        $this$invokeSuspend_u24lambda_u242.setScrollY(var12_13);
                                        $this$invokeSuspend_u24lambda_u242.updateVisualScroll();
                                        CityConstructionsTable.access$getLowerTable$p(this.this$0).pack();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final Table getQueueEntry(int constructionQueueIndex, String constructionName) {
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        Table table2 = new Table();
        table2.align(8).pad(5.0f);
        this.highlightQueueEntry(table2, constructionQueueIndex == this.selectedQueueEntry);
        IConstruction construction2 = cityConstructions.getConstruction$core(constructionName);
        boolean isFirstConstructionOfItsKind = cityConstructions.isFirstConstructionOfItsKind(constructionQueueIndex, constructionName);
        String text2 = TranslationsKt.tr$default(constructionName, true, false, 2, null) + (PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(constructionName) ? "\n\u221e" : cityConstructions.getTurnsToConstructionString$core(construction2, isFirstConstructionOfItsKind));
        Counter<String> constructionResource = construction2 instanceof BaseUnit ? construction2.getResourceRequirementsPerTurn(city2.getCiv().getState()) : construction2.getResourceRequirementsPerTurn(city2.getState());
        for (Map.Entry entry : ((Map)constructionResource).entrySet()) {
            TileResource resource2;
            String resourceName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (cityConstructions.getCity().getRuleset().getTileResources().get(resourceName) == null) continue;
            text2 = text2 + '\n' + TranslationsKt.tr$default(FormattingExtensionsKt.getConsumesAmountString(resourceName, amount, resource2.isStockpiled()), false, false, 3, null);
        }
        table2.defaults().pad(2.0f).minWidth(40.0f);
        if (isFirstConstructionOfItsKind) {
            table2.add((Actor)this.getProgressBar(constructionName)).minWidth(5.0f);
        } else {
            table2.add().minWidth(5.0f);
        }
        table2.add((Actor)ImageGetter.INSTANCE.getConstructionPortrait(constructionName, 40.0f)).padRight(10.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel(text2)).expandX().fillX().left();
        if (this.queueExpander.isOpen()) {
            if (constructionQueueIndex > 0 && this.cityScreen.canCityBeChanged()) {
                table2.add((Actor)this.getRaisePriorityButton(constructionQueueIndex, constructionName, city2)).right();
            } else {
                table2.add().right();
            }
            if (constructionQueueIndex != CollectionsKt.getLastIndex(cityConstructions.getConstructionQueue()) && this.cityScreen.canCityBeChanged()) {
                table2.add((Actor)this.getLowerPriorityButton(constructionQueueIndex, constructionName, city2)).right();
            } else {
                table2.add().right();
            }
        }
        if (this.cityScreen.canCityBeChanged()) {
            table2.add((Actor)this.getRemoveFromQueueButton(constructionQueueIndex, city2)).right();
        } else {
            table2.add().right();
        }
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, new Function0<Unit>(this, constructionQueueIndex){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ int $constructionQueueIndex;
            {
                this.this$0 = $receiver;
                this.$constructionQueueIndex = $constructionQueueIndex;
                super(0);
            }

            public final void invoke() {
                CityConstructionsTable.selectQueueEntry$default(this.this$0, this.$constructionQueueIndex, null, 2, null);
            }
        });
        if (this.cityScreen.canCityBeChanged()) {
            ActivationExtensionsKt.onRightClick$default(table2, null, new Function0<Unit>(this, constructionQueueIndex, table2, construction2){
                final /* synthetic */ CityConstructionsTable this$0;
                final /* synthetic */ int $constructionQueueIndex;
                final /* synthetic */ Table $table;
                final /* synthetic */ IConstruction $construction;
                {
                    this.this$0 = $receiver;
                    this.$constructionQueueIndex = $constructionQueueIndex;
                    this.$table = $table;
                    this.$construction = $construction;
                    super(0);
                }

                public final void invoke() {
                    CityConstructionsTable.access$selectQueueEntry(this.this$0, this.$constructionQueueIndex, new Function0<Unit>(this.this$0, this.$table, this.$construction){
                        final /* synthetic */ CityConstructionsTable this$0;
                        final /* synthetic */ Table $table;
                        final /* synthetic */ IConstruction $construction;
                        {
                            this.this$0 = $receiver;
                            this.$table = $table;
                            this.$construction = $construction;
                            super(0);
                        }

                        public final void invoke() {
                            new CityScreenConstructionMenu(CityConstructionsTable.access$getCityScreen$p(this.this$0).getStage(), (Actor)this.$table, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), this.$construction, new Function0<Unit>(this.this$0){
                                final /* synthetic */ CityConstructionsTable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                                    CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                                }
                            });
                        }
                    });
                }
            }, 1, null);
        }
        return table2;
    }

    private final void selectQueueEntry(int constructionQueueIndex, Function0<Unit> onBeforeUpdate) {
        boolean bl = 0 <= constructionQueueIndex ? constructionQueueIndex < this.cityScreen.getCity$core().getCityConstructions().getConstructionQueue().size() : false;
        if (bl) {
            this.cityScreen.selectConstructionFromQueue(constructionQueueIndex);
            this.selectedQueueEntry = constructionQueueIndex;
        } else {
            this.cityScreen.clearSelection();
            this.selectedQueueEntry = -1;
        }
        onBeforeUpdate.invoke();
        this.cityScreen.update$core();
        this.ensureQueueEntryVisible();
    }

    static /* synthetic */ void selectQueueEntry$default(CityConstructionsTable cityConstructionsTable, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function0 = selectQueueEntry.1.INSTANCE;
        }
        cityConstructionsTable.selectQueueEntry(n, function0);
    }

    private final void highlightQueueEntry(Table queueEntry, boolean highlight2) {
        queueEntry.setBackground(highlight2 ? (Drawable)SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/QueueEntrySelected", null, this.highlightColor, 2, null) : (Drawable)SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/QueueEntry", null, ImageGetter.INSTANCE.getCHARCOAL(), 2, null));
    }

    private final Group getProgressBar(String constructionName) {
        CityConstructions cityConstructions = this.cityScreen.getCity$core().getCityConstructions();
        IConstruction construction2 = cityConstructions.getConstruction$core(constructionName);
        if (construction2 instanceof PerpetualConstruction) {
            return new Table();
        }
        if (cityConstructions.getWorkDone(constructionName) == 0) {
            return new Table();
        }
        float f = cityConstructions.getWorkDone(constructionName);
        Intrinsics.checkNotNull(construction2, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
        float constructionPercentage = f / (float)((INonPerpetualConstruction)construction2).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
        Color color = Color.BROWN;
        Intrinsics.checkNotNullExpressionValue(color, "BROWN");
        Color color2 = Scene2dExtensionsKt.brighten(color, 0.5f);
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
        return ImageGetter.getProgressBarVertical$default(ImageGetter.INSTANCE, 2.0f, 30.0f, constructionPercentage, color2, color3, 0.0f, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Table getConstructionButton(ConstructionButtonDTO constructionButtonDTO) {
        Color color;
        int amount;
        String string;
        Object object;
        Color textColor;
        Table table2;
        IConstruction construction2 = constructionButtonDTO.getConstruction();
        Table $this$getConstructionButton_u24lambda_u244 = table2 = new Table();
        boolean bl = false;
        $this$getConstructionButton_u24lambda_u244.setTransform(false);
        $this$getConstructionButton_u24lambda_u244.align(8).pad(5.0f);
        $this$getConstructionButton_u24lambda_u244.setTouchable(Touchable.enabled);
        Table pickConstructionButton = table2;
        CityConstructionsTable.highlightConstructionButton$default(this, pickConstructionButton, !this.isSelectedQueueEntry() && Intrinsics.areEqual(this.cityScreen.getSelectedConstruction(), construction2), false, 4, null);
        Group icon = ImageGetter.INSTANCE.getConstructionPortrait(construction2.getName(), 40.0f);
        pickConstructionButton.add((Actor)this.getProgressBar(construction2.getName())).padRight(5.0f);
        pickConstructionButton.add((Actor)icon).padRight(10.0f);
        Table $this$getConstructionButton_u24lambda_u245 = bl = new Table();
        boolean bl2 = false;
        $this$getConstructionButton_u24lambda_u245.setTransform(false);
        Table constructionTable = bl;
        Table $this$getConstructionButton_u24lambda_u246 = $this$getConstructionButton_u24lambda_u245 = new Table();
        boolean bl322 = false;
        $this$getConstructionButton_u24lambda_u246.setTransform(false);
        Table resourceTable = $this$getConstructionButton_u24lambda_u245;
        Color color2 = textColor = constructionButtonDTO.getRejectionReason() == null ? Color.WHITE : Color.RED;
        if (construction2 instanceof Building) {
            void $this$map$iv;
            Stat it;
            Iterable $this$filter$iv;
            Iterable bl322 = Stat.getEntries();
            object = new StringBuilder().append(' ');
            boolean $i$f$filter = false;
            void var11_17 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : var11_17) {
                it = (Stat)element$iv$iv;
                boolean bl4 = false;
                if (!((Building)construction2).isStatRelated(it, this.cityScreen.getCity$core())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            void var11_18 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : var11_18) {
                it = (Stat)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(Character.valueOf(it.getCharacter()));
            }
            string = ((StringBuilder)object).append(CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null)).toString();
        } else {
            string = "";
        }
        String statIcons = string;
        String constructionNameText = TranslationsKt.tr$default(construction2.getName(), true, false, 2, null) + statIcons;
        Intrinsics.checkNotNull(textColor);
        Iterator $i$f$map = Scene2dExtensionsKt.toLabel$default(constructionNameText, textColor, 0, 0, true, 6, null);
        Label label2 = $i$f$map;
        object = constructionTable;
        boolean bl6 = false;
        label2.setWrap(true);
        ((Table)object).add((Actor)((Object)$i$f$map)).width(this.cityScreen.getStage().getWidth() / (float)5).expandX().left().row();
        resourceTable.add((Actor)Scene2dExtensionsKt.toLabel(constructionButtonDTO.getButtonText())).expandX().left();
        if (constructionButtonDTO.getResourcesRequired() != null) {
            for (Map.Entry entry : ((Map)constructionButtonDTO.getResourcesRequired()).entrySet()) {
                String resource2 = (String)entry.getKey();
                amount = ((Number)entry.getValue()).intValue();
                RejectionReason rejectionReason = constructionButtonDTO.getRejectionReason();
                color = (rejectionReason != null ? rejectionReason.getType() : null) == RejectionReasonType.ConsumesResources ? Color.RED : Color.WHITE;
                String string2 = TranslationsKt.tr(amount);
                Intrinsics.checkNotNull(color);
                resourceTable.add((Actor)Scene2dExtensionsKt.toLabel$default(string2, color, 0, 0, false, 14, null)).expandX().left().padLeft(5.0f);
                resourceTable.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource2, 15.0f, 0, 4, null)).padBottom(1.0f);
            }
        }
        for (Map.Entry entry : ((Map)constructionButtonDTO.getConstruction().getStockpiledResourceRequirements(this.cityScreen.getCity$core().getState())).entrySet()) {
            String resourceName = (String)entry.getKey();
            amount = ((Number)entry.getValue()).intValue();
            RejectionReason rejectionReason = constructionButtonDTO.getRejectionReason();
            color = (rejectionReason != null ? rejectionReason.getType() : null) == RejectionReasonType.ConsumesResources ? Color.RED : Color.WHITE;
            String string3 = String.valueOf(amount);
            Intrinsics.checkNotNull(color);
            resourceTable.add((Actor)new ColorMarkupLabel(string3, color, null, 0, 12, null)).expandX().left().padLeft(5.0f);
            resourceTable.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resourceName, 15.0f, 0, 4, null)).padBottom(1.0f);
        }
        constructionTable.add((Actor)resourceTable).expandX().left();
        pickConstructionButton.add((Actor)constructionTable).expandX().left();
        if (!this.cannotAddConstructionToQueue(construction2, this.cityScreen.getCity$core(), this.cityScreen.getCity$core().getCityConstructions())) {
            Image image2;
            Image $this$getConstructionButton_u24lambda_u2410 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/New", null, 2, null);
            boolean bl7 = false;
            $this$getConstructionButton_u24lambda_u2410.setColor(ImageGetter.INSTANCE.getCHARCOAL());
            IconCircleGroup addToQueueButton = Scene2dExtensionsKt.surroundWithCircle$default(image2, 40.0f, false, null, null, 14, null);
            ActivationExtensionsKt.onClick(addToQueueButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, construction2){
                final /* synthetic */ CityConstructionsTable this$0;
                final /* synthetic */ IConstruction $construction;
                {
                    this.this$0 = $receiver;
                    this.$construction = $construction;
                    super(0);
                }

                public final void invoke() {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                }
            });
            pickConstructionButton.add((Actor)addToQueueButton);
        }
        pickConstructionButton.row();
        if (constructionButtonDTO.getRejectionReason() != null) {
            pickConstructionButton.getColor().a = 0.9f;
            icon.getColor().a = 0.5f;
            if (constructionButtonDTO.getRejectionReason().getType() != RejectionReasonType.ConsumesResources) {
                ColorMarkupLabel colorMarkupLabel;
                String string4 = constructionButtonDTO.getRejectionReason().getErrorMessage();
                Color color3 = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color3, "RED");
                ColorMarkupLabel colorMarkupLabel2 = colorMarkupLabel = new ColorMarkupLabel(string4, color3, null, 0, 12, null);
                object = pickConstructionButton;
                boolean bl8 = false;
                colorMarkupLabel2.setWrap(true);
                ((Table)object).add((Actor)colorMarkupLabel).colspan(pickConstructionButton.getColumns()).width(this.cityScreen.getStage().getWidth() / (float)4).fillX().left().padTop(2.0f);
            }
        }
        ActivationExtensionsKt.onClick(pickConstructionButton, new Function0<Unit>(this, construction2, pickConstructionButton){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ IConstruction $construction;
            final /* synthetic */ Table $pickConstructionButton;
            {
                this.this$0 = $receiver;
                this.$construction = $construction;
                this.$pickConstructionButton = $pickConstructionButton;
                super(0);
            }

            public final void invoke() {
                if (Intrinsics.areEqual(CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction(), this.$construction)) {
                    CityConstructionsTable.access$addConstructionToQueue(this.this$0, this.$construction, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core().getCityConstructions());
                } else {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                    CityConstructionsTable.access$highlightConstructionButton(this.this$0, this.$pickConstructionButton, true, true);
                }
                this.this$0.setSelectedQueueEntry(-1);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        if (!this.cityScreen.canCityBeChanged()) {
            return pickConstructionButton;
        }
        ActivationExtensionsKt.onRightClick$default(pickConstructionButton, null, new Function0<Unit>(this, construction2, pickConstructionButton){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ IConstruction $construction;
            final /* synthetic */ Table $pickConstructionButton;
            {
                this.this$0 = $receiver;
                this.$construction = $construction;
                this.$pickConstructionButton = $pickConstructionButton;
                super(0);
            }

            public final void invoke() {
                if (!Intrinsics.areEqual(CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction(), this.$construction)) {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                    CityConstructionsTable.access$highlightConstructionButton(this.this$0, this.$pickConstructionButton, true, true);
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).updateWithoutConstructionAndMap$core();
                }
                new CityScreenConstructionMenu(CityConstructionsTable.access$getCityScreen$p(this.this$0).getStage(), (Actor)this.$pickConstructionButton, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), this.$construction, new Function0<Unit>(this.this$0){
                    final /* synthetic */ CityConstructionsTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                        CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                    }
                });
            }
        }, 1, null);
        return pickConstructionButton;
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightConstructionButton(Table pickConstructionButton, boolean highlight2, boolean clearOthers) {
        Object button2;
        void $this$filterIsInstanceTo$iv$iv;
        Lazy unselected$delegate = LazyKt.lazy(highlightConstructionButton.unselected.2.INSTANCE);
        pickConstructionButton.setBackground(highlight2 ? (Drawable)SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/PickConstructionButtonSelected", null, this.highlightColor, 2, null) : (Drawable)CityConstructionsTable.highlightConstructionButton$lambda$12(unselected$delegate));
        if (!clearOthers) {
            return;
        }
        SnapshotArray<Actor> snapshotArray = this.availableConstructionsTable.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
        Iterable $this$filterIsInstance$iv = snapshotArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExpanderTab)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ExpanderTab categoryExpander : (List)destination$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv2;
            if (!categoryExpander.isOpen()) continue;
            SnapshotArray<Actor> snapshotArray2 = categoryExpander.getInnerTable().getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotArray2, "getChildren(...)");
            Iterable $this$filterIsInstance$iv2 = snapshotArray2;
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof Table)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Object button2 : (List)destination$iv$iv2) {
                if (Intrinsics.areEqual(button2, pickConstructionButton)) continue;
                ((Table)button2).setBackground(CityConstructionsTable.highlightConstructionButton$lambda$12(unselected$delegate));
            }
        }
        if (!this.isSelectedQueueEntry()) {
            return;
        }
        SnapshotArray<Actor> snapshotArray3 = this.constructionsQueueTable.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray3, "getChildren(...)");
        $this$filterIsInstance$iv = snapshotArray3;
        $i$f$filterIsInstance = false;
        button2 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Table)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Table button3 : (List)destination$iv$iv) {
            if (button3.getChildren().size == 1) continue;
            this.highlightQueueEntry(button3, false);
        }
        this.selectedQueueEntry = -1;
    }

    static /* synthetic */ void highlightConstructionButton$default(CityConstructionsTable cityConstructionsTable, Table table2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        cityConstructionsTable.highlightConstructionButton(table2, bl, bl2);
    }

    private final boolean isSelectedQueueEntry() {
        return this.selectedQueueEntry >= 0;
    }

    private final boolean cannotAddConstructionToQueue(IConstruction construction2, City city2, CityConstructions cityConstructions) {
        return cityConstructions.isQueueFull() || !construction2.isBuildable(cityConstructions) || !this.cityScreen.getCanChangeState() || construction2 instanceof PerpetualConstruction && cityConstructions.isBeingConstructedOrEnqueued(construction2.getName()) || city2.isPuppet();
    }

    private final void addConstructionToQueue(IConstruction construction2, CityConstructions cityConstructions) {
        if (this.cannotAddConstructionToQueue(construction2, this.cityScreen.getCity$core(), cityConstructions)) {
            return;
        }
        if (construction2 instanceof Building && ((Building)construction2).hasCreateOneImprovementUnique()) {
            this.cityScreen.startPickTileForCreatesOneImprovement((Building)construction2, Stat.Gold, false);
            return;
        }
        this.cityScreen.stopPickTileForCreatesOneImprovement();
        SoundPlayer.INSTANCE.play(this.getConstructionSound(construction2));
        cityConstructions.addToQueue(construction2.getName());
        if (!construction2.shouldBeDisplayed(cityConstructions)) {
            this.cityScreen.clearSelection();
        }
        City.reassignPopulation$default(this.cityScreen.getCity$core(), false, 1, null);
        this.cityScreen.update$core();
        this.cityScreen.getGame().getSettings().addCompletedTutorialTask("Pick construction");
    }

    private final UncivSound getConstructionSound(IConstruction construction2) {
        IConstruction iConstruction = construction2;
        return iConstruction instanceof Building ? UncivSound.Companion.getConstruction() : (iConstruction instanceof BaseUnit ? UncivSound.Companion.getPromote() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getGold()) ? UncivSound.Companion.getCoin() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getScience()) ? UncivSound.Companion.getPaper() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getCulture()) ? UncivSound.Companion.getPolicy() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getFaith()) ? UncivSound.Companion.getChoir() : UncivSound.Companion.getClick())))));
    }

    /*
     * WARNING - void declaration
     */
    private final Table getMovePriorityButton(int arrowDirection, KeyboardBinding binding, int constructionQueueIndex, String name2, Function1<? super Integer, Integer> movePriority) {
        void $this$getMovePriorityButton_u24lambda_u2413;
        Image image2;
        Table button = new Table();
        Image image3 = image2 = ImageGetter.INSTANCE.getArrowImage(arrowDirection);
        Table table2 = button;
        boolean bl = false;
        $this$getMovePriorityButton_u24lambda_u2413.setColor(ImageGetter.INSTANCE.getCHARCOAL());
        table2.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(image2, 40.0f, false, null, null, 14, null));
        button.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(button, this, movePriority, constructionQueueIndex, name2){
            final /* synthetic */ Table $button;
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ Function1<Integer, Integer> $movePriority;
            final /* synthetic */ int $constructionQueueIndex;
            final /* synthetic */ String $name;
            {
                this.$button = $button;
                this.this$0 = $receiver;
                this.$movePriority = $movePriority;
                this.$constructionQueueIndex = $constructionQueueIndex;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                this.$button.setTouchable(Touchable.disabled);
                this.this$0.setSelectedQueueEntry(((Number)this.$movePriority.invoke(this.$constructionQueueIndex)).intValue());
                CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$name);
                City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                CityConstructionsTable.access$updateQueueAndButtons(this.this$0, CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction());
                CityConstructionsTable.access$ensureQueueEntryVisible(this.this$0);
            }
        });
        if (this.selectedQueueEntry == constructionQueueIndex) {
            ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(button), binding, 0, 2, null);
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)button, binding, 0.0f, 2, null);
        }
        return button;
    }

    private final Table getRaisePriorityButton(int constructionQueueIndex, String name2, City city2) {
        return this.getMovePriorityButton(2, KeyboardBinding.RaisePriority, constructionQueueIndex, name2, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((Object)city2.getCityConstructions()){

            @NotNull
            public final Integer invoke(int p0) {
                return ((CityConstructions)this.receiver).raisePriority(p0);
            }
        });
    }

    private final Table getLowerPriorityButton(int constructionQueueIndex, String name2, City city2) {
        return this.getMovePriorityButton(4, KeyboardBinding.LowerPriority, constructionQueueIndex, name2, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((Object)city2.getCityConstructions()){

            @NotNull
            public final Integer invoke(int p0) {
                return ((CityConstructions)this.receiver).lowerPriority(p0);
            }
        });
    }

    private final Table getRemoveFromQueueButton(int constructionQueueIndex, City city2) {
        Table tab = new Table();
        tab.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Stop", null, 2, null), 40.0f, false, null, null, 14, null));
        tab.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(tab, new Function0<Unit>(tab, city2, constructionQueueIndex, this){
            final /* synthetic */ Table $tab;
            final /* synthetic */ City $city;
            final /* synthetic */ int $constructionQueueIndex;
            final /* synthetic */ CityConstructionsTable this$0;
            {
                this.$tab = $tab;
                this.$city = $city;
                this.$constructionQueueIndex = $constructionQueueIndex;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$tab.setTouchable(Touchable.disabled);
                this.$city.getCityConstructions().removeFromQueue(this.$constructionQueueIndex, false);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).clearSelection();
                City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                CityConstructionsTable.access$selectQueueEntry(this.this$0, RangesKt.coerceAtMost(this.$constructionQueueIndex, CollectionsKt.getLastIndex(this.$city.getCityConstructions().getConstructionQueue())), getRemoveFromQueueButton.1.INSTANCE);
            }
        });
        return tab;
    }

    private final Table getHeader(String title) {
        Table table2 = new Table().background(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/Header", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 2, null));
        Intrinsics.checkNotNullExpressionValue(table2, "background(...)");
        Table table3 = Scene2dExtensionsKt.addCell(table2, (Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).pad(4.0f);
        Intrinsics.checkNotNullExpressionValue(table3, "pad(...)");
        return table3;
    }

    private final void ensureQueueEntryVisible() {
        block0: {
            Actor actor = this.getSelectedQueueButton();
            if (actor == null) break block0;
            Actor it = actor;
            boolean bl = false;
            this.constructionsQueueScrollPane.scrollTo(2.0f, it.getY(), it.getWidth(), it.getHeight(), true, true);
        }
    }

    private final Actor getSelectedQueueButton() {
        if (this.selectedQueueEntry == 0) {
            return this.constructionsQueueTable.getCells().get(0).getActor();
        }
        if (this.selectedQueueEntry > 0 && this.selectedQueueEntry < this.cityScreen.getCity$core().getCityConstructions().getConstructionQueue().size()) {
            return this.queueExpander.getInnerTable().getCells().get(this.selectedQueueEntry * 2 - 2).getActor();
        }
        return null;
    }

    private final void resizeAvailableConstructionsScrollPane() {
        this.availableConstructionsScrollPane.setHeight(Math.min(this.availableConstructionsTable.getPrefHeight(), this.lowerTableScrollCell.getMaxHeight()));
        this.lowerTable.pack();
    }

    private final void addCategory(Table $this$addCategory, String title, ArrayList<Table> list2, float prefWidth, KeyboardBinding toggleKey, boolean startsOutOpened) {
        if (list2.isEmpty()) {
            return;
        }
        if ($this$addCategory.getRows() > 0) {
            Scene2dExtensionsKt.addSeparator$default($this$addCategory, null, 0, 0.0f, 7, null);
        }
        ExpanderTab expander2 = new ExpanderTab(title, 0, null, startsOutOpened, 0.0f, 0.0f, 0.0f, prefWidth, 0.0f, "CityConstruction." + title, toggleKey, new Function0<Unit>(this){
            final /* synthetic */ CityConstructionsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityConstructionsTable.access$resizeAvailableConstructionsScrollPane(this.this$0);
            }
        }, new Function1<Table, Unit>(list2){
            final /* synthetic */ ArrayList<Table> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                for (Table table2 : this.$list) {
                    Scene2dExtensionsKt.addSeparator$default(it, null, 1, 0.0f, 5, null);
                    it.add((Actor)table2).left().row();
                }
            }
        }, 358, null);
        $this$addCategory.add((Actor)expander2).prefWidth(prefWidth).growX().row();
    }

    static /* synthetic */ void addCategory$default(CityConstructionsTable cityConstructionsTable, Table table2, String string, ArrayList arrayList, float f, KeyboardBinding keyboardBinding, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = !cityConstructionsTable.cityScreen.isCrampedPortrait();
        }
        cityConstructionsTable.addCategory(table2, string, arrayList, f, keyboardBinding, bl);
    }

    private static final NinePatchDrawable highlightConstructionButton$lambda$12(Lazy<? extends NinePatchDrawable> $unselected$delegate) {
        Lazy<? extends NinePatchDrawable> lazy = $unselected$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ ArrayList access$getConstructionButtonDTOs(CityConstructionsTable $this) {
        return $this.getConstructionButtonDTOs();
    }

    public static final /* synthetic */ Table access$getConstructionsQueueTable$p(CityConstructionsTable $this) {
        return $this.constructionsQueueTable;
    }

    public static final /* synthetic */ Table access$getConstructionButton(CityConstructionsTable $this, ConstructionButtonDTO constructionButtonDTO) {
        return $this.getConstructionButton(constructionButtonDTO);
    }

    public static final /* synthetic */ Table access$getAvailableConstructionsTable$p(CityConstructionsTable $this) {
        return $this.availableConstructionsTable;
    }

    public static final /* synthetic */ AutoScrollPane access$getAvailableConstructionsScrollPane$p(CityConstructionsTable $this) {
        return $this.availableConstructionsScrollPane;
    }

    public static final /* synthetic */ Table access$getLowerTable$p(CityConstructionsTable $this) {
        return $this.lowerTable;
    }

    public static final /* synthetic */ void access$addCategory(CityConstructionsTable $this, Table $receiver, String title, ArrayList list2, float prefWidth, KeyboardBinding toggleKey, boolean startsOutOpened) {
        $this.addCategory($receiver, title, list2, prefWidth, toggleKey, startsOutOpened);
    }

    public static final /* synthetic */ Cell access$getLowerTableScrollCell$p(CityConstructionsTable $this) {
        return $this.lowerTableScrollCell;
    }

    public static final /* synthetic */ void access$selectQueueEntry(CityConstructionsTable $this, int constructionQueueIndex, Function0 onBeforeUpdate) {
        $this.selectQueueEntry(constructionQueueIndex, onBeforeUpdate);
    }

    public static final /* synthetic */ void access$addConstructionToQueue(CityConstructionsTable $this, IConstruction construction2, CityConstructions cityConstructions) {
        $this.addConstructionToQueue(construction2, cityConstructions);
    }

    public static final /* synthetic */ void access$highlightConstructionButton(CityConstructionsTable $this, Table pickConstructionButton, boolean highlight2, boolean clearOthers) {
        $this.highlightConstructionButton(pickConstructionButton, highlight2, clearOthers);
    }

    public static final /* synthetic */ void access$updateQueueAndButtons(CityConstructionsTable $this, IConstruction construction2) {
        $this.updateQueueAndButtons(construction2);
    }

    public static final /* synthetic */ void access$ensureQueueEntryVisible(CityConstructionsTable $this) {
        $this.ensureQueueEntryVisible();
    }

    public static final /* synthetic */ void access$resizeAvailableConstructionsScrollPane(CityConstructionsTable $this) {
        $this.resizeAvailableConstructionsScrollPane();
    }
}

