/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileDescription;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreenTileTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "innerTable", "getTileStatsTable", "stats", "Lcom/unciv/models/stats/Stats;", "update", "", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
public final class CityScreenTileTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final Table innerTable;
    @NotNull
    private final City city;

    public CityScreenTileTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.innerTable = new Table();
        this.city = this.cityScreen.getCity$core();
        this.innerTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityScreenTileTable/InnerTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        this.add((Actor)this.innerTable).pad(2.0f).fill();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityScreenTileTable/Background", null, Color.WHITE, 2, null));
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void update(@Nullable Tile selectedTile) {
        this.innerTable.clear();
        if (selectedTile == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.innerTable.clearChildren();
        Stats stats2 = TileStatFunctions.getTileStats$default(selectedTile.getStats(), this.city, this.city.getCiv(), null, 4, null);
        this.innerTable.pad(5.0f);
        this.innerTable.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, TileDescription.INSTANCE.toMarkup(selectedTile, this.city.getCiv()), 0.0f, 0.0f, FormattedLine.IconDisplay.None, new Function1<String, Unit>(this){
            final /* synthetic */ CityScreenTileTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                CityScreenTileTable.access$getCityScreen$p(this.this$0).openCivilopedia(it);
            }
        }, 6, null));
        this.innerTable.row();
        this.innerTable.add((Actor)this.getTileStatsTable(stats2)).row();
        if (this.city.getExpansion().canBuyTile(selectedTile)) {
            int goldCostOfTile = this.city.getExpansion().getGoldCostOfTile(selectedTile);
            TextButton buyTileButton = Scene2dExtensionsKt.toTextButton$default("Buy for [" + goldCostOfTile + "] gold", null, false, 3, null);
            ActivationExtensionsKt.onActivation$default(buyTileButton, null, KeyboardBinding.BuyTile, new Function0<Unit>(buyTileButton, this, selectedTile){
                final /* synthetic */ TextButton $buyTileButton;
                final /* synthetic */ CityScreenTileTable this$0;
                final /* synthetic */ Tile $selectedTile;
                {
                    this.$buyTileButton = $buyTileButton;
                    this.this$0 = $receiver;
                    this.$selectedTile = $selectedTile;
                    super(0);
                }

                public final void invoke() {
                    Scene2dExtensionsKt.disable(this.$buyTileButton);
                    CityScreenTileTable.access$getCityScreen$p(this.this$0).askToBuyTile$core(this.$selectedTile);
                }
            }, 1, null);
            Scene2dExtensionsKt.setEnabled(buyTileButton, this.cityScreen.getCanChangeState() && this.city.getCiv().hasStatToBuy(Stat.Gold, goldCostOfTile));
            this.innerTable.add((Actor)buyTileButton).padTop(5.0f).row();
        }
        if (selectedTile.getOwningCity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Owned by [");
            City city2 = selectedTile.getOwningCity();
            Intrinsics.checkNotNull(city2);
            this.innerTable.add((Actor)Scene2dExtensionsKt.toLabel(stringBuilder.append(city2.getName()).append(']').toString())).row();
        }
        if (selectedTile.getWorkingCity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Worked by [");
            City city3 = selectedTile.getWorkingCity();
            Intrinsics.checkNotNull(city3);
            this.innerTable.add((Actor)Scene2dExtensionsKt.toLabel(stringBuilder.append(city3.getName()).append(']').toString())).row();
        }
        if (this.city.isWorked(selectedTile)) {
            if (selectedTile.isLocked()) {
                TextButton unlockButton = Scene2dExtensionsKt.toTextButton$default("Unlock", null, false, 3, null);
                ActivationExtensionsKt.onClick(unlockButton, new Function0<Unit>(this, selectedTile){
                    final /* synthetic */ CityScreenTileTable this$0;
                    final /* synthetic */ Tile $selectedTile;
                    {
                        this.this$0 = $receiver;
                        this.$selectedTile = $selectedTile;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getCity().getLockedTiles().remove(this.$selectedTile.getPosition());
                        this.this$0.update(this.$selectedTile);
                        CityScreenTileTable.access$getCityScreen$p(this.this$0).update$core();
                    }
                });
                if (!this.cityScreen.getCanChangeState()) {
                    Scene2dExtensionsKt.disable(unlockButton);
                }
                this.innerTable.add((Actor)unlockButton).padTop(5.0f).row();
            } else {
                TextButton lockButton = Scene2dExtensionsKt.toTextButton$default("Lock", null, false, 3, null);
                ActivationExtensionsKt.onClick(lockButton, new Function0<Unit>(this, selectedTile){
                    final /* synthetic */ CityScreenTileTable this$0;
                    final /* synthetic */ Tile $selectedTile;
                    {
                        this.this$0 = $receiver;
                        this.$selectedTile = $selectedTile;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getCity().getLockedTiles().add(this.$selectedTile.getPosition());
                        this.this$0.update(this.$selectedTile);
                        CityScreenTileTable.access$getCityScreen$p(this.this$0).update$core();
                    }
                });
                if (!this.cityScreen.getCanChangeState()) {
                    Scene2dExtensionsKt.disable(lockButton);
                }
                this.innerTable.add((Actor)lockButton).padTop(5.0f).row();
            }
        }
        if (selectedTile.isCityCenter() && !Intrinsics.areEqual(selectedTile.getCity(), this.city)) {
            City city4 = selectedTile.getCity();
            Intrinsics.checkNotNull(city4);
            if (Intrinsics.areEqual(city4.getCiv(), this.city.getCiv())) {
                this.innerTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Move to city", null, false, 3, null), new Function0<Unit>(this, selectedTile){
                    final /* synthetic */ CityScreenTileTable this$0;
                    final /* synthetic */ Tile $selectedTile;
                    {
                        this.this$0 = $receiver;
                        this.$selectedTile = $selectedTile;
                        super(0);
                    }

                    public final void invoke() {
                        UncivGame uncivGame = CityScreenTileTable.access$getCityScreen$p(this.this$0).getGame();
                        City city2 = this.$selectedTile.getCity();
                        Intrinsics.checkNotNull(city2);
                        uncivGame.replaceCurrentScreen(new CityScreen(city2, null, null, null, 14, null));
                    }
                }));
            }
        }
        this.innerTable.pack();
        this.pack();
    }

    private final Table getTileStatsTable(Stats stats2) {
        Table statsTable = new Table();
        statsTable.defaults().pad(2.0f);
        for (Stats.StatValuePair statValuePair : stats2) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            statsTable.add((Actor)ImageGetter.INSTANCE.getStatIcon(key.name())).size(20.0f);
            statsTable.add((Actor)Scene2dExtensionsKt.toLabel(MathKt.roundToInt(value))).padRight(5.0f);
        }
        return statsTable;
    }

    public static final /* synthetic */ CityScreen access$getCityScreen$p(CityScreenTileTable $this) {
        return $this.cityScreen;
    }
}

