/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityResources;
import com.unciv.logic.city.GreatPersonPointsBreakdown;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CitizenManagementTable;
import com.unciv.ui.screens.cityscreen.CityReligionInfoTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.cityscreen.CityStatsTable;
import com.unciv.ui.screens.cityscreen.DetailedStatsPopup;
import com.unciv.ui.screens.cityscreen.GreatPersonPointsBreakdownPopup;
import com.unciv.ui.screens.cityscreen.SpecialistAllocationTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J.\u0010!\u001a\u00020\n*\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityStatsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "city", "Lcom/unciv/logic/city/City;", "detailedStatsButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "expander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "lowerCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "lowerPane", "lowerTable", "miniStatsTable", "Lcom/unciv/ui/screens/cityscreen/CityStatsTable$MiniStatsTable;", "addBuildingButton", "", "building", "Lcom/unciv/models/ruleset/Building;", "destinationTable", "addBuildingsInfo", "addCitizenManagement", "addGreatPersonPointInfo", "addReligionInfo", "addSpecialistInfo", "addText", "onContentResize", "update", "height", "", "addCategory", "category", "", "showHideTable", "toggleKey", "Lcom/unciv/ui/components/input/KeyboardBinding;", "startsOpened", "", "MiniStatsTable", "core"})
@SourceDebugExtension(value={"SMAP\nCityStatsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStatsTable.kt\ncom/unciv/ui/screens/cityscreen/CityStatsTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1#2:431\n1002#3,2:432\n1002#3,2:434\n1002#3,2:436\n*S KotlinDebug\n*F\n+ 1 CityStatsTable.kt\ncom/unciv/ui/screens/cityscreen/CityStatsTable\n*L\n232#1:432,2\n233#1:434,2\n234#1:436,2\n*E\n"})
public final class CityStatsTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final City city;
    @NotNull
    private final ExpanderTab expander;
    @NotNull
    private final MiniStatsTable miniStatsTable;
    @NotNull
    private final Table lowerTable;
    @NotNull
    private final AutoScrollPane lowerPane;
    @Nullable
    private Cell<AutoScrollPane> lowerCell;
    @NotNull
    private final TextButton detailedStatsButton;

    /*
     * WARNING - void declaration
     */
    public CityStatsTable(@NotNull CityScreen cityScreen) {
        Color color;
        void $this$detailedStatsButton_u24lambda_u24222;
        TextButton textButton;
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.city = this.cityScreen.getCity$core();
        this.miniStatsTable = new MiniStatsTable(ExpanderTab.Companion.wasOpen("CityStatsTable"));
        this.lowerTable = new Table();
        this.lowerPane = new AutoScrollPane((Actor)this.lowerTable, null, 2, null);
        TextButton textButton2 = textButton = Scene2dExtensionsKt.toTextButton$default("Stats", null, false, 3, null);
        Table table2 = this;
        boolean $i$a$-apply-CityStatsTable$detailedStatsButton$22 = false;
        $this$detailedStatsButton_u24lambda_u24222.getLabelCell().pad(10.0f);
        ActivationExtensionsKt.onActivation$default((Actor)$this$detailedStatsButton_u24lambda_u24222, null, KeyboardBinding.ShowStats, new Function0<Unit>(this){
            final /* synthetic */ CityStatsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Popup.open$default(new DetailedStatsPopup(CityStatsTable.access$getCityScreen$p(this.this$0)), false, 1, null);
            }
        }, 1, null);
        ((CityStatsTable)table2).detailedStatsButton = textButton;
        this.pad(2.0f);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityStatsTable/Background", null, Scene2dExtensionsKt.colorFromRGB(194, 180, 131), 2, null));
        boolean bl = !this.cityScreen.isCrampedPortrait();
        float $this$detailedStatsButton_u24lambda_u24222 = this.cityScreen.isCrampedPortrait() ? 7.0f : 6.0f;
        float $i$a$-apply-CityStatsTable$detailedStatsButton$22 = this.miniStatsTable.getWidth();
        float f = this.miniStatsTable.getHeight();
        this.expander = new ExpanderTab("", 0, null, bl, 7.0f, 0.0f, $this$detailedStatsButton_u24lambda_u24222, $i$a$-apply-CityStatsTable$detailedStatsButton$22, f, "CityStatsTable", null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                cityScreen.updateWithoutConstructionAndMap$core();
            }
        }, new Function1<Table, Unit>(){

            @Override
            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                lowerCell = it.add((Actor)lowerPane).grow();
            }
        }, 1030, null);
        this.expander.getHeaderContent().add((Actor)this.miniStatsTable).growX();
        Color $this$detailedStatsButton_u24lambda_u24222 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
        String string = null;
        String string2 = "CityScreen/CityStatsTable/InnerTable";
        SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
        table2 = this.expander;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.a = 0.8f;
        Unit unit = Unit.INSTANCE;
        table2.setBackground(SkinStrings.getUiBackground$default(skinStrings, string2, string, color, 2, null));
        this.expander.getHeader().setBackground((Drawable)null);
        this.expander.setDynamicHeaderSize();
        this.expander.toggleOnIconOnly();
        this.lowerPane.setOverscroll(false, false);
        this.lowerPane.setScrollingDisabled(true, false);
        this.lowerTable.defaults().space(4.0f);
        this.add((Actor)this.expander).growX();
    }

    public final void update(float height) {
        this.miniStatsTable.update();
        this.lowerTable.clear();
        this.lowerTable.add((Actor)this.detailedStatsButton).row();
        this.addText();
        this.addCitizenManagement();
        this.addGreatPersonPointInfo(this.city);
        if (!this.city.getPopulation().getMaxSpecialists().isEmpty()) {
            this.addSpecialistInfo();
        }
        if (!((Map)this.city.getReligion().getNumberOfFollowers()).isEmpty() && this.city.getCiv().getGameInfo().isReligionEnabled()) {
            this.addReligionInfo();
        }
        this.addBuildingsInfo();
        this.lowerTable.pack();
        this.lowerPane.layout();
        this.lowerPane.updateVisualScroll();
        Cell<AutoScrollPane> cell2 = this.lowerCell;
        if (cell2 != null) {
            cell2.maxHeight(height - this.expander.getHeader().getHeight() - 8.0f);
        }
        this.expander.pack();
        this.pack();
    }

    private final void onContentResize() {
        this.pack();
        this.setPosition(this.getStage().getWidth() - 5.0f, this.getStage().getHeight() - 5.0f, 18);
    }

    /*
     * WARNING - void declaration
     */
    private final void addText() {
        Pair<Object, Object> pair;
        Table table2;
        Object it;
        String string;
        String turnsToExpansionString;
        String string2;
        String unassignedPopString = TranslationsKt.tr$default("{Unassigned population}: ", false, false, 3, null) + TranslationsKt.tr(this.city.getPopulation().getFreePopulation()) + '/' + TranslationsKt.tr(this.city.getPopulation().getPopulation());
        Label unassignedPopLabel = Scene2dExtensionsKt.toLabel(unassignedPopString);
        if (this.cityScreen.getCanChangeState()) {
            ActivationExtensionsKt.onClick(unassignedPopLabel, new Function0<Unit>(this){
                final /* synthetic */ CityStatsTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    City.reassignPopulation$default(CityStatsTable.access$getCity$p(this.this$0), false, 1, null);
                    CityStatsTable.access$getCityScreen$p(this.this$0).update$core();
                }
            });
        }
        if (this.city.getCityStats().getCurrentCityStats().getCulture() > 0.0f && SequencesKt.any(this.city.getExpansion().getChoosableTiles())) {
            int remainingCulture = this.city.getExpansion().getCultureToNextTile() - this.city.getExpansion().getCultureStored();
            int turnsToExpansion = (int)Math.ceil((float)remainingCulture / this.city.getCityStats().getCurrentCityStats().getCulture());
            if (turnsToExpansion < 1) {
                turnsToExpansion = 1;
            }
            string2 = TranslationsKt.tr$default("" + '[' + turnsToExpansion + "] turns to expansion", false, false, 3, null);
        } else {
            string2 = turnsToExpansionString = TranslationsKt.tr$default("Stopped expansion", false, false, 3, null);
        }
        if (SequencesKt.any(this.city.getExpansion().getChoosableTiles())) {
            turnsToExpansionString = turnsToExpansionString + " (" + this.city.getExpansion().getCultureStored() + "\u266a/" + this.city.getExpansion().getCultureToNextTile() + "\u266a)";
        }
        if (this.city.isStarving()) {
            string = "" + '[' + this.city.getPopulation().getNumTurnsToStarvation() + "] turns to lose population";
        } else {
            it = this.city.getRuleset().getUnits().get(this.city.getCityConstructions().getCurrentConstructionFromQueue());
            boolean bl = false;
            string = it != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.ConvertFoodToProductionWhenConstructed, null, 2, null) ? "Food converts to production" : (this.city.isGrowing() ? "" + '[' + this.city.getPopulation().getNumTurnsToNewPopulation() + "] turns to new population" : "Stopped population growth");
        }
        String turnsToPopString = TranslationsKt.tr$default(string, false, false, 3, null);
        turnsToPopString = turnsToPopString + " (" + this.city.getPopulation().getFoodStored() + "\u2042/" + this.city.getPopulation().getFoodToNextPopulation() + "\u2042)";
        this.lowerTable.add((Actor)unassignedPopLabel).row();
        this.lowerTable.add((Actor)Scene2dExtensionsKt.toLabel(turnsToExpansionString)).row();
        this.lowerTable.add((Actor)Scene2dExtensionsKt.toLabel(turnsToPopString)).row();
        Table tableWithIcons = new Table();
        tableWithIcons.defaults().pad(2.0f);
        if (this.city.isInResistance()) {
            void $this$addText_u24lambda_u243;
            Object bl = it = new Table();
            table2 = tableWithIcons;
            boolean bl2 = false;
            $this$addText_u24lambda_u243.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "StatIcons/Resistance", null, 2, null)).size(20.0f).padRight(2.0f);
            $this$addText_u24lambda_u243.add((Actor)Scene2dExtensionsKt.toLabel("In resistance for another [" + this.city.getFlag(CityFlags.Resistance) + "] turns"));
            table2.add((Actor)it);
        }
        Table resourceTable = new Table();
        Counter<TileResource> resourceCounter = new Counter<TileResource>(null, 1, null);
        for (ResourceSupplyList.ResourceSupply resourceSupply : CityResources.INSTANCE.getCityResourcesAvailableToCity(this.city)) {
            resourceCounter.add(resourceSupply.getResource(), resourceSupply.getAmount());
        }
        for (Map.Entry entry : ((Map)resourceCounter).entrySet()) {
            TileResource resource2 = (TileResource)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (!resource2.isCityWide()) continue;
            resourceTable.add((Actor)Scene2dExtensionsKt.toLabel(amount));
            resourceTable.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource2.getName(), 20.0f, 0, 4, null)).padRight(5.0f);
        }
        if (resourceTable.getCells().notEmpty()) {
            tableWithIcons.add((Actor)resourceTable);
        }
        if (this.city.isWeLoveTheKingDayActive()) {
            Image image2 = ImageGetter.INSTANCE.getStatIcon("Food");
            String string3 = "We Love The King Day for another [" + this.city.getFlag(CityFlags.WeLoveTheKing) + "] turns";
            Color color = Color.LIME;
            Intrinsics.checkNotNullExpressionValue(color, "LIME");
            pair = TuplesKt.to(image2, Scene2dExtensionsKt.toLabel$default(string3, color, 0, 0, false, 14, null));
        } else if (((CharSequence)this.city.getDemandedResource()).length() > 0) {
            Group group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, this.city.getDemandedResource(), 20.0f, 0, 4, null);
            String string4 = "Demanding [" + this.city.getDemandedResource() + ']';
            Color color = Color.CORAL;
            Intrinsics.checkNotNullExpressionValue(color, "CORAL");
            pair = TuplesKt.to(group, Scene2dExtensionsKt.toLabel$default(string4, color, 0, 0, true, 6, null));
        } else {
            pair = TuplesKt.to(null, null);
        }
        Pair<Object, Object> pair2 = pair;
        Actor actor = (Actor)pair2.component1();
        Label wltkLabel = (Label)pair2.component2();
        if (wltkLabel != null) {
            void $this$addText_u24lambda_u244;
            Table table3;
            Table table4 = table3 = new Table();
            table2 = tableWithIcons;
            boolean bl = false;
            Actor actor2 = actor;
            Intrinsics.checkNotNull(actor2);
            $this$addText_u24lambda_u244.add(actor2).size(20.0f).padRight(5.0f);
            $this$addText_u24lambda_u244.add((Actor)wltkLabel).row();
            table2.add((Actor)table3);
            ActivationExtensionsKt.onClick(wltkLabel, new Function0<Unit>(this){
                final /* synthetic */ CityStatsTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    CityStatsTable.access$getCityScreen$p(this.this$0).openCivilopedia("Tutorial/We Love The King Day");
                }
            });
        }
        this.lowerTable.add((Actor)tableWithIcons).row();
    }

    private final void addCitizenManagement() {
        ExpanderTab expanderTab2 = new CitizenManagementTable(this.cityScreen).asExpander(new Function0<Unit>(this){
            final /* synthetic */ CityStatsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityStatsTable.access$onContentResize(this.this$0);
            }
        });
        this.lowerTable.add((Actor)expanderTab2).growX().row();
    }

    private final void addSpecialistInfo() {
        ExpanderTab expanderTab2 = new SpecialistAllocationTable(this.cityScreen).asExpander(new Function0<Unit>(this){
            final /* synthetic */ CityStatsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityStatsTable.access$onContentResize(this.this$0);
            }
        });
        this.lowerTable.add((Actor)expanderTab2).growX().row();
    }

    private final void addReligionInfo() {
        ExpanderTab expanderTab2 = new CityReligionInfoTable(this.city.getReligion(), false, 2, null).asExpander(new Function0<Unit>(this){
            final /* synthetic */ CityStatsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityStatsTable.access$onContentResize(this.this$0);
            }
        });
        this.lowerTable.add((Actor)expanderTab2).growX().row();
    }

    /*
     * WARNING - void declaration
     */
    private final void addBuildingsInfo() {
        Object building3;
        Table table2;
        Iterator iterator2;
        List wonders = new ArrayList();
        List specialistBuildings = new ArrayList();
        List otherBuildings = new ArrayList();
        Iterator<Building> iterator3 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator3.hasNext()) {
            Building building2 = iterator3.next();
            if (building2.isAnyWonder()) {
                wonders.add(building2);
                continue;
            }
            if (!building2.newSpecialists().isEmpty()) {
                specialistBuildings.add(building2);
                continue;
            }
            otherBuildings.add(building2);
        }
        List $this$sortBy$iv = wonders;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        $this$sortBy$iv = specialistBuildings;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        $this$sortBy$iv = otherBuildings;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Building it = (Building)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Building)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
        }
        Table totalTable = new Table();
        this.addCategory(this.lowerTable, "Buildings", totalTable, KeyboardBinding.BuildingsDetail, false);
        if (!((Collection)specialistBuildings).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u248;
            Table specialistBuildingsTable = new Table();
            totalTable.add().row();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Specialist Buildings");
            Label label2 = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u248.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color2 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color2, 0, 0.0f, 6, null);
            for (Object building3 : specialistBuildings) {
                this.addBuildingButton((Building)building3, specialistBuildingsTable);
            }
            totalTable.add((Actor)specialistBuildingsTable).growX().right().row();
        }
        if (!((Collection)wonders).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u249;
            Table wondersTable = new Table();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Wonders");
            building3 = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u249.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color3 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color3, 0, 0.0f, 6, null);
            for (Object building3 : wonders) {
                this.addBuildingButton((Building)building3, wondersTable);
            }
            totalTable.add((Actor)wondersTable).growX().right().row();
        }
        if (!((Collection)otherBuildings).isEmpty()) {
            void $this$addBuildingsInfo_u24lambda_u2410;
            Table regularBuildingsTable = new Table();
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color, 0, 0.0f, 6, null);
            iterator2 = Scene2dExtensionsKt.toLabel("Other");
            building3 = iterator2;
            table2 = totalTable;
            boolean bl = false;
            $this$addBuildingsInfo_u24lambda_u2410.setAlignment(1);
            table2.add((Actor)((Object)iterator2)).growX();
            Color color4 = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "LIGHT_GRAY");
            Scene2dExtensionsKt.addSeparator$default(totalTable, color4, 0, 0.0f, 6, null);
            for (Object building3 : otherBuildings) {
                this.addBuildingButton((Building)building3, regularBuildingsTable);
            }
            totalTable.add((Actor)regularBuildingsTable).growX().right().row();
        }
    }

    private final void addBuildingButton(Building building, Table destinationTable) {
        Table button = new Table();
        Table info2 = new Table();
        Table statsAndSpecialists = new Table();
        Group icon = ImageGetter.INSTANCE.getConstructionPortrait(building.getName(), 50.0f);
        boolean isFree = this.cityScreen.hasFreeBuilding$core(building);
        String displayName = isFree ? '{' + building.getName() + "} ({Free})" : building.getName();
        info2.add((Actor)Scene2dExtensionsKt.toLabel$default(displayName, null, 18, 0, true, 5, null)).padBottom(5.0f).right().row();
        String stats2 = CollectionsKt.joinToString$default(Building.getStats$default(building, this.city, null, 2, null), " ", null, null, 0, null, addBuildingButton.stats.1.INSTANCE, 30, null);
        statsAndSpecialists.add((Actor)Scene2dExtensionsKt.toLabel$default(stats2, null, 18, 0, false, 13, null)).right();
        Object assignedSpec = this.city.getPopulation().getNewSpecialists().clone();
        Table specialistIcons = new Table();
        for (Map.Entry entry : ((Map)building.newSpecialists()).entrySet()) {
            String specialistName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (this.city.getRuleset().getSpecialists().get(specialistName) == null) continue;
            for (int i = 0; i < amount; ++i) {
                int it = i;
                boolean bl = false;
                if (((Number)((Counter)assignedSpec).get(specialistName)).intValue() > 0) {
                    Specialist specialist;
                    specialistIcons.add((Actor)ImageGetter.INSTANCE.getSpecialistIcon(specialist.getColorObject())).size(20.0f);
                    ((Counter)assignedSpec).add(specialistName, -1);
                    continue;
                }
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                specialistIcons.add((Actor)ImageGetter.INSTANCE.getSpecialistIcon(color)).size(20.0f);
            }
        }
        statsAndSpecialists.add((Actor)specialistIcons).right();
        info2.add((Actor)statsAndSpecialists).right();
        button.add((Actor)info2).right().top().padRight(10.0f).padTop(5.0f);
        button.add((Actor)icon).right();
        ActivationExtensionsKt.onClick(button, new Function0<Unit>(this, building){
            final /* synthetic */ CityStatsTable this$0;
            final /* synthetic */ Building $building;
            {
                this.this$0 = $receiver;
                this.$building = $building;
                super(0);
            }

            public final void invoke() {
                CityStatsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$building);
                CityStatsTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        destinationTable.add((Actor)button).pad(1.0f).padBottom(2.0f).padTop(2.0f).expandX().right().row();
    }

    private final ExpanderTab addCategory(Table $this$addCategory, String category, Table showHideTable, KeyboardBinding toggleKey, boolean startsOpened) {
        String string = "CityInfo." + category;
        ExpanderTab expanderTab2 = new ExpanderTab(category, 18, null, startsOpened, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, string, toggleKey, new Function0<Unit>(this){
            final /* synthetic */ CityStatsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityStatsTable.access$onContentResize(this.this$0);
            }
        }, new Function1<Table, Unit>(showHideTable){
            final /* synthetic */ Table $showHideTable;
            {
                this.$showHideTable = $showHideTable;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)this.$showHideTable).fillX().right();
            }
        }, 500, null);
        $this$addCategory.add((Actor)expanderTab2).growX().row();
        return expanderTab2;
    }

    static /* synthetic */ ExpanderTab addCategory$default(CityStatsTable cityStatsTable, Table table2, String string, Table table3, KeyboardBinding keyboardBinding, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return cityStatsTable.addCategory(table2, string, table3, keyboardBinding, bl);
    }

    private final void addGreatPersonPointInfo(City city2) {
        Table greatPeopleTable = new Table();
        GreatPersonPointsBreakdown gppBreakdown = new GreatPersonPointsBreakdown(city2);
        if (gppBreakdown.getAllNames().isEmpty()) {
            return;
        }
        Counter<String> greatPersonPoints = gppBreakdown.sum();
        for (String greatPersonName : gppBreakdown.getAllNames()) {
            ImageGetter.ProgressBar progressBar;
            Color color;
            BaseUnit greatPerson;
            int gppPerTurn = ((Number)greatPersonPoints.get((Object)greatPersonName)).intValue();
            Table info2 = new Table();
            if (city2.getRuleset().getUnits().get(greatPersonName) == null) continue;
            Color color2 = Color.GOLD;
            Intrinsics.checkNotNullExpressionValue(color2, "GOLD");
            info2.add((Actor)Scene2dExtensionsKt.toGroup(ImageGetter.INSTANCE.getUnitIcon(greatPerson, color2), 20.0f)).left().padBottom(4.0f).padRight(5.0f);
            info2.add((Actor)Scene2dExtensionsKt.toLabel$default('{' + greatPersonName + "} (+" + gppPerTurn + ')', null, 0, 0, true, 7, null)).left().padBottom(4.0f).expandX().row();
            int gppCurrent = ((Number)city2.getCiv().getGreatPeople().getGreatPersonPointsCounter().get((Object)greatPersonName)).intValue();
            int gppNeeded = city2.getCiv().getGreatPeople().getPointsRequiredForGreatPerson(greatPersonName);
            float percent = (float)gppCurrent / (float)gppNeeded;
            ImageGetter.ProgressBar progressBar2 = new ImageGetter.ProgressBar(300.0f, 25.0f, false);
            Color color3 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            ImageGetter.ProgressBar progressBar3 = progressBar2;
            boolean bl = false;
            $this$addGreatPersonPointInfo_u24lambda_u2412.a = 0.8f;
            Color color4 = color;
            Intrinsics.checkNotNullExpressionValue(color4, "apply(...)");
            progressBar3.setBackground(color4);
            Color color5 = Color.ORANGE;
            Intrinsics.checkNotNullExpressionValue(color5, "ORANGE");
            ImageGetter.ProgressBar.setProgress$default(progressBar2, color5, percent, 0.0f, 4, null);
            ImageGetter.ProgressBar $this$addGreatPersonPointInfo_u24lambda_u2413 = progressBar = progressBar2;
            boolean bl2 = false;
            Image bar = ImageGetter.INSTANCE.getWhiteDot();
            bar.setColor(Color.GRAY);
            bar.setSize($this$addGreatPersonPointInfo_u24lambda_u2413.getWidth() + 5.0f, $this$addGreatPersonPointInfo_u24lambda_u2413.getHeight() + 5.0f);
            Scene2dExtensionsKt.center((Actor)bar, $this$addGreatPersonPointInfo_u24lambda_u2413);
            $this$addGreatPersonPointInfo_u24lambda_u2413.addActor(bar);
            bar.toBack();
            Color color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color6, "WHITE");
            progressBar2.setLabel(color6, "" + gppCurrent + '/' + gppNeeded, 14);
            info2.add((Actor)progressBar2).colspan(2).left().expandX().row();
            ActivationExtensionsKt.onClick(info2, new Function0<Unit>(this, gppBreakdown, greatPersonName){
                final /* synthetic */ CityStatsTable this$0;
                final /* synthetic */ GreatPersonPointsBreakdown $gppBreakdown;
                final /* synthetic */ String $greatPersonName;
                {
                    this.this$0 = $receiver;
                    this.$gppBreakdown = $gppBreakdown;
                    this.$greatPersonName = $greatPersonName;
                    super(0);
                }

                public final void invoke() {
                    new GreatPersonPointsBreakdownPopup(CityStatsTable.access$getCityScreen$p(this.this$0), this.$gppBreakdown, this.$greatPersonName);
                }
            });
            greatPeopleTable.add((Actor)info2).growX().top().padBottom(10.0f);
            Group icon = ImageGetter.INSTANCE.getConstructionPortrait(greatPersonName, 50.0f);
            ActivationExtensionsKt.onClick(icon, new Function0<Unit>(this, gppBreakdown){
                final /* synthetic */ CityStatsTable this$0;
                final /* synthetic */ GreatPersonPointsBreakdown $gppBreakdown;
                {
                    this.this$0 = $receiver;
                    this.$gppBreakdown = $gppBreakdown;
                    super(0);
                }

                public final void invoke() {
                    new GreatPersonPointsBreakdownPopup(CityStatsTable.access$getCityScreen$p(this.this$0), this.$gppBreakdown, null);
                }
            });
            greatPeopleTable.add((Actor)icon).row();
        }
        CityStatsTable.addCategory$default(this, this.lowerTable, "Great People", greatPeopleTable, KeyboardBinding.GreatPeopleDetail, false, 8, null);
    }

    public static final /* synthetic */ void access$onContentResize(CityStatsTable $this) {
        $this.onContentResize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityStatsTable$MiniStatsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "wasOpen", "", "(Lcom/unciv/ui/screens/cityscreen/CityStatsTable;Ljava/lang/Boolean;)V", "update", "", "expanderIsOpen", "(Ljava/lang/Boolean;)V", "core"})
    private final class MiniStatsTable
    extends Table {
        public MiniStatsTable(Boolean wasOpen) {
            this.update(wasOpen);
            this.pack();
        }

        public final void update() {
            this.update(CityStatsTable.this.expander.isOpen());
        }

        private final void update(Boolean expanderIsOpen) {
            this.clear();
            Color selected = BaseScreen.Companion.getSkin().getColor("selection");
            for (Stats.StatValuePair statValuePair : CityStatsTable.this.city.getCityStats().getCurrentCityStats()) {
                float f;
                CityFocus toggledFocus;
                CityFocus cityFocus;
                Stat stat = statValuePair.component1();
                float amount = statValuePair.component2();
                if (stat == Stat.Faith && !CityStatsTable.this.city.getCiv().getGameInfo().isReligionEnabled()) continue;
                Table icon = new Table();
                CityFocus focus = CityFocus.Companion.safeValueOf(stat);
                if (focus == CityStatsTable.this.city.getCityFocus()) {
                    Actor actor = ImageGetter.INSTANCE.getStatIcon(stat.name());
                    Intrinsics.checkNotNull(selected);
                    icon.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(actor, 27.0f, false, selected, null, 8, null));
                    cityFocus = CityFocus.NoFocus;
                } else {
                    Actor actor = ImageGetter.INSTANCE.getStatIcon(stat.name());
                    Color color = Color.CLEAR;
                    Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
                    icon.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(actor, 27.0f, false, color, null, 8, null));
                    cityFocus = toggledFocus = focus;
                }
                if (CityStatsTable.this.cityScreen.canCityBeChanged()) {
                    ActivationExtensionsKt.onActivation$default(icon, null, toggledFocus.getBinding(), new Function0<Unit>(CityStatsTable.this, toggledFocus){
                        final /* synthetic */ CityStatsTable this$0;
                        final /* synthetic */ CityFocus $toggledFocus;
                        {
                            this.this$0 = $receiver;
                            this.$toggledFocus = $toggledFocus;
                            super(0);
                        }

                        public final void invoke() {
                            CityStatsTable.access$getCity$p(this.this$0).setCityFocus(this.$toggledFocus);
                            City.reassignPopulation$default(CityStatsTable.access$getCity$p(this.this$0), false, 1, null);
                            CityStatsTable.access$getCityScreen$p(this.this$0).update$core();
                        }
                    }, 1, null);
                }
                this.add((Actor)icon).size(27.0f).padRight(3.0f);
                if (stat == Stat.Happiness) {
                    Collection<Float> collection = CityStatsTable.this.city.getCityStats().getHappinessList().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    f = CollectionsKt.sumOfFloat((Iterable<Float>)collection);
                } else {
                    f = amount;
                }
                float valueToDisplay = f;
                this.add((Actor)Scene2dExtensionsKt.toLabel((int)Math.rint(valueToDisplay))).padRight(5.0f);
                if (!CityStatsTable.this.cityScreen.isCrampedPortrait() || expanderIsOpen != null && expanderIsOpen.booleanValue() || stat != Stat.Gold) continue;
                this.row();
            }
        }
    }
}

