/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.SmallButtonStyle;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u001a\u001a\u00020\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/cityscreen/SpecialistAllocationTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "smallButtonStyle", "Lcom/unciv/ui/components/SmallButtonStyle;", "asExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "onChange", "Lkotlin/Function0;", "", "getAllocationTable", "assignedSpecialists", "", "maxSpecialists", "specialistName", "", "getAssignButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getSpecialistStatsTable", "getUnassignButton", "update", "core"})
@SourceDebugExtension(value={"SMAP\nSpecialistAllocationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialistAllocationTable.kt\ncom/unciv/ui/screens/cityscreen/SpecialistAllocationTable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n603#2:170\n603#2:172\n1#3:171\n*S KotlinDebug\n*F\n+ 1 SpecialistAllocationTable.kt\ncom/unciv/ui/screens/cityscreen/SpecialistAllocationTable\n*L\n51#1:170\n139#1:172\n*E\n"})
public final class SpecialistAllocationTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final City city;
    @NotNull
    private final SmallButtonStyle smallButtonStyle;

    public SpecialistAllocationTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        super(BaseScreen.Companion.getSkin());
        this.cityScreen = cityScreen;
        this.city = this.cityScreen.getCity$core();
        this.smallButtonStyle = new SmallButtonStyle();
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void update() {
        this.clear();
        if (this.cityScreen.canCityBeChanged()) {
            Actor toggleButton2 = this.city.getManualSpecialists() ? ActivationExtensionsKt.onActivation(Scene2dExtensionsKt.toTextButton$default("Manual Specialists", this.smallButtonStyle, false, 2, null), new Function0<Unit>(this){
                final /* synthetic */ SpecialistAllocationTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getCity().setManualSpecialists(false);
                    City.reassignPopulation$default(this.this$0.getCity(), false, 1, null);
                    SpecialistAllocationTable.access$getCityScreen$p(this.this$0).update$core();
                }
            }) : ActivationExtensionsKt.onActivation(Scene2dExtensionsKt.toTextButton$default("Auto Specialists", this.smallButtonStyle, false, 2, null), new Function0<Unit>(this){
                final /* synthetic */ SpecialistAllocationTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getCity().setManualSpecialists(true);
                    this.this$0.update();
                }
            });
            this.add(toggleButton2).colspan(5).row();
        }
        Sequence $this$sortedBy$iv = MapsKt.asSequence((Map)this.city.getPopulation().getMaxSpecialists());
        boolean $i$f$sortedBy = false;
        Iterator iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String specialistName = (String)entry.getKey();
            int maxSpecialists = ((Number)entry.getValue()).intValue();
            if (!this.city.getRuleset().getSpecialists().containsKey(specialistName)) continue;
            Counter<String> newSpecialists = this.city.getPopulation().getNewSpecialists();
            int assignedSpecialists = ((Number)newSpecialists.get((Object)specialistName)).intValue();
            if (this.cityScreen.getCanChangeState()) {
                this.add(this.getUnassignButton(assignedSpecialists, specialistName));
            }
            this.add((Actor)this.getAllocationTable(assignedSpecialists, maxSpecialists, specialistName)).pad(10.0f);
            if (this.cityScreen.getCanChangeState()) {
                this.add(this.getAssignButton(assignedSpecialists, maxSpecialists, specialistName));
            }
            Scene2dExtensionsKt.addSeparatorVertical$default(this, null, 0.0f, 3, null).pad(10.0f);
            this.add((Actor)this.getSpecialistStatsTable(specialistName)).row();
        }
        this.pack();
    }

    private final Table getAllocationTable(int assignedSpecialists, int maxSpecialists, String specialistName) {
        Table specialistIconTable = new Table();
        Specialist specialist = this.city.getRuleset().getSpecialists().get(specialistName);
        Intrinsics.checkNotNull(specialist);
        Specialist specialistObject = specialist;
        int i = 1;
        if (i <= maxSpecialists) {
            while (true) {
                Color color = i <= assignedSpecialists ? specialistObject.getColorObject() : Color.GRAY;
                Intrinsics.checkNotNull(color);
                Image icon = ImageGetter.INSTANCE.getSpecialistIcon(color);
                specialistIconTable.add((Actor)icon).size(30.0f);
                if (i % 5 == 0) {
                    specialistIconTable.row();
                }
                if (i == maxSpecialists) break;
                ++i;
            }
        }
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, specialistIconTable, specialistName, 24.0f, false, 0, 0, false, null, 124, null);
        return specialistIconTable;
    }

    private final Actor getAssignButton(int assignedSpecialists, int maxSpecialists, String specialistName) {
        if (assignedSpecialists >= maxSpecialists || this.city.isPuppet()) {
            return new Table();
        }
        Actor actor = Scene2dExtensionsKt.toLabel$default("+", ImageGetter.INSTANCE.getCHARCOAL(), 24, 0, false, 12, null);
        Label $this$getAssignButton_u24lambda_u241 = actor;
        boolean bl = false;
        $this$getAssignButton_u24lambda_u241.setAlignment(1);
        Actor $this$getAssignButton_u24lambda_u242 = actor = Scene2dExtensionsKt.surroundWithCircle$default(actor, 30.0f, false, null, null, 14, null);
        boolean bl2 = false;
        Image image2 = ((IconCircleGroup)$this$getAssignButton_u24lambda_u242).getCircle();
        Color color = Color.GREEN;
        Intrinsics.checkNotNullExpressionValue(color, "GREEN");
        image2.setColor(Scene2dExtensionsKt.darken(color, 0.2f));
        Actor assignButton = actor;
        ActivationExtensionsKt.onClick(assignButton, new Function0<Unit>(this, specialistName){
            final /* synthetic */ SpecialistAllocationTable this$0;
            final /* synthetic */ String $specialistName;
            {
                this.this$0 = $receiver;
                this.$specialistName = $specialistName;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCity().getPopulation().getSpecialistAllocations().add(this.$specialistName, 1);
                this.this$0.getCity().setManualSpecialists(true);
                CityStats.update$default(this.this$0.getCity().getCityStats(), null, false, false, null, 15, null);
                SpecialistAllocationTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        if (this.city.getPopulation().getFreePopulation() == 0 || !this.cityScreen.getCanChangeState()) {
            ((Group)assignButton).clear();
        }
        return assignButton;
    }

    private final Actor getUnassignButton(int assignedSpecialists, String specialistName) {
        Actor actor = Scene2dExtensionsKt.toLabel$default("-", ImageGetter.INSTANCE.getCHARCOAL(), 24, 0, false, 12, null);
        Label $this$getUnassignButton_u24lambda_u243 = actor;
        boolean bl = false;
        $this$getUnassignButton_u24lambda_u243.setAlignment(1);
        Actor $this$getUnassignButton_u24lambda_u244 = actor = Scene2dExtensionsKt.surroundWithCircle$default(actor, 30.0f, false, null, null, 14, null);
        boolean bl2 = false;
        Image image2 = ((IconCircleGroup)$this$getUnassignButton_u24lambda_u244).getCircle();
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        image2.setColor(Scene2dExtensionsKt.darken(color, 0.1f));
        Actor unassignButton = actor;
        ActivationExtensionsKt.onClick(unassignButton, new Function0<Unit>(this, specialistName){
            final /* synthetic */ SpecialistAllocationTable this$0;
            final /* synthetic */ String $specialistName;
            {
                this.this$0 = $receiver;
                this.$specialistName = $specialistName;
                super(0);
            }

            public final void invoke() {
                this.this$0.getCity().getPopulation().getSpecialistAllocations().add(this.$specialistName, -1);
                this.this$0.getCity().setManualSpecialists(true);
                CityStats.update$default(this.this$0.getCity().getCityStats(), null, false, false, null, 15, null);
                SpecialistAllocationTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        if (assignedSpecialists <= 0 || this.city.isPuppet()) {
            unassignButton.setVisible(false);
        }
        if (!this.cityScreen.getCanChangeState()) {
            ((Group)unassignButton).clear();
        }
        return unassignButton;
    }

    private final Table getSpecialistStatsTable(String specialistName) {
        Table table2;
        Table $this$getSpecialistStatsTable_u24lambda_u245 = table2 = new Table();
        boolean bl = false;
        $this$getSpecialistStatsTable_u24lambda_u245.defaults().padBottom(5.0f).padTop(5.0f);
        Table specialistStatTable = table2;
        Stats specialistStats = CityStats.getStatsOfSpecialist$default(this.city.getCityStats(), specialistName, null, 2, null);
        Specialist specialist = this.city.getRuleset().getSpecialists().get(specialistName);
        Intrinsics.checkNotNull(specialist);
        Specialist specialist2 = specialist;
        Iterator iterator2 = ((Iterable)specialistStats).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Stats.StatValuePair it = (Stats.StatValuePair)iterator2.next();
        boolean bl2 = false;
        float f = it.getValue();
        while (iterator2.hasNext()) {
            Stats.StatValuePair it22 = (Stats.StatValuePair)iterator2.next();
            $i$a$-maxOf-SpecialistAllocationTable$getSpecialistStatsTable$maxStat$1 = false;
            float it22 = it22.getValue();
            f = Math.max(f, it22);
        }
        float maxStat = f;
        Color lightGreen = new Color(0x7FFF7FFF);
        Ref.IntRef itemsInRow = new Ref.IntRef();
        Sequence $this$sortedBy$iv = MapsKt.asSequence((Map)specialist2.getGreatPersonPoints());
        boolean $i$f$sortedBy = false;
        Iterator<Object> iterator3 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        }).iterator();
        while (iterator3.hasNext()) {
            BaseUnit greatPerson;
            Object object = iterator3.next();
            String gpName = (String)object.getKey();
            int gpPoints = ((Number)object.getValue()).intValue();
            if (this.city.getRuleset().getUnits().get(gpName) == null) continue;
            Color color = Color.GOLD;
            Intrinsics.checkNotNullExpressionValue(color, "GOLD");
            Color color2 = Color.GOLD;
            Intrinsics.checkNotNullExpressionValue(color2, "GOLD");
            SpecialistAllocationTable.getSpecialistStatsTable$addWrapping(specialistStatTable, itemsInRow, gpPoints, color, ImageGetter.INSTANCE.getUnitIcon(greatPerson, color2));
        }
        for (Object object : specialistStats) {
            Stat stat = ((Stats.StatValuePair)object).component1();
            float value = ((Stats.StatValuePair)object).component2();
            int n = (int)value;
            Color color = value == maxStat ? lightGreen : Color.WHITE;
            Intrinsics.checkNotNull(color);
            SpecialistAllocationTable.getSpecialistStatsTable$addWrapping(specialistStatTable, itemsInRow, n, color, ImageGetter.INSTANCE.getStatIcon(stat.name()));
        }
        return specialistStatTable;
    }

    @NotNull
    public final ExpanderTab asExpander(@Nullable Function0<Unit> onChange) {
        KeyboardBinding keyboardBinding = KeyboardBinding.SpecialistDetail;
        return new ExpanderTab("{Specialists}:", 18, null, true, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "CityStatsTable.Specialists", keyboardBinding, onChange, new Function1<Table, Unit>(this){
            final /* synthetic */ SpecialistAllocationTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)this.this$0);
                this.this$0.update();
            }
        }, 500, null);
    }

    private static final void getSpecialistStatsTable$addWrapping(Table specialistStatTable, Ref.IntRef itemsInRow, int value, Color labelColor, Actor icon) {
        specialistStatTable.add((Actor)Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(value), labelColor, 0, 0, false, 14, null));
        specialistStatTable.add(icon).size(20.0f).padRight(10.0f);
        int n = itemsInRow.element;
        itemsInRow.element = n + 1;
        if (itemsInRow.element % 3 == 0) {
            itemsInRow.element = 0;
            specialistStatTable.row();
        }
    }

    public static final /* synthetic */ CityScreen access$getCityScreen$p(SpecialistAllocationTable $this) {
        return $this.cityScreen;
    }
}

