/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.NationPickerPopup;
import com.unciv.ui.screens.newgamescreen.NationTable;
import com.unciv.ui.screens.newgamescreen.PlayerPickerTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 52\u00020\u0001:\u00045678B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u000fH\u0002J\b\u0010,\u001a\u00020$H\u0002J\u0014\u0010-\u001a\u00020$2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010/\u001a\u00020$H\u0002J\u0014\u00100\u001a\u000201*\u0002022\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup;", "Lcom/unciv/ui/popups/Popup;", "playerPicker", "Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;", "player", "Lcom/unciv/models/metadata/Player;", "noRandom", "", "(Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;Lcom/unciv/models/metadata/Player;Z)V", "civBlocksWidth", "", "keyRoundRobin", "", "keySelectMap", "", "", "", "Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$SelectInfo;", "lastKeyPressed", "listMode", "Lcom/unciv/models/metadata/GameSettings$NationPickerListMode;", "nationDetailsScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "nationDetailsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "nationListScroll", "nationListTable", "partHeight", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "selection", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addActionIcons", "", "getSortedNations", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$NationIterationElement;", "highlightNation", "selectInfo", "onKeyPress", "key", "returnSelected", "toggleListMode", "newMode", "updateNationListTable", "toImageButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "", "overColor", "Lcom/badlogic/gdx/graphics/Color;", "Companion", "HighlightAction", "NationIterationElement", "SelectInfo", "core"})
@SourceDebugExtension(value={"SMAP\nNationPickerPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NationPickerPopup.kt\ncom/unciv/ui/screens/newgamescreen/NationPickerPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1#2:324\n1#2:335\n1603#3,9:325\n1855#3:334\n1856#3:336\n1612#3:337\n*S KotlinDebug\n*F\n+ 1 NationPickerPopup.kt\ncom/unciv/ui/screens/newgamescreen/NationPickerPopup\n*L\n232#1:335\n232#1:325,9\n232#1:334\n232#1:336\n232#1:337\n*E\n"})
public final class NationPickerPopup
extends Popup {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PlayerPickerTable playerPicker;
    @NotNull
    private final Player player;
    private final boolean noRandom;
    @NotNull
    private final IPreviousScreen previousScreen;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final GameSettings settings;
    private final float partHeight;
    private final float civBlocksWidth;
    @NotNull
    private final Table nationListTable;
    @NotNull
    private final AutoScrollPane nationListScroll;
    @NotNull
    private final Table nationDetailsTable;
    @NotNull
    private final AutoScrollPane nationDetailsScroll;
    @NotNull
    private GameSettings.NationPickerListMode listMode;
    @Nullable
    private SelectInfo selection;
    @NotNull
    private final Map<Character, List<SelectInfo>> keySelectMap;
    private char lastKeyPressed;
    private int keyRoundRobin;
    public static final float buttonsCircleSize = 70.0f;
    public static final float buttonsIconSize = 50.0f;
    public static final float buttonsOffsetFromEdge = 5.0f;
    @NotNull
    private static final Color buttonsBackColor;
    public static final float iconViewIconSize = 50.0f;
    public static final float iconViewCellSize = 60.0f;
    public static final float iconViewSpacing = 5.0f;
    public static final float iconViewPadTop = 18.0f;
    public static final float iconViewPadBottom = 55.0f;
    public static final float iconViewPadHorz = 2.5f;

    public NationPickerPopup(@NotNull PlayerPickerTable playerPicker, @NotNull Player player, boolean noRandom) {
        Intrinsics.checkNotNullParameter(playerPicker, "playerPicker");
        Intrinsics.checkNotNullParameter(player, "player");
        IPreviousScreen iPreviousScreen = playerPicker.getPreviousScreen();
        Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
        super((BaseScreen)((Object)iPreviousScreen), Popup.Scrollability.None, 0.0f, 4, null);
        this.playerPicker = playerPicker;
        this.player = player;
        this.noRandom = noRandom;
        this.previousScreen = this.playerPicker.getPreviousScreen();
        this.ruleset = this.previousScreen.getRuleset();
        this.settings = GUI.INSTANCE.getSettings();
        this.partHeight = this.getStageToShowOn().getHeight() * (Scene2dExtensionsKt.isNarrowerThan4to3(this.getStageToShowOn()) ? 0.45f : 0.8f);
        this.civBlocksWidth = this.playerPicker.getCivBlocksWidth();
        this.nationListTable = new Table();
        this.nationListScroll = new AutoScrollPane((Actor)this.nationListTable, null, 2, null);
        this.nationDetailsTable = new Table();
        this.nationDetailsScroll = new AutoScrollPane((Actor)this.nationDetailsTable, null, 2, null);
        this.listMode = this.settings.getNationPickerListMode();
        this.keySelectMap = new LinkedHashMap();
        this.nationListScroll.setOverscroll(false, false);
        this.add((Actor)this.nationListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        if (Scene2dExtensionsKt.isNarrowerThan4to3(this.getStageToShowOn())) {
            this.row();
        }
        this.nationDetailsScroll.setOverscroll(false, false);
        this.add((Actor)this.nationDetailsScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        this.updateNationListTable();
        this.setClickBehindToClose(true);
        this.addActionIcons();
        this.nationDetailsTable.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(this.nationDetailsTable, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.returnSelected();
            }
        });
    }

    private final void toggleListMode(GameSettings.NationPickerListMode newMode) {
        GameSettings.NationPickerListMode nationPickerListMode = newMode;
        if (nationPickerListMode == null) {
            nationPickerListMode = NationPickerPopup.toggleListMode$toggle(this.listMode);
        }
        this.listMode = nationPickerListMode;
        this.settings.setNationPickerListMode(this.listMode);
        this.updateNationListTable();
        this.nationListScroll.updateVisualScroll();
    }

    static /* synthetic */ void toggleListMode$default(NationPickerPopup nationPickerPopup, GameSettings.NationPickerListMode nationPickerListMode, int n, Object object) {
        if ((n & 1) != 0) {
            nationPickerListMode = null;
        }
        nationPickerPopup.toggleListMode(nationPickerListMode);
    }

    private final Group toImageButton(String $this$toImageButton, Color overColor) {
        return Scene2dExtensionsKt.toImageButton($this$toImageButton, 50.0f, 70.0f, buttonsBackColor, overColor);
    }

    private final void addActionIcons() {
        Color color = Color.FIREBRICK;
        Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
        Group closeButton2 = Scene2dExtensionsKt.getCloseButton(70.0f, 50.0f, buttonsBackColor, color, new Function0<Unit>(this){
            final /* synthetic */ NationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.close();
            }
        });
        closeButton2.setPosition(5.0f, 5.0f, 12);
        this.getInnerTable().addActor(closeButton2);
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        Group okButton = this.toImageButton("OtherIcons/Checkmark", color2);
        ActivationExtensionsKt.onActivation(okButton, new Function0<Unit>(this){
            final /* synthetic */ NationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                NationPickerPopup.access$returnSelected(this.this$0);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(okButton).add(KeyCharAndCode.Companion.getRETURN());
        okButton.setPosition(this.getInnerTable().getWidth() - 5.0f, 5.0f, 20);
        this.getInnerTable().addActor(okButton);
        Color color3 = Color.ROYAL;
        Intrinsics.checkNotNullExpressionValue(color3, "ROYAL");
        Group switchViewButton = this.toImageButton("OtherIcons/NationSwap", color3);
        ActivationExtensionsKt.onActivation(switchViewButton, new Function0<Unit>(this){
            final /* synthetic */ NationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                NationPickerPopup.toggleListMode$default(this.this$0, null, 1, null);
            }
        });
        switchViewButton.setPosition(80.0f, 5.0f, 12);
        this.getInnerTable().addActor(switchViewButton);
    }

    private final void returnSelected() {
        Object object = this.selection;
        if (object == null || (object = ((SelectInfo)object).getNation()) == null || (object = ((RulesetObject)object).getName()) == null) {
            return;
        }
        Object selectedNation = object;
        UncivGame.Companion.getCurrent().getMusicController().chooseTrack((String)selectedNation, MusicMood.INSTANCE.getThemeOrPeace(), MusicTrackChooserFlags.Companion.getSetSelectNation());
        this.player.setChosenCiv((String)selectedNation);
        this.close();
        PlayerPickerTable.update$default(this.playerPicker, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateNationListTable() {
        KFunction kFunction;
        this.nationListTable.clear();
        this.keySelectMap.clear();
        ActivationExtensionsKt.getKeyShortcuts(this.nationListTable).clear();
        if (this.listMode == GameSettings.NationPickerListMode.List) {
            this.nationListTable.setBackground((Drawable)null);
            this.nationListTable.defaults().space(0.0f);
            this.nationListTable.pad(0.0f);
        } else {
            Color color;
            Color color2 = color = Color.DARK_GRAY.cpy();
            String string = null;
            String string2 = "NewGameScreen/NationTable/Background";
            SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
            Table table2 = this.nationListTable;
            boolean bl = false;
            $this$updateNationListTable_u24lambda_u240.a = 0.75f;
            Unit unit = Unit.INSTANCE;
            table2.setBackground(SkinStrings.getUiBackground$default(skinStrings, string2, string, color, 2, null));
            this.nationListTable.defaults().space(5.0f);
            this.nationListTable.pad(18.0f, 2.5f, 55.0f, 2.5f);
        }
        Ref.FloatRef currentX = new Ref.FloatRef();
        Ref.FloatRef currentY = new Ref.FloatRef();
        switch (WhenMappings.$EnumSwitchMapping$0[this.listMode.ordinal()]) {
            case 1: {
                kFunction = (KFunction)((Object)new Function1<NationIterationElement, Pair<? extends WidgetGroup, ? extends SelectInfo>>(currentY, currentX, this){
                    final /* synthetic */ Ref.FloatRef $currentY;
                    final /* synthetic */ Ref.FloatRef $currentX;
                    final /* synthetic */ NationPickerPopup this$0;
                    {
                        this.$currentY = $currentY;
                        this.$currentX = $currentX;
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "getIconsModeNationActor", "updateNationListTable$getIconsModeNationActor(Lkotlin/jvm/internal/Ref$FloatRef;Lkotlin/jvm/internal/Ref$FloatRef;Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup;Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$NationIterationElement;)Lkotlin/Pair;", 0);
                    }

                    @NotNull
                    public final Pair<WidgetGroup, SelectInfo> invoke(@NotNull NationIterationElement p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return NationPickerPopup.access$updateNationListTable$getIconsModeNationActor(this.$currentY, this.$currentX, this.this$0, p0);
                    }
                });
                break;
            }
            case 2: {
                kFunction = (KFunction)((Object)new Function1<NationIterationElement, Pair<? extends WidgetGroup, ? extends SelectInfo>>(currentY, this){
                    final /* synthetic */ Ref.FloatRef $currentY;
                    final /* synthetic */ NationPickerPopup this$0;
                    {
                        this.$currentY = $currentY;
                        this.this$0 = $receiver;
                        super(1, Intrinsics.Kotlin.class, "getListModeNationActor", "updateNationListTable$getListModeNationActor(Lkotlin/jvm/internal/Ref$FloatRef;Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup;Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$NationIterationElement;)Lkotlin/Pair;", 0);
                    }

                    @NotNull
                    public final Pair<WidgetGroup, SelectInfo> invoke(@NotNull NationIterationElement p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return NationPickerPopup.access$updateNationListTable$getListModeNationActor(this.$currentY, this.this$0, p0);
                    }
                });
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KFunction nationActorFactory2 = kFunction;
        this.selection = null;
        SelectInfo selectInfo = null;
        Iterator<NationIterationElement> iterator2 = this.getSortedNations().iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            NationIterationElement element = iterator2.next();
            Pair pair = (Pair)((Function1)((Object)nationActorFactory2)).invoke(element);
            WidgetGroup nationActor = (WidgetGroup)pair.component1();
            SelectInfo currentSelectInfo = (SelectInfo)pair.component2();
            ActivationExtensionsKt.onClick(nationActor, new Function0<Unit>(this, currentSelectInfo){
                final /* synthetic */ NationPickerPopup this$0;
                final /* synthetic */ SelectInfo $currentSelectInfo;
                {
                    this.this$0 = $receiver;
                    this.$currentSelectInfo = $currentSelectInfo;
                    super(0);
                }

                public final void invoke() {
                    NationPickerPopup.access$highlightNation(this.this$0, this.$currentSelectInfo);
                }
            });
            ActivationExtensionsKt.onDoubleClick$default(nationActor, null, new Function0<Unit>(this, currentSelectInfo){
                final /* synthetic */ NationPickerPopup this$0;
                final /* synthetic */ SelectInfo $currentSelectInfo;
                {
                    this.this$0 = $receiver;
                    this.$currentSelectInfo = $currentSelectInfo;
                    super(0);
                }

                public final void invoke() {
                    NationPickerPopup.access$setSelection$p(this.this$0, this.$currentSelectInfo);
                    NationPickerPopup.access$returnSelected(this.this$0);
                }
            }, 1, null);
            if (Intrinsics.areEqual(this.player.getChosenCiv(), element.getNation().getName())) {
                selectInfo = currentSelectInfo;
            }
            Object object = new char[]{' '};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)element.getTranslatedName(), object, false, 0, 6, null);
            boolean $i$f$mapNotNull = false;
            Object object2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Character it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (StringsKt.firstOrNull(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set keys2 = CollectionsKt.toSet((List)destination$iv$iv);
            object = keys2.iterator();
            while (object.hasNext()) {
                char key = ((Character)object.next()).charValue();
                Character c = Character.valueOf(key);
                if (this.keySelectMap.containsKey(c)) {
                    List<SelectInfo> list2 = this.keySelectMap.get(Character.valueOf(key));
                    Intrinsics.checkNotNull(list2);
                    ((Collection)list2).add(currentSelectInfo);
                    continue;
                }
                object2 = this.keySelectMap;
                c = Character.valueOf(key);
                Object object3 = new SelectInfo[]{currentSelectInfo};
                object3 = CollectionsKt.mutableListOf(object3);
                object2.put(c, object3);
                ActivationExtensionsKt.getKeyShortcuts(this.nationListTable).add(Character.valueOf(key), new Function0<Unit>(this, key){
                    final /* synthetic */ NationPickerPopup this$0;
                    final /* synthetic */ char $key;
                    {
                        this.this$0 = $receiver;
                        this.$key = $key;
                        super(0);
                    }

                    public final void invoke() {
                        NationPickerPopup.access$onKeyPress(this.this$0, this.$key);
                    }
                });
            }
        }
        this.nationListScroll.layout();
        this.pack();
        if (selectInfo != null) {
            this.highlightNation(selectInfo);
        }
    }

    private final Sequence<NationIterationElement> getSortedNations() {
        Sequence part12 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super NationIterationElement>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (!NationPickerPopup.access$getNoRandom$p(this.this$0)) {
                            $this$invokeSuspend_u24lambda_u240 = var4_4 = new Nation();
                            $i$a$-apply-NationPickerPopup$getSortedNations$part1$1$random$1 = false;
                            $this$invokeSuspend_u24lambda_u240.setName("Random");
                            var7_7 = new Integer[]{Boxing.boxInt(255), Boxing.boxInt(255), Boxing.boxInt(255)};
                            $this$invokeSuspend_u24lambda_u240.setInnerColor(CollectionsKt.listOf(var7_7));
                            var7_7 = new Integer[]{Boxing.boxInt(0), Boxing.boxInt(0), Boxing.boxInt(0)};
                            $this$invokeSuspend_u24lambda_u240.setOuterColor(CollectionsKt.listOf(var7_7));
                            $this$invokeSuspend_u24lambda_u240.setTransients();
                            random = var4_4;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(new NationIterationElement(random, null, 2, null), this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        if ((spectator = NationPickerPopup.access$getPreviousScreen$p(this.this$0).getRuleset().getNations().get("Spectator")) != null && NationPickerPopup.access$getPlayer$p(this.this$0).getPlayerType() != PlayerType.AI) {
                            this.L$0 = null;
                            this.label = 2;
                            v1 = $this$sequence.yield(new NationIterationElement(spectator, null, 2, null), this);
                            if (v1 == var8_2) {
                                return var8_2;
                            }
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super NationIterationElement>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super NationIterationElement> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        Sequence part22 = SequencesKt.map(this.playerPicker.getAvailablePlayerCivs$core(this.player.getChosenCiv()), getSortedNations.part2.1.INSTANCE);
        Comparator comparator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        return SequencesKt.plus(part12, SequencesKt.sortedWith(part22, new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                NationIterationElement nationIterationElement = (NationIterationElement)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                NationIterationElement it = (NationIterationElement)b;
                String string = it.getTranslatedName();
                bl = false;
                String string2 = it.getTranslatedName();
                return comparator.compare(string, string2);
            }
        }));
    }

    private final void onKeyPress(char key) {
        List<SelectInfo> list2 = this.keySelectMap.get(Character.valueOf(key));
        if (list2 == null) {
            return;
        }
        List<SelectInfo> entries2 = list2;
        this.keyRoundRobin = key != this.lastKeyPressed ? 0 : (this.keyRoundRobin + 1) % entries2.size();
        this.lastKeyPressed = key;
        this.highlightNation(entries2.get(this.keyRoundRobin));
    }

    private final void highlightNation(SelectInfo selectInfo) {
        block1: {
            Object object = this.selection;
            if (object != null && (object = ((SelectInfo)object).getWidget()) != null) {
                Object $this$highlightNation_u24lambda_u244 = object;
                boolean bl = false;
                ((Actor)$this$highlightNation_u24lambda_u244).clearActions();
                ((Container)$this$highlightNation_u24lambda_u244).setBackground(null);
            }
            this.nationDetailsTable.clearChildren();
            this.nationDetailsTable.add((Actor)new NationTable(selectInfo.getNation(), this.civBlocksWidth, this.partHeight, this.ruleset));
            this.selection = selectInfo;
            this.nationListScroll.setScrollY(selectInfo.getScrollY() - (this.nationListScroll.getHeight() - this.nationListTable.getRowHeight(0)) / (float)2);
            Container<Portrait> container = selectInfo.getWidget();
            if (container == null) break block1;
            container.addAction(new HighlightAction(selectInfo));
        }
    }

    private static final GameSettings.NationPickerListMode toggleListMode$toggle(GameSettings.NationPickerListMode $this$toggleListMode_u24toggle) {
        GameSettings.NationPickerListMode nationPickerListMode;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toggleListMode_u24toggle.ordinal()]) {
            case 1: {
                nationPickerListMode = GameSettings.NationPickerListMode.List;
                break;
            }
            case 2: {
                nationPickerListMode = GameSettings.NationPickerListMode.Icons;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return nationPickerListMode;
    }

    private static final Pair<WidgetGroup, SelectInfo> updateNationListTable$getListModeNationActor(Ref.FloatRef currentY, NationPickerPopup this$0, NationIterationElement element) {
        SelectInfo currentSelectInfo = new SelectInfo(element.getNation(), currentY.element, null, 4, null);
        NationTable nationTable = new NationTable(element.getNation(), this$0.civBlocksWidth, 0.0f, null, 8, null);
        Cell<Actor> cell2 = this$0.nationListTable.add((Actor)nationTable);
        currentY.element += cell2.getPadBottom() + cell2.getPrefHeight() + cell2.getPadTop();
        cell2.row();
        return TuplesKt.to(nationTable, currentSelectInfo);
    }

    private static final Pair<WidgetGroup, SelectInfo> updateNationListTable$getIconsModeNationActor(Ref.FloatRef currentY, Ref.FloatRef currentX, NationPickerPopup this$0, NationIterationElement element) {
        Container<Actor> container;
        Portrait nationIcon = ImageGetter.INSTANCE.getNationPortrait(element.getNation(), 50.0f);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, nationIcon, element.getTranslatedName(), 0.0f, false, 0, 1, true, null, 78, null);
        Container<Actor> $this$updateNationListTable_u24getIconsModeNationActor_u24lambda_u241 = container = new Container<Actor>((Actor)nationIcon);
        boolean bl = false;
        $this$updateNationListTable_u24getIconsModeNationActor_u24lambda_u241.setTransform(false);
        $this$updateNationListTable_u24getIconsModeNationActor_u24lambda_u241.setTouchable(Touchable.enabled);
        $this$updateNationListTable_u24getIconsModeNationActor_u24lambda_u241.setRound(false);
        $this$updateNationListTable_u24getIconsModeNationActor_u24lambda_u241.center();
        Container<Actor> nationGroup = container;
        SelectInfo currentSelectInfo = new SelectInfo(element.getNation(), currentY.element, nationGroup);
        if (currentX.element + 60.0f > this$0.civBlocksWidth) {
            this$0.nationListTable.row();
            currentX.element = 0.0f;
            currentY.element += 60.0f;
        }
        this$0.nationListTable.add((Actor)nationGroup).size(60.0f);
        currentX.element += 65.0f;
        return TuplesKt.to(nationGroup, currentSelectInfo);
    }

    public static final /* synthetic */ Pair access$updateNationListTable$getIconsModeNationActor(Ref.FloatRef currentY, Ref.FloatRef currentX, NationPickerPopup this$0, NationIterationElement element) {
        return NationPickerPopup.updateNationListTable$getIconsModeNationActor(currentY, currentX, this$0, element);
    }

    public static final /* synthetic */ Pair access$updateNationListTable$getListModeNationActor(Ref.FloatRef currentY, NationPickerPopup this$0, NationIterationElement element) {
        return NationPickerPopup.updateNationListTable$getListModeNationActor(currentY, this$0, element);
    }

    public static final /* synthetic */ void access$highlightNation(NationPickerPopup $this, SelectInfo selectInfo) {
        $this.highlightNation(selectInfo);
    }

    public static final /* synthetic */ void access$setSelection$p(NationPickerPopup $this, SelectInfo selectInfo) {
        $this.selection = selectInfo;
    }

    public static final /* synthetic */ void access$onKeyPress(NationPickerPopup $this, char key) {
        $this.onKeyPress(key);
    }

    public static final /* synthetic */ boolean access$getNoRandom$p(NationPickerPopup $this) {
        return $this.noRandom;
    }

    public static final /* synthetic */ IPreviousScreen access$getPreviousScreen$p(NationPickerPopup $this) {
        return $this.previousScreen;
    }

    public static final /* synthetic */ Player access$getPlayer$p(NationPickerPopup $this) {
        return $this.player;
    }

    static {
        Color color;
        Companion = new Companion(null);
        Color $this$buttonsBackColor_u24lambda_u245 = color = ImageGetter.INSTANCE.getCHARCOAL().cpy();
        boolean bl = false;
        $this$buttonsBackColor_u24lambda_u245.a = 0.67f;
        Color color2 = color;
        Intrinsics.checkNotNullExpressionValue(color2, "apply(...)");
        buttonsBackColor = color2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$Companion;", "", "()V", "buttonsBackColor", "Lcom/badlogic/gdx/graphics/Color;", "getButtonsBackColor", "()Lcom/badlogic/gdx/graphics/Color;", "buttonsCircleSize", "", "buttonsIconSize", "buttonsOffsetFromEdge", "iconViewCellSize", "iconViewIconSize", "iconViewPadBottom", "iconViewPadHorz", "iconViewPadTop", "iconViewSpacing", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getButtonsBackColor() {
            return buttonsBackColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$HighlightAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "selectInfo", "Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$SelectInfo;", "(Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$SelectInfo;)V", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "tempColor", "widget", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/unciv/ui/images/Portrait;", "begin", "", "end", "update", "percent", "", "core"})
    @SourceDebugExtension(value={"SMAP\nNationPickerPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NationPickerPopup.kt\ncom/unciv/ui/screens/newgamescreen/NationPickerPopup$HighlightAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
    private static final class HighlightAction
    extends TemporalAction {
        @NotNull
        private final Color innerColor;
        @NotNull
        private final Color outerColor;
        @NotNull
        private final Container<Portrait> widget;
        @NotNull
        private final Color tempColor;

        public HighlightAction(@NotNull SelectInfo selectInfo) {
            Intrinsics.checkNotNullParameter(selectInfo, "selectInfo");
            super(1.5f);
            this.innerColor = selectInfo.getNation().getInnerColor();
            this.outerColor = selectInfo.getNation().getOuterColor();
            Container<Portrait> container = selectInfo.getWidget();
            Intrinsics.checkNotNull(container);
            this.widget = container;
            this.tempColor = new Color();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void begin() {
            void $this$begin_u24lambda_u240;
            TextureRegionDrawable textureRegionDrawable;
            TextureRegionDrawable textureRegionDrawable2 = textureRegionDrawable = ImageGetter.INSTANCE.getCircleDrawable();
            Container<Portrait> container = this.widget;
            boolean bl = false;
            $this$begin_u24lambda_u240.setMinSize(60.0f, 60.0f);
            container.setBackground(textureRegionDrawable);
        }

        @Override
        protected void update(float percent) {
            double t = (1.0 - Math.cos((double)percent * Math.PI * (double)2)) / (double)2;
            this.tempColor.set(this.outerColor).lerp(this.innerColor, (float)t);
            this.widget.setColor(this.tempColor);
        }

        @Override
        protected void end() {
            this.restart();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$NationIterationElement;", "", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "translatedName", "", "(Lcom/unciv/models/ruleset/nation/Nation;Ljava/lang/String;)V", "getNation", "()Lcom/unciv/models/ruleset/nation/Nation;", "getTranslatedName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class NationIterationElement {
        @NotNull
        private final Nation nation;
        @NotNull
        private final String translatedName;

        public NationIterationElement(@NotNull Nation nation2, @NotNull String translatedName) {
            Intrinsics.checkNotNullParameter(nation2, "nation");
            Intrinsics.checkNotNullParameter(translatedName, "translatedName");
            this.nation = nation2;
            this.translatedName = translatedName;
        }

        public /* synthetic */ NationIterationElement(Nation nation2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = TranslationsKt.tr$default(nation2.getName(), true, false, 2, null);
            }
            this(nation2, string);
        }

        @NotNull
        public final Nation getNation() {
            return this.nation;
        }

        @NotNull
        public final String getTranslatedName() {
            return this.translatedName;
        }

        @NotNull
        public final Nation component1() {
            return this.nation;
        }

        @NotNull
        public final String component2() {
            return this.translatedName;
        }

        @NotNull
        public final NationIterationElement copy(@NotNull Nation nation2, @NotNull String translatedName) {
            Intrinsics.checkNotNullParameter(nation2, "nation");
            Intrinsics.checkNotNullParameter(translatedName, "translatedName");
            return new NationIterationElement(nation2, translatedName);
        }

        public static /* synthetic */ NationIterationElement copy$default(NationIterationElement nationIterationElement, Nation nation2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                nation2 = nationIterationElement.nation;
            }
            if ((n & 2) != 0) {
                string = nationIterationElement.translatedName;
            }
            return nationIterationElement.copy(nation2, string);
        }

        @NotNull
        public String toString() {
            return "NationIterationElement(nation=" + this.nation + ", translatedName=" + this.translatedName + ')';
        }

        public int hashCode() {
            int result2 = this.nation.hashCode();
            result2 = result2 * 31 + this.translatedName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NationIterationElement)) {
                return false;
            }
            NationIterationElement nationIterationElement = (NationIterationElement)other;
            if (!Intrinsics.areEqual(this.nation, nationIterationElement.nation)) {
                return false;
            }
            return Intrinsics.areEqual(this.translatedName, nationIterationElement.translatedName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationPickerPopup$SelectInfo;", "", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "scrollY", "", "widget", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/unciv/ui/images/Portrait;", "(Lcom/unciv/models/ruleset/nation/Nation;FLcom/badlogic/gdx/scenes/scene2d/ui/Container;)V", "getNation", "()Lcom/unciv/models/ruleset/nation/Nation;", "getScrollY", "()F", "getWidget", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "core"})
    private static final class SelectInfo {
        @NotNull
        private final Nation nation;
        private final float scrollY;
        @Nullable
        private final Container<Portrait> widget;

        public SelectInfo(@NotNull Nation nation2, float scrollY, @Nullable Container<Portrait> widget) {
            Intrinsics.checkNotNullParameter(nation2, "nation");
            this.nation = nation2;
            this.scrollY = scrollY;
            this.widget = widget;
        }

        public /* synthetic */ SelectInfo(Nation nation2, float f, Container container, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                container = null;
            }
            this(nation2, f, container);
        }

        @NotNull
        public final Nation getNation() {
            return this.nation;
        }

        public final float getScrollY() {
            return this.scrollY;
        }

        @Nullable
        public final Container<Portrait> getWidget() {
            return this.widget;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameSettings.NationPickerListMode.values().length];
            try {
                nArray[GameSettings.NationPickerListMode.Icons.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameSettings.NationPickerListMode.List.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

