/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.GameInfoPreview;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.newgamescreen.PlayerPickerTable;
import com.unciv.ui.screens.newgamescreen.ScenarioSelectTable;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d0\u001cH\u0002J\u0006\u0010 \u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "newGameScreen", "Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;", "(Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;)V", "getNewGameScreen", "()Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;", "scenarioSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "getScenarioSelectBox", "()Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "setScenarioSelectBox", "(Lcom/unciv/ui/components/widgets/TranslatedSelectBox;)V", "scenarios", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable$ScenarioData;", "Lkotlin/collections/HashMap;", "getScenarios", "()Ljava/util/HashMap;", "selectedScenario", "getSelectedScenario", "()Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable$ScenarioData;", "setSelectedScenario", "(Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable$ScenarioData;)V", "createScenarioSelectBox", "", "scenarioFiles", "", "Lkotlin/Pair;", "Lcom/badlogic/gdx/files/FileHandle;", "Lcom/unciv/models/ruleset/Ruleset;", "selectScenario", "ScenarioData", "core"})
@SourceDebugExtension(value={"SMAP\nMapOptionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/ScenarioSelectTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class ScenarioSelectTable
extends Table {
    @NotNull
    private final NewGameScreen newGameScreen;
    @NotNull
    private final HashMap<String, ScenarioData> scenarios;
    public ScenarioData selectedScenario;
    @Nullable
    private TranslatedSelectBox scenarioSelectBox;

    public ScenarioSelectTable(@NotNull NewGameScreen newGameScreen) {
        Intrinsics.checkNotNullParameter(newGameScreen, "newGameScreen");
        this.newGameScreen = newGameScreen;
        this.scenarios = new HashMap();
        Pair<FileHandle, Ruleset> firstScenarioFile = SequencesKt.firstOrNull(this.newGameScreen.getGame().getFiles().getScenarioFiles());
        if (firstScenarioFile != null) {
            this.createScenarioSelectBox(CollectionsKt.listOf(firstScenarioFile));
            Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ScenarioSelectTable this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Override
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            List<Pair<FileHandle, Ruleset>> scenarioFiles = SequencesKt.toList(this.this$0.getNewGameScreen().getGame().getFiles().getScenarioFiles());
                            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, scenarioFiles, null){
                                int label;
                                final /* synthetic */ ScenarioSelectTable this$0;
                                final /* synthetic */ List<Pair<FileHandle, Ruleset>> $scenarioFiles;
                                {
                                    this.this$0 = $receiver;
                                    this.$scenarioFiles = $scenarioFiles;
                                    super(2, $completion);
                                }

                                @Override
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.this$0.createScenarioSelectBox(this.$scenarioFiles);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @Override
                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Override
                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Override
                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Override
                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @NotNull
    public final NewGameScreen getNewGameScreen() {
        return this.newGameScreen;
    }

    @NotNull
    public final HashMap<String, ScenarioData> getScenarios() {
        return this.scenarios;
    }

    @NotNull
    public final ScenarioData getSelectedScenario() {
        ScenarioData scenarioData = this.selectedScenario;
        if (scenarioData != null) {
            return scenarioData;
        }
        Intrinsics.throwUninitializedPropertyAccessException("selectedScenario");
        return null;
    }

    public final void setSelectedScenario(@NotNull ScenarioData scenarioData) {
        Intrinsics.checkNotNullParameter(scenarioData, "<set-?>");
        this.selectedScenario = scenarioData;
    }

    @Nullable
    public final TranslatedSelectBox getScenarioSelectBox() {
        return this.scenarioSelectBox;
    }

    public final void setScenarioSelectBox(@Nullable TranslatedSelectBox translatedSelectBox) {
        this.scenarioSelectBox = translatedSelectBox;
    }

    private final void createScenarioSelectBox(List<? extends Pair<? extends FileHandle, Ruleset>> scenarioFiles) {
        Iterator<? extends Pair<? extends FileHandle, Ruleset>> iterator2 = scenarioFiles.iterator();
        while (iterator2.hasNext()) {
            String string;
            FileHandle file = iterator2.next().component1();
            Map map2 = this.scenarios;
            Intrinsics.checkNotNullExpressionValue(file.name(), "name(...)");
            String string2 = file.name();
            Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
            ScenarioData scenarioData = new ScenarioData(string2, file);
            map2.put(string, scenarioData);
        }
        Set<String> set2 = this.scenarios.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Collection collection = CollectionsKt.sorted((Iterable)set2);
        Set<String> set3 = this.scenarios.keySet();
        Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
        Object t = CollectionsKt.first((Iterable)set3);
        Intrinsics.checkNotNullExpressionValue(t, "first(...)");
        TranslatedSelectBox translatedSelectBox = this.scenarioSelectBox = new TranslatedSelectBox(collection, (String)t);
        Intrinsics.checkNotNull(translatedSelectBox);
        ActivationExtensionsKt.onChange(translatedSelectBox, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(this){
            final /* synthetic */ ScenarioSelectTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.this$0.selectScenario();
            }
        });
        this.clear();
        this.add((Actor)this.scenarioSelectBox);
    }

    /*
     * WARNING - void declaration
     */
    public final void selectScenario() {
        void $this$selectScenario_u24lambda_u240;
        ArrayList<Player> arrayList;
        GameInfoPreview gameInfoPreview;
        TranslatedSelectBox translatedSelectBox = this.scenarioSelectBox;
        Intrinsics.checkNotNull(translatedSelectBox);
        ScenarioData scenarioData = this.scenarios.get(((TranslatedSelectBox.TranslatedString)translatedSelectBox.getSelected()).getValue());
        Intrinsics.checkNotNull(scenarioData);
        ScenarioData scenario = scenarioData;
        if (scenario.getPreview() != null) {
            GameInfoPreview gameInfoPreview2 = scenario.getPreview();
            gameInfoPreview = gameInfoPreview2;
            Intrinsics.checkNotNull(gameInfoPreview2);
        } else {
            GameInfoPreview preview = this.newGameScreen.getGame().getFiles().loadGamePreviewFromFile(scenario.getFile());
            scenario.setPreview(preview);
            gameInfoPreview = arrayList;
        }
        GameInfoPreview preload2 = gameInfoPreview;
        ArrayList<Player> arrayList2 = arrayList = preload2.getGameParameters().getPlayers();
        GameParameters gameParameters = this.newGameScreen.getGameSetupInfo().getGameParameters();
        boolean bl = false;
        CollectionsKt.removeAll((List)$this$selectScenario_u24lambda_u240, (Function1)selectScenario.1.1.INSTANCE);
        gameParameters.setPlayers(arrayList);
        this.newGameScreen.getGameSetupInfo().getGameParameters().setBaseRuleset(preload2.getGameParameters().getBaseRuleset());
        this.newGameScreen.getGameSetupInfo().getGameParameters().setMods(preload2.getGameParameters().getMods());
        this.newGameScreen.tryUpdateRuleset(true);
        PlayerPickerTable.update$default(this.newGameScreen.getPlayerPickerTable$core(), null, 1, null);
        this.setSelectedScenario(scenario);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/screens/newgamescreen/ScenarioSelectTable$ScenarioData;", "", "name", "", "file", "Lcom/badlogic/gdx/files/FileHandle;", "(Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;)V", "getFile", "()Lcom/badlogic/gdx/files/FileHandle;", "getName", "()Ljava/lang/String;", "preview", "Lcom/unciv/logic/GameInfoPreview;", "getPreview", "()Lcom/unciv/logic/GameInfoPreview;", "setPreview", "(Lcom/unciv/logic/GameInfoPreview;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class ScenarioData {
        @NotNull
        private final String name;
        @NotNull
        private final FileHandle file;
        @Nullable
        private GameInfoPreview preview;

        public ScenarioData(@NotNull String name2, @NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(file, "file");
            this.name = name2;
            this.file = file;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final FileHandle getFile() {
            return this.file;
        }

        @Nullable
        public final GameInfoPreview getPreview() {
            return this.preview;
        }

        public final void setPreview(@Nullable GameInfoPreview gameInfoPreview) {
            this.preview = gameInfoPreview;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final FileHandle component2() {
            return this.file;
        }

        @NotNull
        public final ScenarioData copy(@NotNull String name2, @NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(file, "file");
            return new ScenarioData(name2, file);
        }

        public static /* synthetic */ ScenarioData copy$default(ScenarioData scenarioData, String string, FileHandle fileHandle, int n, Object object) {
            if ((n & 1) != 0) {
                string = scenarioData.name;
            }
            if ((n & 2) != 0) {
                fileHandle = scenarioData.file;
            }
            return scenarioData.copy(string, fileHandle);
        }

        @NotNull
        public String toString() {
            return "ScenarioData(name=" + this.name + ", file=" + this.file + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScenarioData)) {
                return false;
            }
            ScenarioData scenarioData = (ScenarioData)other;
            if (!Intrinsics.areEqual(this.name, scenarioData.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.file, scenarioData.file);
        }
    }
}

