/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.screens.victoryscreen.IndependentMiniMap;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTile;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH$J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/screens/victoryscreen/IndependentMiniMap;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "(Lcom/unciv/logic/map/TileMap;)V", "minimapTiles", "", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile;", "getMinimapTiles", "()Ljava/util/List;", "setMinimapTiles", "(Ljava/util/List;)V", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "calcTileSize", "", "maxWidth", "maxHeight", "createReplayMap", "tileSize", "deferredInit", "", "includeTileFilter", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
@SourceDebugExtension(value={"SMAP\nReplayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayMap.kt\ncom/unciv/ui/screens/victoryscreen/IndependentMiniMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n766#2:140\n857#2,2:141\n*S KotlinDebug\n*F\n+ 1 ReplayMap.kt\ncom/unciv/ui/screens/victoryscreen/IndependentMiniMap\n*L\n53#1:140\n53#1:141,2\n*E\n"})
public abstract class IndependentMiniMap
extends Group {
    @NotNull
    private final TileMap tileMap;
    protected List<MinimapTile> minimapTiles;

    public IndependentMiniMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this.tileMap = tileMap;
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    @NotNull
    protected final List<MinimapTile> getMinimapTiles() {
        List<MinimapTile> list2 = this.minimapTiles;
        if (list2 != null) {
            return list2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("minimapTiles");
        return null;
    }

    protected final void setMinimapTiles(@NotNull List<MinimapTile> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.minimapTiles = list2;
    }

    protected void deferredInit(float maxWidth, float maxHeight) {
        float tileSize = this.calcTileSize(maxWidth, maxHeight);
        this.setMinimapTiles(this.createReplayMap(tileSize));
        Rectangle tileExtension = MinimapTileUtil.INSTANCE.spreadOutMinimapTiles(this, this.getMinimapTiles(), tileSize);
        for (Actor group : this.getChildren()) {
            group.moveBy(-tileExtension.x, -tileExtension.y);
        }
        this.setSize(tileExtension.width, tileExtension.height);
    }

    protected abstract float calcTileSize(float var1, float var2);

    protected boolean includeTileFilter(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MinimapTile> createReplayMap(float tileSize) {
        void $this$filterTo$iv$iv;
        Function0 doNothing2 = createReplayMap.doNothing.1.INSTANCE;
        ArrayList<MinimapTile> tiles2 = new ArrayList<MinimapTile>(this.tileMap.getValues().size());
        Iterable $this$filter$iv = this.tileMap.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile p0 = (Tile)element$iv$iv;
            boolean bl = false;
            if (!this.includeTileFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Tile tile : (List)destination$iv$iv) {
            MinimapTile minimapTile2 = new MinimapTile(tile, tileSize, doNothing2);
            minimapTile2.updateColor(false, null);
            tiles2.add(minimapTile2);
        }
        tiles2.trimToSize();
        return tiles2;
    }
}

