/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/worldscreen/TradePopup;", "Lcom/unciv/ui/popups/Popup;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "tradeRequest", "Lcom/unciv/logic/trade/TradeRequest;", "getTradeRequest", "()Lcom/unciv/logic/trade/TradeRequest;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "close", "", "TradeThanksPopup", "core"})
@SourceDebugExtension(value={"SMAP\nTradePopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradePopup.kt\ncom/unciv/ui/screens/worldscreen/TradePopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class TradePopup
extends Popup {
    @NotNull
    private final Civilization viewingCiv;
    @NotNull
    private final TradeRequest tradeRequest;

    public TradePopup(final @NotNull WorldScreen worldScreen) {
        Table table2;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(worldScreen, null, 0.0f, 6, null);
        this.viewingCiv = worldScreen.getViewingCiv();
        this.tradeRequest = (TradeRequest)CollectionsKt.first((List)this.viewingCiv.getTradeRequests());
        final Civilization requestingCiv = worldScreen.getGameInfo().getCivilization(this.tradeRequest.getRequestingCiv());
        Nation nation2 = requestingCiv.getNation();
        final Trade trade = this.tradeRequest.getTrade();
        HashMap<String, Integer> ourResources = this.viewingCiv.getCivResourcesByName();
        final LeaderIntroTable leaderIntroTable = new LeaderIntroTable(requestingCiv, null, 2, null);
        this.add((Actor)leaderIntroTable);
        Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
        Table $this$_init__u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$_init__u24lambda_u240.defaults().pad(10.0f);
        Table tradeOffersTable = table2;
        tradeOffersTable.add((Actor)Scene2dExtensionsKt.toLabel('[' + nation2.getName() + "]'s trade offer"));
        Cell cell2 = tradeOffersTable.add();
        Intrinsics.checkNotNullExpressionValue(cell2, "add(...)");
        Scene2dExtensionsKt.pad(cell2, 0.0f, 15.0f);
        tradeOffersTable.add((Actor)Scene2dExtensionsKt.toLabel("Our trade offer"));
        tradeOffersTable.row();
        int i = 0;
        int n = Math.max(CollectionsKt.getLastIndex(trade.getTheirOffers()), CollectionsKt.getLastIndex(trade.getOurOffers()));
        if (i <= n) {
            while (true) {
                if (CollectionsKt.getLastIndex(trade.getTheirOffers()) < i) {
                    tradeOffersTable.add();
                } else {
                    Object e = trade.getTheirOffers().get(i);
                    Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                    tradeOffersTable.add((Actor)Scene2dExtensionsKt.toLabel(TradePopup._init_$getOfferText(ourResources, (TradeOffer)e)));
                }
                tradeOffersTable.add();
                if (CollectionsKt.getLastIndex(trade.getOurOffers()) < i) {
                    tradeOffersTable.add();
                } else {
                    Object e = trade.getOurOffers().get(i);
                    Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                    tradeOffersTable.add((Actor)Scene2dExtensionsKt.toLabel(TradePopup._init_$getOfferText(ourResources, (TradeOffer)e)));
                }
                tradeOffersTable.row();
                if (i == n) break;
                ++i;
            }
        }
        tradeOffersTable.pack();
        float scrollHeight = Math.min(tradeOffersTable.getHeight(), worldScreen.getStage().getHeight() / (float)2);
        this.add((Actor)new AutoScrollPane((Actor)tradeOffersTable, null, 2, null)).height(scrollHeight).row();
        Popup popup2 = this;
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        Popup.addSeparator$default(popup2, color, 0, 1.0f, 2, null);
        UncivGame.Companion.getCurrent().getMusicController().playVoice(requestingCiv.getCivName() + ".tradeRequest");
        Popup.addGoodSizedLabel$default(this, nation2.getTradeRequest(), 0, false, 6, null).pad(15.0f).row();
        Popup.addButton$default((Popup)this, "Sounds good!", 'y', null, (Function0)new Function0<Unit>(){

            @Override
            public final void invoke() {
                TradeLogic tradeLogic = new TradeLogic(this.getViewingCiv(), requestingCiv);
                tradeLogic.getCurrentTrade().set(trade);
                TradeLogic.acceptTrade$default(tradeLogic, false, 1, null);
                this.close();
                new TradeThanksPopup(leaderIntroTable, worldScreen);
                String[] stringArray = new String[]{this.getViewingCiv().getCivName(), "StatIcons/Acquire"};
                requestingCiv.addNotification('[' + this.getViewingCiv().getCivName() + "] has accepted your trade request", Notification.NotificationCategory.Trade, stringArray);
            }
        }, 4, null).row();
        Popup.addButton$default((Popup)this, "Not this time.", 'n', null, (Function0)new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getTradeRequest().decline(this.getViewingCiv());
                this.close();
                String[] stringArray = new String[]{this.getViewingCiv().getCivName(), "StatIcons/Acquire"};
                requestingCiv.addNotification('[' + this.getViewingCiv().getCivName() + "] has denied your trade request", Notification.NotificationCategory.Trade, stringArray);
                worldScreen.setShouldUpdate(true);
            }
        }, 4, null).row();
        Popup.addButton$default((Popup)this, "How about something else...", 'e', null, (Function0)new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.close();
                worldScreen.getGame().pushScreen(new DiplomacyScreen(this.getViewingCiv(), requestingCiv, trade, false, 8, null));
                worldScreen.setShouldUpdate(true);
            }
        }, 4, null).row();
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @NotNull
    public final TradeRequest getTradeRequest() {
        return this.tradeRequest;
    }

    @Override
    public void close() {
        this.viewingCiv.getTradeRequests().remove(this.tradeRequest);
        super.close();
    }

    private static final String _init_$getOfferText(HashMap<String, Integer> ourResources, TradeOffer offer) {
        String tradeText = TradeOffer.getOfferText$default(offer, 0, 1, null);
        if (offer.getType() == TradeOfferType.Luxury_Resource || offer.getType() == TradeOfferType.Strategic_Resource) {
            tradeText = tradeText + '\n' + TranslationsKt.tr$default("Owned by you: [" + ourResources.get(offer.getName()) + ']', false, false, 3, null);
        }
        return tradeText;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/worldscreen/TradePopup$TradeThanksPopup;", "Lcom/unciv/ui/popups/Popup;", "leaderIntroTable", "Lcom/unciv/ui/screens/diplomacyscreen/LeaderIntroTable;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/diplomacyscreen/LeaderIntroTable;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "core"})
    public static final class TradeThanksPopup
    extends Popup {
        public TradeThanksPopup(@NotNull LeaderIntroTable leaderIntroTable, final @NotNull WorldScreen worldScreen) {
            Intrinsics.checkNotNullParameter(leaderIntroTable, "leaderIntroTable");
            Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
            super(worldScreen, null, 0.0f, 6, null);
            this.add((Actor)leaderIntroTable);
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null).padBottom(15.0f);
            Popup.addGoodSizedLabel$default(this, "Excellent!", 0, false, 6, null).row();
            Popup.addCloseButton$default(this, "Farewell.", KeyCharAndCode.Companion.getSPACE(), null, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    worldScreen.setShouldUpdate(true);
                }
            }, 4, null);
            Popup.open$default(this, false, 1, null);
        }
    }
}

