/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.bottombar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.Nuke;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.bottombar.BattleTableHelpers;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\fH\u0002J\n\u0010!\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "quarterScreen", "", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getIcon", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "combatant", "Lcom/unciv/logic/battle/ICombatant;", "getModifierTable", "key", "", "value", "", "hide", "", "onAttackButtonClicked", "attacker", "defender", "attackableTile", "Lcom/unciv/logic/battle/AttackableTile;", "simulateAirsweep", "Lcom/unciv/logic/battle/MapUnitCombatant;", "targetTile", "Lcom/unciv/logic/map/tile/Tile;", "simulateBattle", "tileToAttackFrom", "simulateNuke", "tryGetAttacker", "tryGetDefender", "tryGetDefenderAtTile", "selectedTile", "includeFriendly", "", "update", "core"})
@SourceDebugExtension(value={"SMAP\nBattleTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleTable.kt\ncom/unciv/ui/screens/worldscreen/bottombar/BattleTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,447:1\n1#2:448\n288#3,2:449\n288#3,2:459\n125#4:451\n152#4,3:452\n125#4:455\n152#4,3:456\n125#4:461\n152#4,3:462\n*S KotlinDebug\n*F\n+ 1 BattleTable.kt\ncom/unciv/ui/screens/worldscreen/bottombar/BattleTable\n*L\n79#1:449,2\n267#1:459,2\n175#1:451\n175#1:452,3\n180#1:455\n180#1:456,3\n410#1:461\n410#1:462,3\n*E\n"})
public final class BattleTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    private final float quarterScreen;

    public BattleTable(@NotNull WorldScreen worldScreen) {
        Color color;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.setVisible(false);
        this.setSkin(BaseScreen.Companion.getSkin());
        Color color2 = color = BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
        String string = null;
        String string2 = "WorldScreen/BattleTable";
        SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
        BattleTable battleTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.a = 0.8f;
        Unit unit = Unit.INSTANCE;
        battleTable.setBackground(SkinStrings.getUiBackground$default(skinStrings, string2, string, color, 2, null));
        this.defaults().pad(5.0f);
        this.pad(5.0f);
        this.setTouchable(Touchable.enabled);
        this.quarterScreen = this.worldScreen.getStage().getWidth() / (float)4;
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    private final void hide() {
        this.setVisible(false);
        this.clear();
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        ICombatant iCombatant = this.tryGetAttacker();
        if (iCombatant == null) {
            this.hide();
            return;
        }
        ICombatant attacker = iCombatant;
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().isNuclearWeapon()) {
            Tile tile = this.worldScreen.getMapHolder().getSelectedTile$core();
            if (tile == null) {
                this.hide();
                return;
            }
            Tile selectedTile = tile;
            if (Intrinsics.areEqual(selectedTile, attacker.getTile())) {
                this.hide();
                return;
            }
            this.simulateNuke((MapUnitCombatant)attacker, selectedTile);
        } else if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().isPreparingAirSweep()) {
            Tile tile = this.worldScreen.getMapHolder().getSelectedTile$core();
            if (tile == null) {
                this.hide();
                return;
            }
            Tile selectedTile = tile;
            this.simulateAirsweep((MapUnitCombatant)attacker, selectedTile);
        } else {
            Object object;
            ICombatant iCombatant2 = this.tryGetDefender();
            if (iCombatant2 == null) {
                this.hide();
                return;
            }
            ICombatant defender = iCombatant2;
            if (attacker instanceof CityCombatant && defender instanceof CityCombatant) {
                this.hide();
                return;
            }
            if (attacker instanceof MapUnitCombatant) {
                Object v4;
                block14: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, ((MapUnitCombatant)attacker).getUnit(), UnitMovement.getDistanceToTiles$default(((MapUnitCombatant)attacker).getUnit().getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AttackableTile it = (AttackableTile)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getTileToAttack(), defender.getTile())) continue;
                        v4 = element$iv;
                        break block14;
                    }
                    v4 = null;
                }
                if ((object = (AttackableTile)v4) == null || (object = ((AttackableTile)object).getTileToAttackFrom()) == null) {
                    object = attacker.getTile();
                }
            } else {
                object = attacker.getTile();
            }
            Tile tileToAttackFrom = object;
            this.simulateBattle(attacker, defender, tileToAttackFrom);
        }
        this.setVisible(true);
        this.pack();
        Group group = this;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Scene2dExtensionsKt.addBorderAllowOpacity(group, 2.0f, color);
        Scene2dExtensionsKt.addRoundCloseButton(this, new Function0<Unit>(this){
            final /* synthetic */ BattleTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.setVisible(false);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ICombatant tryGetAttacker() {
        ICombatant iCombatant;
        UnitTable unitTable = this.worldScreen.getBottomUnitTable$core();
        if (unitTable.getSelectedUnit() != null) {
            MapUnit mapUnit = unitTable.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!mapUnit.isCivilian()) {
                MapUnit mapUnit2 = unitTable.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit2);
                if (!MapUnit.hasUnique$default(mapUnit2, UniqueType.CannotAttack, null, false, 6, null)) {
                    MapUnit mapUnit3 = unitTable.getSelectedUnit();
                    Intrinsics.checkNotNull(mapUnit3);
                    iCombatant = new MapUnitCombatant(mapUnit3);
                    return iCombatant;
                }
            }
        }
        if (unitTable.getSelectedCity() == null) return null;
        City city2 = unitTable.getSelectedCity();
        Intrinsics.checkNotNull(city2);
        iCombatant = new CityCombatant(city2);
        return iCombatant;
    }

    private final ICombatant tryGetDefender() {
        Tile tile = this.worldScreen.getMapHolder().getSelectedTile$core();
        if (tile == null) {
            return null;
        }
        Tile selectedTile = tile;
        return this.tryGetDefenderAtTile(selectedTile, false);
    }

    private final ICombatant tryGetDefenderAtTile(Tile selectedTile, boolean includeFriendly) {
        boolean canSeeDefender;
        Civilization attackerCiv = this.worldScreen.getViewingCiv();
        ICombatant defender = Battle.INSTANCE.getMapCombatantOfTile(selectedTile);
        if (defender == null || !includeFriendly && Intrinsics.areEqual(defender.getCivInfo(), attackerCiv)) {
            return null;
        }
        boolean bl = DebugUtils.INSTANCE.getVISIBLE_MAP() ? true : (defender.isInvisible(attackerCiv) ? attackerCiv.getViewableInvisibleUnitsTiles().contains(selectedTile) : (canSeeDefender = defender.isCity() ? attackerCiv.hasExplored(selectedTile) : attackerCiv.getViewableTiles().contains(selectedTile)));
        if (!canSeeDefender) {
            return null;
        }
        return defender;
    }

    private final Group getIcon(ICombatant combatant) {
        return combatant instanceof MapUnitCombatant ? (Group)new UnitIconGroup(((MapUnitCombatant)combatant).getUnit(), 25.0f) : (Group)ImageGetter.INSTANCE.getNationPortrait(combatant.getCivInfo().getNation(), 25.0f);
    }

    private final Table getModifierTable(String key, int value) {
        Label label2;
        Label label3;
        Table table2;
        Table $this$getModifierTable_u24lambda_u243 = table2 = new Table();
        boolean bl = false;
        String description2 = StringsKt.startsWith$default(key, "vs ", false, 2, null) ? TranslationsKt.tr$default("vs [" + StringsKt.drop(key, 3) + ']', false, false, 3, null) : TranslationsKt.tr$default(key, false, false, 3, null);
        String percentage = (value > 0 ? "+" : "") + value + '%';
        if ((float)value > 0.0f) {
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            label3 = Scene2dExtensionsKt.toLabel$default("\u2b06", color, 0, 0, false, 14, null);
        } else {
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            label3 = Scene2dExtensionsKt.toLabel$default("\u2b07", color, 0, 0, false, 14, null);
        }
        Label upOrDownLabel = label3;
        $this$getModifierTable_u24lambda_u243.add((Actor)upOrDownLabel);
        Label $this$getModifierTable_u24lambda_u243_u24lambda_u242 = label2 = Scene2dExtensionsKt.toLabel$default(percentage + ' ' + description2, null, 14, 0, false, 13, null);
        boolean bl2 = false;
        $this$getModifierTable_u24lambda_u243_u24lambda_u242.setWrap(true);
        Label modifierLabel = label2;
        $this$getModifierTable_u24lambda_u243.add((Actor)modifierLabel).width(this.quarterScreen - upOrDownLabel.getMinWidth());
        return table2;
    }

    /*
     * WARNING - void declaration
     */
    private final void simulateBattle(ICombatant attacker, ICombatant defender, Tile tileToAttackFrom) {
        List list2;
        Label $this$mapTo$iv$iv;
        Ref.ObjectRef<AttackableTile> objectRef;
        void $this$mapTo$iv$iv2;
        this.clear();
        Table attackerNameWrapper = new Table();
        Label attackerLabel = Scene2dExtensionsKt.toLabel$default(attacker.getName(), null, 0, 0, true, 7, null);
        attackerNameWrapper.add((Actor)this.getIcon(attacker)).padRight(5.0f);
        attackerNameWrapper.add((Actor)attackerLabel);
        this.add((Actor)attackerNameWrapper);
        Table defenderNameWrapper = new Table();
        Label defenderLabel = new Label((CharSequence)TranslationsKt.tr$default(defender.getName(), true, false, 2, null), this.getSkin());
        defenderNameWrapper.add((Actor)this.getIcon(defender)).padRight(5.0f);
        defenderNameWrapper.add((Actor)defenderLabel);
        this.add((Actor)defenderNameWrapper).row();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).pad(0.0f);
        char attackIcon = attacker.isRanged() ? (char)'\u2021' : '\u2020';
        char defenceIcon = attacker.isRanged() && defender.isRanged() && !defender.isCity() && (!(defender instanceof MapUnitCombatant) || !((MapUnitCombatant)defender).getUnit().isEmbarked()) ? (char)'\u2021' : '\u2020';
        this.add(TranslationsKt.tr(attacker.getAttackingStrength()) + attackIcon);
        this.add(TranslationsKt.tr(defender.getDefendingStrength(attacker.isRanged())) + defenceIcon).row();
        Map $this$map$iv = BattleDamage.INSTANCE.getAttackModifiers(attacker, defender, tileToAttackFrom);
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            objectRef = destination$iv$iv;
            boolean bl = false;
            objectRef.add(this.getModifierTable((String)it.getKey(), ((Number)it.getValue()).intValue()));
        }
        List attackerModifiers = (List)destination$iv$iv;
        if (defender instanceof MapUnitCombatant) {
            Map $this$map$iv2 = BattleDamage.INSTANCE.getDefenceModifiers(attacker, defender, tileToAttackFrom);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry bl = item$iv$iv2 = iterator3.next();
                objectRef = destination$iv$iv2;
                boolean bl2 = false;
                objectRef.add(this.getModifierTable((String)it.getKey(), ((Number)it.getValue()).intValue()));
            }
            list2 = (List)destination$iv$iv2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List defenderModifiers = list2;
        int i = 0;
        int $i$f$map2 = Math.max(attackerModifiers.size(), defenderModifiers.size());
        if (i <= $i$f$map2) {
            while (true) {
                if (i < attackerModifiers.size()) {
                    this.add((Actor)attackerModifiers.get(i));
                } else {
                    this.add().width(this.quarterScreen);
                }
                if (i < defenderModifiers.size()) {
                    this.add((Actor)defenderModifiers.get(i));
                } else {
                    this.add().width(this.quarterScreen);
                }
                this.row().pad(2.0f);
                if (i == $i$f$map2) break;
                ++i;
            }
        }
        if (CollectionsKt.any(attackerModifiers) || CollectionsKt.any(defenderModifiers)) {
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
            int attackerStrength = MathKt.roundToInt(BattleDamage.INSTANCE.getAttackingStrength(attacker, defender, tileToAttackFrom));
            int defenderStrength = MathKt.roundToInt(BattleDamage.INSTANCE.getDefendingStrength(attacker, defender, tileToAttackFrom));
            this.add(TranslationsKt.tr(attackerStrength) + attackIcon);
            this.add(TranslationsKt.tr(defenderStrength) + attackIcon).row();
        }
        int maxXPFromBarbarians = attacker.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMaxXPfromBarbarians();
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().getPromotions().totalXpProduced() >= maxXPFromBarbarians && defender.getCivInfo().isBarbarian()) {
            void $this$simulateBattle_u24lambda_u246;
            Label defenderStrength;
            $this$mapTo$iv$iv = defenderStrength = Scene2dExtensionsKt.toLabel$default("Cannot gain more XP from Barbarians", null, 16, 0, false, 13, null);
            objectRef = this;
            boolean bl = false;
            $this$simulateBattle_u24lambda_u246.setWrap(true);
            ((Table)((Object)objectRef)).add((AttackableTile)((Object)defenderStrength)).width(this.quarterScreen);
            this.row();
        }
        if (attacker.isMelee() && (defender.isCivilian() || defender instanceof CityCombatant && defender.isDefeated())) {
            String string;
            this.add();
            if (!defender.isCivilian()) {
                string = "Occupied!";
            } else {
                Intrinsics.checkNotNull(defender, "null cannot be cast to non-null type com.unciv.logic.battle.MapUnitCombatant");
                string = MapUnit.hasUnique$default(((MapUnitCombatant)defender).getUnit(), UniqueType.Uncapturable, null, false, 6, null) ? "" : "Captured!";
            }
            String defeatedText = string;
            this.add((Actor)Scene2dExtensionsKt.toLabel(defeatedText));
        } else {
            int maxDamageToDefender = BattleDamage.INSTANCE.calculateDamageToDefender(attacker, defender, tileToAttackFrom, 1.0f);
            int minDamageToDefender = BattleDamage.INSTANCE.calculateDamageToDefender(attacker, defender, tileToAttackFrom, 0.0f);
            int maxDamageToAttacker = BattleDamage.INSTANCE.calculateDamageToAttacker(attacker, defender, tileToAttackFrom, 1.0f);
            int minDamageToAttacker = BattleDamage.INSTANCE.calculateDamageToAttacker(attacker, defender, tileToAttackFrom, 0.0f);
            int n = attacker.getHealth();
            int minRemainingLifeAttacker = Math.max(n - maxDamageToAttacker, 0);
            int maxRemainingLifeAttacker = Math.max(n - minDamageToAttacker, 0);
            int defenderHealth = defender.getHealth();
            int minRemainingLifeDefender = Math.max(defenderHealth - maxDamageToDefender, 0);
            int maxRemainingLifeDefender = Math.max(defenderHealth - minDamageToDefender, 0);
            this.add((Actor)BattleTableHelpers.getHealthBar$default(BattleTableHelpers.INSTANCE, attacker.getMaxHealth(), attacker.getHealth(), maxRemainingLifeAttacker, minRemainingLifeAttacker, false, 16, null));
            this.add((Actor)BattleTableHelpers.INSTANCE.getHealthBar(defender.getMaxHealth(), defender.getHealth(), maxRemainingLifeDefender, minRemainingLifeDefender, true)).row();
            int[] nArray = new int[]{defenderHealth - minRemainingLifeDefender, defenderHealth - maxRemainingLifeDefender};
            int avgDamageToDefender = BattleTable.simulateBattle$avg(nArray);
            int[] nArray2 = new int[]{n - minRemainingLifeAttacker, n - maxRemainingLifeAttacker};
            int avgDamageToAttacker = BattleTable.simulateBattle$avg(nArray2);
            if (minRemainingLifeAttacker == n) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(n));
            } else if (maxRemainingLifeAttacker == minRemainingLifeAttacker) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(n + " \u2192 " + maxRemainingLifeAttacker + " (" + avgDamageToAttacker + ')'));
            } else {
                this.add((Actor)Scene2dExtensionsKt.toLabel(n + " \u2192 " + minRemainingLifeAttacker + '-' + maxRemainingLifeAttacker + " (~" + avgDamageToAttacker + ')'));
            }
            if (minRemainingLifeDefender == maxRemainingLifeDefender) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(defenderHealth + " \u2192 " + maxRemainingLifeDefender + " (" + avgDamageToDefender + ')'));
            } else {
                this.add((Actor)Scene2dExtensionsKt.toLabel(defenderHealth + " \u2192 " + minRemainingLifeDefender + '-' + maxRemainingLifeDefender + " (~" + avgDamageToDefender + ')'));
            }
        }
        this.row().pad(5.0f);
        if (this.worldScreen.getCanChangeState()) {
            String attackText = attacker instanceof CityCombatant ? "Bombard" : "Attack";
            TextButton maxDamageToAttacker = Scene2dExtensionsKt.toTextButton$default(attackText, null, false, 3, null);
            Object $this$simulateBattle_u24lambda_u247 = maxDamageToAttacker;
            boolean bl = false;
            ((Actor)$this$simulateBattle_u24lambda_u247).setColor(Color.RED);
            TextButton attackButton = maxDamageToAttacker;
            Ref.ObjectRef<AttackableTile> attackableTile = new Ref.ObjectRef<AttackableTile>();
            if (attacker.canAttack()) {
                boolean canBombard;
                if (attacker instanceof MapUnitCombatant) {
                    Object v2;
                    block30: {
                        void $this$firstOrNull$iv;
                        $this$simulateBattle_u24lambda_u247 = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, ((MapUnitCombatant)attacker).getUnit(), UnitMovement.getDistanceToTiles$default(((MapUnitCombatant)attacker).getUnit().getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                        objectRef = attackableTile;
                        boolean bl2 = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            AttackableTile it = (AttackableTile)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it.getTileToAttack(), defender.getTile())) continue;
                            v2 = element$iv;
                            break block30;
                        }
                        v2 = null;
                    }
                    objectRef.element = v2;
                } else if (attacker instanceof CityCombatant && (canBombard = SequencesKt.contains(TargetHelper.INSTANCE.getBombardableTiles(((CityCombatant)attacker).getCity()), defender.getTile()))) {
                    attackableTile.element = new AttackableTile(attacker.getTile(), defender.getTile(), 0.0f, defender);
                }
            }
            if (!this.worldScreen.isPlayersTurn() || attackableTile.element == null) {
                Scene2dExtensionsKt.disable(attackButton);
                attackButton.getLabel().setColor(Color.GRAY);
            } else {
                ActivationExtensionsKt.onClick(attackButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, attacker, defender, attackableTile){
                    final /* synthetic */ BattleTable this$0;
                    final /* synthetic */ ICombatant $attacker;
                    final /* synthetic */ ICombatant $defender;
                    final /* synthetic */ Ref.ObjectRef<AttackableTile> $attackableTile;
                    {
                        this.this$0 = $receiver;
                        this.$attacker = $attacker;
                        this.$defender = $defender;
                        this.$attackableTile = $attackableTile;
                        super(0);
                    }

                    public final void invoke() {
                        BattleTable.access$onAttackButtonClicked(this.this$0, this.$attacker, this.$defender, (AttackableTile)this.$attackableTile.element);
                    }
                });
            }
            this.add((Actor)attackButton).colspan(2);
        }
        this.pack();
        this.setPosition(this.worldScreen.getStage().getWidth() / (float)2 - this.getWidth() / (float)2, 5.0f);
    }

    private final void onAttackButtonClicked(ICombatant attacker, ICombatant defender, AttackableTile attackableTile) {
        boolean canStillAttack = Battle.movePreparingAttack$default(Battle.INSTANCE, attacker, attackableTile, false, 4, null);
        this.worldScreen.getMapHolder().removeUnitActionOverlay();
        this.worldScreen.setShouldUpdate(true);
        UndoHandler.Companion.clearUndoCheckpoints(this.worldScreen);
        if (!canStillAttack) {
            return;
        }
        SoundPlayer.INSTANCE.play(attacker.getAttackSound());
        Battle.DamageDealt damageDealt = Battle.INSTANCE.attackOrNuke(attacker, attackableTile);
        int damageToDefender = damageDealt.component1();
        int damageToAttacker = damageDealt.component2();
        BattleTableHelpers.INSTANCE.battleAnimationDeferred(this.worldScreen, attacker, damageToAttacker, defender, damageToDefender);
        if (!attacker.canAttack()) {
            this.hide();
        }
    }

    private final void simulateNuke(MapUnitCombatant attacker, Tile targetTile) {
        Object tile;
        this.clear();
        Table attackerNameWrapper = new Table();
        Label attackerLabel = Scene2dExtensionsKt.toLabel$default(attacker.getName(), null, 0, 0, true, 7, null);
        attackerNameWrapper.add((Actor)this.getIcon(attacker)).padRight(5.0f);
        attackerNameWrapper.add((Actor)attackerLabel);
        this.add((Actor)attackerNameWrapper);
        boolean canNuke = Nuke.INSTANCE.mayUseNuke(attacker, targetTile);
        int blastRadius = attacker.getUnit().getNukeBlastRadius();
        Table defenderNameWrapper = new Table();
        Iterator<Tile> iterator2 = targetTile.getTilesInDistance(blastRadius).iterator();
        while (iterator2.hasNext()) {
            ICombatant defender;
            tile = iterator2.next();
            if (this.tryGetDefenderAtTile((Tile)tile, true) == null) continue;
            Label defenderLabel = Scene2dExtensionsKt.toLabel$default(defender.getName(), null, 0, 0, true, 7, null);
            defenderNameWrapper.add((Actor)this.getIcon(defender)).padRight(5.0f);
            defenderNameWrapper.add((Actor)defenderLabel).row();
        }
        this.add((Actor)defenderNameWrapper).row();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).pad(0.0f);
        this.row().pad(5.0f);
        Object $this$simulateNuke_u24lambda_u249 = tile = Scene2dExtensionsKt.toTextButton$default("NUKE", null, false, 3, null);
        boolean bl = false;
        ((Actor)$this$simulateNuke_u24lambda_u249).setColor(Color.RED);
        Object attackButton = tile;
        boolean canReach = SequencesKt.contains(attacker.getUnit().getCurrentTile().getTilesInDistance(attacker.getUnit().getRange()), targetTile);
        if (!(this.worldScreen.isPlayersTurn() && attacker.canAttack() && canReach && canNuke)) {
            Scene2dExtensionsKt.disable((Button)attackButton);
            ((TextButton)attackButton).getLabel().setColor(Color.GRAY);
        } else {
            ActivationExtensionsKt.onClick((Actor)attackButton, attacker.getAttackSound(), new Function0<Unit>(attacker, targetTile, this){
                final /* synthetic */ MapUnitCombatant $attacker;
                final /* synthetic */ Tile $targetTile;
                final /* synthetic */ BattleTable this$0;
                {
                    this.$attacker = $attacker;
                    this.$targetTile = $targetTile;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Nuke.INSTANCE.NUKE(this.$attacker, this.$targetTile);
                    Image nukeCircle = ImageGetter.INSTANCE.getCircle();
                    Scene2dExtensionsKt.setSize(nukeCircle, 10.0f);
                    nukeCircle.setOrigin(1);
                    nukeCircle.addAction(Actions.sequence((Action)Actions.fadeOut(0.0f), (Action)Actions.parallel((Action)Actions.fadeIn(1.0f, Interpolation.pow2In), (Action)Actions.scaleTo(200.0f, 200.0f, 1.0f, Interpolation.linear)), (Action)Actions.delay(1.0f), (Action)Actions.fadeOut(1.0f, Interpolation.pow2Out), (Action)Actions.removeActor()));
                    WorldTileGroup worldTileGroup = this.this$0.getWorldScreen().getMapHolder().getTileGroups().get(this.$targetTile);
                    Intrinsics.checkNotNull(worldTileGroup);
                    WorldTileGroup targetTileGroup = worldTileGroup;
                    nukeCircle.setX(targetTileGroup.getX());
                    nukeCircle.setY(targetTileGroup.getY());
                    targetTileGroup.getParent().addActor(nukeCircle);
                    this.this$0.getWorldScreen().getMapHolder().removeUnitActionOverlay();
                    this.this$0.getWorldScreen().setShouldUpdate(true);
                }
            });
        }
        this.add((Actor)attackButton).colspan(2);
        this.pack();
        this.setPosition(this.worldScreen.getStage().getWidth() / (float)2 - this.getWidth() / (float)2, 5.0f);
    }

    /*
     * WARNING - void declaration
     */
    private final void simulateAirsweep(MapUnitCombatant attacker, Tile targetTile) {
        TextButton modifier2;
        void $this$mapTo$iv$iv;
        this.clear();
        Table attackerNameWrapper = new Table();
        Label attackerLabel = Scene2dExtensionsKt.toLabel$default(attacker.getName(), null, 0, 0, true, 7, null);
        attackerNameWrapper.add((Actor)this.getIcon(attacker)).padRight(5.0f);
        attackerNameWrapper.add((Actor)attackerLabel);
        this.add((Actor)attackerNameWrapper);
        boolean canAttack = attacker.canAttack();
        Label defenderLabel = new Label((CharSequence)"???", this.getSkin());
        this.add((Actor)defenderLabel).row();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).pad(0.0f);
        char attackIcon = '\u2021';
        this.add(TranslationsKt.tr(attacker.getAttackingStrength()) + attackIcon);
        this.add("???" + attackIcon).row();
        Map $this$map$iv = BattleDamage.INSTANCE.getAirSweepAttackModifiers(attacker);
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getModifierTable((String)it.getKey(), ((Number)it.getValue()).intValue()));
        }
        List attackerModifiers = (List)destination$iv$iv;
        for (Table modifier2 : attackerModifiers) {
            this.add((Actor)modifier2);
            this.add().width(this.quarterScreen);
            this.row().pad(2.0f);
        }
        this.add((Actor)BattleTableHelpers.getHealthBar$default(BattleTableHelpers.INSTANCE, attacker.getMaxHealth(), attacker.getHealth(), attacker.getHealth(), attacker.getHealth(), false, 16, null));
        this.add((Actor)BattleTableHelpers.getHealthBar$default(BattleTableHelpers.INSTANCE, attacker.getMaxHealth(), attacker.getMaxHealth(), attacker.getMaxHealth(), attacker.getMaxHealth(), false, 16, null));
        this.row().pad(5.0f);
        TextButton $this$simulateAirsweep_u24lambda_u2411 = modifier2 = Scene2dExtensionsKt.toTextButton$default("Air Sweep", null, false, 3, null);
        boolean bl = false;
        $this$simulateAirsweep_u24lambda_u2411.setColor(Color.RED);
        TextButton attackButton = modifier2;
        boolean canReach = SequencesKt.contains(attacker.getUnit().getCurrentTile().getTilesInDistance(attacker.getUnit().getRange()), targetTile);
        if (!(this.worldScreen.isPlayersTurn() && attacker.canAttack() && canReach && canAttack)) {
            Scene2dExtensionsKt.disable(attackButton);
            attackButton.getLabel().setColor(Color.GRAY);
        } else {
            ActivationExtensionsKt.onClick(attackButton, attacker.getAttackSound(), new Function0<Unit>(attacker, targetTile, this){
                final /* synthetic */ MapUnitCombatant $attacker;
                final /* synthetic */ Tile $targetTile;
                final /* synthetic */ BattleTable this$0;
                {
                    this.$attacker = $attacker;
                    this.$targetTile = $targetTile;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    AirInterception.INSTANCE.airSweep(this.$attacker, this.$targetTile);
                    this.this$0.getWorldScreen().getMapHolder().removeUnitActionOverlay();
                    this.this$0.getWorldScreen().setShouldUpdate(true);
                }
            });
        }
        this.add((Actor)attackButton).colspan(2);
        this.pack();
        this.setPosition(this.worldScreen.getStage().getWidth() / (float)2 - this.getWidth() / (float)2, 5.0f);
    }

    private static final int simulateBattle$avg(int ... values2) {
        return MathKt.roundToInt(ArraysKt.average(values2));
    }

    public static final /* synthetic */ void access$onAttackButtonClicked(BattleTable $this, ICombatant attacker, ICombatant defender, AttackableTile attackableTile) {
        $this.onAttackButtonClicked(attacker, defender, attackableTile);
    }
}

