/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.presenter;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.screens.pickerscreens.CityRenamePopup;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.unit.presenter.UnitPresenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/presenter/CityPresenter;", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "unitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "unitPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "(Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;)V", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "selectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity", "()Lcom/unciv/logic/city/City;", "setSelectedCity", "(Lcom/unciv/logic/city/City;)V", "selectCity", "", "city", "updateWhenNeeded", "", "core"})
public final class CityPresenter
implements UnitTable.Presenter {
    @NotNull
    private final UnitTable unitTable;
    @NotNull
    private final UnitPresenter unitPresenter;
    @Nullable
    private City selectedCity;

    public CityPresenter(@NotNull UnitTable unitTable, @NotNull UnitPresenter unitPresenter) {
        Intrinsics.checkNotNullParameter(unitTable, "unitTable");
        Intrinsics.checkNotNullParameter(unitPresenter, "unitPresenter");
        this.unitTable = unitTable;
        this.unitPresenter = unitPresenter;
    }

    @Nullable
    public final City getSelectedCity() {
        return this.selectedCity;
    }

    public final void setSelectedCity(@Nullable City city2) {
        this.selectedCity = city2;
    }

    @Override
    @Nullable
    public Vector2 getPosition() {
        City city2 = this.selectedCity;
        return city2 != null ? city2.getLocation() : null;
    }

    public final boolean selectCity(@NotNull City city2) {
        UnitPresenter unitPresenter;
        Intrinsics.checkNotNullParameter(city2, "city");
        UnitPresenter $this$selectCity_u24lambda_u240 = unitPresenter = this.unitPresenter;
        boolean bl = false;
        if ($this$selectCity_u24lambda_u240.getSelectedUnitIsConnectingRoad()) {
            UnitPresenter.selectUnit$default($this$selectCity_u24lambda_u240, $this$selectCity_u24lambda_u240.getSelectedUnits().get(0), false, 2, null);
            $this$selectCity_u24lambda_u240.setSelectedUnitIsConnectingRoad(true);
        } else {
            UnitPresenter.selectUnit$default($this$selectCity_u24lambda_u240, null, false, 3, null);
        }
        if (Intrinsics.areEqual(city2, this.selectedCity)) {
            return false;
        }
        this.selectedCity = city2;
        return true;
    }

    @Override
    public void updateWhenNeeded() {
        UnitTable $this$updateWhenNeeded_u24lambda_u241 = this.unitTable;
        boolean bl = false;
        $this$updateWhenNeeded_u24lambda_u241.getSeparator$core().setVisible(true);
        City city2 = $this$updateWhenNeeded_u24lambda_u241.getSelectedCity();
        Intrinsics.checkNotNull(city2);
        City city3 = city2;
        String nameLabelText = TranslationsKt.tr$default(city3.getName(), false, false, 3, null);
        if (city3.getHealth() < city3.getMaxHealth$core()) {
            nameLabelText = nameLabelText + " (" + TranslationsKt.tr(city3.getHealth()) + ')';
        }
        $this$updateWhenNeeded_u24lambda_u241.getUnitNameLabel$core().setText(nameLabelText);
        $this$updateWhenNeeded_u24lambda_u241.getUnitNameLabel$core().clearListeners();
        ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u241.getUnitNameLabel$core(), new Function0<Unit>($this$updateWhenNeeded_u24lambda_u241, city3){
            final /* synthetic */ UnitTable $this_with;
            final /* synthetic */ City $city;
            {
                this.$this_with = $receiver;
                this.$city = $city;
                super(0);
            }

            public final void invoke() {
                if (!this.$this_with.getWorldScreen().getCanChangeState()) {
                    return;
                }
                new CityRenamePopup(this.$this_with.getWorldScreen(), this.$city, new Function0<Unit>(this.$this_with, this.$city){
                    final /* synthetic */ UnitTable $this_with;
                    final /* synthetic */ City $city;
                    {
                        this.$this_with = $receiver;
                        this.$city = $city;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_with.getUnitNameLabel$core().setText(TranslationsKt.tr$default(this.$city.getName(), false, false, 3, null));
                        this.$this_with.getWorldScreen().setShouldUpdate(true);
                    }
                });
            }
        });
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().clear();
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().defaults().pad(2.0f).padRight(5.0f);
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr$default("Strength", false, false, 3, null));
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr(ICombatant.DefaultImpls.getDefendingStrength$default(new CityCombatant(city3), false, 1, null))).row();
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr$default("Bombard strength", false, false, 3, null));
        $this$updateWhenNeeded_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr(new CityCombatant(city3).getAttackingStrength())).row();
        $this$updateWhenNeeded_u24lambda_u241.setShouldUpdate(true);
    }

    @Override
    public void update() {
        UnitTable.Presenter.DefaultImpls.update(this);
    }

    @Override
    public boolean shouldBeShown() {
        return UnitTable.Presenter.DefaultImpls.shouldBeShown(this);
    }
}

