/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.presenter;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.pickerscreens.PromotionPickerScreen;
import com.unciv.ui.screens.pickerscreens.UnitRenamePopup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u001c\u0010 \u001a\u00020!2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\"\u001a\u00020\u0010J\b\u0010#\u001a\u00020!H\u0016J\b\u0010$\u001a\u00020!H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0019j\b\u0012\u0004\u0012\u00020\f`\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "unitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "selectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "selectedUnitIsConnectingRoad", "", "getSelectedUnitIsConnectingRoad", "()Z", "setSelectedUnitIsConnectingRoad", "(Z)V", "selectedUnitIsSwapping", "getSelectedUnitIsSwapping", "setSelectedUnitIsSwapping", "selectedUnits", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedUnits", "()Ljava/util/ArrayList;", "buildNameLabelText", "", "unit", "selectUnit", "", "append", "update", "updateWhenNeeded", "core"})
@SourceDebugExtension(value={"SMAP\nUnitPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitPresenter.kt\ncom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1747#2,3:164\n*S KotlinDebug\n*F\n+ 1 UnitPresenter.kt\ncom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter\n*L\n130#1:164,3\n*E\n"})
public final class UnitPresenter
implements UnitTable.Presenter {
    @NotNull
    private final UnitTable unitTable;
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final ArrayList<MapUnit> selectedUnits;
    private boolean selectedUnitIsSwapping;
    private boolean selectedUnitIsConnectingRoad;

    public UnitPresenter(@NotNull UnitTable unitTable, @NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(unitTable, "unitTable");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.unitTable = unitTable;
        this.worldScreen = worldScreen;
        this.selectedUnits = new ArrayList();
    }

    @Nullable
    public final MapUnit getSelectedUnit() {
        return (MapUnit)CollectionsKt.firstOrNull((List)this.selectedUnits);
    }

    @NotNull
    public final ArrayList<MapUnit> getSelectedUnits() {
        return this.selectedUnits;
    }

    public final boolean getSelectedUnitIsSwapping() {
        return this.selectedUnitIsSwapping;
    }

    public final void setSelectedUnitIsSwapping(boolean bl) {
        this.selectedUnitIsSwapping = bl;
    }

    public final boolean getSelectedUnitIsConnectingRoad() {
        return this.selectedUnitIsConnectingRoad;
    }

    public final void setSelectedUnitIsConnectingRoad(boolean bl) {
        this.selectedUnitIsConnectingRoad = bl;
    }

    @Override
    @Nullable
    public Vector2 getPosition() {
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.getSelectedUnit();
        return isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((MapUnit)isPartOfGameInfoSerialization).getCurrentTile()) != null ? ((Tile)isPartOfGameInfoSerialization).getPosition() : null;
    }

    public final void selectUnit(@Nullable MapUnit unit, boolean append2) {
        if (!append2) {
            this.selectedUnits.clear();
        }
        if (unit != null) {
            this.selectedUnits.add(unit);
            unit.actionsOnDeselect();
        }
        this.selectedUnitIsSwapping = false;
        this.selectedUnitIsConnectingRoad = false;
    }

    public static /* synthetic */ void selectUnit$default(UnitPresenter unitPresenter, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        unitPresenter.selectUnit(mapUnit, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        Unit unit;
        MapUnit mapUnit = this.getSelectedUnit();
        if (mapUnit != null) {
            boolean disappeared;
            MapUnit unit2 = mapUnit;
            boolean bl = false;
            boolean captured = !Intrinsics.areEqual(unit2.getCiv(), this.worldScreen.getViewingCiv()) && !this.worldScreen.getViewingCiv().isSpectator();
            boolean bl2 = disappeared = !SequencesKt.contains(unit2.getTile().getUnits(), unit2);
            if (captured || disappeared) {
                UnitTable.selectUnit$default(this.unitTable, null, false, 3, null);
                this.worldScreen.setShouldUpdate(true);
                return;
            }
            if (this.selectedUnits.size() == 1) {
                int interceptionRange;
                UnitTable $this$update_u24lambda_u243_u24lambda_u241 = this.unitTable;
                boolean bl3 = false;
                $this$update_u24lambda_u243_u24lambda_u241.getSeparator$core().setVisible(true);
                $this$update_u24lambda_u243_u24lambda_u241.setNameLabelText(this.buildNameLabelText(unit2));
                $this$update_u24lambda_u243_u24lambda_u241.getUnitNameLabel$core().clearListeners();
                ActivationExtensionsKt.onClick($this$update_u24lambda_u243_u24lambda_u241.getUnitNameLabel$core(), new Function0<Unit>($this$update_u24lambda_u243_u24lambda_u241, unit2, this){
                    final /* synthetic */ UnitTable $this_with;
                    final /* synthetic */ MapUnit $unit;
                    final /* synthetic */ UnitPresenter this$0;
                    {
                        this.$this_with = $receiver;
                        this.$unit = $unit;
                        this.this$0 = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.$this_with.getWorldScreen().getCanChangeState()) {
                            return;
                        }
                        new UnitRenamePopup(this.$this_with.getWorldScreen(), this.$unit, new Function0<Unit>(this.$this_with, this.this$0, this.$unit){
                            final /* synthetic */ UnitTable $this_with;
                            final /* synthetic */ UnitPresenter this$0;
                            final /* synthetic */ MapUnit $unit;
                            {
                                this.$this_with = $receiver;
                                this.this$0 = $receiver2;
                                this.$unit = $unit;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_with.getUnitNameLabel$core().setText(UnitPresenter.access$buildNameLabelText(this.this$0, this.$unit));
                                this.$this_with.setShouldUpdate(true);
                            }
                        });
                    }
                });
                $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().clear();
                $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().defaults().pad(2.0f);
                char c = '\u27a1';
                Object object = unit2.getMovementString();
                $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                if (!unit2.isCivilian()) {
                    c = '\u2020';
                    object = TranslationsKt.tr(unit2.getBaseUnit().getStrength());
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if (unit2.getBaseUnit().getRangedStrength() != 0) {
                    c = '\u2021';
                    object = TranslationsKt.tr(unit2.getBaseUnit().getRangedStrength());
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if (unit2.getBaseUnit().isRanged()) {
                    c = '\u2026';
                    object = TranslationsKt.tr(unit2.getRange());
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(c + (String)object).padRight(10.0f);
                }
                if ((interceptionRange = unit2.getInterceptionRange()) > 0) {
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add((Actor)ImageGetter.INSTANCE.getStatIcon("InterceptRange")).size(20.0f);
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr(interceptionRange)).padRight(10.0f);
                }
                if (!unit2.isCivilian()) {
                    void $this$update_u24lambda_u243_u24lambda_u241_u24lambda_u240;
                    Object object2 = object = Scene2dExtensionsKt.toLabel("XP");
                    Table table2 = $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core();
                    boolean bl4 = false;
                    ActivationExtensionsKt.onClick((Actor)$this$update_u24lambda_u243_u24lambda_u241_u24lambda_u240, new Function0<Unit>($this$update_u24lambda_u243_u24lambda_u241, unit2){
                        final /* synthetic */ UnitTable $this_with;
                        final /* synthetic */ MapUnit $unit;
                        {
                            this.$this_with = $receiver;
                            this.$unit = $unit;
                            super(0);
                        }

                        public final void invoke() {
                            if (this.$this_with.getSelectedUnit() == null) {
                                return;
                            }
                            this.$this_with.getWorldScreen().getGame().pushScreen(new PromotionPickerScreen(this.$unit, false, null, 6, null));
                        }
                    });
                    table2.add((Actor)object);
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr(unit2.getPromotions().getXP()) + '/' + TranslationsKt.tr(unit2.getPromotions().xpForNextPromotion()));
                }
                if (unit2.getBaseUnit().getReligiousStrength() > 0) {
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add((Actor)ImageGetter.INSTANCE.getStatIcon("ReligiousStrength")).size(20.0f);
                    $this$update_u24lambda_u243_u24lambda_u241.getDescriptionTable$core().add(TranslationsKt.tr(unit2.getBaseUnit().getReligiousStrength() - unit2.getReligiousStrengthLost()));
                }
                if (unit2.getPromotions().getPromotions().size() != $this$update_u24lambda_u243_u24lambda_u241.getPromotionsTable$core().getChildren().size) {
                    $this$update_u24lambda_u243_u24lambda_u241.setShouldUpdate(true);
                }
            } else {
                UnitTable $this$update_u24lambda_u243_u24lambda_u242 = this.unitTable;
                boolean bl5 = false;
                $this$update_u24lambda_u243_u24lambda_u242.setNameLabelText("");
                $this$update_u24lambda_u243_u24lambda_u242.getDescriptionTable$core().clear();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    @Override
    public void updateWhenNeeded() {
        Unit unit;
        MapUnit mapUnit = this.getSelectedUnit();
        if (mapUnit != null) {
            MapUnit unit2 = mapUnit;
            boolean bl = false;
            if (this.selectedUnits.size() == 1) {
                UnitTable $this$updateWhenNeeded_u24lambda_u246_u24lambda_u245 = this.unitTable;
                boolean bl2 = false;
                $this$updateWhenNeeded_u24lambda_u246_u24lambda_u245.getUnitIconHolder$core().add((Actor)new UnitIconGroup(unit2, 30.0f)).pad(5.0f);
                Iterator<Object> iterator2 = unit2.getPromotions().getPromotions(true).iterator();
                while (iterator2.hasNext()) {
                    Promotion promotion2 = iterator2.next();
                    if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)promotion2, UniqueType.NotShownOnWorldScreen, null, 2, null)) continue;
                    $this$updateWhenNeeded_u24lambda_u246_u24lambda_u245.getPromotionsTable$core().add((Actor)ImageGetter.INSTANCE.getPromotionPortrait(promotion2.getName(), 20.0f)).padBottom(2.0f);
                }
                for (MapUnit.UnitStatus status : unit2.getStatusMap().values()) {
                    boolean bl3;
                    block11: {
                        Iterable $this$any$iv = status.getUniques();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Unique it = (Unique)element$iv;
                                boolean bl4 = false;
                                if (!(it.getType() == UniqueType.NotShownOnWorldScreen)) continue;
                                bl3 = true;
                                break block11;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) continue;
                    Group group = ImageGetter.getPromotionPortrait$default(ImageGetter.INSTANCE, status.getName(), 0.0f, 2, null);
                    IconCircleGroup turnsLeft = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.toLabel$default("" + status.getTurnsLeft() + '\u23f3', null, 8, 0, false, 13, null), 15.0f, false, ImageGetter.INSTANCE.getCHARCOAL(), null, 10, null);
                    group.addActor(turnsLeft);
                    turnsLeft.setPosition(group.getWidth(), 0.0f, 20);
                    $this$updateWhenNeeded_u24lambda_u246_u24lambda_u245.getPromotionsTable$core().add((Actor)group).padBottom(2.0f);
                }
                ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u246_u24lambda_u245.getPromotionsTable$core(), new Function0<Unit>($this$updateWhenNeeded_u24lambda_u246_u24lambda_u245, unit2){
                    final /* synthetic */ UnitTable $this_with;
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$this_with = $receiver;
                        this.$unit = $unit;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$this_with.getSelectedUnit() == null || this.$this_with.getPromotionsTable$core().getChildren().isEmpty()) {
                            return;
                        }
                        this.$this_with.getWorldScreen().getGame().pushScreen(new PromotionPickerScreen(this.$unit, false, null, 6, null));
                    }
                });
                ActivationExtensionsKt.onClick($this$updateWhenNeeded_u24lambda_u246_u24lambda_u245.getUnitIconHolder$core(), new Function0<Unit>($this$updateWhenNeeded_u24lambda_u246_u24lambda_u245, unit2){
                    final /* synthetic */ UnitTable $this_with;
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$this_with = $receiver;
                        this.$unit = $unit;
                        super(0);
                    }

                    public final void invoke() {
                        this.$this_with.getWorldScreen().openCivilopedia(this.$unit.getBaseUnit().makeLink());
                    }
                });
            } else {
                for (MapUnit selectedUnit : this.selectedUnits) {
                    Table table2 = this.unitTable.getUnitIconHolder$core();
                    Intrinsics.checkNotNull(selectedUnit);
                    table2.add((Actor)new UnitIconGroup(selectedUnit, 30.0f)).pad(5.0f);
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit != null) {
            // empty if block
        }
    }

    private final String buildNameLabelText(MapUnit unit) {
        String nameLabelText = TranslationsKt.tr$default(unit.displayName(), true, false, 2, null);
        if (unit.getHealth() < 100) {
            nameLabelText = nameLabelText + " (" + TranslationsKt.tr(unit.getHealth()) + ')';
        }
        return nameLabelText;
    }

    @Override
    public boolean shouldBeShown() {
        return UnitTable.Presenter.DefaultImpls.shouldBeShown(this);
    }

    public static final /* synthetic */ String access$buildNameLabelText(UnitPresenter $this, MapUnit unit) {
        return $this.buildNameLabelText(unit);
    }
}

