/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.cache;

import io.ktor.client.engine.UtilsKt;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaders;
import io.ktor.http.URLProtocol;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f0\u0006H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\"\u0018\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"LOGGER", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "mergedHeadersLookup", "Lkotlin/Function1;", "", "content", "Lio/ktor/http/content/OutgoingContent;", "headerExtractor", "allHeadersExtractor", "", "canStore", "", "Lio/ktor/http/URLProtocol;", "ktor-client-core"})
public final class HttpCacheKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.client.plugins.HttpCache");

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final Function1<String, String> mergedHeadersLookup(@NotNull OutgoingContent content2, @NotNull Function1<? super String, String> headerExtractor, @NotNull Function1<? super String, ? extends List<String>> allHeadersExtractor) {
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(headerExtractor, "headerExtractor");
        Intrinsics.checkNotNullParameter(allHeadersExtractor, "allHeadersExtractor");
        return new Function1<String, String>(content2, headerExtractor, allHeadersExtractor){
            final /* synthetic */ OutgoingContent $content;
            final /* synthetic */ Function1<String, String> $headerExtractor;
            final /* synthetic */ Function1<String, List<String>> $allHeadersExtractor;
            {
                this.$content = $content;
                this.$headerExtractor = $headerExtractor;
                this.$allHeadersExtractor = $allHeadersExtractor;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String header) {
                Object object;
                Intrinsics.checkNotNullParameter(header, "header");
                String string = header;
                if (Intrinsics.areEqual(string, HttpHeaders.INSTANCE.getContentLength())) {
                    object = this.$content.getContentLength();
                    if (object == null || (object = ((Long)object).toString()) == null) {
                        object = "";
                    }
                } else if (Intrinsics.areEqual(string, HttpHeaders.INSTANCE.getContentType())) {
                    object = this.$content.getContentType();
                    if (object == null || (object = ((HeaderValueWithParameters)object).toString()) == null) {
                        object = "";
                    }
                } else if (Intrinsics.areEqual(string, HttpHeaders.INSTANCE.getUserAgent())) {
                    object = this.$content.getHeaders().get(HttpHeaders.INSTANCE.getUserAgent());
                    if (object == null && (object = this.$headerExtractor.invoke(HttpHeaders.INSTANCE.getUserAgent())) == null) {
                        object = UtilsKt.getKTOR_DEFAULT_USER_AGENT();
                    }
                } else {
                    List<String> list2 = this.$content.getHeaders().getAll(header);
                    if (list2 == null && (list2 = this.$allHeadersExtractor.invoke(header)) == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List<String> value = list2;
                    object = CollectionsKt.joinToString$default(value, ";", null, null, 0, null, null, 62, null);
                }
                return object;
            }
        };
    }

    private static final boolean canStore(URLProtocol $this$canStore) {
        return Intrinsics.areEqual($this$canStore.getName(), "http") || Intrinsics.areEqual($this$canStore.getName(), "https");
    }

    public static final /* synthetic */ boolean access$canStore(URLProtocol $receiver) {
        return HttpCacheKt.canStore($receiver);
    }
}

