/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.FileContentTypeKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0012\u0010\f\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0004\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002\u001a<\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00030\u0001\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u0017*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u00190\u0018H\u0000\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0004H\u0002\u001a\u0012\u0010\u001c\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\f\u0010\u001d\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\f\u0010\u001e\u001a\u00020\u0004*\u00020\u0004H\u0002\"-\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"-\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001f"}, d2={"contentTypesByExtensions", "", "", "", "Lio/ktor/http/ContentType;", "getContentTypesByExtensions", "()Ljava/util/Map;", "contentTypesByExtensions$delegate", "Lkotlin/Lazy;", "extensionsByContentType", "getExtensionsByContentType", "extensionsByContentType$delegate", "defaultForFileExtension", "Lio/ktor/http/ContentType$Companion;", "extension", "defaultForFilePath", "path", "fileExtensions", "fromFileExtension", "ext", "fromFilePath", "groupByPairs", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "matchApplicationTypeWithCharset", "", "selectDefault", "toContentType", "withCharsetUTF8IfNeeded", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nFileContentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n970#2:105\n999#2,3:106\n1002#2,3:116\n361#3,7:109\n442#3:119\n392#3:120\n1238#4,2:121\n1549#4:123\n1620#4,3:124\n1241#4:127\n*S KotlinDebug\n*F\n+ 1 FileContentType.kt\nio/ktor/http/FileContentTypeKt\n*L\n96#1:105\n96#1:106,3\n96#1:116,3\n96#1:109,7\n97#1:119\n97#1:120\n97#1:121,2\n97#1:123\n97#1:124,3\n97#1:127\n*E\n"})
public final class FileContentTypeKt {
    @NotNull
    private static final Lazy contentTypesByExtensions$delegate = LazyKt.lazy(contentTypesByExtensions.2.INSTANCE);
    @NotNull
    private static final Lazy extensionsByContentType$delegate = LazyKt.lazy(extensionsByContentType.2.INSTANCE);

    @NotNull
    public static final ContentType defaultForFileExtension(@NotNull ContentType.Companion $this$defaultForFileExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter($this$defaultForFileExtension, "<this>");
        Intrinsics.checkNotNullParameter(extension, "extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, extension));
    }

    @NotNull
    public static final ContentType defaultForFilePath(@NotNull ContentType.Companion $this$defaultForFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter($this$defaultForFilePath, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, path));
    }

    @NotNull
    public static final List<ContentType> fromFilePath(@NotNull ContentType.Companion $this$fromFilePath, @NotNull String path) {
        Intrinsics.checkNotNullParameter($this$fromFilePath, "<this>");
        Intrinsics.checkNotNullParameter(path, "path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path, CharsetKt.toCharArray("/\\"), 0, false, 6, null);
        int index = StringsKt.indexOf$default((CharSequence)path, '.', slashIndex + 1, false, 4, null);
        if (index == -1) {
            return CollectionsKt.emptyList();
        }
        String string = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return FileContentTypeKt.fromFileExtension($this$fromFilePath, string);
    }

    @NotNull
    public static final List<ContentType> fromFileExtension(@NotNull ContentType.Companion $this$fromFileExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter($this$fromFileExtension, "<this>");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String current = TextKt.toLowerCasePreservingASCIIRules(StringsKt.removePrefix(ext, (CharSequence)"."));
        while (((CharSequence)current).length() > 0) {
            List<ContentType> type2 = FileContentTypeKt.getContentTypesByExtensions().get(current);
            if (type2 != null) {
                return type2;
            }
            current = StringsKt.substringAfter(current, ".", "");
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<String> fileExtensions(@NotNull ContentType $this$fileExtensions) {
        Intrinsics.checkNotNullParameter($this$fileExtensions, "<this>");
        List<String> list2 = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions);
        if (list2 == null && (list2 = FileContentTypeKt.getExtensionsByContentType().get($this$fileExtensions.withoutParameters())) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final Map<String, List<ContentType>> getContentTypesByExtensions() {
        Lazy lazy = contentTypesByExtensions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<ContentType, List<String>> getExtensionsByContentType() {
        Lazy lazy = extensionsByContentType$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public static final ContentType selectDefault(@NotNull List<ContentType> $this$selectDefault) {
        Intrinsics.checkNotNullParameter($this$selectDefault, "<this>");
        ContentType contentType2 = CollectionsKt.firstOrNull($this$selectDefault);
        if (contentType2 == null) {
            contentType2 = ContentType.Application.INSTANCE.getOctetStream();
        }
        ContentType contentType3 = contentType2;
        return contentType3.match(ContentType.Text.INSTANCE.getAny()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : (contentType3.match(ContentType.Image.INSTANCE.getSVG()) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : (FileContentTypeKt.matchApplicationTypeWithCharset(contentType3) ? FileContentTypeKt.withCharsetUTF8IfNeeded(contentType3) : contentType3));
    }

    private static final boolean matchApplicationTypeWithCharset(ContentType $this$matchApplicationTypeWithCharset) {
        if (!$this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAny())) {
            return false;
        }
        return $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getAtom()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getJavaScript()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getRss()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml()) || $this$matchApplicationTypeWithCharset.match(ContentType.Application.INSTANCE.getXml_Dtd());
    }

    private static final ContentType withCharsetUTF8IfNeeded(ContentType $this$withCharsetUTF8IfNeeded) {
        if (ContentTypesKt.charset($this$withCharsetUTF8IfNeeded) != null) {
            return $this$withCharsetUTF8IfNeeded;
        }
        return ContentTypesKt.withCharset($this$withCharsetUTF8IfNeeded, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A, B> Map<A, List<B>> groupByPairs(@NotNull Sequence<? extends Pair<? extends A, ? extends B>> $this$groupByPairs) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupByPairs, "<this>");
        Sequence<? extends Pair<? extends A, ? extends B>> $this$groupBy$iv = $this$groupByPairs;
        boolean $i$f$groupBy = false;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void e;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)e.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getSecond());
            }
            List list2 = (List)destination$iv$iv2;
            map3.put(k, list2);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final ContentType toContentType(@NotNull String $this$toContentType) {
        ContentType contentType2;
        Intrinsics.checkNotNullParameter($this$toContentType, "<this>");
        try {
            contentType2 = ContentType.Companion.parse($this$toContentType);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to parse " + $this$toContentType, e);
        }
        return contentType2;
    }
}

