/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.SharedLibraryUtil;
import org.lwjgl.system.macosx.DynamicLinkLoader;
import org.lwjgl.system.macosx.MacOSXLibrary;

public class MacOSXLibraryDL
extends MacOSXLibrary {
    public MacOSXLibraryDL(String name2) {
        this(name2, MacOSXLibraryDL.loadLibrary(name2));
    }

    public MacOSXLibraryDL(String name2, long handle2) {
        super(name2, handle2);
    }

    private static long loadLibrary(String name2) {
        long handle2;
        try (MemoryStack stack = MemoryStack.stackPush();){
            handle2 = DynamicLinkLoader.dlopen(stack.UTF8(name2), 5);
        }
        if (handle2 == 0L) {
            throw new UnsatisfiedLinkError("Failed to dynamically load library: " + name2 + "(error = " + DynamicLinkLoader.dlerror() + ")");
        }
        return handle2;
    }

    @Override
    @Nullable
    public String getPath() {
        return SharedLibraryUtil.getLibraryPath(this.address());
    }

    @Override
    public long getFunctionAddress(ByteBuffer functionName) {
        return DynamicLinkLoader.dlsym(this.address(), functionName);
    }

    @Override
    public void free() {
        DynamicLinkLoader.dlclose(this.address());
    }
}

